/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.postscript;

import com.adobe.fontengine.inlineformatting.css20.CSS20Attribute;
import java.util.regex.Pattern;

public final class NameHeuristics {
    private static final PatternToWeight[] weightPatterns = new PatternToWeight[21];
    private static final PatternToStretch[] widthPatterns;
    private static final Pattern smallCapsPattern;
    private static final Pattern[] dingbatsPatterns;

    public static int fullNameToWeight(String string) {
        for (int i = 0; i < weightPatterns.length; ++i) {
            if (!NameHeuristics.weightPatterns[i].pattern.matcher(string).find()) continue;
            return NameHeuristics.weightPatterns[i].weight;
        }
        return 400;
    }

    public static int weightNameToWeight(String string) {
        String string2 = "-" + string;
        for (int i = 0; i < weightPatterns.length; ++i) {
            if (!NameHeuristics.weightPatterns[i].pattern.matcher(string2).lookingAt()) continue;
            return NameHeuristics.weightPatterns[i].weight;
        }
        return 400;
    }

    public static CSS20Attribute.CSSStretchValue fullNameToWidth(String string, String string2) {
        Pattern pattern;
        if (string2 != null && (pattern = Pattern.compile(string2 + "[-\\s]*ultra\\s*condensed\\s*(italic|oblique)?", 2)).matcher(string).matches()) {
            return CSS20Attribute.CSSStretchValue.CONDENSED;
        }
        for (int i = 0; i < widthPatterns.length; ++i) {
            if (!NameHeuristics.widthPatterns[i].pattern.matcher(string).find()) continue;
            return NameHeuristics.widthPatterns[i].stretch;
        }
        return CSS20Attribute.CSSStretchValue.NORMAL;
    }

    public static boolean fullNameIndicatesSmallCaps(String string) {
        return smallCapsPattern.matcher(string).find();
    }

    public static boolean fullNameIndicatesDingbats(String string) {
        if (string == null) {
            return false;
        }
        for (int i = 0; i < dingbatsPatterns.length; ++i) {
            if (!dingbatsPatterns[i].matcher(string).find()) continue;
            return true;
        }
        return false;
    }

    static {
        NameHeuristics.weightPatterns[0] = new PatternToWeight(Pattern.compile("[- ]extra\\s*light", 2), 100);
        NameHeuristics.weightPatterns[1] = new PatternToWeight(Pattern.compile("[- ]ultra\\s*light", 2), 100);
        NameHeuristics.weightPatterns[2] = new PatternToWeight(Pattern.compile("[- ]thin", 2), 200);
        NameHeuristics.weightPatterns[3] = new PatternToWeight(Pattern.compile("[- ]highlight", 2), 400);
        NameHeuristics.weightPatterns[4] = new PatternToWeight(Pattern.compile("[- ]light", 2), 300);
        NameHeuristics.weightPatterns[5] = new PatternToWeight(Pattern.compile("[- ]medium", 2), 500);
        NameHeuristics.weightPatterns[6] = new PatternToWeight(Pattern.compile("[- ]semi\\s*bold", 2), 600);
        NameHeuristics.weightPatterns[7] = new PatternToWeight(Pattern.compile("[- ]demi\\s*bold", 2), 600);
        NameHeuristics.weightPatterns[8] = new PatternToWeight(Pattern.compile("[- ]demi", 2), 600);
        NameHeuristics.weightPatterns[9] = new PatternToWeight(Pattern.compile("[- ]extra\\s*bold", 2), 800);
        NameHeuristics.weightPatterns[10] = new PatternToWeight(Pattern.compile("[- ]ultra\\s*bold", 2), 800);
        NameHeuristics.weightPatterns[11] = new PatternToWeight(Pattern.compile("[- ]extra\\s*black", 2), 950);
        NameHeuristics.weightPatterns[12] = new PatternToWeight(Pattern.compile("[- ]ext\\s*black", 2), 950);
        NameHeuristics.weightPatterns[13] = new PatternToWeight(Pattern.compile("[- ]ultra\\s*black", 2), 950);
        NameHeuristics.weightPatterns[14] = new PatternToWeight(Pattern.compile("[- ]ultra", 2), 900);
        NameHeuristics.weightPatterns[15] = new PatternToWeight(Pattern.compile("[- ]super", 2), 800);
        NameHeuristics.weightPatterns[16] = new PatternToWeight(Pattern.compile("[- ]bold", 2), 700);
        NameHeuristics.weightPatterns[17] = new PatternToWeight(Pattern.compile("[- ]black", 2), 900);
        NameHeuristics.weightPatterns[18] = new PatternToWeight(Pattern.compile("[- ]poster", 2), 900);
        NameHeuristics.weightPatterns[19] = new PatternToWeight(Pattern.compile("[- ]heavy", 2), 850);
        NameHeuristics.weightPatterns[20] = new PatternToWeight(Pattern.compile("[- ]nord", 2), 900);
        widthPatterns = new PatternToStretch[17];
        NameHeuristics.widthPatterns[0] = new PatternToStretch(Pattern.compile("[- ]ultra\\s*condensed", 2), CSS20Attribute.CSSStretchValue.ULTRACONDENSED);
        NameHeuristics.widthPatterns[1] = new PatternToStretch(Pattern.compile("[- ]extra\\s*compressed", 2), CSS20Attribute.CSSStretchValue.ULTRACONDENSED);
        NameHeuristics.widthPatterns[2] = new PatternToStretch(Pattern.compile("[- ]ultra\\s*compressed", 2), CSS20Attribute.CSSStretchValue.ULTRACONDENSED);
        NameHeuristics.widthPatterns[3] = new PatternToStretch(Pattern.compile("[- ]extra\\s*condensed", 2), CSS20Attribute.CSSStretchValue.EXTRACONDENSED);
        NameHeuristics.widthPatterns[4] = new PatternToStretch(Pattern.compile("[- ]compressed", 2), CSS20Attribute.CSSStretchValue.EXTRACONDENSED);
        NameHeuristics.widthPatterns[5] = new PatternToStretch(Pattern.compile("[- ]semi\\s*condensed", 2), CSS20Attribute.CSSStretchValue.SEMICONDENSED);
        NameHeuristics.widthPatterns[6] = new PatternToStretch(Pattern.compile("[- ]compact", 2), CSS20Attribute.CSSStretchValue.SEMICONDENSED);
        NameHeuristics.widthPatterns[7] = new PatternToStretch(Pattern.compile("[- ]narrow", 2), CSS20Attribute.CSSStretchValue.SEMICONDENSED);
        NameHeuristics.widthPatterns[8] = new PatternToStretch(Pattern.compile("[- ]condensed", 2), CSS20Attribute.CSSStretchValue.CONDENSED);
        NameHeuristics.widthPatterns[9] = new PatternToStretch(Pattern.compile("[- ]semi\\s*expanded", 2), CSS20Attribute.CSSStretchValue.SEMIEXPANDED);
        NameHeuristics.widthPatterns[10] = new PatternToStretch(Pattern.compile("[- ]semi\\s*extended", 2), CSS20Attribute.CSSStretchValue.SEMIEXPANDED);
        NameHeuristics.widthPatterns[11] = new PatternToStretch(Pattern.compile("[- ]extra\\s*expanded", 2), CSS20Attribute.CSSStretchValue.EXTRAEXPANDED);
        NameHeuristics.widthPatterns[12] = new PatternToStretch(Pattern.compile("[- ]extra\\s*extended", 2), CSS20Attribute.CSSStretchValue.EXTRAEXPANDED);
        NameHeuristics.widthPatterns[13] = new PatternToStretch(Pattern.compile("[- ]ultra\\s*expanded", 2), CSS20Attribute.CSSStretchValue.ULTRAEXPANDED);
        NameHeuristics.widthPatterns[14] = new PatternToStretch(Pattern.compile("[- ]ultra\\s*extended", 2), CSS20Attribute.CSSStretchValue.ULTRAEXPANDED);
        NameHeuristics.widthPatterns[15] = new PatternToStretch(Pattern.compile("[- ]expanded", 2), CSS20Attribute.CSSStretchValue.EXPANDED);
        NameHeuristics.widthPatterns[16] = new PatternToStretch(Pattern.compile("[- ]extended", 2), CSS20Attribute.CSSStretchValue.EXPANDED);
        smallCapsPattern = Pattern.compile("[- ]small\\s*caps", 2);
        dingbatsPatterns = new Pattern[]{Pattern.compile("Zapf\\s*Dingbats", 2), Pattern.compile("Adobe\\s*Pi", 2)};
    }

    private static class PatternToStretch {
        final Pattern pattern;
        final CSS20Attribute.CSSStretchValue stretch;

        PatternToStretch(Pattern pattern, CSS20Attribute.CSSStretchValue cSSStretchValue) {
            this.pattern = pattern;
            this.stretch = cSSStretchValue;
        }
    }

    private static class PatternToWeight {
        final Pattern pattern;
        final int weight;

        PatternToWeight(Pattern pattern, int n) {
            this.pattern = pattern;
            this.weight = n;
        }
    }
}

