/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.embedding.avmplus;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import macromedia.abc.BytecodeBuffer;
import macromedia.asc.embedding.avmplus.ByteCodeFactory;
import macromedia.asc.embedding.avmplus.ClassBuilder;
import macromedia.asc.embedding.avmplus.DebugInfo;
import macromedia.asc.embedding.avmplus.InstanceBuilder;
import macromedia.asc.embedding.avmplus.RuntimeConstants;
import macromedia.asc.parser.LiteralNumberNode;
import macromedia.asc.parser.MetaDataEvaluator;
import macromedia.asc.parser.MetaDataNode;
import macromedia.asc.semantics.Builder;
import macromedia.asc.semantics.Emitter;
import macromedia.asc.semantics.MethodSlot;
import macromedia.asc.semantics.NamespaceValue;
import macromedia.asc.semantics.ObjectValue;
import macromedia.asc.semantics.QName;
import macromedia.asc.semantics.ReferenceValue;
import macromedia.asc.semantics.Slot;
import macromedia.asc.semantics.TypeInfo;
import macromedia.asc.semantics.TypeValue;
import macromedia.asc.semantics.Value;
import macromedia.asc.semantics.VariableSlot;
import macromedia.asc.util.Boxing;
import macromedia.asc.util.ByteList;
import macromedia.asc.util.Context;
import macromedia.asc.util.IntList;
import macromedia.asc.util.IntegerPool;
import macromedia.asc.util.Names;
import macromedia.asc.util.Namespaces;
import macromedia.asc.util.ObjectList;
import macromedia.asc.util.Qualifiers;

/*
 * This class specifies class file version 47.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionBlockEmitter
extends Emitter {
    public static final int MAJOR = 46;
    public static final int MINOR = 16;
    private ActionBlock ab;
    private Context cx;
    private ByteCodeFactory bytecodeFactory;
    protected int max_locals;
    protected int cur_locals;
    protected int max_stack;
    protected int cur_stack;
    protected int max_scope;
    protected int cur_scope;
    protected int max_params;
    protected String scriptname;
    protected String modulename;
    protected ObjectList<ExceptionBlock> exceptionBlocks = new ObjectList();
    protected IntList if_addrs = new IntList();
    protected IntList try_addrs = new IntList();
    protected IntList else_addrs = new IntList();
    protected IntList loopbegin_addrs = new IntList();
    protected ObjectList<IntList> break_addrs = new ObjectList();
    protected IntList break_scope_depth = new IntList();
    protected IntList break_temp_count = new IntList();
    protected ObjectList<IntList> continue_addrs = new ObjectList();
    protected IntList continue_scope_depth = new IntList();
    protected IntList switchbegin_addrs = new IntList();
    protected ObjectList<IntList> case_addrs = new ObjectList();
    protected IntList default_addrs = new IntList();
    protected IntList seen_default_case = new IntList();
    private boolean sets_dxns;
    private Map<ObjectValue, Integer> nsConstants = new HashMap<ObjectValue, Integer>();
    protected ObjectList<String> method_infos = new ObjectList();
    protected Map<String, Integer> method_infos_map = new HashMap<String, Integer>();
    protected ObjectList<String> metadata_infos = new ObjectList();
    protected Map<String, Integer> metadata_infos_map = new HashMap<String, Integer>();
    protected ObjectList<QName> class_infos = new ObjectList();
    protected ObjectList<String> package_infos = new ObjectList();
    protected ObjectList<String> global_method_names = new ObjectList();
    IntList stackDepthStack = new IntList();
    IntList scopeDepthStack = new IntList();
    static final int IKIND_push = 1;
    static final int IKIND_other = 2;
    static final int IKIND_coerce = 3;
    protected int last_in;
    protected int last_ip;
    static final int DI_BAD = 0;
    static final int DI_LOCAL = 1;
    public boolean show_instructions;
    public boolean show_linenums;
    public boolean show_stacknames;
    public boolean emit_debug_info;
    private DebugInfo debug_info = new DebugInfo();
    private PrintWriter code_out;
    private PrintWriter header_out;
    public int native_method_count = 0;
    public int native_class_count = 0;
    public int native_package_count = 1;
    static final /* synthetic */ boolean $assertionsDisabled;

    int addClassName(QName qName) {
        if (qName == null || qName.toString().equals("*")) {
            return 0;
        }
        String string = qName.name;
        int n = this.addNamespace(qName.ns);
        int n2 = this.ab.addUtf8Constant(this.bytecodeFactory.ConstantUtf8Info(string));
        int n3 = this.ab.addMultiNameConstant(this.bytecodeFactory.ConstantQualifiedName(n2, n, false));
        return n3;
    }

    int addNamespace(ObjectValue objectValue) {
        int n;
        if (objectValue == this.cx.anyNamespace()) {
            return 0;
        }
        if (this.nsConstants.containsKey(objectValue)) {
            return this.nsConstants.get(objectValue);
        }
        int n2 = this.ab.addUtf8Constant(this.bytecodeFactory.ConstantUtf8Info(objectValue.name));
        if (objectValue.isPackage()) {
            n = this.ab.addNsConstant(this.bytecodeFactory.ConstantPackageNamespace(n2));
        } else {
            switch (objectValue.getNamespaceKind()) {
                case 1: {
                    n = this.ab.addNsConstant(this.bytecodeFactory.ConstantInternalNamespace(n2));
                    break;
                }
                case 2: {
                    n = this.ab.addNsConstant(this.bytecodeFactory.ConstantPrivateNamespace(n2));
                    break;
                }
                case 3: {
                    n = this.ab.addNsConstant(this.bytecodeFactory.ConstantProtectedNamespace(n2));
                    break;
                }
                case 5: {
                    n = this.ab.addNsConstant(this.bytecodeFactory.ConstantStaticProtectedNamespace(n2));
                    break;
                }
                default: {
                    n = this.ab.addNsConstant(this.bytecodeFactory.ConstantNamespace(n2));
                }
            }
        }
        this.nsConstants.put(objectValue, Boxing.valueOf(n));
        return n;
    }

    int makeNamespaceSet(ObjectList<ObjectValue> objectList) {
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        for (ObjectValue objectValue : objectList) {
            if (objectValue != null) {
                int n = this.addNamespace(objectValue);
                treeSet.add(IntegerPool.getNumber(n));
                continue;
            }
            this.cx.internalError("internal error: non object value for namespace");
        }
        int n = this.ab.addNsSetConstant(this.bytecodeFactory.ConstantNamespaceSet(treeSet));
        return n;
    }

    int makeMultiname(String string, ObjectList<ObjectValue> objectList) {
        int n = this.ab.addUtf8Constant(this.bytecodeFactory.ConstantUtf8Info(string));
        int n2 = this.makeNamespaceSet(objectList);
        int n3 = this.ab.addMultiNameConstant(this.bytecodeFactory.ConstantMultiname(n, n2, false));
        return n3;
    }

    @Override
    protected void StartClass(String string) {
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print(new StringBuffer().append("// ++StartClass ").append(string).toString());
        }
        this.showLineNumber();
    }

    @Override
    protected void FinishClass(Context context, QName qName, QName qName2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        int n;
        Builder builder;
        ObjectValue objectValue;
        ObjectList<ByteList> objectList = new ObjectList<ByteList>();
        ObjectList<ByteList> objectList2 = new ObjectList<ByteList>();
        IntList intList = new IntList();
        int n2 = context.getScopes().size();
        ObjectValue objectValue2 = null;
        if (!bl3) {
            objectValue = context.scope(n2 - 2);
            builder = objectValue.builder;
            objectValue2 = ((ClassBuilder)builder).protected_namespace;
            this.FinishTraits(objectValue, objectList);
        }
        objectValue = context.scope(n2 - 1);
        builder = objectValue.builder instanceof InstanceBuilder ? (InstanceBuilder)objectValue.builder : null;
        for (ReferenceValue value2 : ((InstanceBuilder)builder).interface_refs) {
            intList.add(this.makeMultiname(value2.name, value2.getImmutableNamespaces()));
        }
        this.FinishTraits(objectValue, objectList2);
        int n3 = this.addClassName(qName);
        int n4 = qName2 == null ? 0 : this.addClassName(qName2);
        int n5 = 0;
        ObjectValue n7 = context.scope();
        int n6 = n7.getSlotIndex(context, -78, "$construct", context.publicNamespace());
        n6 = n7.getImplicitIndex(context, n6, -132);
        Slot n8 = n7.getSlot(context, n6);
        n5 = this.GetMethodInfo(n8.getMethodName());
        int n9 = this.GetClassInfo(qName);
        n6 = 0;
        if (!bl) {
            n6 |= 1;
        }
        if (bl2) {
            n6 |= 2;
        }
        if (bl3) {
            n6 |= 4;
        }
        if (!bl4) {
            n6 |= 0x10;
        }
        int n10 = n = objectValue2 != null ? this.addNamespace(objectValue2) : 0;
        if (n != 0) {
            n6 |= 8;
        }
        this.ab.addBytesToTable(this.ab.instances, this.bytecodeFactory.InstanceInfo(this.ab.instances.at(n9), n3, n4, n6, n, intList.size(), intList, n5, objectList2, n9));
        int n11 = this.GetMethodInfo(new StringBuffer().append(qName).append("$cinit").toString());
        this.ab.addBytesToTable(this.ab.classes, this.bytecodeFactory.ClassInfo(this.ab.classes.at(n9), n11, objectList, n9));
        String string = qName.toString().replace('.', '_');
        string = string.replace('/', '_');
        string = string.replace(':', '_');
        string = string.replace('|', '_');
        string = string.replace('$', '_');
        this.header_out.println(new StringBuffer().append("const int abcclass_").append(string).append(" = ").append(n9).append(";").toString());
        if (n9 >= this.native_class_count) {
            this.native_class_count = n9 + 1;
        }
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print(new StringBuffer().append("// --FinishClass ").append(qName).append(" ").append(qName2 != null ? qName2.toString() : "").toString());
        }
        this.showLineNumber();
    }

    @Override
    protected void StartProgram(String string) {
        this.modulename = string;
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print(new StringBuffer().append("// ++StartProgram ").append(this.modulename).toString());
        }
    }

    @Override
    public ByteList emit(ByteList byteList) {
        return this.bytecodeFactory.ActionBlock(byteList, this.ab.minor_version, this.ab.major_version, this.ab.constant_int_pool.size() == 0 ? 0 : this.ab.constant_int_pool.size() + 1, this.ab.constant_int_pool, this.ab.constant_uint_pool.size() == 0 ? 0 : this.ab.constant_uint_pool.size() + 1, this.ab.constant_uint_pool, this.ab.constant_double_pool.size() == 0 ? 0 : this.ab.constant_double_pool.size() + 1, this.ab.constant_double_pool, this.ab.constant_utf8_pool.size() == 0 ? 0 : this.ab.constant_utf8_pool.size() + 1, this.ab.constant_utf8_pool, this.ab.constant_mn_pool.size() == 0 ? 0 : this.ab.constant_mn_pool.size() + 1, this.ab.constant_mn_pool, this.ab.constant_nss_pool.size() == 0 ? 0 : this.ab.constant_nss_pool.size() + 1, this.ab.constant_nss_pool, this.ab.constant_ns_pool.size() == 0 ? 0 : this.ab.constant_ns_pool.size() + 1, this.ab.constant_ns_pool, this.ab.methods.size() == 0 ? 0 : this.ab.methods.size(), this.ab.methods, this.ab.metadata.size() == 0 ? 0 : this.ab.metadata.size(), this.ab.metadata, this.ab.classes.size() == 0 ? 0 : this.ab.classes.size(), this.ab.instances, this.ab.classes, this.ab.scripts.size() == 0 ? 0 : this.ab.scripts.size(), this.ab.scripts, this.ab.bodies.size() == 0 ? 0 : this.ab.bodies.size(), this.ab.bodies);
    }

    int getValueIndex(ObjectValue objectValue) {
        TypeValue typeValue;
        int n = 0;
        String string = objectValue.toString();
        TypeValue typeValue2 = typeValue = objectValue.type != null ? objectValue.type.getTypeValue() : null;
        if (typeValue == this.cx.booleanType()) {
            n = string.equals("true") ? 11 : 10;
        } else if (typeValue == this.cx.stringType()) {
            n = this.ab.addUtf8Constant(this.bytecodeFactory.ConstantUtf8Info(string));
        } else if (typeValue == this.cx.intType()) {
            TypeValue[] typeValueArray = new TypeValue[1];
            n = this.ab.addIntConstant(this.bytecodeFactory.ConstantIntegerInfo((int)this.getValueOfNumberLiteral(string, typeValueArray)));
        } else if (typeValue == this.cx.numberType()) {
            TypeValue[] typeValueArray = new TypeValue[1];
            n = this.ab.addDoubleConstant(this.bytecodeFactory.ConstantDoubleInfo(this.getValueOfNumberLiteral(string, typeValueArray)));
        } else if (typeValue == this.cx.nullType()) {
            n = 12;
        } else if (typeValue == this.cx.voidType()) {
            n = 0;
        } else if (this.cx.isNamespace(objectValue)) {
            n = this.addNamespace(objectValue);
        }
        return n;
    }

    byte getValueKind(ObjectValue objectValue) {
        TypeValue typeValue;
        int n = 0;
        String string = objectValue.toString();
        TypeValue typeValue2 = typeValue = objectValue.type != null ? objectValue.type.getTypeValue() : null;
        if (typeValue == this.cx.booleanType()) {
            n = string.equals("true") ? 11 : 10;
        } else if (typeValue == this.cx.stringType()) {
            n = 1;
        } else if (typeValue == this.cx.intType()) {
            n = 3;
        } else if (typeValue == this.cx.numberType()) {
            n = 6;
        } else if (typeValue == this.cx.nullType()) {
            n = 12;
        } else if (typeValue == this.cx.voidType()) {
            n = 12;
        } else if (this.cx.isNamespace(objectValue)) {
            n = 8;
        }
        return (byte)n;
    }

    @Override
    protected void DefineSlotVariable(Context context, String string, String string2, int n, TypeInfo typeInfo, int n2) {
        if (this.emit_debug_info) {
            this.DebugSlot(string, n2, this.debug_info.debug_linenum);
        }
    }

    @Override
    protected void StartMethod() {
        this.StartMethod("", 0, 0, 0, false, 0);
    }

    @Override
    protected void StartMethod(String string, int n, int n2, int n3, boolean bl, int n4) {
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print(new StringBuffer().append("// ++StartMethod ").append(string).toString());
        }
        this.max_stack = 0;
        this.cur_stack = 0;
        this.max_scope = 0;
        this.cur_scope = 0;
        this.max_params = n + 1;
        this.cur_locals = !bl ? (this.max_locals = n + n2 + n3 + 1) : (this.max_locals = n + n3 + (n4 != 0 ? 1 : 0) + 1);
        this.ab.code = ByteCodeFactory.allocBytes();
        this.last_in = 2;
        if (string.equals("$init")) {
            this.method_infos_map.remove(string);
        }
        this.GetMethodInfo(string);
        this.debug_info.debug_file_dirty = true;
        this.debug_info.debug_linenum_dirty = true;
        this.debug_info.suppress_debug_method = string.indexOf("$iinit") != -1 || string.indexOf("$cinit") != -1;
        this.sets_dxns = false;
    }

    @Override
    protected int FinishMethod(Context context, String string, TypeInfo typeInfo, ObjectList<TypeInfo> objectList, ObjectValue objectValue, int n, int n2, String string2, boolean bl, boolean bl2, String[] stringArray) {
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print(new StringBuffer().append("// --FinishMethod ").append(string).append(" ").append(string2).toString());
        }
        this.showLineNumber();
        int n3 = this.GetMethodInfo(string);
        ObjectList<ByteList> objectList2 = new ObjectList<ByteList>();
        if (objectValue != null) {
            ObjectValue objectValue2 = objectValue;
            this.FinishTraits(objectValue2, objectList2);
        }
        int n4 = 0;
        n4 |= n;
        n4 |= objectValue != null ? 2 : 0;
        int n5 = this.ab.addUtf8Constant(this.bytecodeFactory.ConstantUtf8Info(this.emit_debug_info ? string2 : ""));
        if (bl) {
            n4 |= 0x20;
        }
        if (this.sets_dxns) {
            n4 |= 0x40;
        }
        int n6 = typeInfo != null ? this.addClassName(typeInfo.getName(context)) : 0;
        IntList intList = null;
        IntList intList2 = null;
        ByteList byteList = null;
        Object object = context.scope();
        Object object2 = ((ObjectValue)object).slots;
        if (object2 != null) {
            intList = new IntList(((ArrayList)object2).size());
            intList2 = new IntList(((ArrayList)object2).size());
            byteList = new ByteList(((ArrayList)object2).size());
            Iterator iterator = ((ArrayList)object2).iterator();
            boolean bl3 = false;
            for (int i = 1; iterator.hasNext() && i < this.max_params; ++i) {
                Slot slot = (Slot)iterator.next();
                int n7 = this.addClassName(slot.getType().getName(context));
                intList.add(n7);
                int n8 = 0;
                int n9 = 0;
                if (slot.getInitializerValue() != null) {
                    TypeValue typeValue;
                    bl3 = true;
                    String string3 = slot.getInitializerValue().toString();
                    TypeValue typeValue2 = typeValue = slot.getInitializerValue().type != null ? slot.getInitializerValue().type.getTypeValue() : null;
                    if (typeValue == context.booleanType()) {
                        n8 = string3.equals("true") ? 11 : 10;
                        n9 = string3.equals("true") ? 11 : 10;
                    } else if (typeValue == context.stringType()) {
                        n8 = this.ab.addUtf8Constant(this.bytecodeFactory.ConstantUtf8Info(string3));
                        n9 = 1;
                    } else if (typeValue == context.intType()) {
                        n8 = this.ab.addIntConstant(this.bytecodeFactory.ConstantIntegerInfo((int)this.getValueOfNumberLiteral(string3, new TypeValue[1])));
                        n9 = 3;
                    } else if (typeValue == context.numberType()) {
                        n8 = this.ab.addDoubleConstant(this.bytecodeFactory.ConstantDoubleInfo(this.getValueOfNumberLiteral(string3, new TypeValue[1])));
                        n9 = 6;
                    } else if (typeValue == context.nullType()) {
                        n8 = 12;
                        n9 = 12;
                    } else if (typeValue == context.voidType()) {
                        n8 = 0;
                        n9 = 0;
                    } else if (slot.getInitializerValue() instanceof NamespaceValue) {
                        n8 = this.addNamespace(slot.getInitializerValue());
                        n9 = 8;
                    }
                }
                if (!bl3) continue;
                intList2.add(n8);
                byteList.add((byte)n9);
            }
            if (bl3) {
                n4 |= 8;
            }
        }
        object = null;
        if (this.emit_debug_info && stringArray != null) {
            n4 |= 0x80;
            object = new IntList(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                ((IntList)object).add(this.ab.addUtf8Constant(this.bytecodeFactory.ConstantUtf8Info(stringArray[i])));
            }
        }
        this.bytecodeFactory.MethodInfo(this.ab.methods.at(n3), this.max_params - 1, n6, intList, intList2, byteList, (IntList)object, n5, n4, n3);
        if (!bl) {
            if (!bl2) {
                this.ab.addBody(this.bytecodeFactory.MethodBody(ByteCodeFactory.allocBytes(), (short)this.max_stack, this.max_locals, n2, n2 + this.max_scope, this.ab.code.size(), this.ab.code, this.ab.exception_count, this.ab.exception_table, objectList2, n3));
            }
        } else {
            object2 = string2.replace('.', '_');
            object2 = ((String)object2).replace('/', '_');
            object2 = ((String)object2).replace(':', '_');
            object2 = ((String)object2).replace('|', '_');
            object2 = ((String)object2).replace('$', '_');
            this.header_out.println(new StringBuffer().append("const int ").append((String)object2).append(" = ").append(n3).append(";").toString());
            if (n3 >= this.native_method_count) {
                this.native_method_count = n3 + 1;
            }
        }
        this.max_locals = 0;
        this.cur_locals = 0;
        this.ab.exception_count = 0;
        this.ab.exception_table.clear();
        return n3;
    }

    protected void MakeDispatchMethod(Context context) {
    }

    @Override
    public int GetMethodInfo(String string) {
        Integer n = this.method_infos_map.get(string);
        if (n != null) {
            return n;
        }
        n = Boxing.valueOf(this.method_infos.size());
        this.method_infos_map.put(string, n);
        this.method_infos.add(string);
        this.ab.methods.add(ByteCodeFactory.allocBytes());
        if (this.method_infos.size() != this.ab.methods.size()) {
            this.cx.internalError("internal error: internal method name and info out of sync");
        }
        return n;
    }

    public int GetMetadataInfo(String string) {
        Integer n = this.metadata_infos_map.get(string);
        if (n != null) {
            return n;
        }
        n = Boxing.valueOf(this.metadata_infos_map.size());
        this.metadata_infos_map.put(string, n);
        this.metadata_infos.add(string);
        this.ab.metadata.add(ByteCodeFactory.allocBytes());
        if (this.metadata_infos.size() != this.ab.metadata.size()) {
            this.cx.internalError("internal error: internal metadata name and info out of sync");
        }
        return n;
    }

    public int GetClassInfo(QName qName) {
        int n;
        for (n = 0; n < this.class_infos.size(); ++n) {
            if (!((QName)this.class_infos.get(n)).equals(qName)) continue;
            return n;
        }
        this.class_infos.push_back(qName);
        this.ab.classes.push_back(ByteCodeFactory.allocBytes());
        this.ab.instances.push_back(ByteCodeFactory.allocBytes());
        if (this.class_infos.size() != this.ab.classes.size()) {
            this.cx.internalError("internal error: internal class name and info out of sync");
        }
        return n;
    }

    public int GetPackageInfo(String string) {
        return this.GetPackageInfo(string, false);
    }

    public int GetPackageInfo(String string, boolean bl) {
        int n;
        for (n = 0; n < this.package_infos.size(); ++n) {
            if (!((String)this.package_infos.get(n)).equals(string)) continue;
            return n;
        }
        if (bl) {
            return -1;
        }
        this.package_infos.push_back(string);
        this.ab.scripts.push_back(ByteCodeFactory.allocBytes());
        if (this.package_infos.size() != this.ab.scripts.size()) {
            this.cx.internalError("internal error: internal class name and info out of sync");
        }
        return n;
    }

    @Override
    public int GetMethodId(String string, Namespaces namespaces) {
        int n = this.global_method_names.size();
        for (int i = 0; i < n; ++i) {
            if (!string.equals(this.global_method_names.get(i))) continue;
            return i + 1;
        }
        this.global_method_names.add(string);
        return this.global_method_names.size();
    }

    protected String GetMethodName(int n) {
        if (n > 0 && n <= this.global_method_names.size()) {
            return (String)this.global_method_names.get(n - 1);
        }
        this.cx.internalError("invalid method name");
        return "";
    }

    protected String getBinaryName(int n) {
        switch (n) {
            case 1: {
                return "BinaryPlusOp_II";
            }
            case 0: {
                return "BinaryPlusOp";
            }
            case 2: {
                return "BinaryMinusOp";
            }
            case 3: {
                return "BinaryMinusOp_II";
            }
            case 4: {
                return "MultiplyOp";
            }
            case 5: {
                return "MultiplyOp_II";
            }
            case 6: {
                return "DivideOp";
            }
            case 8: {
                return "ModulusOp";
            }
            case 10: {
                return "LeftShiftOp";
            }
            case 11: {
                return "LeftShiftOp_II";
            }
            case 12: {
                return "RightShiftOp";
            }
            case 13: {
                return "RightShiftOp_II";
            }
            case 14: {
                return "UnsignedRightShiftOp";
            }
            case 15: {
                return "UnsignedRightShiftOp_II";
            }
            case 16: {
                return "LessThanOp";
            }
            case 18: {
                return "GreaterThanOp";
            }
            case 20: {
                return "LessThanOrEqualOp";
            }
            case 22: {
                return "GreaterThanOrEqualOp";
            }
            case 24: {
                return "InstanceofOp";
            }
            case 25: {
                return "InOp";
            }
            case 29: {
                return "EqualsOp_II";
            }
            case 28: {
                return "EqualsOp";
            }
            case 31: {
                return "NotEqualsOp_II";
            }
            case 30: {
                return "NotEqualsOp";
            }
            case 32: {
                return "StrictEqualsOp";
            }
            case 33: {
                return "StrictEqualsOp_II";
            }
            case 34: {
                return "StrictNotEqualsOp";
            }
            case 35: {
                return "StrictNotEqualsOp_II";
            }
            case 36: {
                return "BitwiseAndOp";
            }
            case 37: {
                return "BitwiseAndOp_II";
            }
            case 38: {
                return "BitwiseXorOp";
            }
            case 39: {
                return "BitwiseXorOp_II";
            }
            case 40: {
                return "BitwiseOrOp";
            }
            case 41: {
                return "BitwiseOrOp_II";
            }
            case 42: {
                return "LogicalAndOp";
            }
            case 43: {
                return "LogicalAndOp_II";
            }
            case 45: {
                return "LogicalOrOp";
            }
            case 46: {
                return "LogicalOrOp_II";
            }
            case 27: {
                return "IsLateOp";
            }
            case 26: {
                return "IsOp";
            }
            case 49: {
                return "AsLateOp";
            }
            case 48: {
                return "AsOp";
            }
        }
        return "N/A";
    }

    private final int unHex(char c) {
        return Character.digit(c, 16);
    }

    @Override
    public double getValueOfNumberLiteral(String string, TypeValue[] typeValueArray) {
        Double d;
        double d2 = 1.0;
        int n = string.length();
        int n2 = 0;
        double d3 = 0.0;
        int n3 = 10;
        if (string.equals("NaN")) {
            typeValueArray[0] = this.cx.numberType();
            return Double.NaN;
        }
        if (string.equals("Infinity")) {
            typeValueArray[0] = this.cx.numberType();
            return Double.POSITIVE_INFINITY;
        }
        if (string.equals("-Infinity")) {
            typeValueArray[0] = this.cx.numberType();
            return Double.NEGATIVE_INFINITY;
        }
        if ((string.indexOf(".") > -1 || string.indexOf("e") > -1 || string.indexOf("E") > -1 || string.length() > 10) && string.indexOf("x") <= -1 && string.indexOf("X") <= -1) {
            Double d4 = Double.valueOf(string);
            if (d4.isNaN()) {
                d3 = Double.NaN;
                typeValueArray[0] = this.cx.numberType();
            } else if (d4.isInfinite()) {
                d3 = string.charAt(0) == '-' ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
                typeValueArray[0] = this.cx.numberType();
            } else if (d4 == 0.0 && string.charAt(0) == '-') {
                d3 = d4;
                typeValueArray[0] = this.cx.numberType();
            } else {
                int n4;
                d3 = d4;
                typeValueArray[0] = d3 == (double)(n4 = (int)d3) ? this.cx.intType() : this.cx.numberType();
            }
            return d3;
        }
        if (n > 1 && (string.charAt(0) == '-' || string.charAt(0) == '+')) {
            d2 = string.charAt(0) == '-' ? -1.0 : 1.0;
            n2 = 1;
        }
        if (n > 2 && string.charAt(n2) == '0') {
            if (string.charAt(++n2) == 'x' || string.charAt(n2) == 'X') {
                n3 = 16;
                ++n2;
            } else {
                n3 = 10;
            }
        }
        while (n2 < n && string.charAt(n2) == '0') {
            ++n2;
        }
        String string2 = string.substring(n2, n);
        n -= n2;
        n2 = 0;
        int n5 = 0;
        boolean bl = false;
        switch (n3) {
            case 10: {
                for (int i = n2; i < n; ++i) {
                    n5 = string2.charAt(i) - 48;
                    d3 = d3 * (double)n3 + (double)n5;
                }
                if (!(d3 > 2.147483647E9)) break;
                d = Double.valueOf(string2);
                d3 = d;
                break;
            }
            case 8: {
                int n6;
                for (n6 = n2; n6 * 3 < 52 && n6 < n; ++n6) {
                    n5 = string2.charAt(n6) - 48;
                    d3 = d3 * (double)n3 + (double)n5;
                }
                if (n6 >= n - 1) break;
                int n7 = n5 & 1;
                int n8 = (n5 & 2) >> 1;
                bl = false;
                double d5 = 1.0;
                while (n6++ < n) {
                    n5 = string2.charAt(n6) - 48;
                    bl |= n5 != 0;
                    d5 *= (double)n3;
                }
                bl = n8 != 0 && (n7 != 0 || bl);
                d3 += bl ? 1.0 : 0.0;
                d3 *= d5;
                break;
            }
            case 16: {
                int n9;
                for (n9 = n2; n9 * 4 < 53 && n9 < n; ++n9) {
                    n5 = this.unHex(string2.charAt(n9));
                    d3 = d3 * (double)n3 + (double)n5;
                }
                if (n9 >= n) break;
                int n10 = n5 & 1;
                n5 = this.unHex(string2.charAt(n9));
                int n11 = (n5 & 8) >> 3;
                bl = (n5 & 7) != 0;
                double d6 = n3;
                while (++n9 < n) {
                    n5 = this.unHex(string2.charAt(n9));
                    bl |= n5 != 0;
                    d6 *= (double)n3;
                }
                bl = n11 != 0 && (n10 != 0 || bl);
                d3 += bl ? 1.0 : 0.0;
                d3 *= d6;
            }
        }
        if (d2 == -1.0 && d3 == 0.0) {
            d = Double.valueOf("-0");
            typeValueArray[0] = this.cx.numberType();
            return d;
        }
        int n12 = (int)d3;
        typeValueArray[0] = d3 == (double)n12 ? this.cx.intType() : this.cx.numberType();
        return d3 * d2;
    }

    protected String getUnaryName(int n) {
        switch (n) {
            case 2: {
                return "put";
            }
            case 3: {
                return "get";
            }
            case 4: {
                return "HasMoreNamesOp";
            }
            case 5: {
                return "NextNameOp";
            }
            case 6: {
                return "NextValueOp";
            }
            case 10: {
                return "DeleteOp";
            }
            case 12: {
                return "TypeofOp";
            }
            case 14: {
                return "TypeofOp_I";
            }
            case 18: {
                return "IncrementOp";
            }
            case 20: {
                return "IncrementOp_I";
            }
            case 19: {
                return "IncrementLocalOp";
            }
            case 21: {
                return "IncrementLocalOp_I";
            }
            case 22: {
                return "DecrementOp";
            }
            case 24: {
                return "DecrementOp_I";
            }
            case 23: {
                return "DecrementLocalOp";
            }
            case 25: {
                return "DecrementLocalOp_I";
            }
            case 26: {
                return "UnaryPlusOp";
            }
            case 27: {
                return "UnaryPlusOp_I";
            }
            case 28: {
                return "UnaryMinusOp";
            }
            case 29: {
                return "UnaryMinusOp_I";
            }
            case 30: {
                return "BitwiseNotOp";
            }
            case 31: {
                return "BitwiseNotOp_I";
            }
            case 32: {
                return "LogicalNotOp";
            }
            case 33: {
                return "LogicalNotOp_B";
            }
            case 34: {
                return "LogicalNotOp_I";
            }
            case 35: {
                return "ToXMLString";
            }
            case 36: {
                return "ToXMLAttrString";
            }
            case 37: {
                return "CheckFilterOperand";
            }
        }
        return "N/A";
    }

    protected double stringToDouble(String string) {
        double d;
        block4: {
            boolean bl;
            d = 0.0;
            double d2 = string.charAt(0) == '-' ? -1.0 : 1.0;
            int n = string.charAt(0) == '+' || string.charAt(0) == '-' ? 1 : 0;
            boolean bl2 = string.startsWith("0x", n) || string.startsWith("0X", n);
            boolean bl3 = !bl2 && (string.indexOf(46) != -1 || string.indexOf(101) != -1 || string.indexOf(69) != -1);
            boolean bl4 = bl = !bl2 && !bl3 && string.startsWith("0", n);
            int n2 = bl2 ? 16 : (bl ? 8 : 10);
            try {
                if (n2 != 10) {
                    String string2 = bl2 ? string.substring(n + 2) : string.substring(n);
                    d = d2 * (double)Long.parseLong(string2, n2);
                } else {
                    d = Double.parseDouble(string);
                }
            }
            catch (NumberFormatException numberFormatException) {
                if ($assertionsDisabled) break block4;
                throw new Error();
            }
        }
        return d;
    }

    @Override
    protected int allocateTemp() {
        int n = this.cur_locals++;
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print(new StringBuffer().append("AllocTemp ").append(n).toString());
        }
        if (this.cur_locals > this.max_locals) {
            this.max_locals = this.cur_locals;
        }
        return n - 1;
    }

    @Override
    protected void Kill(int n) {
        ++n;
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print(new StringBuffer().append("Kill ").append(n).toString());
        }
        this.Kill(this.ab.code, n);
    }

    @Override
    protected void freeTemp(int n) {
        ++n;
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print(new StringBuffer().append("FreeTemp ").append(n).toString());
            if (n != this.cur_locals - 1) {
                this.code_out.write("  out of order");
            }
        }
        this.Kill(this.ab.code, n);
        --this.cur_locals;
    }

    @Override
    protected int getTempCount() {
        return this.cur_locals;
    }

    protected void stack(int n) {
        this.cur_stack += n;
        if (this.cur_stack > this.max_stack) {
            this.max_stack = this.cur_stack;
        }
    }

    protected void scope(int n) {
        this.cur_scope += n;
        if (this.cur_scope > this.max_scope) {
            this.max_scope = this.cur_scope;
        }
    }

    protected void saveStackDepth() {
        this.stackDepthStack.add(this.cur_stack);
        this.scopeDepthStack.add(this.cur_scope);
    }

    protected void restoreStackDepth() {
        this.cur_stack = this.stackDepthStack.removeLast();
        this.cur_scope = this.scopeDepthStack.last();
        this.scopeDepthStack.removeLast();
    }

    @Override
    protected int getIP() {
        return this.ab.code != null ? this.ab.code.size() : -1;
    }

    protected void showLineNumber() {
        if (this.show_linenums) {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            String[] stringArray = new String[1];
            this.getOriginAndPosition(stringArray, nArray, nArray2);
            this.code_out.println();
            this.code_out.print(new StringBuffer().append("[Ln ").append(nArray[0]).append("]").toString());
        }
    }

    public TypeValue getTypeOfNumberLiteral(LiteralNumberNode literalNumberNode) {
        TypeValue[] typeValueArray = new TypeValue[1];
        literalNumberNode.numericValue = this.getValueOfNumberLiteral(literalNumberNode.value, typeValueArray);
        literalNumberNode.type = literalNumberNode.value.indexOf(".eE") > -1 && literalNumberNode.value.indexOf("xX") <= -1 ? this.cx.numberType() : typeValueArray[0];
        return literalNumberNode.type;
    }

    @Override
    protected void Break(int n) {
        int n2;
        int n3;
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print(new StringBuffer().append("Break target ").append(n).toString());
        }
        this.flushDebugInfo();
        this.last_in = 2;
        int n4 = this.break_temp_count.get(n);
        for (n3 = this.cur_locals - 1; n3 >= n4; --n3) {
            this.Kill(this.ab.code, n3);
        }
        n3 = this.break_scope_depth.get(n) - 1;
        int n5 = this.getRegisterOffset(this.cx);
        int n6 = this.cx.getScopeDepth() - 1;
        for (n2 = this.exceptionBlocks.size(); n2 > 0 && this.exceptionBlocks.at((int)(n2 - 1)).loop_index >= n; --n2) {
            int n7;
            ExceptionBlock exceptionBlock = this.exceptionBlocks.at(n2 - 1);
            while (n6 > exceptionBlock.scopeIndex) {
                this.Popscope(this.ab.code);
                n7 = this.cx.scope((int)n6).builder.temp_reg;
                if (n7 != -1) {
                    this.Kill(this.ab.code, n7 + n5);
                }
                --n6;
            }
            if (!exceptionBlock.hasFinally) continue;
            this.Label(this.ab.code);
            n7 = exceptionBlock.finallyAddrs.size();
            this.Pushbyte(this.ab.code, n7);
            this.Jump(this.ab.code);
            exceptionBlock.fixups.add(this.getIP() - 3);
            this.Label(this.ab.code);
            this.Pop();
            exceptionBlock.finallyAddrs.add(this.getIP());
            this.Label(this.ab.code);
        }
        while (n6 > n3) {
            this.Popscope(this.ab.code);
            n2 = this.cx.scope((int)n6).builder.temp_reg;
            if (n2 != -1) {
                this.Kill(this.ab.code, n2 + n5);
            }
            --n6;
        }
        if (n < this.break_addrs.size()) {
            this.Jump(this.ab.code);
            ((IntList)this.break_addrs.get(n)).add(this.getIP() - 3);
        }
        if (this.show_instructions) {
            this.code_out.write(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
    }

    @Override
    protected void CaseLabel(boolean bl) {
        this.showLineNumber();
        if (this.show_instructions) {
            if (bl) {
                this.code_out.println();
                this.code_out.print("CaseLabel default");
            } else {
                this.code_out.println();
                this.code_out.print("CaseLabel");
            }
        }
        this.restoreStackDepth();
        this.saveStackDepth();
        boolean bl2 = true;
        if (bl) {
            if (this.seen_default_case.last() == 0) {
                this.default_addrs.add(this.getIP());
                this.case_addrs.last().add(this.getIP());
                this.seen_default_case.set(this.seen_default_case.size() - 1, 1);
            }
        } else {
            if (this.case_addrs.last().size() > 0 && this.case_addrs.last().last() == this.getIP() - 1) {
                bl2 = false;
            }
            this.case_addrs.last().add(bl2 ? this.getIP() : this.getIP() - 1);
        }
        if (bl2) {
            this.Label(this.ab.code);
        }
        this.last_in = 2;
        if (this.show_instructions) {
            this.code_out.write(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
    }

    @Override
    protected void CheckType(QName qName) {
        if (qName.toString().length() == 0) {
            return;
        }
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print(new StringBuffer().append("CheckType ").append(qName).toString());
        }
        this.flushDebugInfo();
        if (this.last_in == 3) {
            this.stack(0);
            this.code_out.println();
            this.code_out.write(new StringBuffer().append("* ERASING ").append(this.ab.code.size() - this.last_ip).append(" bytes").toString());
            this.ab.code.remove(this.last_ip, this.ab.code.size() - this.last_ip);
        }
        this.last_ip = this.getIP();
        this.last_in = 3;
        String string = qName.toString();
        if ("*".equals(string)) {
            this.Coerce_a(this.ab.code);
        } else if ("String".equals(string)) {
            this.Coerce_s(this.ab.code);
        } else if ("Boolean".equals(string)) {
            this.Convert_b(this.ab.code);
        } else if ("Number".equals(string)) {
            this.Convert_d(this.ab.code);
        } else if ("int".equals(string)) {
            this.Convert_i(this.ab.code);
        } else if ("uint".equals(string)) {
            this.Convert_u(this.ab.code);
        } else {
            int n = this.addClassName(qName);
            this.Coerce(this.ab.code, n);
        }
        if (this.show_instructions) {
            this.code_out.write(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
    }

    @Override
    protected void Continue(int n) {
        int n2;
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print(new StringBuffer().append("Continue ").append(n).toString());
        }
        this.flushDebugInfo();
        this.last_in = 2;
        int n3 = this.continue_scope_depth.get(n) - 1;
        int n4 = this.getRegisterOffset(this.cx);
        int n5 = this.cx.getScopeDepth() - 1;
        for (n2 = this.exceptionBlocks.size(); n2 > 0 && this.exceptionBlocks.at((int)(n2 - 1)).loop_index >= n; --n2) {
            int n6;
            ExceptionBlock exceptionBlock = this.exceptionBlocks.at(n2 - 1);
            while (n5 > exceptionBlock.scopeIndex) {
                this.Popscope(this.ab.code);
                n6 = this.cx.scope((int)n5).builder.temp_reg;
                if (n6 != -1) {
                    this.Kill(this.ab.code, n6 + n4);
                }
                --n5;
            }
            if (!exceptionBlock.hasFinally) continue;
            this.Label(this.ab.code);
            n6 = exceptionBlock.finallyAddrs.size();
            this.Pushbyte(this.ab.code, n6);
            this.Jump(this.ab.code);
            exceptionBlock.fixups.add(this.getIP() - 3);
            this.Label(this.ab.code);
            this.Pop();
            exceptionBlock.finallyAddrs.add(this.getIP());
            this.Label(this.ab.code);
        }
        while (n5 > n3) {
            this.Popscope(this.ab.code);
            n2 = this.cx.scope((int)n5).builder.temp_reg;
            if (n2 != -1) {
                this.Kill(this.ab.code, n2 + n4);
            }
            --n5;
        }
        if (n >= 0 && n < this.continue_addrs.size()) {
            this.Jump(this.ab.code);
            ((IntList)this.continue_addrs.get(n)).add(this.getIP() - 3);
        }
        if (this.show_instructions) {
            this.code_out.write(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
    }

    protected void DebugSlot(String string, int n, int n2) {
        int n3 = this.ab.addUtf8Constant(this.bytecodeFactory.ConstantUtf8Info(string));
        this.DebugLocal(this.ab.code, n3, n, n2);
    }

    protected void DebugFile(String string) {
        int n = this.ab.addUtf8Constant(this.bytecodeFactory.ConstantUtf8Info(string));
        this.DebugFile(this.ab.code, n);
    }

    protected void DebugLine(int n) {
        this.DebugLine(this.ab.code, n);
    }

    protected void addSlotTrait(ObjectValue objectValue, ObjectList<ByteList> objectList, String string, Qualifiers qualifiers) {
        Map.Entry entry;
        Builder builder = objectValue.builder;
        IntList intList = new IntList(qualifiers.size());
        int n = -1;
        int n2 = -1;
        int n3 = 0;
        Slot slot = null;
        Iterator iterator = qualifiers.entrySet().iterator();
        Map.Entry entry2 = entry = iterator.hasNext() ? iterator.next() : null;
        while (entry != null) {
            Object object;
            int n4;
            int n5;
            int n6;
            Slot slot2;
            block8: {
                intList.clear();
                n2 = -1;
                ObjectValue objectValue2 = (ObjectValue)entry.getKey();
                int n7 = objectValue.getSlotIndex(this.cx, -78, string, objectValue2);
                slot2 = objectValue.getSlot(this.cx, n7);
                n2 = slot2.getVarIndex() + builder.var_offset + 1;
                if (slot2.declaredBy != objectValue) {
                    entry = iterator.hasNext() ? iterator.next() : null;
                    continue;
                }
                while (true) {
                    if (objectValue2 != null) {
                        n6 = this.addNamespace(objectValue2);
                        intList.add(n6);
                    } else {
                        this.cx.internalError("internal error: non object value for namespace");
                    }
                    Map.Entry entry3 = entry = iterator.hasNext() ? iterator.next() : null;
                    if (entry == null) break block8;
                    n = n2;
                    slot = slot2;
                    objectValue2 = (ObjectValue)entry.getKey();
                    n7 = objectValue.getSlotIndex(this.cx, -78, string, objectValue2);
                    if (n7 <= 0) continue;
                    slot2 = objectValue.getSlot(this.cx, n7);
                    n2 = slot2.getVarIndex() + builder.var_offset + 1;
                    n3 &= slot2.isFinal() ? 1 : 0;
                    n3 &= slot2.isOverride() ? 2 : 0;
                    if (n2 < 0 || n2 != n || slot2.declaredBy != slot.declaredBy) break;
                }
                n2 = n;
                slot2 = slot;
            }
            n6 = this.ab.addUtf8Constant(this.bytecodeFactory.ConstantUtf8Info(string));
            int n8 = this.ab.addMultiNameConstant(this.bytecodeFactory.ConstantQualifiedName(n6, intList.back(), false));
            ObjectValue objectValue3 = slot2.getInitializerValue();
            int n9 = 0;
            byte by = 0;
            if (objectValue3 != null && (objectValue3.builder instanceof ClassBuilder ? objectValue3.builder : null) != null) {
                n5 = 4;
                n4 = this.GetClassInfo(objectValue3.builder.classname);
            } else {
                int n10 = n5 = slot2.isConst() ? 6 : 0;
                if (objectValue3 != null) {
                    n9 = this.getValueIndex(objectValue3);
                    by = this.getValueKind(objectValue3);
                }
                object = slot2.getType().getName(this.cx);
                n4 = this.addClassName((QName)object);
            }
            object = this.addMetadata(slot2);
            objectList.push_back(ByteCodeFactory.allocBytes());
            this.ab.addBytesToTable(objectList, this.bytecodeFactory.TraitInfo(objectList.back(), n8, n5, objectValue.canEarlyBind() ? n2 : 0, n4, n9, by, (IntList)object));
        }
    }

    protected IntList addMetadata(Slot slot) {
        if (slot != null) {
            return this.addMetadata(slot.getMetadata());
        }
        return null;
    }

    protected IntList addMetadata(ArrayList<MetaDataNode> arrayList) {
        IntList intList = null;
        if (arrayList != null && arrayList.size() > 0) {
            intList = new IntList(arrayList.size());
            for (MetaDataNode metaDataNode : arrayList) {
                String string = metaDataNode.id;
                Value[] valueArray = metaDataNode.values;
                int n = this.addMetadataInfo(string, valueArray);
                intList.add(n);
            }
        }
        return intList;
    }

    protected int addMetadataInfo(String string, Value[] valueArray) {
        int n;
        String string2 = string;
        int n2 = string == null ? 0 : this.ab.addUtf8Constant(this.bytecodeFactory.ConstantUtf8Info(string));
        int n3 = valueArray == null ? 0 : valueArray.length;
        IntList intList = new IntList(n3);
        IntList intList2 = new IntList(n3);
        for (n = 0; n < n3; ++n) {
            Value value = valueArray[n];
            String string3 = null;
            String string4 = null;
            if (value instanceof MetaDataEvaluator.KeylessValue) {
                string3 = null;
                string4 = ((MetaDataEvaluator.KeylessValue)value).obj;
            } else if (value instanceof MetaDataEvaluator.KeyValuePair) {
                MetaDataEvaluator.KeyValuePair keyValuePair = (MetaDataEvaluator.KeyValuePair)value;
                string3 = keyValuePair.key;
                string4 = keyValuePair.obj;
            } else {
                string4 = value.toString();
            }
            if (string3 != null) {
                intList.add(this.ab.addUtf8Constant(this.bytecodeFactory.ConstantUtf8Info(string3)));
                string2 = new StringBuffer().append(string2).append(string3).toString();
            } else {
                intList.add(0);
            }
            string2 = new StringBuffer().append(string2).append(string4).toString();
            intList2.add(this.ab.addUtf8Constant(this.bytecodeFactory.ConstantUtf8Info(string4)));
        }
        n = this.GetMetadataInfo(string2);
        if (this.ab.metadata.at(n).size() == 0) {
            this.ab.addBytesToTable(this.ab.metadata, this.bytecodeFactory.MetadataInfo(this.ab.metadata.at(n), n2, n3, intList, intList2, n));
        }
        return n;
    }

    protected void addMethodTrait(int n, ObjectValue objectValue, ObjectList<ByteList> objectList, String string, Qualifiers qualifiers) {
        boolean bl;
        if ("$construct".equals(string)) {
            return;
        }
        IntList intList = new IntList(qualifiers.size());
        Iterator iterator = qualifiers.keySet().iterator();
        boolean bl2 = bl = objectValue.type != null && objectValue.type.isInterface();
        while (iterator.hasNext()) {
            int n2;
            ObjectValue objectValue2 = (ObjectValue)iterator.next();
            int n3 = n == 3 ? -98 : -78;
            int n4 = objectValue.getSlotIndex(this.cx, n3, string, objectValue2);
            Slot slot = objectValue.getSlot(this.cx, n4);
            if (n == 1) {
                int n5 = objectValue.getImplicitIndex(this.cx, n4, -132);
                slot = objectValue.getSlot(this.cx, n5);
            }
            if (slot == null || slot.declaredBy != objectValue || slot.getMethodName().length() == 0) continue;
            ObjectValue objectValue3 = slot != null ? (slot.getValue() instanceof ObjectValue ? (ObjectValue)slot.getValue() : null) : null;
            ArrayList<MetaDataNode> arrayList = slot.getMetadata();
            if (!bl && objectValue2.isInterface()) continue;
            boolean bl3 = slot.isOverride();
            int n6 = 0;
            n6 |= slot.isFinal() ? 1 : 0;
            n6 |= bl3 ? 2 : 0;
            if (objectValue2 != null) {
                n2 = this.addNamespace(objectValue2);
                intList.add(n2);
            } else {
                this.cx.internalError("internal error: non object value for namespace");
            }
            n2 = -1;
            int n7 = slot.getMethodID();
            if (n7 >= 0) {
                n2 = this.GetMethodInfo(slot.getMethodName());
            } else if (objectValue3 != null && objectValue3.method_info >= 0) {
                n2 = objectValue3.method_info;
            } else {
                this.cx.internalError("internal error");
                continue;
            }
            int n8 = this.ab.addUtf8Constant(this.bytecodeFactory.ConstantUtf8Info(string));
            int n9 = this.ab.addMultiNameConstant(this.bytecodeFactory.ConstantQualifiedName(n8, intList.back(), false));
            IntList intList2 = this.addMetadata(arrayList);
            if (n2 >= 0) {
                objectList.push_back(ByteCodeFactory.allocBytes());
                n7 = n7 < 0 ? 0 : n7;
                this.ab.addBytesToTable(objectList, this.bytecodeFactory.TraitInfo(objectList.back(), n9, n, objectValue.canEarlyBind() ? n7 : 0, n2, n6, (byte)0, intList2));
                continue;
            }
            this.cx.internalError("internal error: invalid method info");
        }
    }

    @Override
    protected void FinishProgram(Context context, String string, int n) {
        ObjectValue objectValue = context.scope();
        ObjectList<ByteList> objectList = new ObjectList<ByteList>();
        this.FinishTraits(objectValue, objectList);
        int n2 = this.GetPackageInfo(string);
        this.ab.addBytesToTable(this.ab.scripts, this.bytecodeFactory.ScriptInfo(this.ab.scripts.at(n2), n, objectList, n2));
        if (string.length() > 1) {
            String string2 = string.replace('.', '_');
            string2 = string2.replace('/', '_');
            string2 = string2.replace(':', '_');
            string2 = string2.replace('|', '_');
            string2 = string2.replace('$', '_');
            this.header_out.println(new StringBuffer().append("const int abcpackage_").append(string2).append(" = ").append(n2).append(";").toString());
            if (n2 >= this.native_package_count) {
                this.native_package_count = n2 + 1;
            }
        }
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print(new StringBuffer().append("// --FinishProgram ").append(this.modulename).toString());
        }
    }

    private void FinishTraits(ObjectValue objectValue, ObjectList<ByteList> objectList) {
        Names names = objectValue.builder.getNames();
        if (names != null) {
            Qualifiers qualifiers = new Qualifiers();
            int n = 0;
            while ((n = names.hasNext(n)) != -1) {
                qualifiers.clear();
                int n2 = names.getSlot(n);
                String string = names.getName(n);
                qualifiers.put(names.getNamespace(n), Boxing.valueOf(0));
                if (n2 >= 1) {
                    Slot slot = objectValue.getSlot(this.cx, n2);
                    if (names.getNamespace(n) != ObjectValue.loopLabelNamespace && slot != null && slot.declaredBy == objectValue) {
                        if (slot instanceof VariableSlot && names.getType(n) != 1) {
                            this.addSlotTrait(objectValue, objectList, string, qualifiers);
                        }
                        if (slot instanceof MethodSlot) {
                            int n3 = 1;
                            if (slot.isGetter()) {
                                n3 = 2;
                            }
                            if (names.getType(n) == 1) {
                                n3 = 3;
                            }
                            this.addMethodTrait(n3, objectValue, objectList, string, qualifiers);
                        }
                    }
                }
                ++n;
            }
        }
    }

    @Override
    protected void Dup() {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("Dup");
        }
        this.flushDebugInfo();
        this.last_ip = this.getIP();
        this.last_in = 1;
        this.Dup(this.ab.code);
        if (this.show_instructions) {
            this.code_out.write(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
    }

    @Override
    protected void Else() {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("Else");
        }
        this.flushDebugInfo();
        this.Jump(this.ab.code);
        this.else_addrs.add(this.getIP() - 3);
        this.last_in = 2;
        if (this.show_instructions) {
            this.code_out.write(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
    }

    @Override
    protected void GetProperty(boolean bl, boolean bl2, boolean bl3, Namespaces namespaces) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print(new StringBuffer().append("GetProperty is_qualified=").append(bl).append(" is_super=").append(bl2).append(" is_attr=").append(bl3).toString());
        }
        this.flushDebugInfo();
        this.last_ip = this.getIP();
        int n = -1;
        if (bl) {
            n = this.ab.addMultiNameConstant(this.bytecodeFactory.ConstantRuntimeQualifiedLate(bl3));
            this.stack(-2);
        } else {
            int n2 = this.makeNamespaceSet(namespaces);
            n = this.ab.addMultiNameConstant(this.bytecodeFactory.ConstantMultinameLate(n2, bl3));
            this.stack(-1);
        }
        if (bl2) {
            this.Getsuper(this.ab.code, n);
        } else {
            this.Getproperty(this.ab.code, n);
        }
        this.last_in = 2;
        if (this.show_instructions) {
            this.code_out.write(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
    }

    @Override
    protected void GetProperty(String string, boolean bl, boolean bl2) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print(new StringBuffer().append("GetProperty ").append(string).append(" is_super=").append(bl).append(" is_attr=").append(bl2).toString());
        }
        this.flushDebugInfo();
        this.last_ip = this.getIP();
        int n = string.equals("*") ? 0 : this.ab.addUtf8Constant(this.bytecodeFactory.ConstantUtf8Info(string));
        int n2 = this.ab.addMultiNameConstant(this.bytecodeFactory.ConstantRuntimeQualifiedName(n, bl2));
        if (bl) {
            this.Getsuper(this.ab.code, n2);
        } else {
            this.Getproperty(this.ab.code, n2);
        }
        this.stack(-1);
        this.last_in = 2;
        if (this.show_instructions) {
            this.code_out.print(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
    }

    private void printNamespaceSet(ObjectList<ObjectValue> objectList) {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (ObjectValue objectValue : objectList) {
            String string = objectValue == this.cx.publicNamespace() ? "public" : objectValue.name;
            switch (objectValue.getNamespaceKind()) {
                case 3: {
                    string = new StringBuffer().append(string).append("(protected)").toString();
                    break;
                }
                case 2: {
                    string = new StringBuffer().append(string).append("(private)").toString();
                    break;
                }
                case 1: {
                    string = new StringBuffer().append(string).append("(package-internal)").toString();
                    break;
                }
                case 5: {
                    string = new StringBuffer().append(string).append("(static-protected)").toString();
                }
            }
            treeSet.add(string);
        }
        this.code_out.print(new StringBuffer().append(treeSet.size()).append(" {").toString());
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            this.code_out.print(new StringBuffer().append(" ").append((String)iterator.next()).toString());
        }
        this.code_out.print(" }");
    }

    @Override
    protected void GetProperty(String string, Namespaces namespaces, boolean bl, boolean bl2, boolean bl3) {
        int n;
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print(new StringBuffer().append("GetProperty ").append(string).append(" ").toString());
            this.printNamespaceSet(namespaces);
            this.code_out.print(new StringBuffer().append(" is_qualified=").append(bl).append(" is_super=").append(bl2).append(" is_attr=").append(bl3).toString());
        }
        this.flushDebugInfo();
        this.last_ip = this.getIP();
        int n2 = string.equals("*") ? 0 : this.ab.addUtf8Constant(this.bytecodeFactory.ConstantUtf8Info(string));
        if (bl && namespaces.size() == 1) {
            int n3 = this.addNamespace((ObjectValue)namespaces.last());
            n = this.ab.addMultiNameConstant(this.bytecodeFactory.ConstantQualifiedName(n2, n3, bl3));
        } else {
            int n4 = this.makeNamespaceSet(namespaces);
            n = this.ab.addMultiNameConstant(this.bytecodeFactory.ConstantMultiname(n2, n4, bl3));
        }
        if (bl2) {
            this.Getsuper(this.ab.code, n);
        } else {
            this.Getproperty(this.ab.code, n);
        }
        this.last_in = 2;
        if (this.show_instructions) {
            this.code_out.print(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
    }

    @Override
    protected void SetProperty(boolean bl, boolean bl2, boolean bl3, Namespaces namespaces, boolean bl4) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print(new StringBuffer().append("SetProperty is_qualified=").append(bl).append(" is_super=").append(bl2).append(" is_attr=").append(bl3).toString());
        }
        this.flushDebugInfo();
        this.last_ip = this.getIP();
        int n = -1;
        if (bl) {
            n = this.ab.addMultiNameConstant(this.bytecodeFactory.ConstantRuntimeQualifiedLate(bl3));
            this.stack(-4);
        } else {
            int n2 = this.makeNamespaceSet(namespaces);
            n = this.ab.addMultiNameConstant(this.bytecodeFactory.ConstantMultinameLate(n2, bl3));
            this.stack(-3);
        }
        if (bl2) {
            this.Setsuper(this.ab.code, n);
        } else if (bl4) {
            this.Initproperty(this.ab.code, n);
        } else {
            this.Setproperty(this.ab.code, n);
        }
        this.last_in = 2;
        if (this.show_instructions) {
            this.code_out.write(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
    }

    @Override
    protected void SetProperty(String string, boolean bl, boolean bl2) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print(new StringBuffer().append("SetProperty ").append(string).append(" is_super=").append(bl).append(" is_attr=").append(bl2).toString());
        }
        this.flushDebugInfo();
        this.last_ip = this.getIP();
        int n = string.equals("*") ? 0 : this.ab.addUtf8Constant(this.bytecodeFactory.ConstantUtf8Info(string));
        int n2 = this.ab.addMultiNameConstant(this.bytecodeFactory.ConstantRuntimeQualifiedName(n, bl2));
        if (bl) {
            this.Setsuper(this.ab.code, n2);
        } else {
            this.Setproperty(this.ab.code, n2);
        }
        this.stack(-3);
        this.last_in = 2;
        if (this.show_instructions) {
            this.code_out.print(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
    }

    @Override
    protected void SetProperty(String string, Namespaces namespaces, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        int n;
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print(new StringBuffer().append("SetProperty ").append(string).append(" ").toString());
            this.printNamespaceSet(namespaces);
            this.code_out.print(new StringBuffer().append(" is_qualified=").append(bl).append(" is_super=").append(bl2).append(" is_attr=").append(bl3).append(" is_constinit=").append(bl4).toString());
        }
        this.flushDebugInfo();
        this.last_ip = this.getIP();
        int n2 = string.equals("*") ? 0 : this.ab.addUtf8Constant(this.bytecodeFactory.ConstantUtf8Info(string));
        if (bl && namespaces.size() == 1) {
            int n3 = this.addNamespace((ObjectValue)namespaces.last());
            n = this.ab.addMultiNameConstant(this.bytecodeFactory.ConstantQualifiedName(n2, n3, bl3));
        } else {
            int n4 = this.makeNamespaceSet(namespaces);
            n = this.ab.addMultiNameConstant(this.bytecodeFactory.ConstantMultiname(n2, n4, bl3));
        }
        if (bl2) {
            this.Setsuper(this.ab.code, n);
        } else if (bl4) {
            this.Initproperty(this.ab.code, n);
        } else {
            this.Setproperty(this.ab.code, n);
        }
        this.stack(-2);
        this.last_in = 2;
        if (this.show_instructions) {
            this.code_out.print(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
    }

    @Override
    protected void DeleteProperty(boolean bl, boolean bl2, boolean bl3, Namespaces namespaces) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print(new StringBuffer().append("DeleteProperty is_qualified=").append(bl).append(" is_super=").append(bl2).append(" is_attr=").append(bl3).toString());
        }
        this.flushDebugInfo();
        this.last_ip = this.getIP();
        int n = -1;
        if (bl) {
            n = this.ab.addMultiNameConstant(this.bytecodeFactory.ConstantRuntimeQualifiedLate(bl3));
            this.stack(-2);
        } else {
            int n2 = this.makeNamespaceSet(namespaces);
            n = this.ab.addMultiNameConstant(this.bytecodeFactory.ConstantMultinameLate(n2, bl3));
            this.stack(-1);
        }
        if (!bl2) {
            this.Delproperty(this.ab.code, n);
        }
        this.last_in = 2;
        if (this.show_instructions) {
            this.code_out.write(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
    }

    @Override
    protected void DeleteProperty(String string, boolean bl, boolean bl2) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print(new StringBuffer().append("DeleteProperty ").append(string).append(" is_super=").append(bl).append(" is_attr=").append(bl2).toString());
        }
        this.flushDebugInfo();
        this.last_ip = this.getIP();
        int n = string.equals("*") ? 0 : this.ab.addUtf8Constant(this.bytecodeFactory.ConstantUtf8Info(string));
        int n2 = this.ab.addMultiNameConstant(this.bytecodeFactory.ConstantRuntimeQualifiedName(n, bl2));
        if (!bl) {
            this.Delproperty(this.ab.code, n2);
        }
        this.stack(-1);
        this.last_in = 2;
        if (this.show_instructions) {
            this.code_out.print(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
    }

    @Override
    protected void DeleteProperty(String string, Namespaces namespaces, boolean bl, boolean bl2, boolean bl3) {
        int n;
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print(new StringBuffer().append("DeleteProperty ").append(string).append(" ").toString());
            this.printNamespaceSet(namespaces);
            this.code_out.print(new StringBuffer().append(" is_qualified=").append(bl).append(" is_super=").append(bl2).append(" is_attr=").append(bl3).toString());
        }
        this.flushDebugInfo();
        this.last_ip = this.getIP();
        int n2 = string.equals("*") ? 0 : this.ab.addUtf8Constant(this.bytecodeFactory.ConstantUtf8Info(string));
        if (bl && namespaces.size() == 1) {
            int n3 = this.addNamespace((ObjectValue)namespaces.last());
            n = this.ab.addMultiNameConstant(this.bytecodeFactory.ConstantQualifiedName(n2, n3, bl3));
        } else {
            int n4 = this.makeNamespaceSet(namespaces);
            n = this.ab.addMultiNameConstant(this.bytecodeFactory.ConstantMultiname(n2, n4, bl3));
        }
        if (!bl2) {
            this.Delproperty(this.ab.code, n);
        }
        this.last_in = 2;
        if (this.show_instructions) {
            this.code_out.print(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
    }

    @Override
    protected void GetDescendants(boolean bl, boolean bl2, Namespaces namespaces) {
        int n;
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print(new StringBuffer().append("GetDescendants is_qualified=").append(bl).append(" is_attr=").append(bl2).toString());
        }
        this.flushDebugInfo();
        this.last_ip = this.getIP();
        if (bl) {
            n = this.ab.addMultiNameConstant(this.bytecodeFactory.ConstantRuntimeQualifiedLate(bl2));
            this.stack(-2);
        } else {
            int n2 = this.makeNamespaceSet(namespaces);
            n = this.ab.addMultiNameConstant(this.bytecodeFactory.ConstantMultinameLate(n2, bl2));
            this.stack(-1);
        }
        this.Descendants(this.ab.code, n);
        this.last_in = 2;
        if (this.show_instructions) {
            this.code_out.print(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
    }

    @Override
    protected void GetDescendants(String string, boolean bl, boolean bl2) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print(new StringBuffer().append("GetDescendants ").append(string).append(" is_super=").append(bl).append(" is_attr=").append(bl2).toString());
        }
        this.flushDebugInfo();
        this.last_ip = this.getIP();
        int n = string.equals("*") ? 0 : this.ab.addUtf8Constant(this.bytecodeFactory.ConstantUtf8Info(string));
        int n2 = this.ab.addMultiNameConstant(this.bytecodeFactory.ConstantRuntimeQualifiedName(n, bl2));
        if (!bl) {
            this.Descendants(this.ab.code, n2);
        }
        this.stack(-1);
        this.last_in = 2;
        if (this.show_instructions) {
            this.code_out.print(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
    }

    @Override
    protected void GetDescendants(String string, Namespaces namespaces, boolean bl, boolean bl2, boolean bl3) {
        int n;
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print(new StringBuffer().append("GetDescendants ").append(string).append(" ").toString());
            this.printNamespaceSet(namespaces);
            this.code_out.print(new StringBuffer().append(" is_qualified=").append(bl).append(" is_super=").append(bl2).append(" is_attr=").append(bl3).toString());
        }
        this.flushDebugInfo();
        this.last_ip = this.getIP();
        int n2 = string.equals("*") ? 0 : this.ab.addUtf8Constant(this.bytecodeFactory.ConstantUtf8Info(string));
        if (bl && namespaces.size() == 1) {
            int n3 = this.addNamespace((ObjectValue)namespaces.last());
            n = this.ab.addMultiNameConstant(this.bytecodeFactory.ConstantQualifiedName(n2, n3, bl3));
        } else {
            int n4 = this.makeNamespaceSet(namespaces);
            n = this.ab.addMultiNameConstant(this.bytecodeFactory.ConstantMultiname(n2, n4, bl3));
        }
        if (!bl2) {
            this.Descendants(this.ab.code, n);
        }
        this.last_in = 2;
        if (this.show_instructions) {
            this.code_out.print(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
    }

    @Override
    protected void DeleteDescendants(String string, boolean bl, boolean bl2) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print(new StringBuffer().append("DeleteDescendants ").append(string).append(" is_super=").append(bl).append(" is_attr=").append(bl2).toString());
        }
        this.flushDebugInfo();
        this.last_ip = this.getIP();
        int n = string.equals("*") ? 0 : this.ab.addUtf8Constant(this.bytecodeFactory.ConstantUtf8Info(string));
        int n2 = this.ab.addMultiNameConstant(this.bytecodeFactory.ConstantRuntimeQualifiedName(n, bl2));
        if (!bl) {
            this.Deletedescendants(this.ab.code, n2);
        }
        this.stack(-1);
        this.last_in = 2;
        if (this.show_instructions) {
            this.code_out.print(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
    }

    @Override
    protected void DeleteDescendants(String string, Namespaces namespaces, boolean bl, boolean bl2, boolean bl3) {
        int n;
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print(new StringBuffer().append("DeleteDescendants ").append(string).append(" ").toString());
            this.printNamespaceSet(namespaces);
            this.code_out.print(new StringBuffer().append(" is_qualified=").append(bl).append(" is_super=").append(bl2).append(" is_attr=").append(bl3).toString());
        }
        this.flushDebugInfo();
        this.last_ip = this.getIP();
        int n2 = string.equals("*") ? 0 : this.ab.addUtf8Constant(this.bytecodeFactory.ConstantUtf8Info(string));
        if (bl && namespaces.size() == 1) {
            int n3 = this.addNamespace((ObjectValue)namespaces.last());
            n = this.ab.addMultiNameConstant(this.bytecodeFactory.ConstantQualifiedName(n2, n3, bl3));
        } else {
            int n4 = this.makeNamespaceSet(namespaces);
            n = this.ab.addMultiNameConstant(this.bytecodeFactory.ConstantMultiname(n2, n4, bl3));
        }
        if (!bl2) {
            this.Deletedescendants(this.ab.code, n);
        }
        this.last_in = 2;
        if (this.show_instructions) {
            this.code_out.print(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
    }

    @Override
    protected void FindProperty(String string, Namespaces namespaces, boolean bl, boolean bl2, boolean bl3) {
        int n;
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print(new StringBuffer().append("FindProperty ").append(string).append(" ").toString());
            this.printNamespaceSet(namespaces);
            this.code_out.print(new StringBuffer().append(" is_strict=").append(bl).append(" is_qualified=").append(bl2).append(" is_attr=").append(bl3).toString());
        }
        this.flushDebugInfo();
        this.last_ip = this.getIP();
        this.last_in = 2;
        int n2 = string.equals("*") ? 0 : this.ab.addUtf8Constant(this.bytecodeFactory.ConstantUtf8Info(string));
        if (bl2 && namespaces.size() == 1) {
            int n3 = this.addNamespace((ObjectValue)namespaces.last());
            n = this.ab.addMultiNameConstant(this.bytecodeFactory.ConstantQualifiedName(n2, n3, bl3));
        } else {
            int n4 = this.makeNamespaceSet(namespaces);
            n = this.ab.addMultiNameConstant(this.bytecodeFactory.ConstantMultiname(n2, n4, bl3));
        }
        if (bl) {
            this.Findpropstrict(this.ab.code, n);
        } else {
            this.Findproperty(this.ab.code, n);
        }
        if (this.show_instructions) {
            this.code_out.write(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
    }

    @Override
    protected void FindProperty(String string, boolean bl, boolean bl2) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print(new StringBuffer().append("FindProperty ").append(string).append(" is_strict=").append(bl).append(" is_attr=").append(bl2).toString());
        }
        this.flushDebugInfo();
        this.stack(-1);
        this.last_ip = this.getIP();
        this.last_in = 2;
        int n = "*".equals(string) ? 0 : this.ab.addUtf8Constant(this.bytecodeFactory.ConstantUtf8Info(string));
        int n2 = this.ab.addMultiNameConstant(this.bytecodeFactory.ConstantRuntimeQualifiedName(n, bl2));
        if (bl) {
            this.Findpropstrict(this.ab.code, n2);
        } else {
            this.Findproperty(this.ab.code, n2);
        }
        if (this.show_instructions) {
            this.code_out.write(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
    }

    @Override
    protected void FindProperty(boolean bl, boolean bl2, boolean bl3, Namespaces namespaces) {
        int n;
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print(new StringBuffer().append("FindProperty  is_strict=").append(bl).append(" is_attr=").append(bl2).toString());
        }
        this.flushDebugInfo();
        this.last_ip = this.getIP();
        this.last_in = 2;
        if (bl3) {
            n = this.ab.addMultiNameConstant(this.bytecodeFactory.ConstantRuntimeQualifiedLate(bl2));
            this.stack(-2);
        } else {
            int n2 = this.makeNamespaceSet(namespaces);
            n = this.ab.addMultiNameConstant(this.bytecodeFactory.ConstantMultinameLate(n2, bl2));
            this.stack(-1);
        }
        if (bl) {
            this.Findpropstrict(this.ab.code, n);
        } else {
            this.Findproperty(this.ab.code, n);
        }
        if (this.show_instructions) {
            this.code_out.write(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
    }

    @Override
    protected void GetGlobalScope() {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("GetGlobalScope");
        }
        this.flushDebugInfo();
        this.last_ip = this.getIP();
        this.last_in = 1;
        this.Getglobalscope(this.ab.code);
        if (this.show_instructions) {
            this.code_out.write(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
    }

    @Override
    protected void GetBaseObject(int n) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print(new StringBuffer().append("GetBaseObject ").append(n).toString());
        }
        this.flushDebugInfo();
        this.last_ip = this.getIP();
        this.last_in = 1;
        this.Getscopeobject(this.ab.code, n);
        if (this.show_instructions) {
            this.code_out.write(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
    }

    @Override
    protected void GetScopeChain() {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("GetScopeChain");
        }
        this.flushDebugInfo();
        this.last_in = 2;
        if (this.show_instructions) {
            this.code_out.write(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
    }

    @Override
    protected void GetScopeOnTop() {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("GetScopeOnTop");
        }
        this.flushDebugInfo();
        this.last_in = 2;
        if (this.show_instructions) {
            this.code_out.write(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
    }

    @Override
    protected void Try(boolean bl) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("Try");
        }
        ExceptionBlock exceptionBlock = new ExceptionBlock(this);
        exceptionBlock.try_start = this.getIP();
        exceptionBlock.hasFinally = bl;
        exceptionBlock.scopeIndex = this.cx.getScopeDepth() - 1;
        exceptionBlock.loop_index = this.break_addrs.size() - 1;
        this.exceptionBlocks.add(exceptionBlock);
        this.last_in = 2;
        if (this.show_instructions) {
            this.code_out.write(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
        this.flushDebugInfo();
    }

    @Override
    protected void CatchClausesBegin() {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("CatchClausesBegin");
        }
        ExceptionBlock exceptionBlock = this.exceptionBlocks.last();
        exceptionBlock.try_end = this.getIP();
        exceptionBlock.cur_locals = this.cur_locals;
        this.last_in = 2;
        if (this.show_instructions) {
            this.code_out.write(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
        this.flushDebugInfo();
    }

    @Override
    protected void CatchClausesEnd() {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("CatchClausesEnd");
        }
        ExceptionBlock exceptionBlock = this.exceptionBlocks.last();
        int n = this.getIP();
        while (!exceptionBlock.fixups.isEmpty()) {
            int n2 = exceptionBlock.fixups.removeLast();
            int n3 = n - n2 + 1 - 4;
            if (this.bytecodeFactory.show_bytecode) {
                this.code_out.println();
                this.code_out.print(new StringBuffer().append("      Jump@").append(n2 - 1).append(" <- ").append(n3).toString());
            }
            this.ab.code.set(n2, (byte)n3);
            this.ab.code.set(n2 + 1, (byte)(n3 >> 8));
            this.ab.code.set(n2 + 2, (byte)(n3 >> 16));
        }
        this.last_in = 2;
        if (this.show_instructions) {
            this.code_out.write(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
        this.flushDebugInfo();
    }

    @Override
    protected void CallFinally(int n) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("CallFinally");
        }
        this.flushDebugInfo();
        int n2 = 0;
        for (int i = this.exceptionBlocks.size(); i > 0; --i) {
            ExceptionBlock exceptionBlock = this.exceptionBlocks.at(i - 1);
            if (this.cur_locals > exceptionBlock.cur_locals) {
                exceptionBlock.cur_locals = this.cur_locals;
            }
            if (!exceptionBlock.hasFinally) continue;
            int n3 = exceptionBlock.finallyAddrs.size();
            this.Pushbyte(this.ab.code, n3);
            this.Jump(this.ab.code);
            exceptionBlock.fixups.add(this.getIP() - 3);
            this.Label(this.ab.code);
            this.Pop();
            exceptionBlock.finallyAddrs.add(this.getIP());
            this.Label(this.ab.code);
            if (++n2 == n) break;
        }
        this.last_in = 2;
        if (this.show_instructions) {
            this.code_out.write(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
    }

    @Override
    protected void FinallyClauseBegin() {
        ExceptionBlock exceptionBlock = this.exceptionBlocks.last();
        int n = exceptionBlock.cur_locals;
        exceptionBlock.cur_locals = this.cur_locals;
        this.cur_locals = n;
    }

    @Override
    protected void FinallyClauseEnd() {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("FinallyClauseEnd");
        }
        this.flushDebugInfo();
        this.last_in = 2;
        IntList intList = this.exceptionBlocks.last().finallyAddrs;
        if (intList.size() > 0) {
            int n;
            int n2 = this.getIP();
            this.Lookupswitch(this.ab.code);
            ByteCodeFactory.Int24(this.ab.code, 0);
            ByteCodeFactory.Int(this.ab.code, intList.size() - 1);
            int n3 = intList.size();
            for (n = 0; n < n3; ++n) {
                ByteCodeFactory.Int24(this.ab.code, intList.get(n) - n2);
            }
            n = this.getIP() - n2;
            this.ab.code.set(n2 + 1, (byte)n);
            this.ab.code.set(n2 + 2, (byte)(n >> 8));
            this.ab.code.set(n2 + 3, (byte)(n >> 16));
        }
        this.cur_locals = this.exceptionBlocks.last().cur_locals;
        this.exceptionBlocks.removeLast();
        if (this.show_instructions) {
            this.code_out.write(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
    }

    @Override
    protected void Catch(TypeValue typeValue, QName qName) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("Catch");
        }
        this.flushDebugInfo();
        ExceptionBlock exceptionBlock = this.exceptionBlocks.last();
        this.Jump(this.ab.code);
        exceptionBlock.fixups.add(this.getIP() - 3);
        ByteCodeFactory.Int(this.ab.exception_table, exceptionBlock.try_start);
        ByteCodeFactory.Int(this.ab.exception_table, exceptionBlock.try_end);
        ByteCodeFactory.Int(this.ab.exception_table, this.getIP());
        int n = this.addClassName(typeValue.builder.classname);
        ByteCodeFactory.Int(this.ab.exception_table, n);
        int n2 = qName != null ? this.addClassName(qName) : 0;
        ByteCodeFactory.Int(this.ab.exception_table, n2);
        this.stack(1);
        ++this.ab.exception_count;
        this.last_in = 2;
        if (this.show_instructions) {
            this.code_out.write(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
    }

    @Override
    protected void Throw() {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("Throw");
        }
        this.flushDebugInfo();
        this.Throw(this.ab.code);
        this.last_in = 2;
        if (this.show_instructions) {
            this.code_out.write(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
    }

    @Override
    protected void If(int n) {
        this.showLineNumber();
        if (this.show_instructions) {
            String string = "";
            switch (n) {
                case 0: {
                    string = "false";
                    break;
                }
                case 1: {
                    string = "true";
                    break;
                }
                case 2: {
                    string = "lt";
                    break;
                }
                case 4: {
                    string = "le";
                    break;
                }
                case 5: {
                    string = "gt";
                    break;
                }
                case 6: {
                    string = "ge";
                    break;
                }
                case 8: {
                    string = "eq";
                    break;
                }
                case 9: {
                    string = "ne";
                    break;
                }
                case 10: {
                    string = "stricteq";
                    break;
                }
                case 11: {
                    string = "strictne";
                    break;
                }
                case 12: {
                    string = "nlt";
                    break;
                }
                case 13: {
                    string = "nle";
                    break;
                }
                case 14: {
                    string = "ngt";
                    break;
                }
                case 15: {
                    string = "nge";
                    break;
                }
            }
            this.code_out.println();
            this.code_out.print(new StringBuffer().append("If ").append(string).toString());
        }
        this.flushDebugInfo();
        switch (n) {
            case 0: {
                this.Iffalse(this.ab.code);
                break;
            }
            case 1: {
                this.Iftrue(this.ab.code);
                break;
            }
            case 2: {
                this.Iflt(this.ab.code);
                break;
            }
            case 4: {
                this.Ifle(this.ab.code);
                break;
            }
            case 5: {
                this.Ifgt(this.ab.code);
                break;
            }
            case 6: {
                this.Ifge(this.ab.code);
                break;
            }
            case 8: {
                this.Ifeq(this.ab.code);
                break;
            }
            case 9: {
                this.Ifne(this.ab.code);
                break;
            }
            case 10: {
                this.Ifstricteq(this.ab.code);
                break;
            }
            case 11: {
                this.Ifstrictne(this.ab.code);
                break;
            }
            case 12: {
                this.Ifnlt(this.ab.code);
                break;
            }
            case 13: {
                this.Ifnle(this.ab.code);
                break;
            }
            case 14: {
                this.Ifngt(this.ab.code);
                break;
            }
            case 15: {
                this.Ifnge(this.ab.code);
                break;
            }
        }
        this.if_addrs.add(this.getIP() - 3);
        this.saveStackDepth();
        this.last_in = 2;
        if (this.show_instructions) {
            this.code_out.write(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
    }

    @Override
    protected void InvokeBinary(int n) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print(new StringBuffer().append("InvokeBinary ").append(this.getBinaryName(n)).toString());
        }
        this.flushDebugInfo();
        this.last_in = 2;
        switch (n) {
            case 1: {
                this.Add_i(this.ab.code);
                break;
            }
            case 0: {
                this.Add(this.ab.code);
                break;
            }
            case 3: {
                this.Subtract_i(this.ab.code);
                break;
            }
            case 2: {
                this.Subtract(this.ab.code);
                break;
            }
            case 5: {
                this.Multiply_i(this.ab.code);
                break;
            }
            case 4: {
                this.Multiply(this.ab.code);
                break;
            }
            case 6: {
                this.Divide(this.ab.code);
                break;
            }
            case 8: {
                this.Modulo(this.ab.code);
                break;
            }
            case 10: 
            case 11: {
                this.Lshift(this.ab.code);
                break;
            }
            case 12: 
            case 13: {
                this.Rshift(this.ab.code);
                break;
            }
            case 14: 
            case 15: {
                this.Urshift(this.ab.code);
                break;
            }
            case 16: {
                this.Lessthan(this.ab.code);
                break;
            }
            case 18: {
                this.Greaterthan(this.ab.code);
                break;
            }
            case 20: {
                this.Lessequals(this.ab.code);
                break;
            }
            case 22: {
                this.Greaterequals(this.ab.code);
                break;
            }
            case 28: 
            case 29: {
                this.Equals(this.ab.code);
                break;
            }
            case 32: 
            case 33: {
                this.Strictequals(this.ab.code);
                break;
            }
            case 30: 
            case 31: {
                this.Equals(this.ab.code);
                this.Not(this.ab.code);
                break;
            }
            case 34: 
            case 35: {
                this.Strictequals(this.ab.code);
                this.Not(this.ab.code);
                break;
            }
            case 36: 
            case 37: {
                this.Bitand(this.ab.code);
                break;
            }
            case 38: 
            case 39: {
                this.Bitxor(this.ab.code);
                break;
            }
            case 40: 
            case 41: {
                this.Bitor(this.ab.code);
                break;
            }
            case 42: 
            case 43: 
            case 45: 
            case 46: {
                break;
            }
            case 24: {
                this.Instanceof(this.ab.code);
                break;
            }
            case 25: {
                this.In(this.ab.code);
                break;
            }
            case 27: {
                this.Istypelate(this.ab.code);
                break;
            }
            case 49: {
                this.Astypelate(this.ab.code);
            }
        }
        if (this.show_instructions) {
            this.code_out.write(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
    }

    @Override
    protected void InvokeClosure(boolean bl, int n) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print(new StringBuffer().append("InvokeClosure ").append(bl ? "construct" : "call").append(", ").append(n).toString());
        }
        this.flushDebugInfo();
        this.last_in = 2;
        this.Callfunction(this.ab.code, bl, n);
        if (this.show_instructions) {
            this.code_out.write(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
    }

    @Override
    protected void ConstructProperty(String string, ObjectList<ObjectValue> objectList, int n, boolean bl, boolean bl2, boolean bl3) {
        this.callPropertyCommon(string, objectList, n, bl, bl2, bl3, true, false);
    }

    @Override
    protected void CallProperty(String string, ObjectList<ObjectValue> objectList, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.callPropertyCommon(string, objectList, n, bl, bl2, bl3, false, bl4);
    }

    private void callPropertyCommon(String string, ObjectList<ObjectValue> objectList, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        int n2;
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            if (bl4) {
                this.code_out.print("ConstructProperty ");
            } else if (bl5) {
                this.code_out.print("CallPropLex ");
            } else {
                this.code_out.print("CallProperty ");
            }
            this.code_out.print(new StringBuffer().append(string).append(" ").toString());
            this.printNamespaceSet(objectList);
            this.code_out.print(new StringBuffer().append(" ").append(n).append(" is_qualified=").append(bl).append(" is_super=").append(bl2).append(" is_attr=").append(bl3).toString());
        }
        this.flushDebugInfo();
        this.last_ip = this.getIP();
        int n3 = string.equals("*") ? 0 : this.ab.addUtf8Constant(this.bytecodeFactory.ConstantUtf8Info(string));
        if (bl && objectList.size() == 1) {
            int n4 = this.addNamespace(objectList.last());
            n2 = this.ab.addMultiNameConstant(this.bytecodeFactory.ConstantQualifiedName(n3, n4, bl3));
        } else {
            int n5 = this.makeNamespaceSet(objectList);
            n2 = this.ab.addMultiNameConstant(this.bytecodeFactory.ConstantMultiname(n3, n5, bl3));
        }
        if (bl2) {
            this.Callsuper(this.ab.code, n2, n);
        } else if (bl4) {
            this.Constructproperty(this.ab.code, n2, n);
        } else if (bl5) {
            this.Callproplex(this.ab.code, n2, n);
        } else {
            this.Callproperty(this.ab.code, n2, n);
        }
        this.last_in = 2;
        if (this.show_instructions) {
            this.code_out.print(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
    }

    @Override
    protected void InvokeMethod(boolean bl, int n, int n2) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print(new StringBuffer().append("InvokeMethod ").append(bl ? "local" : "global").append(" ").append(n).append(" ").append(n2).toString());
        }
        this.flushDebugInfo();
        this.last_in = 2;
        if (bl) {
            this.Callmethod(this.ab.code, n, n2);
        } else {
            this.Callstatic(this.ab.code, n, n2);
        }
        if (this.show_instructions) {
            this.code_out.write(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
    }

    @Override
    protected void InvokeSuper(boolean bl, int n) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print(new StringBuffer().append("InvokeSuper ").append(bl ? "construct" : "call").append(" ").append(n).toString());
        }
        this.flushDebugInfo();
        this.last_in = 2;
        if (bl) {
            this.Constructsuper(this.ab.code, n);
        } else {
            this.cx.internalError("internal error in InvokeSuper()");
        }
        if (this.show_instructions) {
            this.code_out.print(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
    }

    @Override
    protected void InvokeUnary(int n, int n2, int n3, Namespaces namespaces) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print(new StringBuffer().append("InvokeUnary ").append(this.getUnaryName(n)).append(" ").append(n2).toString());
            if (n3 >= 0) {
                this.code_out.write(new StringBuffer().append(" ").append(n3).toString());
            }
        }
        this.flushDebugInfo();
        this.last_in = 2;
        switch (n) {
            case 13: {
                int n4 = this.ab.addUtf8Constant(this.bytecodeFactory.ConstantUtf8Info("boolean"));
                this.Pushstring(this.ab.code, n4);
                break;
            }
            case 14: 
            case 15: {
                int n5 = this.ab.addUtf8Constant(this.bytecodeFactory.ConstantUtf8Info("number"));
                this.Pushstring(this.ab.code, n5);
                break;
            }
            case 16: {
                int n6 = this.ab.addUtf8Constant(this.bytecodeFactory.ConstantUtf8Info("string"));
                this.Pushstring(this.ab.code, n6);
                break;
            }
            case 17: {
                int n7 = this.ab.addUtf8Constant(this.bytecodeFactory.ConstantUtf8Info("undefined"));
                this.Pushstring(this.ab.code, n7);
                break;
            }
            case 12: {
                this.Typeof(this.ab.code);
                break;
            }
            case 18: {
                this.Increment(this.ab.code);
                break;
            }
            case 20: {
                this.Increment_i(this.ab.code);
                break;
            }
            case 19: {
                this.Inclocal(this.ab.code, n3);
                break;
            }
            case 21: {
                this.Inclocal_i(this.ab.code, n3);
                break;
            }
            case 22: {
                this.Decrement(this.ab.code);
                break;
            }
            case 24: {
                this.Decrement_i(this.ab.code);
                break;
            }
            case 23: {
                this.Declocal(this.ab.code, n3);
                break;
            }
            case 25: {
                this.Declocal_i(this.ab.code, n3);
                break;
            }
            case 27: {
                break;
            }
            case 26: {
                this.Convert_d(this.ab.code);
                break;
            }
            case 28: 
            case 29: {
                this.Negate(this.ab.code);
                break;
            }
            case 33: 
            case 34: {
                this.Not(this.ab.code);
                break;
            }
            case 2: {
                int n8 = this.makeNamespaceSet(namespaces);
                int n9 = this.ab.addMultiNameConstant(this.bytecodeFactory.ConstantMultinameLate(n8, false));
                this.Setproperty(this.ab.code, n9);
                break;
            }
            case 3: {
                int n10 = this.makeNamespaceSet(namespaces);
                int n11 = this.ab.addMultiNameConstant(this.bytecodeFactory.ConstantMultinameLate(n10, false));
                this.Getproperty(this.ab.code, n11);
                break;
            }
            case 32: {
                this.Not(this.ab.code);
                break;
            }
            case 4: {
                this.Hasnext(this.ab.code);
                break;
            }
            case 10: {
                int n12 = this.makeNamespaceSet(namespaces);
                int n13 = this.ab.addMultiNameConstant(this.bytecodeFactory.ConstantMultinameLate(n12, false));
                this.Delproperty(this.ab.code, n13);
                break;
            }
            case 30: 
            case 31: {
                this.Bitnot(this.ab.code);
                break;
            }
            case 5: {
                this.Nextname(this.ab.code);
                break;
            }
            case 6: {
                this.Nextvalue(this.ab.code);
                break;
            }
            case 11: {
                break;
            }
            case 35: {
                this.Esc_xelem(this.ab.code);
                break;
            }
            case 36: {
                this.Esc_xattr(this.ab.code);
                break;
            }
            case 37: {
                this.CheckFilter(this.ab.code);
                break;
            }
        }
        if (this.show_instructions) {
            this.code_out.write(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
    }

    @Override
    protected void LoadGlobal(int n, int n2) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print(new StringBuffer().append("LoadGlobal ").append(n).append(", ").append(RuntimeConstants.typeToString(n2)).toString());
        }
        this.flushDebugInfo();
        this.last_ip = this.getIP();
        this.last_in = 1;
        this.Getglobalscope(this.ab.code);
        this.Getslot(this.ab.code, n + 1);
        if (this.show_instructions) {
            this.code_out.write(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
    }

    @Override
    protected void LoadGlobal(String string) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print(new StringBuffer().append("LoadGlobal ").append(string).toString());
        }
        this.flushDebugInfo();
        this.cx.internalError("LoadGlobal(name) is deprecated");
        if (this.show_instructions) {
            this.code_out.write(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
    }

    @Override
    protected void LoadRegister(int n, int n2) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print(new StringBuffer().append("LoadRegister ").append(n).append(", ").append(RuntimeConstants.typeToString(n2)).toString());
        }
        this.flushDebugInfo();
        this.last_ip = this.getIP();
        this.last_in = 1;
        this.Getlocal(this.ab.code, n);
        if (this.show_instructions) {
            this.code_out.write(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
    }

    @Override
    protected void LoadThis() {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("LoadThis");
        }
        this.flushDebugInfo();
        this.last_ip = this.getIP();
        this.last_in = 1;
        this.Getlocal(this.ab.code, 0);
        if (this.show_instructions) {
            this.code_out.write(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
    }

    @Override
    protected void LoadSuper() {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("LoadSuper");
        }
        this.flushDebugInfo();
        this.last_ip = this.getIP();
        this.cx.internalError("super expressions are not implemented");
        this.last_in = 1;
        if (this.show_instructions) {
            this.code_out.write(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
    }

    @Override
    protected void LoadVar(int n) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print(new StringBuffer().append("LoadVar ").append(n).toString());
        }
        this.flushDebugInfo();
        this.last_ip = this.getIP();
        this.Getslot(this.ab.code, n + 1);
        this.last_in = 2;
        if (this.show_instructions) {
            this.code_out.write(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
    }

    @Override
    protected void LabelStatementBegin() {
        this.break_addrs.add(new IntList());
        this.break_scope_depth.add(this.cx.getScopeDepth());
        this.break_temp_count.add(this.cur_locals);
        this.continue_addrs.add(new IntList());
        this.continue_scope_depth.add(this.cx.getScopeDepth());
    }

    @Override
    protected void LabelStatementEnd(int n) {
        this.PatchBreak(n);
        this.PatchContinue(n);
    }

    @Override
    protected void LoopBegin() {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("LoopBegin");
        }
        this.break_addrs.add(new IntList());
        this.break_scope_depth.add(this.cx.getScopeDepth());
        this.break_temp_count.add(this.cur_locals);
        this.continue_addrs.add(new IntList());
        this.continue_scope_depth.add(this.cx.getScopeDepth());
        this.Jump(this.ab.code);
        this.loopbegin_addrs.add(this.getIP() - 3);
        this.Label(this.ab.code);
        this.last_in = 2;
        if (this.show_instructions) {
            this.code_out.write(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
    }

    @Override
    protected void LoopEnd(int n) {
        this.showLineNumber();
        if (this.show_instructions) {
            String string = "";
            switch (n) {
                case 0: {
                    string = "false";
                    break;
                }
                case 1: {
                    string = "true";
                    break;
                }
                case 2: {
                    string = "lt";
                    break;
                }
                case 4: {
                    string = "le";
                    break;
                }
                case 5: {
                    string = "gt";
                    break;
                }
                case 6: {
                    string = "ge";
                    break;
                }
                case 8: {
                    string = "eq";
                    break;
                }
                case 9: {
                    string = "ne";
                    break;
                }
                case 10: {
                    string = "stricteq";
                    break;
                }
                case 11: {
                    string = "strictne";
                    break;
                }
                case 12: {
                    string = "nlt";
                    break;
                }
                case 13: {
                    string = "nle";
                    break;
                }
                case 14: {
                    string = "ngt";
                    break;
                }
                case 15: {
                    string = "nge";
                    break;
                }
            }
            this.code_out.println();
            this.code_out.print(new StringBuffer().append("LoopEnd ").append(string).toString());
        }
        this.flushDebugInfo();
        int n2 = this.getIP();
        int n3 = this.loopbegin_addrs.back() - n2 + 2 - 3;
        switch (n) {
            case 0: {
                this.Iffalse(this.ab.code, n3);
                break;
            }
            case 1: {
                this.Iftrue(this.ab.code, n3);
                break;
            }
            case 2: {
                this.Iflt(this.ab.code, n3);
                break;
            }
            case 4: {
                this.Ifle(this.ab.code, n3);
                break;
            }
            case 5: {
                this.Ifgt(this.ab.code, n3);
                break;
            }
            case 6: {
                this.Ifge(this.ab.code, n3);
                break;
            }
            case 8: {
                this.Ifeq(this.ab.code, n3);
                break;
            }
            case 9: {
                this.Ifne(this.ab.code, n3);
                break;
            }
            case 10: {
                this.Ifstricteq(this.ab.code, n3);
                break;
            }
            case 11: {
                this.Ifstrictne(this.ab.code, n3);
                break;
            }
            case 12: {
                this.Ifnlt(this.ab.code, n3);
                break;
            }
            case 13: {
                this.Ifnle(this.ab.code, n3);
                break;
            }
            case 14: {
                this.Ifngt(this.ab.code, n3);
                break;
            }
            case 15: {
                this.Ifnge(this.ab.code, n3);
                break;
            }
        }
        this.loopbegin_addrs.removeLast();
        this.last_in = 2;
        if (this.show_instructions) {
            this.code_out.write(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
    }

    @Override
    protected void NewArray(int n) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print(new StringBuffer().append("NewArray ").append(n).toString());
        }
        this.flushDebugInfo();
        this.last_in = 2;
        this.Newarray(this.ab.code, n);
        if (this.show_instructions) {
            this.code_out.write(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
    }

    @Override
    protected void NewClassObject(QName qName) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print(new StringBuffer().append("NewClassObject ").append(qName).toString());
        }
        this.flushDebugInfo();
        this.last_ip = this.getIP();
        this.last_in = 2;
        int n = this.GetClassInfo(qName);
        this.Newclass(this.ab.code, n);
        if (this.show_instructions) {
            this.code_out.write(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
    }

    @Override
    protected void NewFunctionObject(String string) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print(new StringBuffer().append("NewFunctionObject ").append(string).toString());
        }
        this.flushDebugInfo();
        this.last_ip = this.getIP();
        this.last_in = 2;
        int n = this.GetMethodInfo(string);
        this.Newfunction(this.ab.code, n);
        if (this.show_instructions) {
            this.code_out.write(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
    }

    @Override
    protected void NewActivation() {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("NewActivation");
        }
        this.flushDebugInfo();
        this.last_in = 2;
        this.Newactivation(this.ab.code);
        if (this.show_instructions) {
            this.code_out.write(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
    }

    @Override
    protected void NewCatch(int n) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print(new StringBuffer().append("NewCatch ").append(n).toString());
        }
        this.flushDebugInfo();
        this.last_in = 2;
        this.Newcatch(this.ab.code, n);
        if (this.show_instructions) {
            this.code_out.write(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
    }

    @Override
    protected void NewObject(int n) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print(new StringBuffer().append("NewObject ").append(n).toString());
        }
        this.flushDebugInfo();
        this.last_in = 2;
        this.Newobject(this.ab.code, n);
        if (this.show_instructions) {
            this.code_out.write(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
    }

    @Override
    protected void PatchBreak(int n) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print(new StringBuffer().append("PatchBreak ").append(n).toString());
        }
        this.flushDebugInfo();
        int n2 = this.getIP();
        IntList intList = this.break_addrs.removeLast();
        while (intList.size() != 0) {
            int n3 = intList.removeLast();
            int n4 = n2 - n3 + 1 - 4;
            if (this.bytecodeFactory.show_bytecode) {
                this.code_out.println();
                this.code_out.print(new StringBuffer().append("      Jump@").append(n3 - 1).append(" <- ").append(n4).toString());
            }
            this.ab.code.set(n3, (byte)n4);
            this.ab.code.set(n3 + 1, (byte)(n4 >> 8));
            this.ab.code.set(n3 + 2, (byte)(n4 >> 16));
        }
        this.break_scope_depth.removeLast();
        this.break_temp_count.removeLast();
        this.last_in = 2;
        if (this.show_instructions) {
            this.code_out.write(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
    }

    @Override
    protected void PatchContinue(int n) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print(new StringBuffer().append("PatchContinue ").append(n).toString());
        }
        this.flushDebugInfo();
        int n2 = this.getIP();
        IntList intList = this.continue_addrs.removeLast();
        while (intList.size() != 0) {
            int n3 = intList.removeLast();
            int n4 = n2 - n3 + 1 - 4;
            if (this.bytecodeFactory.show_bytecode) {
                this.code_out.println();
                this.code_out.print(new StringBuffer().append("      Jump@").append(n3 - 1).append(" <- ").append(n4).toString());
            }
            this.ab.code.set(n3, (byte)n4);
            this.ab.code.set(n3 + 1, (byte)(n4 >> 8));
            this.ab.code.set(n3 + 2, (byte)(n4 >> 16));
        }
        this.continue_scope_depth.removeLast();
        this.last_in = 2;
        if (this.show_instructions) {
            this.code_out.write(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
    }

    @Override
    protected void PatchElse(int n) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print(new StringBuffer().append("PatchElse ").append(this.else_addrs.last()).toString());
        }
        this.flushDebugInfo();
        int n2 = this.else_addrs.removeLast();
        int n3 = n - n2 + 1 - 4;
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.println();
            this.code_out.print(new StringBuffer().append("      Jump@").append(n2 - 1).append(" <- ").append(n3).toString());
        }
        this.ab.code.set(n2, (byte)n3);
        this.ab.code.set(n2 + 1, (byte)(n3 >> 8));
        this.ab.code.set(n2 + 2, (byte)(n3 >> 16));
        this.last_in = 2;
        if (this.show_instructions) {
            this.code_out.write(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
    }

    @Override
    protected void PatchIf(int n) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print(new StringBuffer().append("PatchIf ").append(this.if_addrs.last()).toString());
        }
        this.flushDebugInfo();
        this.restoreStackDepth();
        int n2 = this.if_addrs.removeLast();
        int n3 = n - n2 + 1 - 4;
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.println();
            this.code_out.print(new StringBuffer().append("      If@").append(n2 - 1).append(" <- ").append(n3).toString());
        }
        this.ab.code.set(n2, (byte)n3);
        this.ab.code.set(n2 + 1, (byte)(n3 >> 8));
        this.ab.code.set(n2 + 2, (byte)(n3 >> 16));
        this.last_in = 2;
        if (this.show_instructions) {
            this.code_out.write(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
    }

    @Override
    protected void PatchLoopBegin(int n) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print(new StringBuffer().append("PatchLoopBegin ").append(n).toString());
        }
        this.flushDebugInfo();
        int n2 = this.loopbegin_addrs.last();
        int n3 = n - n2 + 1 - 4;
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.println();
            this.code_out.print(new StringBuffer().append("      Jump@").append(n2 - 1).append(" <- ").append(n3).toString());
        }
        this.ab.code.set(n2, (byte)n3);
        this.ab.code.set(n2 + 1, (byte)(n3 >> 8));
        this.ab.code.set(n2 + 2, (byte)(n3 >> 16));
        this.last_in = 2;
        if (this.show_instructions) {
            this.code_out.write(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
    }

    @Override
    protected void PatchSwitchBegin(int n) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print(new StringBuffer().append("PatchSwitchBegin ").append(n).toString());
        }
        this.flushDebugInfo();
        this.restoreStackDepth();
        int n2 = this.switchbegin_addrs.removeLast();
        int n3 = n - n2 + 1 - 4;
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.println();
            this.code_out.print(new StringBuffer().append("      Jump@").append(n2 - 1).append(" <- ").append(n3).toString());
        }
        this.ab.code.set(n2, (byte)n3);
        this.ab.code.set(n2 + 1, (byte)(n3 >> 8));
        this.ab.code.set(n2 + 2, (byte)(n3 >> 16));
        this.last_in = 2;
        this.seen_default_case.removeLast();
        if (this.show_instructions) {
            this.code_out.write(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
    }

    @Override
    protected void Pop() {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("Pop");
        }
        this.flushDebugInfo();
        this.Pop(this.ab.code);
        this.last_in = 2;
        if (this.show_instructions) {
            this.code_out.write(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
    }

    @Override
    protected void PushBoolean(boolean bl) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print(new StringBuffer().append("PushBoolean ").append(bl ? 1 : 0).toString());
        }
        this.flushDebugInfo();
        this.last_ip = this.getIP();
        this.last_in = 1;
        if (bl) {
            this.Pushtrue(this.ab.code);
        } else {
            this.Pushfalse(this.ab.code);
        }
        if (this.show_instructions) {
            this.code_out.write(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
    }

    @Override
    protected void PushEmpty() {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("PushEmpty");
        }
        this.flushDebugInfo();
        this.last_ip = this.getIP();
        this.last_in = 1;
        this.Pushnull(this.ab.code);
        if (this.show_instructions) {
            this.code_out.write(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
    }

    @Override
    protected void PushCaseIndex(int n) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print(new StringBuffer().append("PushCaseIndex ").append(n).toString());
        }
        this.flushDebugInfo();
        this.Pushshort(this.ab.code, n);
        if (this.show_instructions) {
            this.code_out.write(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
    }

    @Override
    protected void PushNull() {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("PushNull");
        }
        this.flushDebugInfo();
        this.last_ip = this.getIP();
        this.last_in = 1;
        this.Pushnull(this.ab.code);
        if (this.show_instructions) {
            this.code_out.write(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
    }

    @Override
    protected void PushNumber(double d, int n) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            StringBuffer stringBuffer = new StringBuffer();
            ByteCodeFactory.IL_FormatDoubleAsString(d, stringBuffer);
            this.code_out.print(new StringBuffer().append("PushNumber ").append(stringBuffer.toString()).append(", ").append(RuntimeConstants.typeToString(n)).toString());
        }
        this.flushDebugInfo();
        this.last_ip = this.getIP();
        this.last_in = 1;
        if (n == 256 || n == 512) {
            int n2 = (int)d;
            if ((byte)n2 == n2) {
                this.Pushbyte(this.ab.code, n2);
            } else if ((short)n2 == n2) {
                this.Pushshort(this.ab.code, n2);
            } else {
                int n3 = this.ab.addIntConstant(this.bytecodeFactory.ConstantIntegerInfo(n2));
                this.Pushint(this.ab.code, n3);
            }
        } else if (Double.isNaN(d)) {
            this.Pushnan(this.ab.code);
        } else {
            int n4 = this.ab.addDoubleConstant(this.bytecodeFactory.ConstantDoubleInfo(d));
            this.Pushdouble(this.ab.code, n4);
        }
        if (this.show_instructions) {
            this.code_out.write(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
    }

    @Override
    protected void NewNamespace(ObjectValue objectValue) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print(new StringBuffer().append("NewNamespace ").append(objectValue.name).toString());
        }
        this.flushDebugInfo();
        this.last_ip = this.getIP();
        this.last_in = 2;
        this.addNamespace(objectValue);
        if (this.show_instructions) {
            this.code_out.print(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
    }

    @Override
    protected void PushString(String string) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print(new StringBuffer().append("PushString ").append(string).toString());
        }
        this.last_ip = this.getIP();
        this.last_in = 1;
        int n = this.ab.addUtf8Constant(this.bytecodeFactory.ConstantUtf8Info(string));
        this.Pushstring(this.ab.code, n);
        if (this.show_instructions) {
            this.code_out.write(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
    }

    @Override
    protected void PushNamespace(ObjectValue objectValue) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print(new StringBuffer().append("PushNamespace ").append(objectValue.name).toString());
        }
        this.last_ip = this.getIP();
        this.last_in = 1;
        int n = this.addNamespace(objectValue);
        this.Pushnamespace(this.ab.code, n);
        if (this.show_instructions) {
            this.code_out.write(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
    }

    @Override
    protected void PushUndefined() {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("PushUndefined");
        }
        this.flushDebugInfo();
        this.last_ip = this.getIP();
        this.last_in = 1;
        this.Pushundefined(this.ab.code);
        if (this.show_instructions) {
            this.code_out.write(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
    }

    @Override
    protected void PushUninitialized() {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("PushUninitialized");
        }
        this.flushDebugInfo();
        this.last_ip = this.getIP();
        this.last_in = 1;
        this.Pushuninitialized(this.ab.code);
        if (this.show_instructions) {
            this.code_out.write(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
    }

    @Override
    protected void Return(int n) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("Return");
        }
        this.flushDebugInfo();
        if (n == 1024) {
            this.Returnvoid(this.ab.code);
        } else {
            this.Returnvalue(this.ab.code);
        }
        this.last_in = 2;
        if (this.show_instructions) {
            this.code_out.write(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
    }

    @Override
    protected void StoreGlobal(int n, int n2) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print(new StringBuffer().append("StoreGlobal ").append(n).append(", ").append(RuntimeConstants.typeToString(n2)).toString());
        }
        this.flushDebugInfo();
        this.last_in = 2;
        this.Getglobalscope(this.ab.code);
        this.Swap(this.ab.code);
        this.Setslot(this.ab.code, n + 1);
        if (this.show_instructions) {
            this.code_out.write(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
    }

    @Override
    protected void StoreGlobal(String string) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print(new StringBuffer().append("StoreGlobal ").append(string).toString());
        }
        this.flushDebugInfo();
        this.cx.internalError("StoreGlobal(name) is deprecated");
        if (this.show_instructions) {
            this.code_out.write(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
    }

    @Override
    protected void StoreRegister(int n, int n2, String string) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print(new StringBuffer().append("StoreRegister ").append(n).append(", ").append(RuntimeConstants.typeToString(n2)).toString());
        }
        this.flushDebugInfo();
        this.last_in = 2;
        this.Setlocal(this.ab.code, n);
        if (this.show_instructions) {
            this.code_out.write(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
    }

    @Override
    protected void HasNext(int n, int n2) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print(new StringBuffer().append("HasNext ").append(n).append(", ").append(n2).toString());
        }
        this.flushDebugInfo();
        this.last_in = 2;
        this.Hasnext2(this.ab.code, n, n2);
        if (this.show_instructions) {
            this.code_out.write(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
    }

    @Override
    protected void StoreVar(int n) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print(new StringBuffer().append("StoreVar ").append(n).toString());
        }
        this.flushDebugInfo();
        this.last_in = 2;
        this.Setslot(this.ab.code, n + 1);
        if (this.show_instructions) {
            this.code_out.write(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
    }

    @Override
    protected void SwitchBegin() {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("SwitchBegin");
        }
        this.seen_default_case.add(0);
        this.case_addrs.add(new IntList());
        this.break_addrs.add(new IntList());
        this.break_scope_depth.add(this.cx.getScopeDepth());
        this.break_temp_count.add(this.cur_locals);
        this.continue_addrs.add(new IntList());
        this.continue_scope_depth.add(this.cx.getScopeDepth());
        this.Jump(this.ab.code);
        this.switchbegin_addrs.add(this.getIP() - 3);
        this.saveStackDepth();
        this.last_in = 2;
        if (this.show_instructions) {
            this.code_out.write(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
    }

    @Override
    protected void SwitchTable() {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("SwitchTable");
        }
        this.flushDebugInfo();
        this.last_in = 2;
        int n = this.getIP();
        this.Lookupswitch(this.ab.code);
        int n2 = this.default_addrs.removeLast();
        ByteCodeFactory.Int24(this.ab.code, n2 - n);
        IntList intList = this.case_addrs.removeLast();
        ByteCodeFactory.Int(this.ab.code, intList.size() - 1);
        int n3 = intList.size();
        for (int i = 0; i < n3; ++i) {
            ByteCodeFactory.Int24(this.ab.code, intList.get(i) - n);
        }
        if (this.show_instructions) {
            this.code_out.write(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
        IntList intList2 = this.continue_addrs.removeLast();
        if (this.continue_addrs.size() != 0) {
            IntList intList3 = this.continue_addrs.last();
            intList3.addAll(intList2);
        }
        this.continue_scope_depth.removeLast();
    }

    @Override
    protected void ToBoolean(int n) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print(new StringBuffer().append("ToBoolean ").append(RuntimeConstants.typeToString(n)).toString());
        }
        this.flushDebugInfo();
        this.last_in = 2;
        this.Convert_b(this.ab.code);
        if (this.show_instructions) {
            this.code_out.write(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
    }

    @Override
    protected void ToNativeBool() {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("ToNativeBool");
        }
        this.flushDebugInfo();
    }

    @Override
    protected void ToInt() {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("ToInt");
        }
        this.Convert_i(this.ab.code);
        this.flushDebugInfo();
    }

    @Override
    protected void ToUint() {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("ToUint");
        }
        this.Convert_i(this.ab.code);
        this.flushDebugInfo();
    }

    @Override
    protected void ToNumber(int n) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print(new StringBuffer().append("ToNumber ").append(RuntimeConstants.typeToString(n)).toString());
        }
        this.flushDebugInfo();
        this.last_in = 2;
        this.Convert_d(this.ab.code);
        if (this.show_instructions) {
            this.code_out.write(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
    }

    @Override
    protected void ToObject() {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("ToObject");
        }
        this.flushDebugInfo();
        this.last_in = 2;
        this.Convert_o(this.ab.code);
        if (this.show_instructions) {
            this.code_out.write(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
    }

    @Override
    protected void ToString() {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("ToString");
        }
        this.flushDebugInfo();
        this.last_in = 2;
        this.Convert_s(this.ab.code);
        if (this.show_instructions) {
            this.code_out.write(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
    }

    @Override
    protected void PushScope() {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("PushScope");
        }
        this.flushDebugInfo();
        this.Pushscope(this.ab.code);
        this.last_ip = this.getIP();
        if (this.show_instructions) {
            this.code_out.write(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
    }

    @Override
    protected void PushWith() {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("PushWith");
        }
        this.flushDebugInfo();
        this.Pushwith(this.ab.code);
        this.last_ip = this.getIP();
        if (this.show_instructions) {
            this.code_out.write(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
    }

    @Override
    protected void PopScope() {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("PopScope");
        }
        this.flushDebugInfo();
        this.Popscope(this.ab.code);
        this.last_ip = this.getIP();
        if (this.show_instructions) {
            this.code_out.write(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
    }

    @Override
    protected void PopWith() {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("PopWith");
        }
        this.flushDebugInfo();
        this.Popscope(this.ab.code);
        this.last_ip = this.getIP();
        if (this.show_instructions) {
            this.code_out.write(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
    }

    @Override
    protected void Swap() {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("Swap");
        }
        this.flushDebugInfo();
        this.Swap(this.ab.code);
        this.last_ip = this.getIP();
        if (this.show_instructions) {
            this.code_out.write(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
    }

    @Override
    public void DefaultXMLNamespace() {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print("DefaultXMLNamespace");
        }
        this.flushDebugInfo();
        this.Dxnslate(this.ab.code);
        this.sets_dxns = true;
        this.last_in = 2;
        if (this.show_instructions) {
            this.code_out.print(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
    }

    @Override
    public void DefaultXMLNamespace(String string) {
        this.showLineNumber();
        if (this.show_instructions) {
            this.code_out.println();
            this.code_out.print(new StringBuffer().append("DefaultXMLNamespace ").append(string).toString());
        }
        this.flushDebugInfo();
        int n = this.ab.addUtf8Constant(this.bytecodeFactory.ConstantUtf8Info(string));
        this.Dxns(this.ab.code, n);
        this.sets_dxns = true;
        this.last_in = 2;
        if (this.show_instructions) {
            this.code_out.print(new StringBuffer().append(" [").append(this.cur_stack).append("]").toString());
        }
    }

    protected void Bkpt(ByteList byteList) {
        this.stack(0);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Bkpt").toString());
        }
        ByteCodeFactory.Byte(byteList, 1);
    }

    protected void Nop(ByteList byteList) {
        this.stack(0);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Nop").toString());
        }
        ByteCodeFactory.Byte(byteList, 2);
    }

    protected void Throw(ByteList byteList) {
        this.stack(-1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Throw").toString());
        }
        ByteCodeFactory.Byte(byteList, 3);
    }

    protected void Jump(ByteList byteList) {
        this.stack(0);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Jump").toString());
        }
        ByteCodeFactory.Byte(byteList, 16);
        ByteCodeFactory.Int24(byteList, 0);
    }

    protected void Label(ByteList byteList) {
        this.stack(0);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Label").toString());
        }
        ByteCodeFactory.Byte(byteList, 9);
    }

    protected void Iftrue(ByteList byteList) {
        this.Iftrue(byteList, 0);
    }

    protected void Iftrue(ByteList byteList, int n) {
        this.stack(-1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Iftrue ").append(n).toString());
        }
        ByteCodeFactory.Byte(byteList, 17);
        ByteCodeFactory.Int24(byteList, n);
    }

    protected void Iffalse(ByteList byteList) {
        this.Iffalse(byteList, 0);
    }

    protected void Iffalse(ByteList byteList, int n) {
        this.stack(-1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Iffalse").toString());
        }
        ByteCodeFactory.Byte(byteList, 18);
        ByteCodeFactory.Int24(byteList, n);
    }

    protected void Ifeq(ByteList byteList) {
        this.Ifeq(byteList, 0);
    }

    protected void Ifeq(ByteList byteList, int n) {
        this.stack(-2);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Ifeq").toString());
        }
        ByteCodeFactory.Byte(byteList, 19);
        ByteCodeFactory.Int24(byteList, n);
    }

    protected void Ifne(ByteList byteList) {
        this.Ifne(byteList, 0);
    }

    protected void Ifne(ByteList byteList, int n) {
        this.stack(-2);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Ifne").toString());
        }
        ByteCodeFactory.Byte(byteList, 20);
        ByteCodeFactory.Int24(byteList, n);
    }

    protected void Iflt(ByteList byteList) {
        this.Iflt(byteList, 0);
    }

    protected void Iflt(ByteList byteList, int n) {
        this.stack(-2);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Iflt").toString());
        }
        ByteCodeFactory.Byte(byteList, 21);
        ByteCodeFactory.Int24(byteList, n);
    }

    protected void Ifle(ByteList byteList) {
        this.Ifle(byteList, 0);
    }

    protected void Ifle(ByteList byteList, int n) {
        this.stack(-2);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Ifle").toString());
        }
        ByteCodeFactory.Byte(byteList, 22);
        ByteCodeFactory.Int24(byteList, n);
    }

    protected void Ifgt(ByteList byteList) {
        this.Ifgt(byteList, 0);
    }

    protected void Ifgt(ByteList byteList, int n) {
        this.stack(-2);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Ifgt").toString());
        }
        ByteCodeFactory.Byte(byteList, 23);
        ByteCodeFactory.Int24(byteList, n);
    }

    protected void Ifge(ByteList byteList) {
        this.Ifge(byteList, 0);
    }

    protected void Ifge(ByteList byteList, int n) {
        this.stack(-2);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Ifge").toString());
        }
        ByteCodeFactory.Byte(byteList, 24);
        ByteCodeFactory.Int24(byteList, n);
    }

    protected void Ifstricteq(ByteList byteList) {
        this.Ifstricteq(byteList, 0);
    }

    protected void Ifstricteq(ByteList byteList, int n) {
        this.stack(-2);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Ifstricteq").toString());
        }
        ByteCodeFactory.Byte(byteList, 25);
        ByteCodeFactory.Int24(byteList, n);
    }

    protected void Ifstrictne(ByteList byteList) {
        this.Ifstrictne(byteList, 0);
    }

    protected void Ifstrictne(ByteList byteList, int n) {
        this.stack(-2);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Ifstrictne").toString());
        }
        ByteCodeFactory.Byte(byteList, 26);
        ByteCodeFactory.Int24(byteList, n);
    }

    protected void Ifnlt(ByteList byteList) {
        this.Ifnlt(byteList, 0);
    }

    protected void Ifnlt(ByteList byteList, int n) {
        this.stack(-2);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Ifnlt").toString());
        }
        ByteCodeFactory.Byte(byteList, 12);
        ByteCodeFactory.Int24(byteList, n);
    }

    protected void Ifnle(ByteList byteList) {
        this.Ifnle(byteList, 0);
    }

    protected void Ifnle(ByteList byteList, int n) {
        this.stack(-2);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Ifnle").toString());
        }
        ByteCodeFactory.Byte(byteList, 13);
        ByteCodeFactory.Int24(byteList, n);
    }

    protected void Ifngt(ByteList byteList) {
        this.Ifngt(byteList, 0);
    }

    protected void Ifngt(ByteList byteList, int n) {
        this.stack(-2);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Ifngt").toString());
        }
        ByteCodeFactory.Byte(byteList, 14);
        ByteCodeFactory.Int24(byteList, n);
    }

    protected void Ifnge(ByteList byteList) {
        this.Ifnge(byteList, 0);
    }

    protected void Ifnge(ByteList byteList, int n) {
        this.stack(-2);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Ifnge").toString());
        }
        ByteCodeFactory.Byte(byteList, 15);
        ByteCodeFactory.Int24(byteList, n);
    }

    protected void Lookupswitch(ByteList byteList) {
        this.stack(-1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Lookupswitch").toString());
        }
        ByteCodeFactory.Byte(byteList, 27);
    }

    protected void Pushnull(ByteList byteList) {
        this.stack(1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Pushnull").toString());
        }
        ByteCodeFactory.Byte(byteList, 32);
    }

    protected void Pushundefined(ByteList byteList) {
        this.stack(1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Pushundefined").toString());
        }
        ByteCodeFactory.Byte(byteList, 33);
    }

    protected void Pushuninitialized(ByteList byteList) {
        this.stack(1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Pushuninitialized ").toString());
        }
        ByteCodeFactory.Byte(byteList, 34);
    }

    protected void Pushstring(ByteList byteList, int n) {
        this.stack(1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Pushstring ").append(n).toString());
        }
        ByteCodeFactory.Byte(byteList, 44);
        ByteCodeFactory.Int(byteList, n);
    }

    protected void Pushnamespace(ByteList byteList, int n) {
        this.stack(1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Pushnamespace ").append(n).toString());
        }
        ByteCodeFactory.Byte(byteList, 49);
        ByteCodeFactory.Int(byteList, n);
    }

    protected void Pushuint(ByteList byteList, int n) {
        this.stack(1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Pushuint ").append(n).toString());
        }
        ByteCodeFactory.Byte(byteList, 46);
        ByteCodeFactory.Int(byteList, n);
    }

    protected void Pushdouble(ByteList byteList, int n) {
        this.stack(1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Pushdouble ").append(n).toString());
        }
        ByteCodeFactory.Byte(byteList, 47);
        ByteCodeFactory.Int(byteList, n);
    }

    protected void Pushint(ByteList byteList, int n) {
        this.stack(1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Pushint ").append(n).toString());
        }
        ByteCodeFactory.Byte(byteList, 45);
        ByteCodeFactory.Int(byteList, n);
    }

    protected void Pushbyte(ByteList byteList, int n) {
        this.stack(1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Pushbyte ").append(n).toString());
        }
        ByteCodeFactory.Byte(byteList, 36);
        ByteCodeFactory.Byte(byteList, n);
    }

    protected void Pushshort(ByteList byteList, int n) {
        this.stack(1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Pushshort ").append(n).toString());
        }
        ByteCodeFactory.Byte(byteList, 37);
        ByteCodeFactory.Int(byteList, n);
    }

    protected void Pushtrue(ByteList byteList) {
        this.stack(1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Pushtrue").toString());
        }
        ByteCodeFactory.Byte(byteList, 38);
    }

    protected void Pushfalse(ByteList byteList) {
        this.stack(1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Pushfalse").toString());
        }
        ByteCodeFactory.Byte(byteList, 39);
    }

    protected void Pushnan(ByteList byteList) {
        this.stack(1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Pushnan").toString());
        }
        ByteCodeFactory.Byte(byteList, 40);
    }

    protected void Pop(ByteList byteList) {
        this.stack(-1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Pop").toString());
        }
        ByteCodeFactory.Byte(byteList, 41);
    }

    protected void Dup(ByteList byteList) {
        this.stack(1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Dup").toString());
        }
        ByteCodeFactory.Byte(byteList, 42);
    }

    protected void Swap(ByteList byteList) {
        this.stack(0);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Swap").toString());
        }
        ByteCodeFactory.Byte(byteList, 43);
    }

    protected void Newfunction(ByteList byteList, int n) {
        this.stack(1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Newfunction ").append(n).toString());
        }
        ByteCodeFactory.Byte(byteList, 64);
        ByteCodeFactory.Int(byteList, n);
    }

    protected void Newclass(ByteList byteList, int n) {
        this.stack(0);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Newclass ").append(n).toString());
        }
        ByteCodeFactory.Byte(byteList, 88);
        ByteCodeFactory.Int(byteList, n);
    }

    protected void Callfunction(ByteList byteList, boolean bl, int n) {
        if (!bl) {
            if (this.bytecodeFactory.show_bytecode) {
                this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Call ").append(n).toString());
            }
            this.stack(1 - n - 2);
            ByteCodeFactory.Byte(byteList, 65);
        } else {
            if (this.bytecodeFactory.show_bytecode) {
                this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Construct ").append(n).toString());
            }
            this.stack(1 - n - 1);
            ByteCodeFactory.Byte(byteList, 66);
        }
        ByteCodeFactory.Int(byteList, n);
    }

    protected void Callstatic(ByteList byteList, int n, int n2) {
        this.stack(1 - n2 - 1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Callstatic ").append(n).append(" ").append(n2).toString());
        }
        ByteCodeFactory.Byte(byteList, 68);
        ByteCodeFactory.Int(byteList, n);
        ByteCodeFactory.Int(byteList, n2);
    }

    protected void Callmethod(ByteList byteList, int n, int n2) {
        this.stack(1 - n2 - 1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Callmethod ").append(n).append(" ").append(n2).toString());
        }
        ByteCodeFactory.Byte(byteList, 67);
        ByteCodeFactory.Int(byteList, n);
        ByteCodeFactory.Int(byteList, n2);
    }

    protected void Callsuper(ByteList byteList, int n, int n2) {
        this.stack(1 - n2 - 1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Callsuper ").append(n).append(" ").append(n2).toString());
        }
        ByteCodeFactory.Byte(byteList, 69);
        ByteCodeFactory.Int(byteList, n);
        ByteCodeFactory.Int(byteList, n2);
    }

    protected void Constructsuper(ByteList byteList, int n) {
        this.stack(0 - n - 1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Constructsuper ").append(n).toString());
        }
        ByteCodeFactory.Byte(byteList, 73);
        ByteCodeFactory.Int(byteList, n);
    }

    protected void Callproperty(ByteList byteList, int n, int n2) {
        this.stack(1 - n2 - 1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Callproperty ").append(n).append(" ").append(n2).toString());
        }
        ByteCodeFactory.Byte(byteList, 70);
        ByteCodeFactory.Int(byteList, n);
        ByteCodeFactory.Int(byteList, n2);
    }

    protected void Callproplex(ByteList byteList, int n, int n2) {
        this.stack(1 - n2 - 1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Callproplex ").append(n).append(" ").append(n2).toString());
        }
        ByteCodeFactory.Byte(byteList, 76);
        ByteCodeFactory.Int(byteList, n);
        ByteCodeFactory.Int(byteList, n2);
    }

    protected void Constructproperty(ByteList byteList, int n, int n2) {
        this.stack(1 - n2 - 1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Constructproperty ").append(n).append(" ").append(n2).toString());
        }
        ByteCodeFactory.Byte(byteList, 74);
        ByteCodeFactory.Int(byteList, n);
        ByteCodeFactory.Int(byteList, n2);
    }

    protected void Returnvoid(ByteList byteList) {
        this.stack(0);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.print(new StringBuffer().append("\n      ").append(this.getIP()).append(":Returnvoid").toString());
        }
        ByteCodeFactory.Byte(byteList, 71);
    }

    protected void Returnvalue(ByteList byteList) {
        this.stack(-1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.print(new StringBuffer().append("\n      ").append(this.getIP()).append(":Returnvalue").toString());
        }
        ByteCodeFactory.Byte(byteList, 72);
    }

    protected void Newactivation(ByteList byteList) {
        this.stack(1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Newactivation").toString());
        }
        ByteCodeFactory.Byte(byteList, 87);
    }

    protected void Newcatch(ByteList byteList, int n) {
        this.stack(1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Newcatch ").append(n).toString());
        }
        ByteCodeFactory.Byte(byteList, 90);
        ByteCodeFactory.Int(byteList, n);
    }

    protected void Newobject(ByteList byteList, int n) {
        this.stack(1 - n * 2);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Newobject ").append(n).toString());
        }
        ByteCodeFactory.Byte(byteList, 85);
        ByteCodeFactory.Int(byteList, n);
    }

    protected void Newarray(ByteList byteList, int n) {
        this.stack(1 - n);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Newarray ").append(n).toString());
        }
        ByteCodeFactory.Byte(byteList, 86);
        ByteCodeFactory.Int(byteList, n);
    }

    protected void Getlocal(ByteList byteList, int n) {
        this.stack(1);
        if (n <= 3) {
            if (this.bytecodeFactory.show_bytecode) {
                this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Getlocal").append(n).toString());
            }
            ByteCodeFactory.Byte(byteList, 208 + n);
        } else {
            if (this.bytecodeFactory.show_bytecode) {
                this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Getlocal ").append(n).toString());
            }
            ByteCodeFactory.Byte(byteList, 98);
            ByteCodeFactory.Int(byteList, n);
        }
    }

    protected void Setlocal(ByteList byteList, int n) {
        this.stack(-1);
        if (n <= 3) {
            if (this.bytecodeFactory.show_bytecode) {
                this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Setlocal").append(n).toString());
            }
            ByteCodeFactory.Byte(byteList, 212 + n);
        } else {
            if (this.bytecodeFactory.show_bytecode) {
                this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Setlocal ").append(n).toString());
            }
            ByteCodeFactory.Byte(byteList, 99);
            ByteCodeFactory.Int(byteList, n);
        }
    }

    protected void Getglobalscope(ByteList byteList) {
        this.stack(1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Getglobalscope").toString());
        }
        ByteCodeFactory.Byte(byteList, 100);
    }

    protected void Getscopeobject(ByteList byteList, int n) {
        this.stack(1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Getscopeobject ").append(n).toString());
        }
        ByteCodeFactory.Byte(byteList, 101);
        ByteCodeFactory.Byte(byteList, n);
    }

    protected void Getproperty(ByteList byteList, int n) {
        this.stack(0);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Getproperty ").append(n).toString());
        }
        ByteCodeFactory.Byte(byteList, 102);
        ByteCodeFactory.Int(byteList, n);
    }

    protected void Getsuper(ByteList byteList, int n) {
        this.stack(0);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Getsuper ").append(n).toString());
        }
        ByteCodeFactory.Byte(byteList, 4);
        ByteCodeFactory.Int(byteList, n);
    }

    protected void Descendants(ByteList byteList, int n) {
        this.stack(0);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Descendants ").append(n).toString());
        }
        ByteCodeFactory.Byte(byteList, 89);
        ByteCodeFactory.Int(byteList, n);
    }

    protected void Deletedescendants(ByteList byteList, int n) {
        this.stack(0);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Deletedescendants ").append(n).toString());
        }
        ByteCodeFactory.Byte(byteList, 91);
        ByteCodeFactory.Int(byteList, n);
    }

    protected void Delproperty(ByteList byteList, int n) {
        this.stack(0);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Delproperty ").append(n).toString());
        }
        ByteCodeFactory.Byte(byteList, 106);
        ByteCodeFactory.Int(byteList, n);
    }

    protected void Setproperty(ByteList byteList, int n) {
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Setproperty ").append(n).toString());
        }
        ByteCodeFactory.Byte(byteList, 97);
        ByteCodeFactory.Int(byteList, n);
    }

    protected void Initproperty(ByteList byteList, int n) {
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Initproperty ").append(n).toString());
        }
        ByteCodeFactory.Byte(byteList, 104);
        ByteCodeFactory.Int(byteList, n);
    }

    protected void Setsuper(ByteList byteList, int n) {
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Setsuper ").append(n).toString());
        }
        ByteCodeFactory.Byte(byteList, 5);
        ByteCodeFactory.Int(byteList, n);
    }

    protected void Pushwith(ByteList byteList) {
        this.stack(-1);
        this.scope(1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Pushwith").toString());
        }
        ByteCodeFactory.Byte(byteList, 28);
    }

    protected void Pushscope(ByteList byteList) {
        this.stack(-1);
        this.scope(1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Pushscope").toString());
        }
        ByteCodeFactory.Byte(byteList, 48);
    }

    protected void Popscope(ByteList byteList) {
        this.stack(0);
        this.scope(-1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Popscope").toString());
        }
        ByteCodeFactory.Byte(byteList, 29);
    }

    protected void Nextname(ByteList byteList) {
        this.stack(-1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Nextname").toString());
        }
        ByteCodeFactory.Byte(byteList, 30);
    }

    protected void Nextvalue(ByteList byteList) {
        this.stack(-1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Nextvalue").toString());
        }
        ByteCodeFactory.Byte(byteList, 35);
    }

    protected void Descendants(ByteList byteList) {
        this.stack(-1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Descendants").toString());
        }
        ByteCodeFactory.Byte(byteList, 89);
    }

    protected void Hasnext(ByteList byteList) {
        this.stack(-1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Hasnext").toString());
        }
        ByteCodeFactory.Byte(byteList, 31);
    }

    protected void Hasnext2(ByteList byteList, int n, int n2) {
        this.stack(1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Hasnext2 ").append(n).append(" ").append(n2).toString());
        }
        ByteCodeFactory.Byte(byteList, 50);
        ByteCodeFactory.Int(byteList, n);
        ByteCodeFactory.Int(byteList, n2);
    }

    protected void Convert_s(ByteList byteList) {
        this.stack(0);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Convert.s").toString());
        }
        ByteCodeFactory.Byte(byteList, 112);
    }

    protected void Esc_xelem(ByteList byteList) {
        this.stack(0);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Esc.xelem").toString());
        }
        ByteCodeFactory.Byte(byteList, 113);
    }

    protected void Esc_xattr(ByteList byteList) {
        this.stack(0);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Esc.xattr").toString());
        }
        ByteCodeFactory.Byte(byteList, 114);
    }

    protected void CheckFilter(ByteList byteList) {
        this.stack(0);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":CheckFilter").toString());
        }
        ByteCodeFactory.Byte(byteList, 120);
    }

    protected void Convert_i(ByteList byteList) {
        this.stack(0);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Convert.i").toString());
        }
        ByteCodeFactory.Byte(byteList, 115);
    }

    protected void Convert_u(ByteList byteList) {
        this.stack(0);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Convert.u").toString());
        }
        ByteCodeFactory.Byte(byteList, 116);
    }

    protected void Convert_d(ByteList byteList) {
        this.stack(0);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Convert.d").toString());
        }
        ByteCodeFactory.Byte(byteList, 117);
    }

    protected void Convert_b(ByteList byteList) {
        this.stack(0);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Convert.b").toString());
        }
        ByteCodeFactory.Byte(byteList, 118);
    }

    protected void Convert_o(ByteList byteList) {
        this.stack(0);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Convert.o").toString());
        }
        ByteCodeFactory.Byte(byteList, 119);
    }

    protected void Coerce(ByteList byteList, int n) {
        this.stack(0);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Coerce ").append(n).toString());
        }
        ByteCodeFactory.Byte(byteList, 128);
        ByteCodeFactory.Int(byteList, n);
    }

    protected void Coerce_a(ByteList byteList) {
        this.stack(0);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Coerce.o").toString());
        }
        ByteCodeFactory.Byte(byteList, 130);
    }

    protected void Coerce_s(ByteList byteList) {
        this.stack(0);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Coerce.s").toString());
        }
        ByteCodeFactory.Byte(byteList, 133);
    }

    protected void Astype(ByteList byteList, int n) {
        this.stack(0);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Astype ").append(n).toString());
        }
        ByteCodeFactory.Byte(byteList, 134);
        ByteCodeFactory.Int(byteList, n);
    }

    protected void Astypelate(ByteList byteList) {
        this.stack(-1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Astypelate").toString());
        }
        ByteCodeFactory.Byte(byteList, 135);
    }

    protected void Negate(ByteList byteList) {
        this.stack(0);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Negate").toString());
        }
        ByteCodeFactory.Byte(byteList, 144);
    }

    protected void Negate_i(ByteList byteList) {
        this.stack(0);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Negate.i").toString());
        }
        ByteCodeFactory.Byte(byteList, 196);
    }

    protected void Increment(ByteList byteList) {
        this.stack(0);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Increment").toString());
        }
        ByteCodeFactory.Byte(byteList, 145);
    }

    protected void Increment_i(ByteList byteList) {
        this.stack(0);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Increment.i").toString());
        }
        ByteCodeFactory.Byte(byteList, 192);
    }

    protected void Inclocal(ByteList byteList, int n) {
        this.stack(0);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Inclocal ").append(n).toString());
        }
        ByteCodeFactory.Byte(byteList, 146);
        ByteCodeFactory.Int(byteList, n);
    }

    protected void Inclocal_i(ByteList byteList, int n) {
        this.stack(0);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Inclocal.i ").append(n).toString());
        }
        ByteCodeFactory.Byte(byteList, 194);
        ByteCodeFactory.Int(byteList, n);
    }

    protected void Decrement(ByteList byteList) {
        this.stack(0);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Decrement").toString());
        }
        ByteCodeFactory.Byte(byteList, 147);
    }

    protected void Decrement_i(ByteList byteList) {
        this.stack(0);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Decrement.i").toString());
        }
        ByteCodeFactory.Byte(byteList, 193);
    }

    protected void Declocal(ByteList byteList, int n) {
        this.stack(0);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Declocal ").append(n).toString());
        }
        ByteCodeFactory.Byte(byteList, 148);
        ByteCodeFactory.Int(byteList, n);
    }

    protected void Declocal_i(ByteList byteList, int n) {
        this.stack(0);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Declocal.i ").append(n).toString());
        }
        ByteCodeFactory.Byte(byteList, 195);
        ByteCodeFactory.Int(byteList, n);
    }

    protected void Typeof(ByteList byteList) {
        this.stack(0);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Typeof").toString());
        }
        ByteCodeFactory.Byte(byteList, 149);
    }

    protected void Not(ByteList byteList) {
        this.stack(0);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Not").toString());
        }
        ByteCodeFactory.Byte(byteList, 150);
    }

    protected void Add(ByteList byteList) {
        this.stack(-1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Add").toString());
        }
        ByteCodeFactory.Byte(byteList, 160);
    }

    protected void Add_i(ByteList byteList) {
        this.stack(-1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Add.i").toString());
        }
        ByteCodeFactory.Byte(byteList, 197);
    }

    protected void Subtract(ByteList byteList) {
        this.stack(-1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Subtract").toString());
        }
        ByteCodeFactory.Byte(byteList, 161);
    }

    protected void Subtract_i(ByteList byteList) {
        this.stack(-1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Subtract.i").toString());
        }
        ByteCodeFactory.Byte(byteList, 198);
    }

    protected void Multiply(ByteList byteList) {
        this.stack(-1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Multiply").toString());
        }
        ByteCodeFactory.Byte(byteList, 162);
    }

    protected void Multiply_i(ByteList byteList) {
        this.stack(-1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Multiply.i").toString());
        }
        ByteCodeFactory.Byte(byteList, 199);
    }

    protected void Divide(ByteList byteList) {
        this.stack(-1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Divide").toString());
        }
        ByteCodeFactory.Byte(byteList, 163);
    }

    protected void Modulo(ByteList byteList) {
        this.stack(-1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Modulo").toString());
        }
        ByteCodeFactory.Byte(byteList, 164);
    }

    protected void Lshift(ByteList byteList) {
        this.stack(-1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Lshift").toString());
        }
        ByteCodeFactory.Byte(byteList, 165);
    }

    protected void Rshift(ByteList byteList) {
        this.stack(-1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Rshift").toString());
        }
        ByteCodeFactory.Byte(byteList, 166);
    }

    protected void Urshift(ByteList byteList) {
        this.stack(-1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Urshift").toString());
        }
        ByteCodeFactory.Byte(byteList, 167);
    }

    protected void Bitand(ByteList byteList) {
        this.stack(-1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Bitand").toString());
        }
        ByteCodeFactory.Byte(byteList, 168);
    }

    protected void Bitor(ByteList byteList) {
        this.stack(-1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Bitor").toString());
        }
        ByteCodeFactory.Byte(byteList, 169);
    }

    protected void Bitxor(ByteList byteList) {
        this.stack(-1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Bitxor").toString());
        }
        ByteCodeFactory.Byte(byteList, 170);
    }

    protected void Equals(ByteList byteList) {
        this.stack(-1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Equals").toString());
        }
        ByteCodeFactory.Byte(byteList, 171);
    }

    protected void Strictequals(ByteList byteList) {
        this.stack(-1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Strictequals").toString());
        }
        ByteCodeFactory.Byte(byteList, 172);
    }

    protected void Lessthan(ByteList byteList) {
        this.stack(-1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Lessthan").toString());
        }
        ByteCodeFactory.Byte(byteList, 173);
    }

    protected void Lessequals(ByteList byteList) {
        this.stack(-1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Lessequals").toString());
        }
        ByteCodeFactory.Byte(byteList, 174);
    }

    protected void Greaterthan(ByteList byteList) {
        this.stack(-1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Greaterthan").toString());
        }
        ByteCodeFactory.Byte(byteList, 175);
    }

    protected void Greaterequals(ByteList byteList) {
        this.stack(-1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Greaterequals").toString());
        }
        ByteCodeFactory.Byte(byteList, 176);
    }

    protected void Instanceof(ByteList byteList) {
        this.stack(-1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Instanceof").toString());
        }
        ByteCodeFactory.Byte(byteList, 177);
    }

    protected void In(ByteList byteList) {
        this.stack(-1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":In").toString());
        }
        ByteCodeFactory.Byte(byteList, 180);
    }

    protected void Istype(ByteList byteList, int n) {
        this.stack(0);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Istype ").append(n).toString());
        }
        ByteCodeFactory.Byte(byteList, 178);
        ByteCodeFactory.Int(byteList, n);
    }

    protected void Istypelate(ByteList byteList) {
        this.stack(-1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Istypelate").toString());
        }
        ByteCodeFactory.Byte(byteList, 179);
    }

    protected void finddef(ByteList byteList, int n) {
        this.stack(1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Finddef ").append(n).toString());
        }
        ByteCodeFactory.Byte(byteList, 95);
        ByteCodeFactory.Int(byteList, n);
    }

    protected void Findpropstrict(ByteList byteList, int n) {
        this.stack(1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Findpropstrict ").append(n).toString());
        }
        ByteCodeFactory.Byte(byteList, 93);
        ByteCodeFactory.Int(byteList, n);
    }

    protected void Findproperty(ByteList byteList, int n) {
        this.stack(1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Findproperty ").append(n).toString());
        }
        ByteCodeFactory.Byte(byteList, 94);
        ByteCodeFactory.Int(byteList, n);
    }

    protected void Getslot(ByteList byteList, int n) {
        this.stack(0);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Getslot ").append(n).toString());
        }
        ByteCodeFactory.Byte(byteList, 108);
        ByteCodeFactory.Int(byteList, n);
    }

    protected void Setslot(ByteList byteList, int n) {
        this.stack(-2);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Setslot ").append(n).toString());
        }
        ByteCodeFactory.Byte(byteList, 109);
        ByteCodeFactory.Int(byteList, n);
    }

    protected void Bitnot(ByteList byteList) {
        this.stack(0);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Bitnot").toString());
        }
        ByteCodeFactory.Byte(byteList, 151);
    }

    protected void DebugLocal(ByteList byteList, int n, int n2, int n3) {
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Debug DI_SLOT ").append(n).append(" slot ").append(n2).append(" line ").append(n3).toString());
        }
        ByteCodeFactory.Byte(byteList, 239);
        ByteCodeFactory.Byte(byteList, 1);
        ByteCodeFactory.Int(byteList, n);
        ByteCodeFactory.Byte(byteList, n2);
        ByteCodeFactory.Int(byteList, n3);
    }

    protected void DebugFile(ByteList byteList, int n) {
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":DebugFile ").append(n).toString());
        }
        ByteCodeFactory.Byte(byteList, 241);
        ByteCodeFactory.Int(byteList, n);
    }

    protected void DebugLine(ByteList byteList, int n) {
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":DebugLine ").append(n).toString());
        }
        ByteCodeFactory.Byte(byteList, 240);
        ByteCodeFactory.Int(byteList, n);
    }

    protected void Dxnslate(ByteList byteList) {
        this.stack(-1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Dxnslate").toString());
        }
        ByteCodeFactory.Byte(byteList, 7);
    }

    protected void Dxns(ByteList byteList, int n) {
        this.stack(1);
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Dxns ").append(n).toString());
        }
        ByteCodeFactory.Byte(byteList, 6);
        ByteCodeFactory.Int(byteList, n);
    }

    protected void Kill(ByteList byteList, int n) {
        if (this.bytecodeFactory.show_bytecode) {
            this.code_out.write(new StringBuffer().append("\n      ").append(this.getIP()).append(":Kill ").append(n).toString());
        }
        ByteCodeFactory.Byte(byteList, 8);
        ByteCodeFactory.Int(byteList, n);
    }

    public int getRegisterOffset(Context context) {
        int n = context.getScopes().size();
        while (--n >= 0) {
            Builder builder = context.scope((int)n).builder;
            if (!builder.hasRegisterOffset()) continue;
            return builder.reg_offset;
        }
        return -1;
    }

    @Override
    public void setOrigin(String string) {
        super.setOrigin(string);
        if (this.emit_debug_info) {
            this.debug_info.debug_file = string;
            this.debug_info.debug_file_dirty = true;
        }
    }

    @Override
    public void setPosition(int n, int n2, int n3) {
        super.setPosition(n, n2, n3);
        if (this.emit_debug_info && n3 > 0 && this.debug_info.debug_linenum != n) {
            this.debug_info.debug_linenum_dirty = true;
            this.debug_info.debug_linenum = n;
        }
    }

    @Override
    public void clearPositionInfo() {
        if (this.emit_debug_info) {
            this.debug_info.debug_linenum_dirty = false;
        }
    }

    public void flushDebugInfo() {
        if (this.emit_debug_info && this.debug_info.debug_linenum_dirty && this.debug_info.debug_linenum > -1 && this.ab.code != null && !this.debug_info.suppress_debug_method) {
            if (this.debug_info.debug_file_dirty) {
                this.DebugFile(this.debug_info.debug_file);
                this.debug_info.debug_file_dirty = false;
            }
            this.DebugLine(this.debug_info.debug_linenum);
            this.debug_info.debug_linenum_dirty = false;
        }
    }

    public void reorderMainScript() {
        this.ab.scripts.add((ByteList)this.ab.scripts.remove(0));
    }

    public String il_str() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.bytecodeFactory.show_bytecode) {
            stringBuffer.append("constants----------------------------------------------------");
            stringBuffer.append(this.bytecodeFactory.cpool_out.str());
            stringBuffer.append("\ndefinitions--------------------------------------------------");
            stringBuffer.append(this.bytecodeFactory.defns_out.str());
            stringBuffer.append("\ncode---------------------------------------------------------");
        }
        stringBuffer.append(this.code_out);
        return stringBuffer.toString();
    }

    private static String cleanupString(ByteList byteList) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = byteList.size();
        for (int i = 0; i < n; ++i) {
            char c = (char)byteList.get(i);
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') && c != '_') continue;
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private String cleanupName(ByteList byteList) {
        int n;
        ByteList byteList2;
        BytecodeBuffer bytecodeBuffer;
        int n2;
        BytecodeBuffer bytecodeBuffer2 = new BytecodeBuffer(byteList.toByteArray(false));
        if (bytecodeBuffer2.readU8() == 7 && ((n2 = (bytecodeBuffer = new BytecodeBuffer((byteList2 = (ByteList)this.ab.constant_ns_pool.get((n = bytecodeBuffer2.readU32()) - 1)).toByteArray(false))).readU8()) == 8 || n2 == 22)) {
            int n3 = bytecodeBuffer.readU32();
            int n4 = bytecodeBuffer2.readU32();
            return new StringBuffer().append(ActionBlockEmitter.cleanupString((ByteList)this.ab.constant_utf8_pool.get(n3 - 1))).append("_").append(ActionBlockEmitter.cleanupString((ByteList)this.ab.constant_utf8_pool.get(n4 - 1))).toString();
        }
        return "";
    }

    public void dumpCpoolVars() {
        String string;
        int n = 1;
        HashSet<String> hashSet = new HashSet<String>();
        for (ByteList byteList : this.ab.constant_utf8_pool) {
            string = ActionBlockEmitter.cleanupString(byteList);
            if (string.length() > 0 && !hashSet.contains(string)) {
                hashSet.add(string);
                this.header_out.println(new StringBuffer().append("const int abcstr_").append(string).append(" = ").append(n).append(";").toString());
            }
            ++n;
        }
        n = 1;
        for (ByteList byteList : this.ab.constant_mn_pool) {
            string = this.cleanupName(byteList);
            if (string.length() > 0) {
                this.header_out.println(new StringBuffer().append("const int abcname_").append(string).append(" = ").append(n).append(";").toString());
            }
            ++n;
        }
    }

    public String header_str() {
        String string = this.header_out.toString();
        if (string.length() > 0) {
            return string;
        }
        return null;
    }

    public ActionBlockEmitter(Context context, String string) {
        this(context, string, null, null, false, true, false, false);
    }

    public ActionBlockEmitter(Context context, String string, PrintWriter printWriter, PrintWriter printWriter2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.cx = context;
        this.scriptname = string;
        this.show_instructions = bl;
        this.code_out = printWriter;
        this.header_out = printWriter2;
        this.show_linenums = bl3;
        this.emit_debug_info = bl4;
        this.show_stacknames = false;
        this.bytecodeFactory = context.getByteCodeFactory();
        this.bytecodeFactory.show_bytecode = bl2;
        this.ab = new ActionBlock(this, bl2);
    }

    static {
        $assertionsDisabled = true;
    }

    class ExceptionBlock {
        public int try_start = 0;
        public int try_end = 0;
        public IntList fixups = new IntList();
        public IntList finallyAddrs = new IntList();
        public int scopeIndex = -1;
        public boolean hasFinally = false;
        public int cur_locals = 0;
        public int loop_index = -1;
        final /* synthetic */ ActionBlockEmitter this$0;

        /*
         * WARNING - void declaration
         */
        ExceptionBlock(ActionBlockEmitter actionBlockEmitter) {
            void arg0;
            this.this$0 = arg0;
        }
    }

    /*
     * This class specifies class file version 47.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ActionBlock {
        public int minor_version = 16;
        public int major_version = 46;
        public int vars_count = 0;
        public ObjectList<ByteList> vars;
        public int methods_count = 0;
        public ObjectList<ByteList> methods;
        public int metadata_count = 0;
        public ObjectList<ByteList> metadata;
        public int bodies_count = 0;
        public ObjectList<ByteList> bodies;
        public int dispids_count = 0;
        public ObjectList<ByteList> dispids;
        public int classes_count = 0;
        public ObjectList<ByteList> classes;
        public ObjectList<ByteList> instances;
        public int interfaces_count = 0;
        public ObjectList<ByteList> interfaces;
        public int scripts_count = 0;
        public ObjectList<ByteList> scripts;
        public int main_index;
        private Map<ByteList, Integer> bodies_map = new HashMap<ByteList, Integer>();
        private Map<ByteList, Integer> constant_utf8_map = new HashMap<ByteList, Integer>();
        public ObjectList<ByteList> constant_utf8_pool = new ObjectList();
        private Map<ByteList, Integer> constant_mn_map = new HashMap<ByteList, Integer>();
        public ObjectList<ByteList> constant_mn_pool = new ObjectList();
        private Map<ByteList, Integer> constant_nss_map = new HashMap<ByteList, Integer>();
        public ObjectList<ByteList> constant_nss_pool = new ObjectList();
        private Map<ByteList, Integer> constant_ns_map = new HashMap<ByteList, Integer>();
        public ObjectList<ByteList> constant_ns_pool = new ObjectList();
        private Map<ByteList, Integer> constant_double_map = new HashMap<ByteList, Integer>();
        public ObjectList<ByteList> constant_double_pool = new ObjectList();
        private Map<ByteList, Integer> constant_uint_map = new HashMap<ByteList, Integer>();
        public ObjectList<ByteList> constant_uint_pool = new ObjectList();
        private Map<ByteList, Integer> constant_int_map = new HashMap<ByteList, Integer>();
        public ObjectList<ByteList> constant_int_pool = new ObjectList();
        public int exception_count = 0;
        public ByteList exception_table;
        public ByteList code = null;
        public boolean show_bytecode;
        final /* synthetic */ ActionBlockEmitter this$0;

        /*
         * WARNING - void declaration
         */
        public ActionBlock(ActionBlockEmitter actionBlockEmitter, boolean bl) {
            void arg1;
            void arg0;
            this.this$0 = arg0;
            this.vars = new ObjectList();
            this.methods = new ObjectList();
            this.metadata = new ObjectList();
            this.bodies = new ObjectList();
            this.dispids = new ObjectList();
            this.instances = new ObjectList();
            this.classes = new ObjectList();
            this.interfaces = new ObjectList();
            this.scripts = new ObjectList();
            this.exception_table = ByteCodeFactory.allocBytes();
            this.show_bytecode = arg1;
        }

        public int addBody(ByteList byteList) {
            Integer n = this.bodies_map.get(byteList);
            if (n != null) {
                return n + 1;
            }
            this.bodies_map.put(byteList, Boxing.valueOf(this.bodies.size()));
            this.bodies.push_back(byteList);
            int n2 = this.bodies.size();
            return n2;
        }

        public int addUtf8Constant(ByteList byteList) {
            Integer n = this.constant_utf8_map.get(byteList);
            if (n != null) {
                int n2 = n;
                return n2 + 1;
            }
            this.constant_utf8_map.put(byteList, Boxing.valueOf(this.constant_utf8_pool.size()));
            this.constant_utf8_pool.add(byteList);
            int n3 = this.constant_utf8_pool.size();
            if (this.show_bytecode) {
                ((ActionBlockEmitter)this.this$0).bytecodeFactory.cpool_out.write(new StringBuffer().append(" -> ").append(n3).toString());
            }
            return n3;
        }

        public int addMultiNameConstant(ByteList byteList) {
            Integer n = this.constant_mn_map.get(byteList);
            if (n != null) {
                int n2 = n;
                return n2 + 1;
            }
            this.constant_mn_map.put(byteList, Boxing.valueOf(this.constant_mn_pool.size()));
            this.constant_mn_pool.add(byteList);
            int n3 = this.constant_mn_pool.size();
            if (this.show_bytecode) {
                ((ActionBlockEmitter)this.this$0).bytecodeFactory.cpool_out.write(new StringBuffer().append(" -> ").append(n3).toString());
            }
            return n3;
        }

        public int addNsSetConstant(ByteList byteList) {
            Integer n = this.constant_nss_map.get(byteList);
            if (n != null) {
                int n2 = n;
                return n2 + 1;
            }
            this.constant_nss_map.put(byteList, Boxing.valueOf(this.constant_nss_pool.size()));
            this.constant_nss_pool.add(byteList);
            int n3 = this.constant_nss_pool.size();
            if (this.show_bytecode) {
                ((ActionBlockEmitter)this.this$0).bytecodeFactory.cpool_out.write(new StringBuffer().append(" -> ").append(n3).toString());
            }
            return n3;
        }

        public int addNsConstant(ByteList byteList) {
            Integer n = this.constant_ns_map.get(byteList);
            if (n != null) {
                int n2 = n;
                return n2 + 1;
            }
            this.constant_ns_map.put(byteList, Boxing.valueOf(this.constant_ns_pool.size()));
            this.constant_ns_pool.add(byteList);
            int n3 = this.constant_ns_pool.size();
            if (this.show_bytecode) {
                ((ActionBlockEmitter)this.this$0).bytecodeFactory.cpool_out.write(new StringBuffer().append(" -> ").append(n3).toString());
            }
            return n3;
        }

        public int addDoubleConstant(ByteList byteList) {
            Integer n = this.constant_double_map.get(byteList);
            if (n != null) {
                int n2 = n;
                return n2 + 1;
            }
            this.constant_double_map.put(byteList, Boxing.valueOf(this.constant_double_pool.size()));
            this.constant_double_pool.add(byteList);
            int n3 = this.constant_double_pool.size();
            if (this.show_bytecode) {
                ((ActionBlockEmitter)this.this$0).bytecodeFactory.cpool_out.write(new StringBuffer().append(" -> ").append(n3).toString());
            }
            return n3;
        }

        public int addUIntConstant(ByteList byteList) {
            Integer n = this.constant_uint_map.get(byteList);
            if (n != null) {
                int n2 = n;
                return n2 + 1;
            }
            this.constant_uint_map.put(byteList, Boxing.valueOf(this.constant_uint_pool.size()));
            this.constant_uint_pool.add(byteList);
            int n3 = this.constant_uint_pool.size();
            if (this.show_bytecode) {
                ((ActionBlockEmitter)this.this$0).bytecodeFactory.cpool_out.write(new StringBuffer().append(" -> ").append(n3).toString());
            }
            return n3;
        }

        public int addIntConstant(ByteList byteList) {
            Integer n = this.constant_int_map.get(byteList);
            if (n != null) {
                int n2 = n;
                return n2 + 1;
            }
            this.constant_int_map.put(byteList, Boxing.valueOf(this.constant_int_pool.size()));
            this.constant_int_pool.add(byteList);
            int n3 = this.constant_int_pool.size();
            if (this.show_bytecode) {
                ((ActionBlockEmitter)this.this$0).bytecodeFactory.cpool_out.write(new StringBuffer().append(" -> ").append(n3).toString());
            }
            return n3;
        }

        public int addBytesToTable(ObjectList<ByteList> objectList, ByteList byteList) {
            int n = 0;
            for (ByteList byteList2 : objectList) {
                int n2 = byteList2.size();
                if (n2 == byteList.size()) {
                    int n3;
                    for (n3 = 0; n3 < n2 && byteList2.get(n3) == byteList.get(n3); ++n3) {
                    }
                    if (n3 == n2) {
                        return n + 1;
                    }
                }
                ++n;
            }
            objectList.add(byteList);
            int n4 = objectList.size();
            return n4;
        }
    }
}

