/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.parser;

import java.io.PrintWriter;
import java.util.Iterator;
import macromedia.asc.parser.ArgumentListNode;
import macromedia.asc.parser.AttributeListNode;
import macromedia.asc.parser.BinaryClassDefNode;
import macromedia.asc.parser.BinaryExpressionNode;
import macromedia.asc.parser.BinaryFunctionDefinitionNode;
import macromedia.asc.parser.BinaryInterfaceDefinitionNode;
import macromedia.asc.parser.BinaryProgramNode;
import macromedia.asc.parser.BoxNode;
import macromedia.asc.parser.BreakStatementNode;
import macromedia.asc.parser.CallExpressionNode;
import macromedia.asc.parser.CaseLabelNode;
import macromedia.asc.parser.CatchClauseNode;
import macromedia.asc.parser.ClassDefinitionNode;
import macromedia.asc.parser.ClassNameNode;
import macromedia.asc.parser.CoerceNode;
import macromedia.asc.parser.ConditionalExpressionNode;
import macromedia.asc.parser.ConfigNamespaceDefinitionNode;
import macromedia.asc.parser.ContinueStatementNode;
import macromedia.asc.parser.DefaultXMLNamespaceNode;
import macromedia.asc.parser.DeleteExpressionNode;
import macromedia.asc.parser.DoStatementNode;
import macromedia.asc.parser.DocCommentNode;
import macromedia.asc.parser.EmptyElementNode;
import macromedia.asc.parser.EmptyStatementNode;
import macromedia.asc.parser.ErrorNode;
import macromedia.asc.parser.Evaluator;
import macromedia.asc.parser.ExpressionStatementNode;
import macromedia.asc.parser.FinallyClauseNode;
import macromedia.asc.parser.ForStatementNode;
import macromedia.asc.parser.FunctionCommonNode;
import macromedia.asc.parser.FunctionDefinitionNode;
import macromedia.asc.parser.FunctionNameNode;
import macromedia.asc.parser.FunctionSignatureNode;
import macromedia.asc.parser.GetExpressionNode;
import macromedia.asc.parser.HasNextNode;
import macromedia.asc.parser.IdentifierNode;
import macromedia.asc.parser.IfStatementNode;
import macromedia.asc.parser.ImportDirectiveNode;
import macromedia.asc.parser.ImportNode;
import macromedia.asc.parser.IncludeDirectiveNode;
import macromedia.asc.parser.IncrementNode;
import macromedia.asc.parser.InheritanceNode;
import macromedia.asc.parser.InterfaceDefinitionNode;
import macromedia.asc.parser.InvokeNode;
import macromedia.asc.parser.LabeledStatementNode;
import macromedia.asc.parser.ListNode;
import macromedia.asc.parser.LiteralArrayNode;
import macromedia.asc.parser.LiteralBooleanNode;
import macromedia.asc.parser.LiteralFieldNode;
import macromedia.asc.parser.LiteralNullNode;
import macromedia.asc.parser.LiteralNumberNode;
import macromedia.asc.parser.LiteralObjectNode;
import macromedia.asc.parser.LiteralRegExpNode;
import macromedia.asc.parser.LiteralStringNode;
import macromedia.asc.parser.LiteralXMLNode;
import macromedia.asc.parser.LoadRegisterNode;
import macromedia.asc.parser.MemberExpressionNode;
import macromedia.asc.parser.MetaDataEvaluator;
import macromedia.asc.parser.MetaDataNode;
import macromedia.asc.parser.NamespaceDefinitionNode;
import macromedia.asc.parser.Node;
import macromedia.asc.parser.PackageDefinitionNode;
import macromedia.asc.parser.PackageIdentifiersNode;
import macromedia.asc.parser.PackageNameNode;
import macromedia.asc.parser.ParameterListNode;
import macromedia.asc.parser.ParameterNode;
import macromedia.asc.parser.ParenExpressionNode;
import macromedia.asc.parser.ParenListExpressionNode;
import macromedia.asc.parser.PragmaExpressionNode;
import macromedia.asc.parser.PragmaNode;
import macromedia.asc.parser.ProgramNode;
import macromedia.asc.parser.QualifiedExpressionNode;
import macromedia.asc.parser.QualifiedIdentifierNode;
import macromedia.asc.parser.RegisterNode;
import macromedia.asc.parser.RestExpressionNode;
import macromedia.asc.parser.RestParameterNode;
import macromedia.asc.parser.ReturnStatementNode;
import macromedia.asc.parser.SetExpressionNode;
import macromedia.asc.parser.StatementListNode;
import macromedia.asc.parser.StoreRegisterNode;
import macromedia.asc.parser.SuperExpressionNode;
import macromedia.asc.parser.SuperStatementNode;
import macromedia.asc.parser.SwitchStatementNode;
import macromedia.asc.parser.ThisExpressionNode;
import macromedia.asc.parser.ThrowStatementNode;
import macromedia.asc.parser.ToObjectNode;
import macromedia.asc.parser.Token;
import macromedia.asc.parser.TryStatementNode;
import macromedia.asc.parser.TypeExpressionNode;
import macromedia.asc.parser.TypedIdentifierNode;
import macromedia.asc.parser.UnaryExpressionNode;
import macromedia.asc.parser.UntypedVariableBindingNode;
import macromedia.asc.parser.UseDirectiveNode;
import macromedia.asc.parser.VariableBindingNode;
import macromedia.asc.parser.VariableDefinitionNode;
import macromedia.asc.parser.WhileStatementNode;
import macromedia.asc.parser.WithStatementNode;
import macromedia.asc.semantics.Value;
import macromedia.asc.util.Context;

public class NodePrinter
implements Evaluator {
    private PrintWriter out;
    private int level;
    private int mode;
    public static final int man_mode = 0;
    public static final int machine_mode = 1;

    private void separate() {
        if (this.mode == 1) {
            this.out.print("|");
        }
    }

    private void push_in() {
        ++this.level;
        if (this.mode == 1) {
            this.out.print("[");
        } else {
            this.out.print(" ");
        }
    }

    private void pop_out() {
        if (this.mode == 1) {
            this.out.print("]");
        }
        --this.level;
    }

    private void indent() {
        if (this.mode == 0) {
            this.out.println();
            for (int i = this.level; i != 0; --i) {
                this.out.print("  ");
            }
        }
    }

    public boolean checkFeature(Context context, Node node) {
        return true;
    }

    public NodePrinter() {
        this(0, new PrintWriter(System.out, true));
    }

    public NodePrinter(PrintWriter printWriter) {
        this(0, printWriter);
    }

    public NodePrinter(int n, PrintWriter printWriter) {
        this.out = printWriter;
        this.level = 0;
        this.mode = n;
    }

    public Value evaluate(Context context, Node node) {
        this.indent();
        this.out.print("error:undefined printer method");
        return null;
    }

    public Value evaluate(Context context, IdentifierNode identifierNode) {
        this.indent();
        if (identifierNode.isAttr()) {
            this.out.print("attributeidentifier ");
        } else {
            this.out.print("identifier ");
        }
        this.out.print(identifierNode.name);
        return null;
    }

    public Value evaluate(Context context, IncrementNode incrementNode) {
        this.indent();
        this.out.print("increment");
        this.out.print(incrementNode.getMode() == -28 ? " bracket" : (incrementNode.getMode() == -13 ? " filter" : (incrementNode.getMode() == -19 ? " descend" : (incrementNode.getMode() == -18 ? " dot" : (incrementNode.getMode() == -132 ? " lexical" : " error")))));
        this.out.print((incrementNode.isPostfix ? " postfix " : " prefix ") + Token.getTokenClassName(incrementNode.op));
        this.push_in();
        this.pop_out();
        this.separate();
        this.push_in();
        if (incrementNode.expr != null) {
            incrementNode.expr.evaluate(context, this);
        }
        this.pop_out();
        return null;
    }

    public Value evaluate(Context context, ThisExpressionNode thisExpressionNode) {
        this.indent();
        this.out.print("this");
        return null;
    }

    public Value evaluate(Context context, QualifiedIdentifierNode qualifiedIdentifierNode) {
        this.indent();
        if (qualifiedIdentifierNode.isAttr()) {
            this.out.print("qualifiedattributeidentifier ");
        } else {
            this.out.print("qualifiedidentifier ");
        }
        this.out.print(qualifiedIdentifierNode.name);
        if (qualifiedIdentifierNode.qualifier != null) {
            this.push_in();
            this.indent();
            this.out.print("qualifier");
            this.push_in();
            qualifiedIdentifierNode.qualifier.evaluate(context, this);
            this.pop_out();
            this.pop_out();
        }
        return null;
    }

    public Value evaluate(Context context, QualifiedExpressionNode qualifiedExpressionNode) {
        this.indent();
        if (qualifiedExpressionNode.isAttr()) {
            this.out.print("qualifiedattributeexpression ");
        } else {
            this.out.print("qualifiedexpression ");
        }
        this.out.print(qualifiedExpressionNode.name);
        if (qualifiedExpressionNode.qualifier != null) {
            this.push_in();
            this.indent();
            this.out.print("qualifier");
            this.push_in();
            qualifiedExpressionNode.qualifier.evaluate(context, this);
            this.pop_out();
            this.pop_out();
        }
        if (qualifiedExpressionNode.expr != null) {
            this.push_in();
            this.indent();
            this.out.print("expr");
            this.push_in();
            qualifiedExpressionNode.expr.evaluate(context, this);
            this.pop_out();
            this.pop_out();
        }
        return null;
    }

    public Value evaluate(Context context, LiteralBooleanNode literalBooleanNode) {
        this.indent();
        this.out.print("literalboolean ");
        this.out.print(literalBooleanNode.value ? 1 : 0);
        return null;
    }

    public Value evaluate(Context context, LiteralNumberNode literalNumberNode) {
        this.indent();
        this.out.print("literalnumber:");
        this.out.print(literalNumberNode.value);
        return null;
    }

    public Value evaluate(Context context, LiteralStringNode literalStringNode) {
        this.indent();
        this.out.print("literalstring:");
        this.out.print(literalStringNode.value);
        return null;
    }

    public Value evaluate(Context context, LiteralNullNode literalNullNode) {
        this.indent();
        this.out.print("literalnull");
        return null;
    }

    public Value evaluate(Context context, LiteralRegExpNode literalRegExpNode) {
        this.indent();
        this.out.print("literalregexp:");
        this.out.print(literalRegExpNode.value);
        return null;
    }

    public Value evaluate(Context context, LiteralXMLNode literalXMLNode) {
        this.indent();
        this.out.print("literalxml");
        this.push_in();
        if (literalXMLNode.list != null) {
            literalXMLNode.list.evaluate(context, this);
        }
        this.pop_out();
        return null;
    }

    public Value evaluate(Context context, FunctionCommonNode functionCommonNode) {
        this.indent();
        this.out.print("functioncommon");
        this.push_in();
        if (functionCommonNode.signature != null) {
            functionCommonNode.signature.evaluate(context, this);
        }
        this.separate();
        if (functionCommonNode.body != null) {
            functionCommonNode.body.evaluate(context, this);
        }
        this.pop_out();
        return null;
    }

    public Value evaluate(Context context, ParenExpressionNode parenExpressionNode) {
        this.indent();
        this.out.print("paren");
        return null;
    }

    public Value evaluate(Context context, ParenListExpressionNode parenListExpressionNode) {
        this.indent();
        this.out.print("parenlist");
        if (parenListExpressionNode.expr != null) {
            parenListExpressionNode.expr.evaluate(context, this);
        }
        return null;
    }

    public Value evaluate(Context context, LiteralObjectNode literalObjectNode) {
        this.indent();
        this.out.print("literalobject");
        this.push_in();
        if (literalObjectNode.fieldlist != null) {
            literalObjectNode.fieldlist.evaluate(context, this);
        }
        this.pop_out();
        return null;
    }

    public Value evaluate(Context context, LiteralFieldNode literalFieldNode) {
        this.indent();
        this.out.print("literalfield");
        this.push_in();
        if (literalFieldNode.name != null) {
            literalFieldNode.name.evaluate(context, this);
        }
        this.separate();
        if (literalFieldNode.value != null) {
            literalFieldNode.value.evaluate(context, this);
        }
        this.pop_out();
        return null;
    }

    public Value evaluate(Context context, LiteralArrayNode literalArrayNode) {
        this.indent();
        this.out.print("literalarray");
        this.push_in();
        if (literalArrayNode.elementlist != null) {
            literalArrayNode.elementlist.evaluate(context, this);
        }
        this.pop_out();
        return null;
    }

    public Value evaluate(Context context, SuperExpressionNode superExpressionNode) {
        this.indent();
        this.out.print("superexpression");
        this.push_in();
        if (superExpressionNode.expr != null) {
            superExpressionNode.expr.evaluate(context, this);
        }
        this.pop_out();
        return null;
    }

    public Value evaluate(Context context, MemberExpressionNode memberExpressionNode) {
        this.indent();
        this.out.print("member");
        this.push_in();
        if (memberExpressionNode.base != null) {
            memberExpressionNode.base.evaluate(context, this);
        }
        this.separate();
        if (memberExpressionNode.selector != null) {
            memberExpressionNode.selector.evaluate(context, this);
        }
        this.pop_out();
        return null;
    }

    public Value evaluate(Context context, InvokeNode invokeNode) {
        this.indent();
        this.out.print("invoke");
        this.out.print(invokeNode.getMode() == -28 ? " bracket" : (invokeNode.getMode() == -13 ? " filter" : (invokeNode.getMode() == -19 ? " descend" : (invokeNode.getMode() == -132 ? " lexical" : " dot"))));
        this.push_in();
        this.out.print(invokeNode.name);
        this.separate();
        if (invokeNode.args != null) {
            invokeNode.args.evaluate(context, this);
        }
        this.pop_out();
        return null;
    }

    public Value evaluate(Context context, CallExpressionNode callExpressionNode) {
        this.indent();
        this.out.print(callExpressionNode.is_new ? "construct" : "call");
        this.out.print(callExpressionNode.getMode() == -28 ? " bracket" : (callExpressionNode.getMode() == -13 ? " filter" : (callExpressionNode.getMode() == -19 ? " descend" : (callExpressionNode.getMode() == -132 ? " lexical" : " dot"))));
        this.push_in();
        if (callExpressionNode.expr != null) {
            callExpressionNode.expr.evaluate(context, this);
        }
        this.separate();
        if (callExpressionNode.args != null) {
            callExpressionNode.args.evaluate(context, this);
        }
        this.pop_out();
        return null;
    }

    public Value evaluate(Context context, DeleteExpressionNode deleteExpressionNode) {
        this.indent();
        this.out.print("delete");
        this.out.print(deleteExpressionNode.getMode() == -28 ? " bracket" : (deleteExpressionNode.getMode() == -13 ? " filter" : (deleteExpressionNode.getMode() == -19 ? " descend" : (deleteExpressionNode.getMode() == -132 ? " lexical" : " dot"))));
        this.push_in();
        if (deleteExpressionNode.expr != null) {
            deleteExpressionNode.expr.evaluate(context, this);
        }
        this.pop_out();
        return null;
    }

    public Value evaluate(Context context, GetExpressionNode getExpressionNode) {
        this.indent();
        this.out.print("get");
        this.out.print(getExpressionNode.getMode() == -28 ? " bracket" : (getExpressionNode.getMode() == -13 ? " filter" : (getExpressionNode.getMode() == -19 ? " descend" : (getExpressionNode.getMode() == -132 ? " lexical" : " dot"))));
        this.push_in();
        if (getExpressionNode.expr != null) {
            getExpressionNode.expr.evaluate(context, this);
        }
        this.pop_out();
        return null;
    }

    public Value evaluate(Context context, SetExpressionNode setExpressionNode) {
        this.indent();
        this.out.print("set");
        this.out.print(setExpressionNode.getMode() == -28 ? " bracket" : (setExpressionNode.getMode() == -13 ? " filter" : (setExpressionNode.getMode() == -19 ? " descend" : (setExpressionNode.getMode() == -132 ? " lexical" : " dot"))));
        this.push_in();
        if (setExpressionNode.expr != null) {
            setExpressionNode.expr.evaluate(context, this);
        }
        this.separate();
        if (setExpressionNode.args != null) {
            setExpressionNode.args.evaluate(context, this);
        }
        this.pop_out();
        return null;
    }

    public Value evaluate(Context context, UnaryExpressionNode unaryExpressionNode) {
        this.indent();
        this.out.print("unary");
        this.push_in();
        this.out.print(Token.getTokenClassName(unaryExpressionNode.op));
        this.pop_out();
        this.separate();
        this.push_in();
        if (unaryExpressionNode.expr != null) {
            unaryExpressionNode.expr.evaluate(context, this);
        }
        this.pop_out();
        return null;
    }

    public Value evaluate(Context context, BinaryExpressionNode binaryExpressionNode) {
        this.indent();
        this.out.print("binary");
        this.push_in();
        this.out.print(Token.getTokenClassName(binaryExpressionNode.op));
        this.pop_out();
        this.separate();
        this.push_in();
        if (binaryExpressionNode.lhs != null) {
            binaryExpressionNode.lhs.evaluate(context, this);
        }
        this.separate();
        if (binaryExpressionNode.rhs != null) {
            binaryExpressionNode.rhs.evaluate(context, this);
        }
        this.pop_out();
        return null;
    }

    public Value evaluate(Context context, ConditionalExpressionNode conditionalExpressionNode) {
        this.indent();
        this.out.print("cond");
        this.push_in();
        if (conditionalExpressionNode.condition != null) {
            conditionalExpressionNode.condition.evaluate(context, this);
        }
        this.pop_out();
        this.separate();
        this.push_in();
        if (conditionalExpressionNode.thenexpr != null) {
            conditionalExpressionNode.thenexpr.evaluate(context, this);
        }
        this.separate();
        if (conditionalExpressionNode.elseexpr != null) {
            conditionalExpressionNode.elseexpr.evaluate(context, this);
        }
        this.pop_out();
        return null;
    }

    public Value evaluate(Context context, ArgumentListNode argumentListNode) {
        this.indent();
        this.out.print("argumentlist");
        this.push_in();
        Iterator iterator = argumentListNode.items.iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            node.evaluate(context, this);
            this.separate();
        }
        this.pop_out();
        return null;
    }

    public Value evaluate(Context context, ListNode listNode) {
        this.indent();
        this.out.print("list");
        this.push_in();
        Iterator iterator = listNode.items.iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            node.evaluate(context, this);
            this.separate();
        }
        this.pop_out();
        return null;
    }

    public Value evaluate(Context context, StatementListNode statementListNode) {
        this.indent();
        this.out.print("statementlist");
        this.push_in();
        Iterator iterator = statementListNode.items.iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            if (node == null) continue;
            node.evaluate(context, this);
        }
        this.pop_out();
        return null;
    }

    public Value evaluate(Context context, EmptyElementNode emptyElementNode) {
        this.indent();
        this.out.print("empty");
        return null;
    }

    public Value evaluate(Context context, EmptyStatementNode emptyStatementNode) {
        this.indent();
        this.out.print("empty");
        return null;
    }

    public Value evaluate(Context context, ExpressionStatementNode expressionStatementNode) {
        this.indent();
        this.out.print("expression");
        this.push_in();
        if (expressionStatementNode.expr != null) {
            expressionStatementNode.expr.evaluate(context, this);
        }
        this.pop_out();
        return null;
    }

    public Value evaluate(Context context, SuperStatementNode superStatementNode) {
        this.indent();
        this.out.print("super");
        this.push_in();
        if (superStatementNode.call.args != null) {
            superStatementNode.call.args.evaluate(context, this);
        }
        this.pop_out();
        return null;
    }

    public Value evaluate(Context context, LabeledStatementNode labeledStatementNode) {
        this.indent();
        this.out.print("labeled");
        this.push_in();
        if (labeledStatementNode.label != null) {
            labeledStatementNode.label.evaluate(context, this);
        }
        this.pop_out();
        this.separate();
        this.push_in();
        if (labeledStatementNode.statement != null) {
            labeledStatementNode.statement.evaluate(context, this);
        }
        this.pop_out();
        return null;
    }

    public Value evaluate(Context context, IfStatementNode ifStatementNode) {
        this.indent();
        this.out.print("if");
        this.push_in();
        if (ifStatementNode.condition != null) {
            ifStatementNode.condition.evaluate(context, this);
        }
        this.pop_out();
        this.separate();
        this.push_in();
        if (ifStatementNode.thenactions != null) {
            ifStatementNode.thenactions.evaluate(context, this);
        }
        this.pop_out();
        this.separate();
        this.push_in();
        if (ifStatementNode.elseactions != null) {
            ifStatementNode.elseactions.evaluate(context, this);
        }
        this.pop_out();
        return null;
    }

    public Value evaluate(Context context, SwitchStatementNode switchStatementNode) {
        this.indent();
        this.out.print("switch");
        this.push_in();
        if (switchStatementNode.expr != null) {
            switchStatementNode.expr.evaluate(context, this);
        }
        this.pop_out();
        this.separate();
        this.push_in();
        if (switchStatementNode.statements != null) {
            switchStatementNode.statements.evaluate(context, this);
        }
        this.pop_out();
        return null;
    }

    public Value evaluate(Context context, CaseLabelNode caseLabelNode) {
        this.indent();
        this.out.print("case");
        this.push_in();
        if (caseLabelNode.label != null) {
            caseLabelNode.label.evaluate(context, this);
        } else {
            this.out.print("default");
        }
        this.pop_out();
        return null;
    }

    public Value evaluate(Context context, DoStatementNode doStatementNode) {
        this.indent();
        this.out.print("do");
        this.push_in();
        if (doStatementNode.expr != null) {
            doStatementNode.expr.evaluate(context, this);
        }
        this.pop_out();
        this.separate();
        this.push_in();
        if (doStatementNode.statements != null) {
            doStatementNode.statements.evaluate(context, this);
        }
        this.pop_out();
        return null;
    }

    public Value evaluate(Context context, WhileStatementNode whileStatementNode) {
        this.indent();
        this.out.print("while");
        this.push_in();
        if (whileStatementNode.expr != null) {
            whileStatementNode.expr.evaluate(context, this);
        }
        this.pop_out();
        this.separate();
        this.push_in();
        if (whileStatementNode.statement != null) {
            whileStatementNode.statement.evaluate(context, this);
        }
        this.pop_out();
        return null;
    }

    public Value evaluate(Context context, ForStatementNode forStatementNode) {
        this.indent();
        this.out.print("for");
        this.push_in();
        if (forStatementNode.initialize != null) {
            forStatementNode.initialize.evaluate(context, this);
        }
        this.pop_out();
        this.separate();
        this.push_in();
        if (forStatementNode.test != null) {
            forStatementNode.test.evaluate(context, this);
        }
        this.pop_out();
        this.separate();
        this.push_in();
        if (forStatementNode.increment != null) {
            forStatementNode.increment.evaluate(context, this);
        }
        this.pop_out();
        this.separate();
        this.push_in();
        if (forStatementNode.statement != null) {
            forStatementNode.statement.evaluate(context, this);
        }
        this.pop_out();
        return null;
    }

    public Value evaluate(Context context, WithStatementNode withStatementNode) {
        this.indent();
        this.out.print("with");
        this.push_in();
        if (withStatementNode.expr != null) {
            withStatementNode.expr.evaluate(context, this);
        }
        this.pop_out();
        this.separate();
        this.push_in();
        if (withStatementNode.statement != null) {
            withStatementNode.statement.evaluate(context, this);
        }
        this.pop_out();
        return null;
    }

    public Value evaluate(Context context, ContinueStatementNode continueStatementNode) {
        this.indent();
        this.out.print("continue");
        this.push_in();
        if (continueStatementNode.id != null) {
            continueStatementNode.id.evaluate(context, this);
        }
        this.pop_out();
        return null;
    }

    public Value evaluate(Context context, BreakStatementNode breakStatementNode) {
        this.indent();
        this.out.print("break");
        this.push_in();
        if (breakStatementNode.id != null) {
            breakStatementNode.id.evaluate(context, this);
        }
        this.pop_out();
        return null;
    }

    public Value evaluate(Context context, ReturnStatementNode returnStatementNode) {
        this.indent();
        this.out.print("return");
        this.push_in();
        if (returnStatementNode.expr != null) {
            returnStatementNode.expr.evaluate(context, this);
        }
        this.pop_out();
        return null;
    }

    public Value evaluate(Context context, ThrowStatementNode throwStatementNode) {
        this.indent();
        this.out.print("throw");
        this.push_in();
        if (throwStatementNode.expr != null) {
            throwStatementNode.expr.evaluate(context, this);
        }
        this.pop_out();
        return null;
    }

    public Value evaluate(Context context, TryStatementNode tryStatementNode) {
        this.indent();
        this.out.print("try");
        this.push_in();
        if (tryStatementNode.tryblock != null) {
            tryStatementNode.tryblock.evaluate(context, this);
        }
        this.pop_out();
        this.separate();
        this.push_in();
        if (tryStatementNode.catchlist != null) {
            tryStatementNode.catchlist.evaluate(context, this);
        }
        this.pop_out();
        this.separate();
        this.push_in();
        if (tryStatementNode.finallyblock != null) {
            tryStatementNode.finallyblock.evaluate(context, this);
        }
        this.pop_out();
        return null;
    }

    public Value evaluate(Context context, CatchClauseNode catchClauseNode) {
        this.indent();
        this.out.print("catch");
        this.push_in();
        if (catchClauseNode.parameter != null) {
            catchClauseNode.parameter.evaluate(context, this);
        }
        this.pop_out();
        this.separate();
        this.push_in();
        if (catchClauseNode.statements != null) {
            catchClauseNode.statements.evaluate(context, this);
        }
        this.pop_out();
        return null;
    }

    public Value evaluate(Context context, FinallyClauseNode finallyClauseNode) {
        this.indent();
        this.out.print("finally");
        this.push_in();
        if (finallyClauseNode.statements != null) {
            finallyClauseNode.statements.evaluate(context, this);
        }
        this.pop_out();
        return null;
    }

    public Value evaluate(Context context, UseDirectiveNode useDirectiveNode) {
        this.indent();
        this.out.print("use");
        if (useDirectiveNode.expr != null) {
            useDirectiveNode.expr.evaluate(context, this);
        }
        return null;
    }

    public Value evaluate(Context context, IncludeDirectiveNode includeDirectiveNode) {
        this.indent();
        this.out.print("include");
        this.push_in();
        if (includeDirectiveNode.filespec != null) {
            includeDirectiveNode.filespec.evaluate(context, this);
        }
        this.separate();
        if (includeDirectiveNode.program != null) {
            // empty if block
        }
        this.pop_out();
        return null;
    }

    public Value evaluate(Context context, ImportDirectiveNode importDirectiveNode) {
        this.indent();
        this.out.print("import");
        this.push_in();
        if (importDirectiveNode.attrs != null) {
            importDirectiveNode.attrs.evaluate(context, this);
        }
        this.pop_out();
        this.separate();
        this.push_in();
        if (importDirectiveNode.name != null) {
            importDirectiveNode.name.evaluate(context, this);
        }
        this.pop_out();
        return null;
    }

    public Value evaluate(Context context, AttributeListNode attributeListNode) {
        this.indent();
        this.out.print("attributelist");
        this.push_in();
        Iterator iterator = attributeListNode.items.iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            node.evaluate(context, this);
            this.separate();
        }
        this.pop_out();
        return null;
    }

    public Value evaluate(Context context, VariableDefinitionNode variableDefinitionNode) {
        this.indent();
        if (variableDefinitionNode.kind == -64) {
            this.out.print("const");
        } else {
            this.out.print("var");
        }
        this.push_in();
        if (variableDefinitionNode.attrs != null) {
            variableDefinitionNode.attrs.evaluate(context, this);
        }
        this.pop_out();
        this.separate();
        this.push_in();
        if (variableDefinitionNode.list != null) {
            variableDefinitionNode.list.evaluate(context, this);
        }
        this.pop_out();
        return null;
    }

    public Value evaluate(Context context, VariableBindingNode variableBindingNode) {
        this.indent();
        this.out.print("variablebinding");
        this.push_in();
        if (variableBindingNode.variable != null) {
            variableBindingNode.variable.evaluate(context, this);
        }
        this.separate();
        if (variableBindingNode.initializer != null) {
            variableBindingNode.initializer.evaluate(context, this);
        }
        this.pop_out();
        return null;
    }

    public Value evaluate(Context context, UntypedVariableBindingNode untypedVariableBindingNode) {
        this.indent();
        this.out.print("untypedvariablebinding");
        this.push_in();
        if (untypedVariableBindingNode.identifier != null) {
            untypedVariableBindingNode.identifier.evaluate(context, this);
        }
        this.separate();
        if (untypedVariableBindingNode.initializer != null) {
            untypedVariableBindingNode.initializer.evaluate(context, this);
        }
        this.pop_out();
        return null;
    }

    public Value evaluate(Context context, TypedIdentifierNode typedIdentifierNode) {
        this.indent();
        this.out.print("typedidentifier");
        this.push_in();
        if (typedIdentifierNode.identifier != null) {
            typedIdentifierNode.identifier.evaluate(context, this);
        }
        this.separate();
        if (typedIdentifierNode.type != null) {
            typedIdentifierNode.type.evaluate(context, this);
        }
        this.pop_out();
        return null;
    }

    public Value evaluate(Context context, BinaryFunctionDefinitionNode binaryFunctionDefinitionNode) {
        return null;
    }

    public Value evaluate(Context context, FunctionDefinitionNode functionDefinitionNode) {
        this.indent();
        this.out.print("function");
        this.push_in();
        if (functionDefinitionNode.attrs != null) {
            functionDefinitionNode.attrs.evaluate(context, this);
        }
        this.separate();
        if (functionDefinitionNode.name != null) {
            functionDefinitionNode.name.evaluate(context, this);
        }
        this.separate();
        if (functionDefinitionNode.fexpr != null) {
            functionDefinitionNode.fexpr.evaluate(context, this);
        }
        this.pop_out();
        return null;
    }

    public Value evaluate(Context context, FunctionNameNode functionNameNode) {
        this.indent();
        this.out.print("functionname");
        this.out.print(functionNameNode.kind == -78 ? " get" : (functionNameNode.kind == -98 ? " set" : ""));
        this.push_in();
        if (functionNameNode.identifier != null) {
            functionNameNode.identifier.evaluate(context, this);
        }
        this.pop_out();
        return null;
    }

    public Value evaluate(Context context, FunctionSignatureNode functionSignatureNode) {
        this.indent();
        this.out.print(functionSignatureNode.inits != null ? "constructorsignature" : "functionsignature");
        this.push_in();
        if (functionSignatureNode.parameter != null) {
            functionSignatureNode.parameter.evaluate(context, this);
        }
        this.separate();
        if (functionSignatureNode.result != null) {
            functionSignatureNode.result.evaluate(context, this);
        }
        if (functionSignatureNode.inits != null) {
            functionSignatureNode.inits.evaluate(context, this);
        }
        this.pop_out();
        return null;
    }

    public Value evaluate(Context context, ParameterNode parameterNode) {
        this.indent();
        this.out.print("parameter");
        if (parameterNode.kind == -64) {
            this.out.print(" const");
        }
        this.push_in();
        if (parameterNode.identifier != null) {
            parameterNode.identifier.evaluate(context, this);
        }
        this.separate();
        if (parameterNode.init != null) {
            parameterNode.init.evaluate(context, this);
        }
        this.separate();
        if (parameterNode.type != null) {
            parameterNode.type.evaluate(context, this);
        }
        this.pop_out();
        return null;
    }

    public Value evaluate(Context context, RestExpressionNode restExpressionNode) {
        this.indent();
        this.out.print("restexpression");
        this.push_in();
        if (restExpressionNode.expr != null) {
            restExpressionNode.expr.evaluate(context, this);
        }
        this.pop_out();
        return null;
    }

    public Value evaluate(Context context, RestParameterNode restParameterNode) {
        this.indent();
        this.out.print("restparameter");
        this.push_in();
        if (restParameterNode.parameter != null) {
            restParameterNode.parameter.evaluate(context, this);
        }
        this.pop_out();
        return null;
    }

    public Value evaluate(Context context, ClassDefinitionNode classDefinitionNode) {
        this.indent();
        this.out.print("class");
        this.push_in();
        if (classDefinitionNode.attrs != null) {
            classDefinitionNode.attrs.evaluate(context, this);
        }
        this.separate();
        if (classDefinitionNode.name != null) {
            classDefinitionNode.name.evaluate(context, this);
        }
        this.separate();
        if (classDefinitionNode.baseclass != null) {
            classDefinitionNode.baseclass.evaluate(context, this);
        }
        this.separate();
        if (classDefinitionNode.interfaces != null) {
            classDefinitionNode.interfaces.evaluate(context, this);
        }
        this.separate();
        if (classDefinitionNode.statements != null) {
            classDefinitionNode.statements.evaluate(context, this);
        }
        this.pop_out();
        return null;
    }

    public Value evaluate(Context context, InterfaceDefinitionNode interfaceDefinitionNode) {
        this.indent();
        this.out.print("interface");
        this.push_in();
        if (interfaceDefinitionNode.attrs != null) {
            interfaceDefinitionNode.attrs.evaluate(context, this);
        }
        this.separate();
        if (interfaceDefinitionNode.name != null) {
            interfaceDefinitionNode.name.evaluate(context, this);
        }
        this.separate();
        if (interfaceDefinitionNode.interfaces != null) {
            interfaceDefinitionNode.interfaces.evaluate(context, this);
        }
        this.separate();
        if (interfaceDefinitionNode.statements != null) {
            interfaceDefinitionNode.statements.evaluate(context, this);
        }
        this.pop_out();
        return null;
    }

    public Value evaluate(Context context, ClassNameNode classNameNode) {
        this.indent();
        this.out.print("classname");
        this.push_in();
        if (classNameNode.pkgname != null) {
            classNameNode.pkgname.evaluate(context, this);
        }
        this.pop_out();
        this.separate();
        this.push_in();
        if (classNameNode.ident != null) {
            classNameNode.ident.evaluate(context, this);
        }
        this.pop_out();
        return null;
    }

    public Value evaluate(Context context, InheritanceNode inheritanceNode) {
        if (inheritanceNode.baseclass != null) {
            this.indent();
            this.out.print("extends");
            this.push_in();
            inheritanceNode.baseclass.evaluate(context, this);
            this.pop_out();
        }
        this.separate();
        if (inheritanceNode.interfaces != null) {
            this.indent();
            this.out.print("implements");
            this.push_in();
            inheritanceNode.interfaces.evaluate(context, this);
            this.pop_out();
        }
        return null;
    }

    public Value evaluate(Context context, NamespaceDefinitionNode namespaceDefinitionNode) {
        this.indent();
        this.out.print("namespace");
        this.push_in();
        if (namespaceDefinitionNode.attrs != null) {
            namespaceDefinitionNode.attrs.evaluate(context, this);
        }
        this.pop_out();
        this.separate();
        this.push_in();
        if (namespaceDefinitionNode.name != null) {
            namespaceDefinitionNode.name.evaluate(context, this);
        }
        this.pop_out();
        this.separate();
        this.push_in();
        if (namespaceDefinitionNode.value != null) {
            namespaceDefinitionNode.value.evaluate(context, this);
        }
        this.pop_out();
        return null;
    }

    public Value evaluate(Context context, ConfigNamespaceDefinitionNode configNamespaceDefinitionNode) {
        this.indent();
        this.out.print("config namespace");
        this.push_in();
        if (configNamespaceDefinitionNode.attrs != null) {
            configNamespaceDefinitionNode.attrs.evaluate(context, this);
        }
        this.pop_out();
        this.separate();
        this.push_in();
        if (configNamespaceDefinitionNode.name != null) {
            configNamespaceDefinitionNode.name.evaluate(context, this);
        }
        this.pop_out();
        this.separate();
        this.push_in();
        if (configNamespaceDefinitionNode.value != null) {
            configNamespaceDefinitionNode.value.evaluate(context, this);
        }
        this.pop_out();
        return null;
    }

    public Value evaluate(Context context, PackageDefinitionNode packageDefinitionNode) {
        this.indent();
        this.out.print("package");
        this.push_in();
        if (packageDefinitionNode.name != null) {
            packageDefinitionNode.name.evaluate(context, this);
        }
        this.pop_out();
        return null;
    }

    public Value evaluate(Context context, PackageIdentifiersNode packageIdentifiersNode) {
        this.indent();
        this.out.print("packageidentifiers");
        this.push_in();
        Iterator iterator = packageIdentifiersNode.list.iterator();
        while (iterator.hasNext()) {
            IdentifierNode identifierNode = (IdentifierNode)iterator.next();
            identifierNode.evaluate(context, this);
            this.separate();
        }
        this.pop_out();
        return null;
    }

    public Value evaluate(Context context, PackageNameNode packageNameNode) {
        this.indent();
        this.out.print("packagename");
        this.push_in();
        if (packageNameNode.id != null) {
            packageNameNode.id.evaluate(context, this);
        }
        this.pop_out();
        return null;
    }

    public Value evaluate(Context context, ProgramNode programNode) {
        this.indent();
        this.out.print("program");
        this.push_in();
        if (programNode.statements != null) {
            programNode.statements.evaluate(context, this);
        }
        this.pop_out();
        this.out.println();
        return null;
    }

    public Value evaluate(Context context, ErrorNode errorNode) {
        this.indent();
        this.out.print("error");
        this.out.print(errorNode.errorCode);
        return null;
    }

    public Value evaluate(Context context, ToObjectNode toObjectNode) {
        this.indent();
        this.out.print("toobject");
        this.push_in();
        if (toObjectNode.expr != null) {
            toObjectNode.expr.evaluate(context, this);
        }
        this.pop_out();
        this.out.println();
        return null;
    }

    public Value evaluate(Context context, LoadRegisterNode loadRegisterNode) {
        this.indent();
        this.out.print("loadregister");
        this.push_in();
        if (loadRegisterNode.reg != null) {
            loadRegisterNode.reg.evaluate(context, this);
        }
        this.pop_out();
        return null;
    }

    public Value evaluate(Context context, StoreRegisterNode storeRegisterNode) {
        this.indent();
        this.out.print("storeregister");
        this.push_in();
        if (storeRegisterNode.reg != null) {
            storeRegisterNode.reg.evaluate(context, this);
        }
        this.pop_out();
        this.push_in();
        if (storeRegisterNode.expr != null) {
            storeRegisterNode.expr.evaluate(context, this);
        }
        this.pop_out();
        this.out.println();
        return null;
    }

    public Value evaluate(Context context, RegisterNode registerNode) {
        this.indent();
        this.out.print("register");
        this.push_in();
        this.out.print(registerNode.index);
        return null;
    }

    public Value evaluate(Context context, HasNextNode hasNextNode) {
        this.indent();
        this.out.print("hasNext");
        this.push_in();
        if (hasNextNode.objectRegister != null) {
            hasNextNode.objectRegister.evaluate(context, this);
        }
        this.pop_out();
        this.push_in();
        if (hasNextNode.indexRegister != null) {
            hasNextNode.indexRegister.evaluate(context, this);
        }
        this.pop_out();
        this.out.println();
        return null;
    }

    public Value evaluate(Context context, BoxNode boxNode) {
        this.indent();
        this.out.print("box");
        this.out.print(boxNode.actual);
        this.push_in();
        if (boxNode.expr != null) {
            boxNode.expr.evaluate(context, this);
        }
        this.pop_out();
        return null;
    }

    public Value evaluate(Context context, CoerceNode coerceNode) {
        this.indent();
        this.out.print("coerce");
        this.push_in();
        if (coerceNode.expr != null) {
            coerceNode.expr.evaluate(context, this);
        }
        this.pop_out();
        return null;
    }

    public Value evaluate(Context context, PragmaNode pragmaNode) {
        this.indent();
        this.out.print("pragma");
        this.push_in();
        if (pragmaNode.list != null) {
            pragmaNode.list.evaluate(context, this);
        }
        this.pop_out();
        return null;
    }

    public Value evaluate(Context context, PragmaExpressionNode pragmaExpressionNode) {
        this.indent();
        this.out.print("pragmaitem");
        this.push_in();
        if (pragmaExpressionNode.identifier != null) {
            pragmaExpressionNode.identifier.evaluate(context, this);
        }
        this.pop_out();
        return null;
    }

    public Value evaluate(Context context, ParameterListNode parameterListNode) {
        this.indent();
        this.out.print("parameterlist");
        this.push_in();
        int n = parameterListNode.items.size();
        for (int i = 0; i < n; ++i) {
            ParameterNode parameterNode = (ParameterNode)parameterListNode.items.get(i);
            if (parameterNode != null) {
                parameterNode.evaluate(context, this);
            }
            if (i >= n - 1) continue;
            this.separate();
        }
        this.pop_out();
        return null;
    }

    public Value evaluate(Context context, MetaDataNode metaDataNode) {
        int n;
        if (metaDataNode.data != null) {
            MetaDataEvaluator metaDataEvaluator = new MetaDataEvaluator();
            metaDataEvaluator.evaluate(context, metaDataNode);
        }
        this.indent();
        this.out.print("metadata:");
        this.out.print(metaDataNode.id != null ? metaDataNode.id : "");
        this.out.print(" ");
        int n2 = n = metaDataNode.values == null ? 0 : metaDataNode.values.length;
        for (int i = 0; i < n; ++i) {
            Value value;
            Value value2 = metaDataNode.values[i];
            if (value2 instanceof MetaDataEvaluator.KeyValuePair) {
                value = (MetaDataEvaluator.KeyValuePair)value2;
                this.out.print("[" + value.key + "," + value.obj + "]");
            }
            if (!(value2 instanceof MetaDataEvaluator.KeylessValue)) continue;
            value = (MetaDataEvaluator.KeylessValue)value2;
            this.out.print("[" + ((MetaDataEvaluator.KeylessValue)value).obj + "]");
        }
        return null;
    }

    public Value evaluate(Context context, DefaultXMLNamespaceNode defaultXMLNamespaceNode) {
        this.indent();
        this.out.print("dxns");
        this.push_in();
        if (defaultXMLNamespaceNode.expr != null) {
            defaultXMLNamespaceNode.expr.evaluate(context, this);
        }
        this.pop_out();
        return null;
    }

    public Value evaluate(Context context, DocCommentNode docCommentNode) {
        this.evaluate(context, (MetaDataNode)docCommentNode);
        return null;
    }

    public Value evaluate(Context context, ImportNode importNode) {
        return null;
    }

    public Value evaluate(Context context, BinaryProgramNode binaryProgramNode) {
        return null;
    }

    public Value evaluate(Context context, BinaryClassDefNode binaryClassDefNode) {
        return null;
    }

    public Value evaluate(Context context, BinaryInterfaceDefinitionNode binaryInterfaceDefinitionNode) {
        return null;
    }

    public Value evaluate(Context context, TypeExpressionNode typeExpressionNode) {
        this.indent();
        this.out.print("typeexpr");
        this.push_in();
        if (typeExpressionNode.expr != null) {
            typeExpressionNode.expr.evaluate(context, this);
        }
        this.pop_out();
        return null;
    }
}

