/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.semantics;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import macromedia.asc.parser.MetaDataNode;
import macromedia.asc.parser.Node;
import macromedia.asc.semantics.ObjectValue;
import macromedia.asc.semantics.ReferenceValue;
import macromedia.asc.semantics.TypeInfo;
import macromedia.asc.semantics.TypeValue;
import macromedia.asc.semantics.Value;
import macromedia.asc.util.BitSet;
import macromedia.asc.util.Boxing;
import macromedia.asc.util.ByteList;
import macromedia.asc.util.Context;
import macromedia.asc.util.IntegerPool;
import macromedia.asc.util.ObjectList;

/*
 * This class specifies class file version 47.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Slot {
    public static final int PUSH_none = 0;
    public static final int PUSH_env = 1;
    public static final int PUSH_this = 2;
    public static final int PUSH_opd1 = 4;
    public static final int PUSH_opd2 = 8;
    public static final int PUSH_args = 16;
    public static final int PUSH_size = 32;
    public static final int CALL_Empty = 0;
    public static final int CALL_Unary = 20;
    public static final int CALL_ThisUnary = 22;
    public static final int CALL_Binary = 12;
    public static final int CALL_Method = 16;
    public static final int CALL_ThisMethod = 18;
    public static final int CALL_Closure = 51;
    public static final int CALL_Args = 16;
    public static final int CALL_ThisArgs = 18;
    public static final int CALL_EnvThisArgs = 51;
    public static final int DISPATCH_final = 0;
    public static final int DISPATCH_virtual = 1;
    public static final int DISP_undefined = 1;
    public static final int DISP_CallProperty = 2;
    public static final int DISP_ConstructProperty = 3;
    public static final int DISP_CallClosure = 4;
    public static final int DISP_ConstructClosure = 5;
    public static final int DISP_CallPropLex = 6;
    public static final int DISP_CallFinal = 0;
    public static final int THIS_undefined = 0;
    public static final int THIS_Global = 1;
    public static final int THIS_Scope = 2;
    public static final int THIS_Base = 3;
    public static final int THIS_Temp = 4;
    public static final int THIS_None = 5;
    public static final int PARAM_Required = 0;
    public static final int PARAM_Optional = 1;
    public static final int PARAM_Rest = 2;
    public static final int PARAM_Void = 3;
    private static final int FINAL_Flag = 1;
    private static final int OVERRIDE_Flag = 2;
    private static final int CONST_Flag = 4;
    private static final int IMPORTED_Flag = 8;
    private static final int INTRINSIC_Flag = 16;
    private static final int NEEDS_INIT_Flag = 32;
    private static final int METHOD_Flag = 64;
    private static final int CALL_SEQUENCE_Mask = 65280;
    private static final int DISPATCH_KIND_Mask = 0xFF0000;
    private static final int CALL_SEQUENCE_Shift = 8;
    private static final int DISPATCH_KIND_Shift = 16;
    private int flags = 2;
    protected static final int AUX_OverriddenSlot = 0;
    protected static final int AUX_EmbeddedData = 1;
    protected static final int AUX_MetaData = 2;
    protected static final int AUX_BaseNode = 3;
    protected static final int AUX_ImplNode = 4;
    protected static final int AUX_UnaryOverloads = 5;
    protected static final int AUX_BinaryOverloads = 6;
    protected static final int AUX_DebugName = 7;
    protected static final int AUX_ImplicitCall = 8;
    protected static final int AUX_ImplicitConstruct = 9;
    protected static final int AUX_MethodName = 10;
    private Object[] auxDataItems = null;
    public int id;
    public ObjectValue declaredBy;
    private BitSet def_bits;
    private Value value;
    private TypeInfo type;
    private ObjectList<TypeInfo> types;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected final void setAuxData(int n, Object object) {
        Object[] objectArray;
        if (this.auxDataItems != null) {
            for (int i = 0; i < this.auxDataItems.length; i += 2) {
                if ((Integer)this.auxDataItems[i] != n) continue;
                this.auxDataItems[i + 1] = object;
                return;
            }
        }
        if (this.auxDataItems != null) {
            objectArray = new Object[this.auxDataItems.length + 2];
            System.arraycopy(this.auxDataItems, 0, objectArray, 0, this.auxDataItems.length);
        } else {
            objectArray = new Object[2];
        }
        objectArray[objectArray.length - 2] = IntegerPool.getNumber(n);
        objectArray[objectArray.length - 1] = object;
        this.auxDataItems = objectArray;
    }

    protected final Object getAuxData(int n) {
        if (this.auxDataItems != null) {
            for (int i = 0; i < this.auxDataItems.length; i += 2) {
                if ((Integer)this.auxDataItems[i] != n) continue;
                return this.auxDataItems[i + 1];
            }
        }
        return null;
    }

    public Slot(TypeValue typeValue, int n) {
        this(typeValue != null ? typeValue.getDefaultTypeInfo() : null, n);
    }

    public Slot(TypeInfo typeInfo, int n) {
        this.type = typeInfo;
        this.id = n;
        this.setCallSequence(22);
        this.setDispatchKind(0);
    }

    public final boolean isCompatible(TypeValue typeValue, TypeValue typeValue2) {
        return typeValue != null && typeValue2 != null && (typeValue.getTypeId() & typeValue2.getTypeId()) != 0;
    }

    public final void addDefBits(BitSet bitSet) {
        this.setDefBits(BitSet.set(this.getDefBits(), bitSet));
    }

    public final void implicit(int n, int n2) {
        switch (n) {
            case -132: {
                this.setAuxData(8, IntegerPool.getNumber(n2));
                break;
            }
            case -91: {
                this.setAuxData(9, IntegerPool.getNumber(n2));
                break;
            }
            default: {
                if ($assertionsDisabled) break;
                throw new Error();
            }
        }
    }

    public final int implies(Context context, int n) {
        Integer n2 = null;
        switch (n) {
            case -132: {
                n2 = (Integer)this.getAuxData(8);
                break;
            }
            case -91: {
                n2 = (Integer)this.getAuxData(9);
                break;
            }
            default: {
                if ($assertionsDisabled) break;
                throw new Error();
            }
        }
        return n2 != null ? n2 : 0;
    }

    public final void overload(TypeValue typeValue, int n) {
        Overload overload = this.getUnaryOverloads();
        if (overload == null) {
            overload = new Overload(this);
            this.setUnaryOverloads(overload);
        }
        overload.put(typeValue, Boxing.valueOf(n));
    }

    public final void overload(TypeValue typeValue, TypeValue typeValue2, int n) {
        Overload overload = new Overload(this);
        overload.put(typeValue2, Boxing.valueOf(n));
        Map<TypeValue, Overload> map = this.getBinaryOverloads();
        if (map == null) {
            map = new HashMap<TypeValue, Overload>();
            this.setBinaryOverloads(map);
        }
        map.put(typeValue, overload);
    }

    public final int dispatch(Context context, TypeValue typeValue) {
        boolean bl = false;
        int n = 0;
        Overload overload = this.getUnaryOverloads();
        if (overload != null) {
            for (TypeValue typeValue2 : overload.keySet()) {
                if (typeValue2.equals(typeValue)) {
                    return (Integer)overload.get(typeValue2);
                }
                if (!this.isCompatible(typeValue2, typeValue)) continue;
                if (!bl) {
                    bl = true;
                    n = (Integer)overload.get(typeValue2);
                    continue;
                }
                return 0;
            }
        }
        return n;
    }

    public final int dispatch(Context context, TypeValue typeValue, TypeValue typeValue2) {
        Object object;
        Map<TypeValue, Overload> map = this.getBinaryOverloads();
        if (map != null) {
            object = map.keySet().iterator();
            while (object.hasNext()) {
                TypeValue typeValue3 = object.next();
                if (typeValue3 == null || typeValue == null) {
                    context.internalError("internal type error");
                }
                if (!this.isCompatible(typeValue3, typeValue)) continue;
                Overload overload = map.get(typeValue3);
                for (TypeValue typeValue4 : overload.keySet()) {
                    if (!this.isCompatible(typeValue4, typeValue2)) continue;
                    return (Integer)overload.get(typeValue4);
                }
            }
        }
        Object object2 = object = map == null ? null : map.get(typeValue);
        if (object == null) {
            object = new Overload(this);
            ((HashMap)object).put(typeValue2, Boxing.valueOf(0));
            if (map == null) {
                map = new HashMap<TypeValue, Overload>();
                this.setBinaryOverloads(map);
            }
            map.put(typeValue, (Overload)object);
        } else if (((HashMap)object).get(typeValue2) == null) {
            ((HashMap)object).put(typeValue2, Boxing.valueOf(0));
        }
        return (Integer)map.get(typeValue).get(typeValue2);
    }

    public final void attrs(int n, int n2) {
        this.setCallSequence((byte)n);
        this.setMethodID(n2);
    }

    public final void addMetadata(MetaDataNode metaDataNode) {
        if (this.getMetadata() == null) {
            this.setMetadata(new ArrayList<MetaDataNode>());
        }
        this.getMetadata().add(metaDataNode);
    }

    public final boolean isFinal() {
        return (this.flags & 1) != 0;
    }

    public final void setFinal(boolean bl) {
        this.flags = bl ? this.flags | 1 : this.flags & 0xFFFFFFFE;
    }

    public final boolean isOverride() {
        return (this.flags & 2) != 0;
    }

    public final void setOverride(boolean bl) {
        this.flags = bl ? this.flags | 2 : this.flags & 0xFFFFFFFD;
    }

    public final boolean isConst() {
        return (this.flags & 4) != 0;
    }

    public final void setConst(boolean bl) {
        this.flags = bl ? this.flags | 4 : this.flags & 0xFFFFFFFB;
    }

    public final boolean isImported() {
        return (this.flags & 8) != 0;
    }

    public final void setImported(boolean bl) {
        this.flags = bl ? this.flags | 8 : this.flags & 0xFFFFFFF7;
    }

    public final boolean isIntrinsic() {
        return (this.flags & 0x10) != 0;
    }

    public final boolean needsInit() {
        return (this.flags & 0x20) != 0;
    }

    public final void setNeedsInit(boolean bl) {
        this.flags = bl ? this.flags | 0x20 : this.flags & 0xFFFFFFDF;
    }

    public final void setIntrinsic(boolean bl) {
        this.flags = bl ? this.flags | 0x10 : this.flags & 0xFFFFFFEF;
    }

    public final int getCallSequence() {
        return (this.flags & 0xFF00) >> 8;
    }

    public final void setCallSequence(int n) {
        this.flags &= 0xFFFF00FF;
        this.flags |= n << 8;
    }

    public final int getDispatchKind() {
        return (this.flags & 0xFF0000) >> 16;
    }

    public final void setDispatchKind(int n) {
        this.flags &= 0xFF00FFFF;
        this.flags |= n << 16;
    }

    public final void setBaseNode(Node node) {
        this.setAuxData(3, node);
    }

    public final Node getBaseNode() {
        return (Node)this.getAuxData(3);
    }

    public final void setImplNode(Node node) {
        this.setAuxData(4, node);
    }

    public final Node getImplNode() {
        return (Node)this.getAuxData(4);
    }

    public final void setMetadata(ArrayList<MetaDataNode> arrayList) {
        this.setAuxData(2, arrayList);
    }

    public final ArrayList<MetaDataNode> getMetadata() {
        return (ArrayList)this.getAuxData(2);
    }

    public final void setEmbeddedData(Object object) {
        this.setAuxData(1, object);
    }

    public final Object getEmbeddedData() {
        return this.getAuxData(1);
    }

    public final void setOverriddenSlot(Slot slot) {
        this.setAuxData(0, slot);
    }

    public final Slot getOverriddenSlot() {
        return (Slot)this.getAuxData(0);
    }

    private final void setUnaryOverloads(Overload overload) {
        this.setAuxData(5, overload);
    }

    private final Overload getUnaryOverloads() {
        return (Overload)this.getAuxData(5);
    }

    private final void setBinaryOverloads(Map<TypeValue, Overload> map) {
        this.setAuxData(6, map);
    }

    private final Map<TypeValue, Overload> getBinaryOverloads() {
        return (Map)this.getAuxData(6);
    }

    public final void setObjectValue(ObjectValue objectValue) {
        this.setValue(objectValue);
    }

    public final ObjectValue getObjectValue() {
        return (ObjectValue)this.getValue();
    }

    public ObjectValue getInitializerValue() {
        return (ObjectValue)this.getValue();
    }

    public void setDebugName(String string) {
        this.setAuxData(7, string);
    }

    public String getDebugName() {
        String string = (String)this.getAuxData(7);
        return string != null ? string : "";
    }

    public boolean isGetter() {
        return (this.flags & 0x40) == 0;
    }

    public void setGetter(boolean bl) {
        this.flags = !bl ? this.flags | 0x40 : this.flags & 0xFFFFFFBF;
    }

    public abstract void setVarIndex(int var1);

    public abstract int getVarIndex();

    public abstract void setMethodID(int var1);

    public abstract int getMethodID();

    public abstract void setMethodName(String var1);

    public abstract String getMethodName();

    public abstract void setTypeRef(ReferenceValue var1);

    public abstract ReferenceValue getTypeRef();

    public abstract void setDeclStyles(ByteList var1);

    public abstract ByteList getDeclStyles();

    public abstract void addDeclStyle(int var1);

    public void setType(TypeInfo typeInfo) {
        this.type = typeInfo;
    }

    public TypeInfo getType() {
        return this.type;
    }

    public void setTypes(ObjectList<TypeInfo> objectList) {
        this.types = objectList;
    }

    public ObjectList<TypeInfo> getTypes() {
        return this.types;
    }

    public void addType(TypeInfo typeInfo) {
        if (this.types == null) {
            this.types = new ObjectList(2);
        }
        this.types.push_back(typeInfo);
    }

    public void setValue(Value value) {
        this.value = value;
    }

    public Value getValue() {
        return this.value;
    }

    public void setDefBits(BitSet bitSet) {
        this.def_bits = bitSet;
    }

    public BitSet getDefBits() {
        return this.def_bits;
    }

    static {
        $assertionsDisabled = true;
    }

    /*
     * This class specifies class file version 47.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class Overload
    extends HashMap<TypeValue, Integer> {
        final /* synthetic */ Slot this$0;

        /*
         * WARNING - void declaration
         */
        Overload(Slot slot) {
            void arg0;
            this.this$0 = arg0;
        }
    }
}

