/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.services.http;

public class ExternalProxySettings {
    public static final int DEFAULT_PROXY_PORT = 80;
    public static final String PORT = "port";
    public static final String EXTERNAL_PROXY = "external-proxy";
    public static final String SERVER = "server";
    public static final String NT_DOMAIN = "nt-domain";
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    private static final String HTTP = "http://";
    private String proxyServer;
    private int proxyPort = 80;
    private String username;
    private String password;
    private String ntDomain;

    public String getProxyServer() {
        return this.proxyServer;
    }

    public void setProxyServer(String s) {
        if (s != null) {
            boolean hasProtocol;
            if (s.endsWith("/")) {
                s = s.substring(0, s.length() - 1);
            }
            boolean bl = hasProtocol = s.indexOf("://") != -1;
            if (!hasProtocol && ExternalProxySettings.isDotNet()) {
                s = HTTP + s;
            }
            if (!ExternalProxySettings.isDotNet() && hasProtocol && !ExternalProxySettings.isDotNet()) {
                if (s.startsWith(HTTP)) {
                    s = s.substring(HTTP.length());
                } else {
                    throw new IllegalArgumentException("A protocol cannot be specified for the proxy element: " + s);
                }
            }
        }
        this.proxyServer = s;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int p) {
        if (p > 0) {
            this.proxyPort = p;
        }
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getNTDomain() {
        return this.ntDomain;
    }

    public void setNTDomain(String ntDomain) {
        this.ntDomain = ntDomain;
    }

    public static boolean isDotNet() {
        return System.getProperty("flex.platform.CLR") != null;
    }
}

