/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.io;

import com.adobe.internal.io.ByteArrayByteWriter;
import com.adobe.internal.io.ByteWriter;
import com.adobe.internal.io.RandomAccessFileByteWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public final class InputStreamByteWriter
implements ByteWriter {
    private ByteWriter byteWriter;

    public InputStreamByteWriter(InputStream inputStream) throws IOException {
        int bytesRead;
        ByteArrayByteWriter writer = new ByteArrayByteWriter();
        byte[] buffer = new byte[4096];
        long position = 0L;
        while ((bytesRead = inputStream.read(buffer)) != -1) {
            writer.write(position, buffer, 0, bytesRead);
            position += (long)bytesRead;
        }
        this.byteWriter = writer;
        inputStream.close();
    }

    public InputStreamByteWriter(InputStream inputStream, RandomAccessFile raf) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[4096];
        while ((bytesRead = inputStream.read(buffer)) != -1) {
            raf.write(buffer, 0, bytesRead);
        }
        this.byteWriter = new RandomAccessFileByteWriter(raf);
        inputStream.close();
    }

    public int read(long position) throws IOException {
        return this.byteWriter.read(position);
    }

    public int read(long position, byte[] b, int offset, int length) throws IOException {
        return this.byteWriter.read(position, b, offset, length);
    }

    public long length() throws IOException {
        return this.byteWriter.length();
    }

    public void close() throws IOException {
        this.byteWriter.close();
    }

    public String toString() {
        return this.byteWriter.toString();
    }

    public void write(long position, int b) throws IOException {
        this.byteWriter.write(position, b);
    }

    public void write(long position, byte[] b, int offset, int length) throws IOException {
        this.byteWriter.write(position, b, offset, length);
    }

    public void flush() throws IOException {
        this.byteWriter.flush();
    }
}

