/*
 * Decompiled with CFR 0.152.
 */
package flex.webtier.server.j2ee;

import flex.webtier.server.j2ee.HttpCache;
import flex.webtier.server.j2ee.MxmlContext;
import flex.webtier.server.j2ee.MxmlFilter;
import flex.webtier.server.j2ee.events.LogOutputHandler;
import flex.webtier.server.j2ee.html.ErrorRenderer;
import flex.webtier.services.ServiceFactory;
import flex.webtier.util.J2EEUtil;
import java.io.File;
import java.io.IOException;
import java.net.SocketException;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

public class SwfRenderFilter
extends MxmlFilter {
    private String swfExt;
    private String swdExt;
    private long maxage;

    public SwfRenderFilter(String swfExt, String swdExt) {
        this.swfExt = swfExt;
        this.swdExt = swdExt;
        this.maxage = ServiceFactory.getConfigurator().getServerConfiguration().getCacheConfiguration().getHttpMaximumAge();
    }

    public void invoke(MxmlContext context) throws Throwable {
        if (context.hasErrors()) {
            context.getResponse().setStatus(500);
            ErrorRenderer errorRenderer = new ErrorRenderer();
            errorRenderer.render(context);
            HttpCache.setCacheHeaders(false, 0L, -1L, context.getResponse());
        } else {
            String path = context.getRequest().getServletPath();
            if (context.hasWarnings() && context.logSwfEvents()) {
                ServletContext servletContext = context.getServletContext();
                String appRoot = new File(J2EEUtil.getRealPath((String)context.getRequest().getServletPath(), (ServletContext)servletContext)).getParent();
                LogOutputHandler logOutputHandler = new LogOutputHandler(path, appRoot, context.getEvents(), context.getSourceCodeLoader());
                logOutputHandler.output();
            }
            if (path.endsWith(this.swfExt)) {
                this.sendResponse(context, context.getResponse(), context.getSwfBuffer());
            } else if (path.endsWith(this.swdExt)) {
                this.sendResponse(context, context.getResponse(), context.getSwdBuffer());
            }
        }
    }

    private void sendResponse(MxmlContext context, HttpServletResponse response, byte[] data) {
        try {
            response.setContentType("application/x-shockwave-flash");
            response.setContentLength(data.length);
            HttpCache.setCacheHeaders(true, this.maxage, context.getLastModifiedTime(), context.getResponse());
            ServletOutputStream out = response.getOutputStream();
            out.write(data);
        }
        catch (SocketException se) {
        }
        catch (IOException ioe) {
            // empty catch block
        }
    }
}

