/*
 * Decompiled with CFR 0.152.
 */
package flex.webtier.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Vector;

public class StringUtils {
    public static String quoteIfNotNull(String str) {
        str = str != null ? (str = "'" + StringUtils.escapeApostrophe(str) + "'") : null;
        return str;
    }

    public static String doubleQuoteIfNotNull(String str) {
        str = str != null ? (str = "\"" + str + "\"") : null;
        return str;
    }

    public static String escapeApostrophe(String str) {
        if (str.indexOf("'") > -1) {
            return StringUtils.substitute(str, "'", "''");
        }
        return str;
    }

    public static String appendToQuotedString(String str1, String str2) throws Exception {
        StringBuffer sb = new StringBuffer();
        if (str1.startsWith("\"") && str1.endsWith("\"")) {
            sb.append(str1);
            sb.insert(sb.length() - 1, str2);
        } else {
            sb.append("\"");
            sb.append(str1);
            sb.append(str2);
            sb.append("\"");
        }
        return sb.toString();
    }

    public static String removeDoubleChar(String str, char c) {
        return StringUtils.removeDuplicates(str, c);
    }

    public static String removeDuplicates(String str, char c) {
        if (str == null) {
            return str;
        }
        int newCharPos = str.indexOf(c);
        if (newCharPos < 0 || newCharPos + 1 == str.length()) {
            return str;
        }
        if (str == null || str.length() < 2) {
            return str;
        }
        char[] chars = str.toCharArray();
        char[] newChars = new char[chars.length];
        newCharPos = 0;
        boolean lastWasChar = false;
        for (int i = 0; i < chars.length; ++i) {
            char thisChar = chars[i];
            if (thisChar == c) {
                if (lastWasChar) continue;
                lastWasChar = true;
            } else {
                lastWasChar = false;
            }
            newChars[newCharPos++] = thisChar;
        }
        return new String(newChars, 0, newCharPos);
    }

    public static int findSingleChar(String str, int currentIndex, int endIndex, char c) {
        if (str == null) {
            return endIndex;
        }
        boolean foundChar = false;
        int strIndex = endIndex;
        while (!foundChar) {
            strIndex = str.indexOf(c, currentIndex);
            if (strIndex == -1) {
                return endIndex;
            }
            if (str.charAt(strIndex + 1) == c) {
                currentIndex = strIndex + 2;
                continue;
            }
            foundChar = true;
        }
        return strIndex;
    }

    public static String loadFileToString(String filename) throws IOException {
        if (filename == null) {
            return null;
        }
        File f = new File(filename);
        int size = (int)f.length();
        FileInputStream in = new FileInputStream(f);
        byte[] data = new byte[size];
        for (int bytes_read = 0; bytes_read < size; bytes_read += in.read(data, bytes_read, size - bytes_read)) {
        }
        in.close();
        return new String(data);
    }

    public static String[] parseArguments(String str, Character trimChar) {
        if (str == null) {
            return null;
        }
        int quote = 0;
        int paren = 0;
        boolean done = false;
        Vector<String> args = new Vector<String>();
        char[] chars = str.toCharArray();
        int endIndex = str.length() - 1;
        int index = 0;
        while (!done) {
            StringBuffer param = new StringBuffer(255);
            int lastIndex = index;
            while (index < endIndex && (quote > 0 || paren > 0 || chars[index] != ')' && (index == 0 || chars[index] != ',' && chars[index - 1] != '\\'))) {
                if (chars[index] != '\\') {
                    if (chars[index] == '\"') {
                        quote = 1 - quote;
                    } else if (chars[index] == '(') {
                        ++paren;
                    } else if (chars[index] == ')') {
                        --paren;
                    }
                }
                int n = ++index;
                ++index;
                param.append(chars[n]);
            }
            if (index > lastIndex) {
                String s = param.toString().trim();
                if (!s.equals("") && s.charAt(0) == '\"' && s.charAt(s.length() - 1) == '\"') {
                    s = s.substring(1, s.length() - 1);
                }
                args.addElement(s);
            }
            if (++index < endIndex) continue;
            done = true;
        }
        String[] strArgs = new String[args.size()];
        for (int i = 0; i < args.size(); ++i) {
            String arg = (String)args.elementAt(i);
            if (trimChar != null && arg != null && arg.length() > 1 && arg.charAt(0) == trimChar.charValue()) {
                arg = arg.substring(1);
            }
            strArgs[i] = arg;
        }
        return strArgs;
    }

    public static String databaseQuote(String value, boolean wrapQuotes) {
        if (value == null) {
            return value;
        }
        String result = "";
        if (wrapQuotes) {
            result = "'";
        }
        for (int i = 0; i < value.length(); ++i) {
            String s = value.substring(i, i + 1);
            result = s.equals("'") ? result + "''" : result + s;
        }
        if (wrapQuotes) {
            result = result + "'";
        }
        return result;
    }

    public static String databaseQuote(String value) {
        return StringUtils.databaseQuote(value, true);
    }

    public static String surroundWithQuotes(String name) {
        return "\"" + name + "\"";
    }

    public static String surroundWithSingleQuotes(String name) {
        return "'" + name + "'";
    }

    public static String escapeQuotes(String s) {
        if (s == null) {
            return s;
        }
        StringBuffer sb = new StringBuffer();
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c == '\"') {
                sb.append("\\\"");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static boolean matchString(String pattern, String string, char sep) {
        if (pattern == null || string == null) {
            return false;
        }
        int p = 0;
        while (true) {
            int s = 0;
            while (true) {
                boolean pEnd;
                boolean sEnd = s >= string.length();
                boolean bl = pEnd = p >= pattern.length() || pattern.charAt(p) == sep;
                if (sEnd && pEnd) {
                    return true;
                }
                if (sEnd || pEnd) break;
                if (pattern.charAt(p) != '?') {
                    if (pattern.charAt(p) == '*') {
                        ++p;
                        for (int i = string.length(); i >= s; --i) {
                            if (!StringUtils.matchString(pattern.substring(p), string.substring(i))) continue;
                            return true;
                        }
                        break;
                    }
                    if (pattern.charAt(p) != string.charAt(s)) break;
                }
                ++p;
                ++s;
            }
            if ((p = pattern.indexOf(sep, p)) == -1) {
                return false;
            }
            ++p;
        }
    }

    public static boolean matchString(String pattern, String string) {
        return StringUtils.matchString(pattern, string, '|');
    }

    public static void sortStrings(String[] strings) {
        if (strings != null) {
            for (int i = 0; i < strings.length - 1; ++i) {
                for (int j = i + 1; j < strings.length; ++j) {
                    if (strings[i].compareTo(strings[j]) <= 0) continue;
                    String t = strings[i];
                    strings[i] = strings[j];
                    strings[j] = t;
                }
            }
        }
    }

    public static String leftPad(String str, int pad) {
        if (str == null) {
            return null;
        }
        if (str.length() >= pad) {
            return str;
        }
        int len = pad - str.length();
        for (int i = 0; i < len; ++i) {
            str = " " + str;
        }
        return str;
    }

    public static String substitute(String str, String from, String to) {
        if (from == null || from.equals("") || to == null) {
            return str;
        }
        int index = str.indexOf(from);
        if (index == -1) {
            return str;
        }
        StringBuffer buf = new StringBuffer(str.length());
        int lastIndex = 0;
        while (index != -1) {
            buf.append(str.substring(lastIndex, index));
            buf.append(to);
            lastIndex = index + from.length();
            index = str.indexOf(from, lastIndex);
        }
        buf.append(str.substring(lastIndex));
        return buf.toString();
    }

    public static String getHeaderParameter(String header, String parameter) {
        return StringUtils.getHeaderParameter(header, parameter, null);
    }

    public static String getHeaderParameter(String header, String parameter, String deflt) {
        if (header == null || parameter == null) {
            return deflt;
        }
        int i = header.indexOf(parameter);
        if (i == -1) {
            return deflt;
        }
        int start = header.indexOf(61, i) + 1;
        int end = header.indexOf(59, start);
        if (end == -1) {
            return header.substring(start).trim();
        }
        return header.substring(start, end).trim();
    }

    public static String stripParamsFromHeader(String header) {
        if (header == null) {
            return null;
        }
        int semi_colon = header.indexOf(59);
        if (semi_colon == -1) {
            return header;
        }
        return header.substring(0, semi_colon).trim();
    }

    public static boolean isJavaEscape(char c) {
        return c == 'b' || c == 't' || c == 'n' || c == 'f' || c == 'r' || c == '\"' || c == '\'' || c == '0' || c == '1' || c == '2' || c == '3' || c == '4' || c == '5' || c == '6' || c == '7' || c == '\\' || c == 'u';
    }

    public static int occurrences(String s, char c) {
        if (s == null) {
            return 0;
        }
        char[] ca = s.toCharArray();
        int count = 0;
        for (int i = 0; i < ca.length; ++i) {
            if (ca[i] != c) continue;
            ++count;
        }
        return count;
    }

    public static String arrayToString(String[] str, char sep) {
        if (str == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < str.length; ++i) {
            sb.append(str[i]);
            sb.append(sep);
        }
        return sb.toString();
    }

    public static String entitizeHtml(String buffer) {
        if (buffer == null) {
            return buffer;
        }
        StringBuffer sb = new StringBuffer();
        block4: for (int i = 0; i < buffer.length(); ++i) {
            char c = buffer.charAt(i);
            switch (c) {
                case '>': {
                    sb.append("&gt;");
                    continue block4;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block4;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String lowerCaseFirstInitial(String str) {
        if (str != null && str.length() >= 1) {
            return str.substring(0, 1).toLowerCase() + str.substring(1);
        }
        return str;
    }

    public static String upperCaseFirstInitial(String str) {
        if (str != null && str.length() >= 1) {
            return str.substring(0, 1).toUpperCase() + str.substring(1);
        }
        return str;
    }
}

