/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.agl.text;

import com.adobe.agl.impl.ICUData;
import com.adobe.agl.impl.ICULocaleData;
import com.adobe.agl.impl.ICULocaleService;
import com.adobe.agl.impl.ICUResourceBundle;
import com.adobe.agl.impl.ICUService;
import com.adobe.agl.text.BreakIterator;
import com.adobe.agl.text.BreakIteratorFactory;
import com.adobe.agl.text.DictionaryBasedBreakIterator;
import com.adobe.agl.text.RuleBasedBreakIterator;
import com.adobe.agl.text.RuleBasedBreakIterator_New;
import com.adobe.agl.text.RuleBasedBreakIterator_Old;
import com.adobe.agl.util.ULocale;
import java.io.IOException;
import java.io.InputStream;
import java.text.StringCharacterIterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

final class BreakIteratorFactory
extends BreakIterator.BreakIteratorServiceShim {
    static final ICULocaleService service;
    private static final String[] KIND_NAMES;
    private static final String[] KIND_NAMES_2;
    static final /* synthetic */ boolean $assertionsDisabled;

    BreakIteratorFactory() {
    }

    public Object registerInstance(BreakIterator iter, ULocale locale, int kind) {
        iter.setText(new StringCharacterIterator(""));
        return service.registerObject((Object)iter, locale, kind);
    }

    public boolean unregister(Object key) {
        if (service.isDefault()) {
            return false;
        }
        return service.unregisterFactory((ICUService.Factory)key);
    }

    public Locale[] getAvailableLocales() {
        if (service == null) {
            return ICUResourceBundle.getAvailableLocales("com/adobe/agl/impl/data/icudt32b");
        }
        return service.getAvailableLocales();
    }

    public ULocale[] getAvailableULocales() {
        if (service == null) {
            return ICUResourceBundle.getAvailableULocales("com/adobe/agl/impl/data/icudt32b");
        }
        return service.getAvailableULocales();
    }

    public BreakIterator createBreakIterator(ULocale locale, int kind) {
        if (service.isDefault()) {
            return BreakIteratorFactory.createBreakInstance(locale, kind);
        }
        ULocale[] actualLoc = new ULocale[1];
        BreakIterator iter = (BreakIterator)service.get(locale, kind, actualLoc);
        iter.setLocale(actualLoc[0], actualLoc[0]);
        return iter;
    }

    private static BreakIterator createBreakInstance(ULocale locale, int kind) {
        String prefix = KIND_NAMES[kind];
        return BreakIteratorFactory.createBreakInstance(locale, kind, prefix + "BreakRules", prefix + "BreakDictionary");
    }

    private static BreakIterator createBreakInstance(ULocale where, int kind, String rulesName, String dictionaryName) {
        RuleBasedBreakIterator iter = null;
        ResourceBundle bundle = ICULocaleData.getResourceBundle("BreakIteratorRules", where);
        String[] classNames = bundle.getStringArray("BreakIteratorClasses");
        String rules = bundle.getString(rulesName);
        if (classNames[kind].equals("RuleBasedBreakIterator")) {
            iter = new RuleBasedBreakIterator_Old(rules);
        } else {
            if (classNames[kind].equals("RuleBasedBreakIterator_New")) {
                try {
                    String rulesFileName = "data/icudt32b/" + KIND_NAMES_2[kind] + ".brk";
                    InputStream is = ICUData.getRequiredStream(rulesFileName);
                    iter = RuleBasedBreakIterator_New.getInstanceFromCompiledRules(is);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(e.toString());
                }
            }
            if (classNames[kind].equals("DictionaryBasedBreakIterator")) {
                block12: {
                    try {
                        InputStream dictionary = ICUData.getStream(bundle.getString(dictionaryName));
                        iter = new DictionaryBasedBreakIterator(rules, dictionary);
                    }
                    catch (IOException e) {
                        if (!$assertionsDisabled) {
                            throw new AssertionError((Object)e);
                        }
                    }
                    catch (MissingResourceException e) {
                        if ($assertionsDisabled) break block12;
                        throw new AssertionError((Object)e);
                    }
                }
                if (iter == null) {
                    iter = new RuleBasedBreakIterator_Old(rules);
                }
            } else {
                throw new IllegalArgumentException("Invalid break iterator class \"" + classNames[kind] + "\"");
            }
        }
        ULocale uloc = ULocale.forLocale(bundle.getLocale());
        iter.setLocale(uloc, uloc);
        return iter;
    }

    static /* synthetic */ BreakIterator access$000(ULocale x0, int x1) {
        return BreakIteratorFactory.createBreakInstance(x0, x1);
    }

    static {
        $assertionsDisabled = !BreakIteratorFactory.class.desiredAssertionStatus();
        service = new BFService();
        KIND_NAMES = new String[]{"Character", "Word", "Line", "Sentence", "Title"};
        KIND_NAMES_2 = new String[]{"char", "word", "line", "sent", "title"};
    }

    private static class BFService
    extends ICULocaleService {
        BFService() {
            super("BreakIterator");
            class RBBreakIteratorFactory
            extends ICULocaleService.ICUResourceBundleFactory {
                private final /* synthetic */ BFService this$0;

                RBBreakIteratorFactory(BFService this$0) {
                    this.this$0 = this$0;
                }

                protected Object handleCreate(ULocale loc, int kind, ICUService service) {
                    return BreakIteratorFactory.access$000(loc, kind);
                }
            }
            this.registerFactory(new RBBreakIteratorFactory(this));
            this.markDefault();
        }
    }
}

