/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.command;

import java.io.ByteArrayInputStream;
import java.util.zip.ZipInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmContext;
import org.jbpm.JbpmException;
import org.jbpm.command.AbstractGetObjectBaseCommand;
import org.jbpm.graph.def.ProcessDefinition;

public class DeployProcessCommand
extends AbstractGetObjectBaseCommand {
    private static final long serialVersionUID = -5861811926680981061L;
    private String xml;
    private byte[] par;
    private static final Log log = LogFactory.getLog((Class)DeployProcessCommand.class);

    public DeployProcessCommand() {
    }

    public DeployProcessCommand(byte[] par) {
        this.par = par;
    }

    public DeployProcessCommand(String xml) {
        this.xml = xml;
    }

    public Object execute(JbpmContext jbpmContext) throws Exception {
        ProcessDefinition processDefinition = null;
        if (this.par != null && this.par.length > 0) {
            log.info((Object)"start parsing process from par");
            ZipInputStream zipInputStream = new ZipInputStream(new ByteArrayInputStream(this.par));
            processDefinition = ProcessDefinition.parseParZipInputStream(zipInputStream);
            jbpmContext.deployProcessDefinition(processDefinition);
            log.info((Object)"deployment sucessfull");
        } else if (this.xml != null && this.xml.length() > 0) {
            log.info((Object)"parse process from String");
            log.debug((Object)("deploy process:\n" + this.xml));
            processDefinition = ProcessDefinition.parseXmlString(this.xml);
            jbpmContext.deployProcessDefinition(processDefinition);
            log.info((Object)"deployment sucessfull");
        } else {
            throw new JbpmException("either xml string or par archive must be given.");
        }
        return this.retrieveProcessDefinition(processDefinition);
    }

    public byte[] getPar() {
        return this.par;
    }

    public void setPar(byte[] par) {
        this.par = par;
    }

    public String getXml() {
        return this.xml;
    }

    public void setXml(String xml) {
        this.xml = xml;
    }
}

