/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.command;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmContext;
import org.jbpm.command.AbstractGetObjectBaseCommand;
import org.jbpm.graph.exe.ProcessInstance;

public class GetProcessInstanceCommand
extends AbstractGetObjectBaseCommand {
    private static final long serialVersionUID = -8436697080972165601L;
    private static final Log log = LogFactory.getLog((Class)GetProcessInstanceCommand.class);
    private long processInstanceId;
    private long tokenId;
    private long taskInstanceId;

    public GetProcessInstanceCommand() {
    }

    public GetProcessInstanceCommand(long processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public GetProcessInstanceCommand(long processInstanceId, boolean includeVariables, boolean includeLogs) {
        super(true, true);
        this.processInstanceId = processInstanceId;
    }

    public Object execute(JbpmContext jbpmContext) throws Exception {
        this.setJbpmContext(jbpmContext);
        ProcessInstance processInstance = null;
        if (this.processInstanceId != 0L) {
            processInstance = jbpmContext.getProcessInstance(this.processInstanceId);
        } else if (this.tokenId != 0L) {
            processInstance = jbpmContext.getToken(this.tokenId).getProcessInstance();
        } else if (this.taskInstanceId != 0L) {
            processInstance = jbpmContext.getTaskInstance(this.taskInstanceId).getProcessInstance();
        }
        if (processInstance != null) {
            processInstance = this.retrieveProcessInstance(processInstance);
        }
        return processInstance;
    }

    public long getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(long processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public long getTaskInstanceId() {
        return this.taskInstanceId;
    }

    public void setTaskInstanceId(long taskInstanceId) {
        this.taskInstanceId = taskInstanceId;
    }

    public long getTokenId() {
        return this.tokenId;
    }

    public void setTokenId(long tokenId) {
        this.tokenId = tokenId;
    }
}

