/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.parsers;

import java.io.IOException;
import org.apache.xerces.impl.XML11DTDScannerImpl;
import org.apache.xerces.impl.XML11DocumentScannerImpl;
import org.apache.xerces.impl.XML11NamespaceBinder;
import org.apache.xerces.impl.XMLEntityHandler;
import org.apache.xerces.impl.XMLVersionDetector;
import org.apache.xerces.impl.dtd.XML11DTDProcessor;
import org.apache.xerces.impl.dtd.XML11DTDValidator;
import org.apache.xerces.impl.dv.DTDDVFactory;
import org.apache.xerces.impl.xs.XMLSchemaValidator;
import org.apache.xerces.impl.xs.XSMessageFormatter;
import org.apache.xerces.parsers.BasicParserConfiguration;
import org.apache.xerces.parsers.DTDConfiguration;
import org.apache.xerces.parsers.IntegratedParserConfigurationMMImpl;
import org.apache.xerces.util.MessageFormatter;
import org.apache.xerces.util.ParserConfigurationSettings;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.xni.XMLDTDContentModelHandler;
import org.apache.xerces.xni.XMLDTDHandler;
import org.apache.xerces.xni.XMLDocumentHandler;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.parser.XMLComponent;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLDocumentSource;

public class XML11ConfigurationMMImpl
extends IntegratedParserConfigurationMMImpl {
    protected static final String XML11_DATATYPE_VALIDATOR_FACTORY = "org.apache.xerces.impl.dv.dtd.XML11DTDDVFactoryImpl";
    protected XMLVersionDetector fVersionDetector = new XMLVersionDetector();
    protected XML11DocumentScannerImpl fXML11DocScanner = null;
    protected XML11DTDScannerImpl fXML11DTDScanner = null;
    protected XML11DTDValidator fXML11DTDValidator = null;
    protected XML11DTDProcessor fXML11DTDProcessor = null;
    protected XML11NamespaceBinder fXML11NamespaceBinder = null;
    protected DTDDVFactory fXML11DatatypeFactory = null;

    public XML11ConfigurationMMImpl() {
        this(null, null, null);
    }

    public XML11ConfigurationMMImpl(SymbolTable symbolTable) {
        this(symbolTable, null, null);
    }

    public XML11ConfigurationMMImpl(SymbolTable symbolTable, XMLGrammarPool grammarPool) {
        this(symbolTable, grammarPool, null);
    }

    public XML11ConfigurationMMImpl(SymbolTable symbolTable, XMLGrammarPool grammarPool, XMLComponentManager parentSettings) {
        super(symbolTable, grammarPool, parentSettings);
    }

    public boolean parse(boolean complete) throws XNIException, IOException {
        if (((DTDConfiguration)this).fInputSource != null) {
            try {
                this.fVersionDetector.reset((XMLComponentManager)this);
                this.reset();
                short version = this.fVersionDetector.determineDocVersion(((DTDConfiguration)this).fInputSource);
                if (version == 2) {
                    this.configureXML11Pipeline();
                }
                this.fVersionDetector.startDocumentParsing((XMLEntityHandler)((DTDConfiguration)this).fScanner, version);
                ((DTDConfiguration)this).fInputSource = null;
            }
            catch (XNIException ex) {
                throw ex;
            }
            catch (IOException ex) {
                throw ex;
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new XNIException(ex);
            }
        }
        try {
            return ((DTDConfiguration)this).fScanner.scanDocument(complete);
        }
        catch (XNIException ex) {
            throw ex;
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new XNIException(ex);
        }
    }

    protected void configureXML11Pipeline() {
        if (this.fXML11DatatypeFactory == null) {
            this.fXML11DatatypeFactory = DTDDVFactory.getInstance((String)XML11_DATATYPE_VALIDATOR_FACTORY);
        }
        this.setProperty("http://apache.org/xml/properties/internal/datatype-validator-factory", this.fXML11DatatypeFactory);
        if (this.fXML11DTDScanner == null) {
            this.fXML11DTDScanner = new XML11DTDScannerImpl();
        }
        if (this.fXML11DTDProcessor == null) {
            this.fXML11DTDProcessor = new XML11DTDProcessor();
        }
        ((ParserConfigurationSettings)this).fProperties.put("http://apache.org/xml/properties/internal/dtd-scanner", this.fXML11DTDScanner);
        ((ParserConfigurationSettings)this).fProperties.put("http://apache.org/xml/properties/internal/dtd-processor", this.fXML11DTDProcessor);
        this.fXML11DTDScanner.setDTDHandler((XMLDTDHandler)this.fXML11DTDProcessor);
        this.fXML11DTDProcessor.setDTDHandler(((BasicParserConfiguration)this).fDTDHandler);
        this.fXML11DTDScanner.setDTDContentModelHandler((XMLDTDContentModelHandler)this.fXML11DTDProcessor);
        this.fXML11DTDProcessor.setDTDContentModelHandler(((BasicParserConfiguration)this).fDTDContentModelHandler);
        if (this.fXML11DocScanner == null) {
            this.fXML11DocScanner = new XML11DocumentScannerImpl();
        }
        if (this.fXML11DTDValidator == null) {
            this.fXML11DTDValidator = new XML11DTDValidator();
        }
        ((DTDConfiguration)this).fScanner = this.fXML11DocScanner;
        ((XMLComponent)((DTDConfiguration)this).fScanner).reset((XMLComponentManager)this);
        ((ParserConfigurationSettings)this).fProperties.put("http://apache.org/xml/properties/internal/document-scanner", this.fXML11DocScanner);
        ((ParserConfigurationSettings)this).fProperties.put("http://apache.org/xml/properties/internal/validator/dtd", this.fXML11DTDValidator);
        if (((ParserConfigurationSettings)this).fFeatures.get("http://xml.org/sax/features/namespaces") == Boolean.TRUE) {
            if (this.fXML11NamespaceBinder == null) {
                this.fXML11NamespaceBinder = new XML11NamespaceBinder();
            }
            ((ParserConfigurationSettings)this).fProperties.put("http://apache.org/xml/properties/internal/namespace-binder", this.fXML11NamespaceBinder);
            ((DTDConfiguration)this).fScanner.setDocumentHandler((XMLDocumentHandler)this.fXML11DTDValidator);
            this.fXML11DTDValidator.setDocumentSource((XMLDocumentSource)((DTDConfiguration)this).fScanner);
            this.fXML11DTDValidator.setDocumentHandler((XMLDocumentHandler)this.fXML11NamespaceBinder);
            this.fXML11NamespaceBinder.setDocumentSource((XMLDocumentSource)this.fXML11DTDValidator);
            this.fXML11NamespaceBinder.setDocumentHandler(((BasicParserConfiguration)this).fDocumentHandler);
            ((BasicParserConfiguration)this).fDocumentHandler.setDocumentSource((XMLDocumentSource)this.fXML11NamespaceBinder);
            ((BasicParserConfiguration)this).fLastComponent = this.fXML11NamespaceBinder;
            this.fXML11NamespaceBinder.reset((XMLComponentManager)this);
        } else {
            ((DTDConfiguration)this).fScanner.setDocumentHandler((XMLDocumentHandler)this.fXML11DTDValidator);
            this.fXML11DTDValidator.setDocumentSource((XMLDocumentSource)((DTDConfiguration)this).fScanner);
            this.fXML11DTDValidator.setDocumentHandler(((BasicParserConfiguration)this).fDocumentHandler);
            ((BasicParserConfiguration)this).fDocumentHandler.setDocumentSource((XMLDocumentSource)this.fXML11DTDValidator);
            ((BasicParserConfiguration)this).fLastComponent = this.fXML11DTDValidator;
        }
        this.fXML11DTDProcessor.reset((XMLComponentManager)this);
        this.fXML11DTDScanner.reset((XMLComponentManager)this);
        this.fXML11DTDValidator.reset((XMLComponentManager)this);
        if (((ParserConfigurationSettings)this).fFeatures.get("http://apache.org/xml/features/validation/schema") == Boolean.TRUE) {
            if (this.fSchemaValidator == null) {
                this.fSchemaValidator = new XMLSchemaValidator();
                ((ParserConfigurationSettings)this).fProperties.put("http://apache.org/xml/properties/internal/validator/schema", this.fSchemaValidator);
                this.addComponent((XMLComponent)this.fSchemaValidator);
                if (((DTDConfiguration)this).fErrorReporter.getMessageFormatter("http://www.w3.org/TR/xml-schema-1") == null) {
                    XSMessageFormatter xmft = new XSMessageFormatter();
                    ((DTDConfiguration)this).fErrorReporter.putMessageFormatter("http://www.w3.org/TR/xml-schema-1", (MessageFormatter)xmft);
                }
            }
            ((BasicParserConfiguration)this).fLastComponent.setDocumentHandler((XMLDocumentHandler)this.fSchemaValidator);
            this.fSchemaValidator.setDocumentSource(((BasicParserConfiguration)this).fLastComponent);
            this.fSchemaValidator.setDocumentHandler(((BasicParserConfiguration)this).fDocumentHandler);
            ((BasicParserConfiguration)this).fLastComponent = this.fSchemaValidator;
        }
    }
}

