/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.client;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadFactory;
import flex.management.ManageableComponent;
import flex.management.runtime.messaging.client.FlexClientManagerControl;
import flex.messaging.MessageBroker;
import flex.messaging.client.FlexClient;
import flex.messaging.client.FlexClientOutboundQueueProcessor;
import flex.messaging.config.FlexClientSettings;
import flex.messaging.endpoints.AbstractEndpoint;
import flex.messaging.endpoints.Endpoint;
import flex.messaging.log.Log;
import flex.messaging.util.ClassUtil;
import flex.messaging.util.TimeoutAbstractObject;
import flex.messaging.util.TimeoutManager;
import java.util.ArrayList;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public class FlexClientManager
extends ManageableComponent {
    public static final String TYPE = "FlexClientManager";
    private final MessageBroker broker;
    private FlexClientManagerControl controller;
    private final Map flexClients = new ConcurrentHashMap();
    private Timer flushScheduler;
    private final Object flushInitLock = new Object();
    private volatile TimeoutManager flexClientTimeoutManager;
    private volatile long flexClientTimeoutMillis;

    public FlexClientManager() {
        this(MessageBroker.getMessageBroker(null));
    }

    public FlexClientManager(MessageBroker broker) {
        this(false, broker);
    }

    public FlexClientManager(boolean enableManagement, MessageBroker mbroker) {
        super(enableManagement);
        super.setId(TYPE);
        this.broker = mbroker != null ? mbroker : MessageBroker.getMessageBroker(null);
        FlexClientSettings flexClientSettings = this.broker.getFlexClientSettings();
        if (flexClientSettings != null) {
            this.setFlexClientTimeoutMillis(flexClientSettings.getTimeoutMinutes() * 60L * 1000L);
        }
        this.setParent(this.broker);
    }

    public String[] getClientIds() {
        String[] ids = new String[this.flexClients.size()];
        ArrayList idList = new ArrayList(this.flexClients.keySet());
        for (int i = 0; i < this.flexClients.size(); ++i) {
            ids[i] = (String)idList.get(i);
        }
        return ids;
    }

    public int getFlexClientCount() {
        return this.flexClients.size();
    }

    public long getFlexClientTimeoutMillis() {
        return this.flexClientTimeoutMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFlexClientTimeoutMillis(long value) {
        if (value < 1L) {
            value = 0L;
        }
        FlexClientManager flexClientManager = this;
        synchronized (flexClientManager) {
            this.flexClientTimeoutMillis = value;
        }
    }

    public MessageBroker getMessageBroker() {
        return this.broker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlexClient getFlexClient(String id) {
        FlexClient flexClient = null;
        if (id != null && (flexClient = (FlexClient)this.flexClients.get(id)) != null) {
            if (flexClient.isValid() && !flexClient.invalidating) {
                flexClient.updateLastUse();
                return flexClient;
            }
            this.flexClients.remove(id);
        }
        FlexClientManager flexClientManager = this;
        synchronized (flexClientManager) {
            if (id != null) {
                flexClient = (FlexClient)this.flexClients.get(id);
                if (flexClient != null) {
                    flexClient.updateLastUse();
                    return flexClient;
                }
                flexClient = new FlexClient(this, id);
            } else {
                flexClient = new FlexClient(this);
            }
            this.flexClients.put(flexClient.getId(), flexClient);
            if (this.flexClientTimeoutMillis > 0L) {
                this.flexClientTimeoutManager.scheduleTimeout(flexClient);
            }
            flexClient.notifyCreated();
            return flexClient;
        }
    }

    public FlexClientOutboundQueueProcessor createOutboundQueueProcessor(FlexClient flexClient, String endpointId) {
        FlexClientOutboundQueueProcessor processor;
        block4: {
            processor = null;
            try {
                Object instance;
                Class processorClass;
                Endpoint endpoint = this.broker.getEndpoint(endpointId);
                if (endpoint instanceof AbstractEndpoint && (processorClass = ((AbstractEndpoint)endpoint).getFlexClientOutboundQueueProcessorClass()) != null && (instance = ClassUtil.createDefaultInstance(processorClass, null)) instanceof FlexClientOutboundQueueProcessor) {
                    processor = (FlexClientOutboundQueueProcessor)instance;
                    processor.setFlexClient(flexClient);
                    processor.setEndpointId(endpointId);
                    processor.initialize(((AbstractEndpoint)endpoint).getFlexClientOutboundQueueProcessorConfig());
                }
            }
            catch (Throwable t) {
                if (!Log.isWarn()) break block4;
                Log.getLogger((String)"Client.FlexClient").warn("Failed to create custom outbound queue processor for FlexClient with id '" + flexClient.getId() + "'. Using default queue processor.", t);
            }
        }
        if (processor == null) {
            processor = new FlexClientOutboundQueueProcessor();
            processor.setFlexClient(flexClient);
            processor.setEndpointId(endpointId);
        }
        return processor;
    }

    public void monitorAsyncPollTimeout(TimeoutAbstractObject asyncPollTimeout) {
        this.flexClientTimeoutManager.scheduleTimeout(asyncPollTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleFlush(TimerTask flushTask, int waitInterval) {
        Object object = this.flushInitLock;
        synchronized (object) {
            if (this.flushScheduler == null) {
                this.flushScheduler = new Timer(true);
            }
        }
        this.flushScheduler.schedule(flushTask, waitInterval);
    }

    public void start() {
        if (this.isManaged()) {
            this.controller = new FlexClientManagerControl(this.getParent().getControl(), this);
            this.setControl(this.controller);
            this.controller.register();
        }
        final String baseId = this.getId();
        this.flexClientTimeoutManager = new TimeoutManager(new ThreadFactory(){
            int counter = 1;

            public synchronized Thread newThread(Runnable runnable) {
                Thread t = new Thread(runnable);
                t.setName(baseId + "-TimeoutThread-" + this.counter++);
                return t;
            }
        });
    }

    public void stop() {
        if (this.controller != null) {
            this.controller.unregister();
        }
        if (this.flushScheduler != null) {
            this.flushScheduler.cancel();
        }
        if (this.flexClientTimeoutManager != null) {
            this.flexClientTimeoutManager.shutdown();
        }
    }

    protected String getLogCategory() {
        return "Client.FlexClient";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFlexClient(FlexClient flexClient) {
        if (flexClient != null) {
            String id;
            String string = id = flexClient.getId();
            synchronized (string) {
                FlexClient storedClient = (FlexClient)this.flexClients.get(id);
                if (storedClient == flexClient) {
                    this.flexClients.remove(id);
                }
            }
        }
    }
}

