/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.cluster;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jgroups.Address;
import org.jgroups.stack.IpAddress;

public class ClusterNode {
    private final String host;
    private final Map destKeyToChannelMap;

    ClusterNode(Address address) {
        IpAddress addr = (IpAddress)address;
        this.host = addr.getIpAddress().getCanonicalHostName();
        this.destKeyToChannelMap = new HashMap();
    }

    String getHost() {
        return this.host;
    }

    Map getDestKeyToChannelMap() {
        return this.destKeyToChannelMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map getEndpoints(String serviceType, String destName) {
        String destKey = serviceType + ":" + destName;
        Map map = this.destKeyToChannelMap;
        synchronized (map) {
            HashMap channelEndpoints = (HashMap)this.destKeyToChannelMap.get(destKey);
            if (channelEndpoints == null) {
                channelEndpoints = new HashMap();
                this.destKeyToChannelMap.put(destKey, channelEndpoints);
            }
            return channelEndpoints;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addEndpoint(String serviceType, String destName, String channelId, String endpointUrl) {
        String destKey = serviceType + ":" + destName;
        Map map = this.destKeyToChannelMap;
        synchronized (map) {
            Map channelEndpoints = this.getEndpoints(serviceType, destName);
            channelEndpoints.put(channelId, endpointUrl);
        }
    }

    boolean containsEndpoint(String serviceType, String destName, String channelId, String endpointUrl) {
        Map channelEndpoints = this.getEndpoints(serviceType, destName);
        return channelEndpoints.containsKey(channelId) && channelEndpoints.get(channelId).equals(endpointUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer sb = new StringBuffer("ClusterNode[");
        Map map = this.destKeyToChannelMap;
        synchronized (map) {
            Iterator iter = this.destKeyToChannelMap.keySet().iterator();
            while (iter.hasNext()) {
                String destKey = (String)iter.next();
                sb.append(" channels for ");
                sb.append(destKey);
                sb.append("(");
                Map channelEndpoints = (Map)this.destKeyToChannelMap.get(destKey);
                Iterator dit = channelEndpoints.keySet().iterator();
                while (dit.hasNext()) {
                    String channelId = (String)dit.next();
                    String endpointUrl = (String)channelEndpoints.get(channelId);
                    sb.append(channelId);
                    sb.append("=");
                    sb.append(endpointUrl);
                    if (!dit.hasNext()) continue;
                    sb.append(", ");
                }
                sb.append(")");
            }
        }
        sb.append(" ]");
        return sb.toString();
    }
}

