/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler;

import flash.swf.tags.DefineFont;
import flash.swf.tags.DefineTag;
import flex2.compiler.AssetInfo;
import flex2.compiler.io.VirtualFile;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class Assets {
    private Map assets;
    private static final Iterator EMPTY_ITERATOR = new Iterator(){

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            return null;
        }

        public void remove() {
        }
    };

    public void add(String className, AssetInfo assetInfo) {
        if (this.assets == null) {
            this.assets = new HashMap(4);
        }
        this.assets.put(className, assetInfo);
    }

    public void add(String className, DefineTag tag) {
        if (this.assets == null) {
            this.assets = new HashMap(4);
        }
        this.assets.put(className, new AssetInfo(tag));
    }

    public void addAll(Assets ass) {
        if (ass.assets == null) {
            return;
        }
        if (this.assets == null) {
            this.assets = new HashMap(4);
        }
        this.assets.putAll(ass.assets);
    }

    public int count() {
        return this.assets == null ? 0 : this.assets.size();
    }

    public boolean contains(String className) {
        return this.assets == null ? false : this.assets.containsKey(className);
    }

    public AssetInfo get(String className) {
        return this.assets == null ? null : (AssetInfo)this.assets.get(className);
    }

    public Iterator iterator() {
        return this.assets == null ? EMPTY_ITERATOR : this.assets.entrySet().iterator();
    }

    public boolean isUpdated() {
        boolean result = false;
        if (this.assets != null) {
            Iterator i = this.assets.values().iterator();
            while (i.hasNext()) {
                AssetInfo assetInfo = (AssetInfo)i.next();
                VirtualFile path = assetInfo.getPath();
                if (path == null || assetInfo.getCreationTime() == path.getLastModified()) continue;
                result = true;
            }
        }
        return result;
    }

    public List getFonts() {
        LinkedList<DefineTag> fonts = new LinkedList<DefineTag>();
        if (this.assets != null) {
            Iterator it = this.assets.values().iterator();
            while (it.hasNext()) {
                AssetInfo assetInfo = (AssetInfo)it.next();
                DefineTag defineTag = assetInfo.getDefineTag();
                if (!(defineTag instanceof DefineFont)) continue;
                fonts.add(defineTag);
            }
        }
        return fonts;
    }

    public boolean exists(String name) {
        return this.assets != null && this.assets.containsValue(name);
    }

    public int size() {
        return this.assets == null ? 0 : this.assets.size();
    }
}

