/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font;

import com.adobe.fontengine.font.FontInputStream;
import com.adobe.fontengine.font.InvalidFontException;
import java.io.IOException;
import java.io.OutputStream;

public class FontByteArray {
    private static final int kMaxBufferLength = 262143;
    private static final int kBufferGrowthAmount = 1024;
    private byte[][] data;
    private int size;
    private int used;

    public FontByteArray(int n) {
        this.size = n;
        this.used = 0;
        int n2 = n / 262143 + (n % 262143 == 0 ? 0 : 1);
        this.data = new byte[n2][];
        for (int i = 0; i < n2; ++i) {
            int n3 = Math.min(262143, n);
            this.data[i] = new byte[n3];
            n -= n3;
        }
    }

    public FontByteArray(FontInputStream fontInputStream, int n) throws IOException, InvalidFontException {
        this(n);
        this.addBytes(fontInputStream, n, 0);
    }

    protected FontByteArray(FontByteArray fontByteArray, boolean bl) {
        this.size = fontByteArray.size;
        this.used = fontByteArray.used;
        if (bl) {
            this.data = new byte[fontByteArray.data.length][];
            for (int i = 0; i < fontByteArray.data.length; ++i) {
                this.data[i] = (byte[])fontByteArray.data[i].clone();
            }
        } else {
            this.data = fontByteArray.data;
            fontByteArray.data = null;
        }
    }

    void addBytes(FontInputStream fontInputStream, int n, int n2) throws IOException, InvalidFontException {
        int n3 = n2 % 262143;
        for (int i = n2 / 262143; i < this.data.length; ++i) {
            int n4 = 0;
            int n5 = Math.min(this.data[i].length - n3, n);
            while (n5 > 0) {
                int n6 = fontInputStream.read(this.data[i], n4 + n3, n5);
                if (n6 == -1) {
                    throw new InvalidFontException("not enough data");
                }
                n5 -= n6;
                n4 += n6;
                n3 = 0;
            }
            this.used += n4;
        }
    }

    public final int getSize() {
        return this.used;
    }

    protected final int getRawByte(int n) throws InvalidFontException {
        if (n < 0 || n >= this.size) {
            throw new InvalidFontException("Invalid index = " + n);
        }
        return this.data[n / 262143][n % 262143] & 0xFF;
    }

    protected final int getSignedRawByte(int n) throws InvalidFontException {
        if (n < 0 || n >= this.size) {
            throw new InvalidFontException("Invalid index = " + n);
        }
        return this.data[n / 262143][n % 262143];
    }

    public final void getBytes(FontByteArray fontByteArray, int n, int n2, int n3) {
        int n4;
        for (int i = 0; i < n3; i += n4) {
            int n5 = (n2 + i) / 262143;
            int n6 = (n2 + i) % 262143;
            int n7 = (n + i) / 262143;
            int n8 = (n + i) % 262143;
            n4 = Math.min(n3 - i, this.data[n5].length - n6);
            if (n4 <= 0) {
                throw new ArrayIndexOutOfBoundsException("Source buffer is too small");
            }
            n4 = Math.min(n4, fontByteArray.data[n7].length - n8);
            System.arraycopy(this.data[n5], n6, fontByteArray.data[n7], n8, n4);
        }
    }

    public final byte[] getBytes(int n, int n2) {
        int n3;
        byte[] byArray = new byte[n2];
        for (int i = 0; i < n2; i += n3) {
            int n4 = (n + i) / 262143;
            int n5 = (n + i) % 262143;
            n3 = Math.min(n2 - i, this.data[n4].length - n5);
            System.arraycopy(this.data[n4], n5, byArray, i, n3);
        }
        return byArray;
    }

    public void write(OutputStream outputStream) throws IOException {
        int n = 0;
        int n2 = 0;
        while (n2 < this.used) {
            int n3 = Math.min(this.used - n2, 262143);
            outputStream.write(this.data[n], 0, n3);
            n2 += n3;
            ++n;
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof FontByteArray)) {
            return false;
        }
        FontByteArray fontByteArray = (FontByteArray)object;
        if (fontByteArray.used != this.used) {
            return false;
        }
        for (int i = 0; i < this.used; ++i) {
            try {
                if (this.getRawByte(i) == fontByteArray.getRawByte(i)) continue;
                return false;
            }
            catch (InvalidFontException invalidFontException) {
                throw new RuntimeException("Unable to get data at index = " + i, invalidFontException);
            }
        }
        return true;
    }

    public int hashCode() {
        int n = this.used;
        int n2 = Math.min(this.used, 10);
        for (int i = 0; i < n2; ++i) {
            n = n * 31 + this.data[0][1];
        }
        return n;
    }

    static /* synthetic */ byte[][] access$002(FontByteArray fontByteArray, byte[][] byArray) {
        fontByteArray.data = byArray;
        return byArray;
    }

    protected static class FontByteArrayBuilder {
        protected FontByteArray byteArray;

        protected FontByteArrayBuilder(FontByteArray fontByteArray) {
            this.byteArray = fontByteArray;
        }

        protected final void setRawByte(int n, int n2) {
            ((FontByteArray)this.byteArray).data[n / 262143][n % 262143] = (byte)(n2 & 0xFF);
            this.byteArray.used = Math.max(this.byteArray.used, n + 1);
        }

        protected final void appendRawByte(int n) {
            int n2 = this.byteArray.used;
            this.ensureCapacity(n2 + 1);
            this.setRawByte(n2, n);
        }

        public int getSize() {
            return this.byteArray.getSize();
        }

        public final void replace(int n, FontByteArray fontByteArray, int n2, int n3) throws InvalidFontException {
            this.ensureCapacity(n + n3);
            if (n3 > 0) {
                fontByteArray.getBytes(this.byteArray, n, n2, n3);
                this.byteArray.used = Math.max(this.byteArray.used, n + n3);
            }
        }

        public final void replace(int n, byte[] byArray, int n2, int n3) {
            this.ensureCapacity(n + n3);
            for (int i = 0; i < n3; ++i) {
                this.setRawByte(n + i, byArray[i + n2]);
            }
        }

        public final void append(FontByteArray fontByteArray, int n, int n2) throws InvalidFontException {
            this.replace(this.byteArray.used, fontByteArray, n, n2);
        }

        public final void append(byte[] byArray, int n, int n2) {
            this.replace(this.byteArray.used, byArray, n, n2);
        }

        public final void append(FontInputStream fontInputStream, int n, int n2) throws IOException, InvalidFontException {
            this.byteArray.addBytes(fontInputStream, n, n2);
        }

        public final void ensureCapacity(int n) {
            if (n > this.byteArray.size) {
                this.grow(n);
            }
        }

        public final void ensureFreeSpace(int n) {
            if (this.byteArray.size - this.byteArray.used < n) {
                this.grow(this.byteArray.used + n);
            }
        }

        private final void grow(int n) {
            Object object;
            int n2;
            int n3 = this.byteArray.data.length - 1;
            if (this.byteArray.data[n3].length != 262143) {
                n2 = Math.max(n, this.byteArray.data[n3].length + 1024);
                n2 = Math.min(n2, 262143);
                object = new byte[n2];
                this.byteArray.size += n2 - this.byteArray.data[n3].length;
                System.arraycopy(this.byteArray.data[n3], 0, object, 0, this.byteArray.data[n3].length);
                ((FontByteArray)this.byteArray).data[n3] = object;
            }
            if ((n2 = n / 262143 + (n % 262143 == 0 ? 0 : 1)) != this.byteArray.data.length) {
                object = new byte[n2][];
                for (int i = 0; i < n2; ++i) {
                    if (i <= n3) {
                        object[i] = (byte)this.byteArray.data[i];
                        n -= ((byte)object[i]).length;
                        continue;
                    }
                    int n4 = Math.min(262143, n);
                    object[i] = (byte)new byte[n4];
                    n -= n4;
                }
                FontByteArray.access$002(this.byteArray, (byte[][])object);
            }
            this.byteArray.size = n;
        }
    }
}

