/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.BitmapConsumer;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Matrix;
import com.adobe.fontengine.font.OutlineConsumer;
import com.adobe.fontengine.font.Scaler;
import com.adobe.fontengine.font.ScalerDebugger;
import com.adobe.fontengine.font.ScanConverter;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.OTByteArray;
import com.adobe.fontengine.font.opentype.OpenTypeFont;
import com.adobe.fontengine.font.opentype.TTInterpreter;
import com.adobe.fontengine.font.opentype.TTOutline;

public class TTScaler
implements Scaler {
    protected final OpenTypeFont font;
    protected final TTInterpreter interpreter;
    protected final ScanConverter scanConverter;
    double pointSize = Double.NaN;
    double ppemX = Double.NaN;
    double ppemY = Double.NaN;
    double dX = Double.NaN;
    double dY = Double.NaN;
    Matrix em2px = null;
    boolean gridfit;
    protected ScalerDebugger debugger;

    public TTScaler(OpenTypeFont openTypeFont, ScanConverter scanConverter) throws InvalidFontException, UnsupportedFontException {
        this.font = openTypeFont;
        if (openTypeFont.maxp == null || openTypeFont.maxp.getTableMajorVersion() < 1) {
            throw new InvalidFontException("need maxp table with major version at least 1");
        }
        if (openTypeFont.head == null) {
            throw new InvalidFontException("need a head table");
        }
        this.interpreter = new TTInterpreter(openTypeFont.maxp.getMaxStorage(), openTypeFont.maxp.getMaxStackElements(), openTypeFont.cvt == null ? 0 : openTypeFont.cvt.getNbEntries(), openTypeFont.cvt == null ? null : openTypeFont.cvt.getData(), openTypeFont.maxp.getMaxFunctionDefs(), openTypeFont.maxp.getMaxTwilightPoints());
        this.scanConverter = scanConverter;
        this.interpreter.setUnitsPerEm(openTypeFont.head.getUnitsPerEm());
        if (openTypeFont.fpgm != null) {
            OTByteArray oTByteArray = openTypeFont.fpgm.getData();
            this.interpreter.runFpgm(oTByteArray, 0, oTByteArray.getSize());
        }
    }

    public void setScale(double d, double d2, double d3, double d4, double d5) throws InvalidFontException, UnsupportedFontException {
        this.pointSize = d;
        this.ppemX = d2;
        this.ppemY = d3;
        this.dX = d4;
        this.dY = d5;
        this.gridfit = true;
        this.em2px = new Matrix(d2, 0.0, 0.0, d3, d4, d5);
        this.interpreter.setScaling(d, d2, d3, d4, d5);
        if (this.font.prep != null) {
            OTByteArray oTByteArray = this.font.prep.getData();
            this.interpreter.runPrep(oTByteArray, 0, oTByteArray.getSize());
        } else {
            this.interpreter.runPrep(null, 0, 0);
        }
    }

    public void getOutline(int n, OutlineConsumer outlineConsumer) throws UnsupportedFontException, InvalidFontException {
        TTOutline tTOutline = this.font.glyf.createTTOutline(this.font, n);
        tTOutline.scale(this.font.head.getUnitsPerEm(), this.em2px);
        if (this.gridfit) {
            tTOutline.instruct(this.interpreter);
        }
        tTOutline.translate();
        tTOutline.toConsumer(outlineConsumer);
    }

    public void getBitmap(int n, BitmapConsumer bitmapConsumer) throws UnsupportedFontException, InvalidFontException {
        TTOutline tTOutline = this.font.glyf.createTTOutline(this.font, n);
        tTOutline.scale(this.font.head.getUnitsPerEm(), this.em2px);
        if (this.gridfit) {
            tTOutline.instruct(this.interpreter);
        }
        tTOutline.translate();
        this.scanConverter.setScanType(tTOutline.getScanType());
        tTOutline.toConsumer2(this.scanConverter.getOutlineConsumer2());
        this.scanConverter.getBitmap(bitmapConsumer);
    }

    public void setDebugger(ScalerDebugger scalerDebugger) {
        this.debugger = scalerDebugger;
        this.interpreter.setDebugger(scalerDebugger);
        if (this.scanConverter != null) {
            this.scanConverter.setDebugger(scalerDebugger);
        }
    }
}

