/*
 * Decompiled with CFR 0.152.
 */
package flash.swf.debug;

import flash.swf.debug.LineRecord;

public class DebugModule {
    public int id;
    public int bitmap;
    public String name;
    public String text;
    public int[] offsets;
    public int[] index;
    public boolean corrupt = false;

    public boolean addOffset(LineRecord lr, int offset) {
        boolean worked = true;
        if (lr.lineno < this.offsets.length) {
            this.offsets[lr.lineno] = offset;
        } else {
            this.corrupt = true;
            worked = false;
        }
        return worked;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DebugModule)) {
            return false;
        }
        DebugModule other = (DebugModule)obj;
        return this.bitmap == other.bitmap && this.name.equals(other.name) && this.text.equals(other.text);
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.text.hashCode() ^ this.bitmap;
    }

    public void setText(String text) {
        int last;
        this.text = text;
        int count = 1;
        int length = text.length();
        int i = DebugModule.eolIndexOf(text);
        while (i != -1) {
            last = i + 1;
            ++count;
            i = DebugModule.eolIndexOf(text, last);
        }
        this.index = new int[++count];
        this.index[0] = 0;
        count = 1;
        i = DebugModule.eolIndexOf(text);
        while (i != -1) {
            this.index[count++] = last = i + 1;
            i = DebugModule.eolIndexOf(text, last);
        }
        this.index[count++] = length;
        this.offsets = new int[count];
    }

    public int getLineNumber(int offset) {
        int closestMatch = 0;
        for (int i = 0; i < this.offsets.length; ++i) {
            int delta = offset - this.offsets[i];
            if (delta < 0 || delta >= offset - this.offsets[closestMatch]) continue;
            closestMatch = i;
        }
        return closestMatch;
    }

    public static int eolIndexOf(String text) {
        return DebugModule.eolIndexOf(text, 0);
    }

    public static int eolIndexOf(String text, int i) {
        int at = -1;
        int size = text.length();
        while (i < size && at < 0) {
            char c = text.charAt(i);
            if (c == '\n') {
                at = i;
            } else if (c == '\r') {
                at = i;
                if (i + 1 < size && text.charAt(i + 1) == '\n') {
                    ++at;
                }
            } else if (c == '\f') {
                at = i;
            }
            ++i;
        }
        return at;
    }

    public static void main(String[] args) {
        new DebugModule().setText("hello");
    }
}

