/*
 * Decompiled with CFR 0.152.
 */
package flex.webtier.server.j2ee;

import flash.swf.Movie;
import flash.util.FileUtils;
import flex.webtier.server.j2ee.BaseCompileFilter;
import flex.webtier.server.j2ee.MxmlContext;
import flex.webtier.server.j2ee.SWFInfo;
import flex.webtier.server.j2ee.Target;
import flex.webtier.services.ServiceFactory;
import flex.webtier.services.config.ServerConfiguration;
import flex.webtier.util.Trace;
import flex2.compiler.Compiler;
import flex2.compiler.CompilerSwcContext;
import flex2.compiler.FileSpec;
import flex2.compiler.ResourceBundlePath;
import flex2.compiler.ResourceContainer;
import flex2.compiler.SourceList;
import flex2.compiler.SourcePath;
import flex2.compiler.SymbolTable;
import flex2.compiler.Transcoder;
import flex2.compiler.common.CompilerConfiguration;
import flex2.compiler.common.Configuration;
import flex2.compiler.i18n.I18nUtils;
import flex2.compiler.io.FileUtil;
import flex2.compiler.io.LocalFile;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.swc.SwcCache;
import flex2.compiler.util.NameMappings;
import flex2.compiler.util.ThreadLocalToolkit;
import flex2.linker.API;
import flex2.linker.PostLink;
import flex2.tools.PreLink;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IncrementalCompileFilter
extends BaseCompileFilter {
    public static ThreadLocal targetThreadLocal;
    static final /* synthetic */ boolean $assertionsDisabled;

    public IncrementalCompileFilter(String swfExt) {
        super(swfExt);
    }

    protected SWFInfo compileMxml(SWFInfo swfInfo, String filename, MxmlContext context, HashMap dependencies) throws Exception {
        File appPath = FileUtil.openFile((String)filename);
        if (appPath != null) {
            appPath = appPath.getCanonicalFile();
        }
        Target t = (Target)targetThreadLocal.get();
        ServerConfiguration configuration = ServiceFactory.getConfigurator().generateConfiguration(context.getRequest(), appPath, dependencies);
        Configuration flexConfig = configuration.getFlexConfigConfiguration();
        CompilerConfiguration compilerConfig = flexConfig.getCompilerConfiguration();
        if (compilerConfig.keepGeneratedActionScript()) {
            File gendir = new File(FileUtils.addPathComponents((String)appPath.getParent(), (String)"generated", (char)File.separatorChar));
            gendir.mkdirs();
            compilerConfig.setGeneratedDirectory(gendir.getCanonicalPath());
        }
        Map licenseMap = ServiceFactory.getLicenseService().getLicenseMap();
        flex2.compiler.API.runBenchmark();
        flex2.compiler.API.setupHeadless((Configuration)flexConfig);
        try {
            if (t != null) {
                if (Trace.cache) {
                    Trace.trace((String)("refresh incremental compile: " + filename));
                }
                t = this.refreshCompile(t, appPath, configuration, licenseMap);
            } else {
                t = new Target();
                if (Trace.cache) {
                    Trace.trace((String)("full incremental compile: " + filename));
                }
                t = this.fullCompile(t, appPath, configuration, licenseMap);
            }
            swfInfo.setTarget(t);
            this.getDependenciesFromCompilationUnits(t.units, dependencies);
            this.getDependenciesFromConfiguration(configuration, dependencies);
            t.units = null;
            this.setHtmlWrapperAttributes(t.movie, context);
            ByteArrayOutputStream bos = this.encodeSwf(t.movie);
            if (bos != null) {
                swfInfo.setSwfBuffer(bos.toByteArray());
                if (configuration.getDebuggingConfiguration().keepGeneratedSwfs()) {
                    this.keepGenerated(bos, new File(appPath.getParent()), appPath);
                }
            }
        }
        catch (Exception e) {
            swfInfo.setTarget(null);
            throw e;
        }
        finally {
            flex2.compiler.API.disableBenchmark();
            targetThreadLocal.set(null);
        }
        return swfInfo;
    }

    protected Target fullCompile(Target t, File appPath, ServerConfiguration configuration, Map licenseMap) throws Exception {
        try {
            Configuration flexConfig = configuration.getFlexConfigConfiguration();
            CompilerConfiguration compilerConfig = flexConfig.getCompilerConfiguration();
            t.configuration = flexConfig;
            LocalFile appPathVirtual = new LocalFile(appPath);
            NameMappings mappings = flex2.compiler.API.getNameMappings((Configuration)flexConfig);
            Transcoder[] transcoders = flex2.tools.API.getTranscoders((Configuration)flexConfig);
            Compiler[] compilers = flex2.tools.API.getCompilers((CompilerConfiguration)compilerConfig, (NameMappings)mappings, (Transcoder[])transcoders);
            t.fileSpec = new FileSpec(Collections.EMPTY_LIST, flex2.tools.API.getFileSpecMimeTypes());
            VirtualFile[] asClasspath = compilerConfig.getSourcePath();
            ArrayList<LocalFile> virtualFileList = new ArrayList<LocalFile>();
            virtualFileList.add(appPathVirtual);
            t.sourceList = new SourceList(virtualFileList, asClasspath, (VirtualFile)appPathVirtual, flex2.tools.API.getSourcePathMimeTypes());
            t.sourcePath = new SourcePath(asClasspath, (VirtualFile)appPathVirtual, flex2.tools.API.getSourcePathMimeTypes(), compilerConfig.allowSourcePathOverlap());
            t.resources = new ResourceContainer();
            t.bundlePath = new ResourceBundlePath(compilerConfig, (VirtualFile)appPathVirtual);
            ThreadLocalToolkit.getBenchmark().benchmark("Initial setup:");
            t.swcCache = new SwcCache();
            CompilerSwcContext swcContext = new CompilerSwcContext(true, true, flexConfig.getCompatibilityVersionString());
            swcContext.load(compilerConfig.getLibraryPath(), compilerConfig.getExternalLibraryPath(), compilerConfig.getThemeFiles(), compilerConfig.getIncludeLibraries(), mappings, I18nUtils.getTranslationFormat((CompilerConfiguration)compilerConfig), t.swcCache);
            ThreadLocalToolkit.getBenchmark().benchmark("Loaded " + swcContext.getNumberLoaded() + " SWCs:");
            flexConfig.addExterns((Collection)swcContext.getExterns());
            flexConfig.addIncludes((Collection)swcContext.getIncludes());
            compilerConfig.addDefaultsCssFiles(swcContext.getDefaultsStyleSheets());
            compilerConfig.addThemeCssFiles(swcContext.getThemeStyleSheets());
            t.checksum = configuration.getChecksum_ts() + swcContext.checksum();
            SymbolTable symbolTable = new SymbolTable(compilerConfig.strict(), compilerConfig.dialect(), compilerConfig.suppressWarningsInIncremental());
            t.perCompileData = symbolTable.perCompileData;
            List units = flex2.compiler.API.compile((FileSpec)t.fileSpec, (SourceList)t.sourceList, (SourcePath)t.sourcePath, (ResourceContainer)t.resources, (ResourceBundlePath)t.bundlePath, (CompilerSwcContext)swcContext, (SymbolTable)symbolTable, (Configuration)flexConfig, (Compiler[])compilers, (flex2.compiler.PreLink)new PreLink(), (Map)licenseMap);
            t.movie = API.link((List)units, (PostLink)new flex2.tools.PostLink((flex2.linker.Configuration)t.configuration), (Configuration)t.configuration);
            t.units = units;
            t.sourcePath.clearCache();
            t.bundlePath.clearCache();
            t.resources.refresh();
            Target target = t;
            return target;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            ThreadLocalToolkit.getBenchmark().totalTime();
            ThreadLocalToolkit.getBenchmark().peakMemoryUsage(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Target refreshCompile(Target t, File appPath, ServerConfiguration configuration, Map licenseMap) throws Exception {
        try {
            List units;
            Configuration flexConfig = configuration.getFlexConfigConfiguration();
            CompilerConfiguration compilerConfig = flexConfig.getCompilerConfiguration();
            t.sourcePath.clearCache();
            t.bundlePath.clearCache();
            t.resources.refresh();
            NameMappings mappings = flex2.compiler.API.getNameMappings((Configuration)flexConfig);
            Transcoder[] transcoders = flex2.tools.API.getTranscoders((Configuration)flexConfig);
            Compiler[] compilers = flex2.tools.API.getCompilers((CompilerConfiguration)compilerConfig, (NameMappings)mappings, (Transcoder[])transcoders);
            ThreadLocalToolkit.getBenchmark().benchmark("Initial setup:");
            CompilerSwcContext swcContext = new CompilerSwcContext(false, true, flexConfig.getCompatibilityVersionString());
            swcContext.load(compilerConfig.getLibraryPath(), compilerConfig.getExternalLibraryPath(), compilerConfig.getThemeFiles(), compilerConfig.getIncludeLibraries(), mappings, I18nUtils.getTranslationFormat((CompilerConfiguration)compilerConfig), t.swcCache);
            ThreadLocalToolkit.getBenchmark().benchmark("Loaded " + swcContext.getNumberLoaded() + " SWCs:");
            flexConfig.addExterns((Collection)swcContext.getExterns());
            flexConfig.addIncludes((Collection)swcContext.getIncludes());
            compilerConfig.addThemeCssFiles(swcContext.getThemeStyleSheets());
            boolean recompile = false;
            int newChecksum = configuration.getChecksum_ts() + swcContext.checksum();
            if (newChecksum != t.checksum) {
                ThreadLocalToolkit.logInfo((String)"Detected configuration changes. Recompile...");
                t.checksum = newChecksum;
                t.resources = new ResourceContainer();
                recompile = true;
            }
            if (flex2.compiler.API.validateCompilationUnits((FileSpec)t.fileSpec, (SourceList)t.sourceList, (SourcePath)t.sourcePath, (ResourceBundlePath)t.bundlePath, (ResourceContainer)t.resources, (CompilerSwcContext)swcContext, (Object)t.perCompileData, (boolean)recompile, (Configuration)flexConfig) > 0) {
                t.configuration = flexConfig;
                SymbolTable symbolTable = new SymbolTable(t.perCompileData);
                units = flex2.compiler.API.compile((FileSpec)t.fileSpec, (SourceList)t.sourceList, (SourcePath)t.sourcePath, (ResourceContainer)t.resources, (ResourceBundlePath)t.bundlePath, (CompilerSwcContext)swcContext, (SymbolTable)symbolTable, (Configuration)t.configuration, (Compiler[])compilers, (flex2.compiler.PreLink)new PreLink(), (Map)licenseMap);
                if (!$assertionsDisabled && units == null) {
                    throw new AssertionError((Object)("recompile = " + recompile + "; please log a bug."));
                }
                if (units == null) {
                    Target target = this.fullCompile(new Target(), appPath, configuration, licenseMap);
                    return target;
                }
            } else {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)"Units should have been compiled but weren't identified. Please log a bug.");
                }
                Target target = this.fullCompile(new Target(), appPath, configuration, licenseMap);
                return target;
            }
            t.movie = API.link((List)units, (PostLink)new flex2.tools.PostLink((flex2.linker.Configuration)t.configuration), (Configuration)t.configuration);
            t.units = units;
            t.sourcePath.clearCache();
            t.bundlePath.clearCache();
            t.resources.refresh();
            Target target = t;
            return target;
        }
        finally {
            ThreadLocalToolkit.getBenchmark().totalTime();
            ThreadLocalToolkit.getBenchmark().peakMemoryUsage(true);
        }
    }

    protected ByteArrayOutputStream encodeSwf(Movie movie) {
        ByteArrayOutputStream bos;
        block4: {
            bos = null;
            OutputStream swfOut = null;
            try {
                bos = new ByteArrayOutputStream();
                swfOut = new BufferedOutputStream(bos);
                flex2.compiler.API.encode((Movie)movie, (OutputStream)swfOut);
                swfOut.flush();
            }
            catch (IOException ioe) {
                if (swfOut == null) break block4;
                try {
                    swfOut.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return bos;
    }

    static {
        $assertionsDisabled = !IncrementalCompileFilter.class.desiredAssertionStatus();
        targetThreadLocal = new ThreadLocal();
    }
}

