/* Copyright 2008 we-lab-doc! (http://www.we-lab-doc.com/)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.we_lab_doc.spacecard.model.abstracts

import com.we_lab_doc.spacecard.model.*
import com.we_lab_doc.spacecard.utils.*

/**
 * @author Shigeru GOUGI
 * @since 0.1
 *        <p/>
 *        Created: March 24, 2008
 */ 
/*abstract*/ class CardHolder implements SpaceCardDomainModel {
	boolean remove() {
		for (card in ModelUtils.cloneCollection(cards)) {
			removeFromCards(card)
			if(! card.remove()) return false
		}
		return ModelUtils.delete(this)
	}
	static protected String makeUniqueKey(SpaceCardDomainModel owner, String name) {
		assert owner != null
		assert owner.id != null
		assert name != null
		return owner.class.name + "-" + owner.id + "-" + name
	}
	/////////////////////////////////////////////
	def addToCards(SpaceCard obj) {
		return CollectionBugEvasion.addToForBidirectionalManyToOne(
					this, Set.class, obj, SpaceCard.class, "cards", "cardHolder"  
				)	
	}
	def removeFromCards(SpaceCard obj) {
		return CollectionBugEvasion.removeFromForBidirectionalManyToOne(
					this, obj, "cards", "cardHolder" 
				)		
	}
	/////////////////////////////////////////////
	def beforeInsert = {
		ModelUtils.insertLog(this)
		onBeforeInsert(delegate)
	}
	def beforeUpdate = {
		ModelUtils.updateLog(this)
		onBeforeUpdate(delegate)
	}
	def beforeDelete = {
		ModelUtils.deleteLog(this)
		onBeforeDelete(delegate)
	}
	/////////////////////////////////////////////
	protected onBeforeInsert(obj) {
		obj.createdDate = new Date()
		if(!obj.creator) {
			def acs = SpaceCardModel.accessControlService
			obj.creator = acs.getLoggedInUser()
		}
	}
	protected onBeforeUpdate(obj) {
		obj.updatedDate = new Date()
		def acs = SpaceCardModel.accessControlService
		obj.updater = acs.getLoggedInUser()		
	}
	protected onBeforeDelete(obj) {
		/* don't delete*/		
	}	
	/////////////////////////////////////////////
	static hasMany     = [cards:SpaceCard]	
	static constraints = {
		creator(nullable:true)
		createdDate(nullable:true)
		updater(nullable:true)
		updatedDate(nullable:true)
		name(blank:false)
		key(nullable:false, unique:true)
	}
	/////////////////////////////////////////////
	User creator
	Date createdDate
	User updater
	Date updatedDate	
	String name
	String key
}
