/* Copyright 2008 we-lab-doc! (http://www.we-lab-doc.com/)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import com.we_lab_doc.spacecard.ac.*
import com.we_lab_doc.spacecard.model.*
import com.we_lab_doc.spacecard.utils.*

/**
 * @author Shigeru GOUGI
 * @since 0.1
 *        <p/>
 *        Created: June 19, 2008
 */ 
class FlexPrivateWorkspaceService   {
	static expose = ['flex-remoting']
	def accessControlService
	// TODO: AccessControlの仕掛け

	def getWorkspaces() {
		User user = accessControlService.loggedInUser
		if(!user) throw new IllegalStateException("ログインしていません")
		def workspaces = user.workspaces?.collect {
			[id:it.id, title:it.title, createdDate:it.createdDate]
		}
		return workspaces == null ? [] : workspaces
	}
	
	def createWorkspace(def data) {
		def userWorkspace
		UserWorkspace.withTransaction  { tx ->
			User user = accessControlService.loggedInUser
			if(!user) throw new IllegalStateException("ログインしていません")		
			userWorkspace = UserWorkspace.create(user, data)
			if(!ModelUtils.save(userWorkspace))  throw new IllegalStateException("作成に失敗しました");
		}
		return userWorkspace.id
	}
	
	def getWorkspace(def workspaceId) {
		def ws = UserWorkspace.get(workspaceId)
		if(ws == null) throw new IllegalStateException("id に対応するプライベートワークスペースが存在しません")
		return [id:ws.id, title:ws.title, createdDate:ws.createdDate]
	}
	
	def getTasks(def workspaceId) {
		return [
                [id:"1", label:"TaskA", data:[:], children:[
                    [id:"2", label:"SubTaskA-1", data:[:], children:[
                                 [id:"3", label:"SubsubTaskA-1-1", data:[:]],
                                 [id:"4", label:"SubsubTaskA-1-2", data:[:], children:[]]
                             ]],
                    [id:"5", label:"SubTaskA-2", data:[:]],
                    [id:"6", label:"SubTaskA-3", data:[:]]
                ]],
               ];
	}
	

}	