import com.we_lab_doc.spacecard.model.*
import com.we_lab_doc.spacecard.utils.*

class CommentTests extends SpaceCardModelTestCase {
	def spaceCardService
	def organizationService
	
    void testCreateDelete() {
		def sv = User.getActiveUserByAccount(spaceCardModelProperties.supervisorAccount)
		assertNotNull sv
		def svc = Organization.getSupervisorCommunity()
		assertNotNull svc
		def p1 = Project.create(
				[
				 title:"hoge1",
				 creator:sv
				]
				,svc)
		assertTrue ModelUtils.flush(p1)
		
		def c1 = WorkCardComment.create(
				[
				 description:"hoge",
				 creator:sv]
				 )
		p1.add(c1)		 
		assertNotNull "1", c1
		assertTrue    "2", ModelUtils.flush(p1)
		assertEquals  "4", c1.description,  "hoge"
		assertNotNull "5", c1.createdDate
		assertNull    "6", c1.updatedDate
		assertTrue    "7", p1.comments?.size() == 1
		assertTrue    "8", c1.remove()
		assertTrue    "9", p1.comments?.size() == 0			
    }
}
