import com.we_lab_doc.spacecard.model.*
import com.we_lab_doc.spacecard.utils.*

class TagTests extends SpaceCardModelTestCase {
	
	void testUpdateTags () {
		def sv = User.getActiveUserByAccount(spaceCardModelProperties.supervisorAccount)
		assertNotNull sv
		def svc = Organization.getSupervisorCommunity()
		assertNotNull svc
		def p1 = Project.create(
				[
				 title:"hoge1",
				 creator:sv
				]
				,svc)
		def p2 = Project.create(
				[
				 title:"hoge2",
				 creator:sv
				]
				,svc)
		assertTrue "0", ModelUtils.flush([p1,p2])
		p1.updateTags(["", "", null])
		assertTrue "1", ModelUtils.flush([p1])
		def tags = WorkCardTag.select("where w.name != null")
		assertTrue "2", tags.size() == 0
		
		p1.updateTags(["aa", "bb", null])
		assertTrue "3", ModelUtils.flush([p1])
		tags = WorkCardTag.list()
		assertTrue "4", tags.size() == 2
		assertTrue "5-1", p1.tags?.size() == 2
		assertTrue "5-2", p2.tags == null || p2.tags.size() == 0 
						
		p2.updateTags(["aa", "bb", null])
		assertTrue "6", ModelUtils.flush([p2])
		tags = WorkCardTag.list()
		assertTrue "7", tags.size() == 2
		assertTrue "8-1", p1.tags?.size() == 2
		assertTrue "8-2", p2.tags?.size() == 2
		
		p1.updateTags([])
		assertTrue "9", ModelUtils.flush([p1])
		tags = WorkCardTag.list()
		assertTrue "10", tags.size() == 2
		assertTrue "11-1", p1.tags == null || p1.tags.size() == 0			
		assertTrue "11-2", p2.tags?.size() == 2
				
		p2.updateTags([])
		assertTrue "12", ModelUtils.flush([p2])
		tags = WorkCardTag.list()
		tags.each {
			println "tag: ${it.name}"
		}		
		assertTrue "13: ${tags.size()}", tags.size() == 0
		assertTrue "14-1", p1.tags == null || p1.tags.size() == 0			
		assertTrue "14-1", p2.tags == null || p2.tags.size() == 0

	}
}