/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.parser;

import macromedia.asc.parser.Evaluator;
import macromedia.asc.parser.Node;
import macromedia.asc.parser.QualifiedIdentifierNode;
import macromedia.asc.parser.SelectorNode;
import macromedia.asc.semantics.ReferenceValue;
import macromedia.asc.semantics.Slot;
import macromedia.asc.semantics.Value;
import macromedia.asc.util.BitSet;
import macromedia.asc.util.Context;

public class MemberExpressionNode
extends Node {
    public Node base;
    public SelectorNode selector;
    public ReferenceValue ref = null;
    int authOrigToken = -1;

    public void setOrigToken(int n) {
        this.authOrigToken = n;
    }

    public int getOrigToken() {
        return this.authOrigToken;
    }

    public MemberExpressionNode(Node node, SelectorNode selectorNode, int n) {
        super(n);
        this.base = node;
        this.selector = selectorNode;
    }

    public Value evaluate(Context context, Evaluator evaluator) {
        if (evaluator.checkFeature(context, this)) {
            return evaluator.evaluate(context, this);
        }
        return null;
    }

    public void voidResult() {
        this.selector.voidResult();
    }

    public boolean isMemberExpression() {
        return true;
    }

    public boolean isIndexedMemberExpression() {
        return this.selector.getMode() == -28;
    }

    public BitSet getGenBits() {
        return this.selector.getGenBits();
    }

    public BitSet getKillBits() {
        return this.selector.getKillBits();
    }

    public String toString() {
        return "MemberExpression";
    }

    public boolean isAttribute() {
        return this.selector.isAttribute();
    }

    public boolean isLabel() {
        return this.base == null && this.selector.isGetExpression() && !(this.selector.expr instanceof QualifiedIdentifierNode);
    }

    public boolean isAny() {
        return this.selector.isAny();
    }

    public boolean hasAttribute(String string) {
        return this.base == null && this.selector.hasAttribute(string);
    }

    public StringBuffer toCanonicalString(Context context, StringBuffer stringBuffer) {
        Slot slot = this.ref.getSlot(context, -78);
        stringBuffer.append(slot == null || slot.getDebugName().length() == 0 ? this.ref.name : slot.getDebugName());
        return stringBuffer;
    }

    public boolean hasSideEffect() {
        return this.selector.hasSideEffect();
    }

    public boolean isLValue() {
        return this.selector.isLValue();
    }

    public boolean isConfigurationName() {
        return this.selector.isConfigurationName();
    }
}

