/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.cff;

import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.cff.CFFByteArray;

final class FdSelect {
    protected final CFFByteArray data;
    protected final int offset;
    protected final int size;

    public FdSelect(CFFByteArray cFFByteArray, int n, int n2) throws InvalidFontException {
        this.data = cFFByteArray;
        this.offset = n;
        this.size = this.size(n2);
    }

    public static FdSelect singleFont(int n) throws InvalidFontException {
        CFFByteArray.CFFByteArrayBuilder cFFByteArrayBuilder = CFFByteArray.getCFFByteArrayBuilderInstance(8);
        cFFByteArrayBuilder.addCard8(3);
        cFFByteArrayBuilder.addCard16(1);
        cFFByteArrayBuilder.addCard16(0);
        cFFByteArrayBuilder.addCard8(0);
        cFFByteArrayBuilder.addCard16(n);
        return new FdSelect(cFFByteArrayBuilder.toCFFByteArray(), 0, n);
    }

    private static FdSelect format0Generator(FdSelect fdSelect, Subset subset) throws InvalidFontException {
        CFFByteArray.CFFByteArrayBuilder cFFByteArrayBuilder = CFFByteArray.getCFFByteArrayBuilderInstance(1 + subset.getNumGlyphs());
        cFFByteArrayBuilder.addCard8(0);
        for (int i = 0; i < subset.getNumGlyphs(); ++i) {
            cFFByteArrayBuilder.addCard8(fdSelect.componentOf(subset.getFullGid(i)));
        }
        return new FdSelect(cFFByteArrayBuilder.toCFFByteArray(), 0, subset.getNumGlyphs());
    }

    private static FdSelect format3Generator(FdSelect fdSelect, Subset subset, int n) throws InvalidFontException {
        CFFByteArray.CFFByteArrayBuilder cFFByteArrayBuilder = CFFByteArray.getCFFByteArrayBuilderInstance(5 + n * 3);
        int n2 = fdSelect.componentOf(subset.getFullGid(0));
        cFFByteArrayBuilder.addCard8(3);
        cFFByteArrayBuilder.addCard16(n);
        cFFByteArrayBuilder.addCard16(0);
        for (int i = 1; i < subset.getNumGlyphs(); ++i) {
            int n3 = fdSelect.componentOf(subset.getFullGid(i));
            if (n2 == n3) continue;
            cFFByteArrayBuilder.addCard8(n2);
            cFFByteArrayBuilder.addCard16(i);
            n2 = n3;
        }
        cFFByteArrayBuilder.addCard8(n2);
        cFFByteArrayBuilder.addCard16(subset.getNumGlyphs());
        return new FdSelect(cFFByteArrayBuilder.toCFFByteArray(), 0, subset.getNumGlyphs());
    }

    public static FdSelect fdSelectFromSubset(FdSelect fdSelect, Subset subset) throws InvalidFontException {
        int n;
        int n2;
        int n3 = fdSelect.componentOf(subset.getFullGid(0));
        int n4 = 1;
        for (n2 = 1; n2 < subset.getNumGlyphs(); ++n2) {
            n = fdSelect.componentOf(subset.getFullGid(n2));
            if (n3 == n) continue;
            ++n4;
            n3 = n;
        }
        n2 = subset.getNumGlyphs();
        if (n2 <= (n = 4 + n4 * 3)) {
            return FdSelect.format0Generator(fdSelect, subset);
        }
        return FdSelect.format3Generator(fdSelect, subset, n4);
    }

    public int componentOf(int n) throws InvalidFontException {
        int n2 = this.offset;
        int n3 = this.data.getcard8(n2);
        ++n2;
        switch (n3) {
            case 0: {
                return this.data.getcard8(n2 + n);
            }
            case 3: {
                int n4 = this.data.getcard16(n2);
                n2 += 2;
                int n5 = 0;
                int n6 = n4 - 1;
                while (n5 <= n6) {
                    int n7 = (n5 + n6) / 2;
                    int n8 = this.data.getcard16(n2 + 3 * n7);
                    int n9 = this.data.getcard16(n2 + 3 * (n7 + 1));
                    if (n < n8) {
                        n6 = n7 - 1;
                        continue;
                    }
                    if (n9 <= n) {
                        n5 = n7 + 1;
                        continue;
                    }
                    return this.data.getcard8(n2 + 3 * n7 + 2);
                }
                throw new InvalidFontException("invalid fdSelect at offset " + this.offset);
            }
        }
        throw new InvalidFontException("invalid fdSelect format at " + this.offset);
    }

    int size(int n) throws InvalidFontException {
        int n2 = this.offset;
        int n3 = this.data.getcard8(n2);
        ++n2;
        switch (n3) {
            case 0: {
                return 1 + n;
            }
            case 3: {
                int n4 = this.data.getcard16(n2);
                return 3 + 3 * n4 + 2;
            }
        }
        throw new InvalidFontException("invalid fdSelect format at " + this.offset);
    }

    public void stream(CFFByteArray.CFFByteArrayBuilder cFFByteArrayBuilder) throws InvalidFontException {
        cFFByteArrayBuilder.addBytes(this.data, this.offset, this.size);
    }
}

