/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.FontByteArray;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.Table;
import java.io.IOException;

public final class Post
extends Table {
    private static final String[] macNames = new String[]{".notdef", ".null", "nonmarkingreturn", "space", "exclam", "quotedbl", "numbersign", "dollar", "percent", "ampersand", "quotesingle", "parenleft", "parenright", "asterisk", "plus", "comma", "hyphen", "period", "slash", "zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "colon", "semicolon", "less", "equal", "greater", "question", "at", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "bracketleft", "backslash", "bracketright", "asciicircum", "underscore", "grave", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "braceleft", "bar", "braceright", "asciitilde", "Adieresis", "Aring", "Ccedilla", "Eacute", "Ntilde", "Odieresis", "Udieresis", "aacute", "agrave", "acircumflex", "adieresis", "atilde", "aring", "ccedilla", "eacute", "egrave", "ecircumflex", "edieresis", "iacute", "igrave", "icircumflex", "idieresis", "ntilde", "oacute", "ograve", "ocircumflex", "odieresis", "otilde", "uacute", "ugrave", "ucircumflex", "udieresis", "dagger", "degree", "cent", "sterling", "section", "bullet", "paragraph", "germandbls", "registered", "copyright", "trademark", "acute", "dieresis", "notequal", "AE", "Oslash", "infinity", "plusminus", "lessequal", "greaterequal", "yen", "mu", "partialdiff", "summation", "product", "pi", "integral", "ordfeminine", "ordmasculine", "Omega", "ae", "oslash", "questiondown", "exclamdown", "logicalnot", "radical", "florin", "approxequal", "Delta", "guillemotleft", "guillemotright", "ellipsis", "nonbreakingspace", "Agrave", "Atilde", "Otilde", "OE", "oe", "endash", "emdash", "quotedblleft", "quotedblright", "quoteleft", "quoteright", "divide", "lozenge", "ydieresis", "Ydieresis", "fraction", "currency", "guilsinglleft", "guilsinglright", "fi", "fl", "daggerdbl", "periodcentered", "quotesinglbase", "quotedblbase", "perthousand", "Acircumflex", "Ecircumflex", "Aacute", "Edieresis", "Egrave", "Iacute", "Icircumflex", "Idieresis", "Igrave", "Oacute", "Ocircumflex", "apple", "Ograve", "Uacute", "Ucircumflex", "Ugrave", "dotlessi", "circumflex", "tilde", "macron", "breve", "dotaccent", "ring", "cedilla", "hungarumlaut", "ogonek", "caron", "Lslash", "lslash", "Scaron", "scaron", "Zcaron", "zcaron", "brokenbar", "Eth", "eth", "Yacute", "yacute", "Thorn", "thorn", "minus", "multiply", "onesuperior", "twosuperior", "threesuperior", "onehalf", "onequarter", "threequarters", "franc", "Gbreve", "gbreve", "Idotaccent", "Scedilla", "scedilla", "Cacute", "cacute", "Ccaron", "ccaron", "dcroat"};

    protected Post(FontByteArray fontByteArray) throws UnsupportedFontException, InvalidFontException, IOException {
        super(fontByteArray);
        if (fontByteArray.getSize() < 32) {
            throw new InvalidFontException("'post' table must be at least 32 bytes");
        }
        int n = this.getTableMajorVersion();
        if (n < 1 || 3 < n) {
            throw new UnsupportedFontException("'post' tables with major version " + n + " are not supported");
        }
    }

    public int getTableMajorVersion() throws InvalidFontException {
        return this.data.getuint16(0);
    }

    public int getTableMinorVersion() throws InvalidFontException {
        return this.data.getuint16(2);
    }

    public int getUnderlinePosition() throws InvalidFontException {
        return this.data.getint16(8);
    }

    public int getUnderlineThickness() throws InvalidFontException {
        return this.data.getint16(10);
    }

    public int getNumberOfGlyphs() throws InvalidFontException {
        if (this.getTableMajorVersion() != 2) {
            return -1;
        }
        return this.data.getuint16(32);
    }

    public String getGlyphName(int n) throws InvalidFontException {
        switch (this.getTableMajorVersion()) {
            case 1: {
                return macNames[n];
            }
            case 2: {
                if (this.getTableMinorVersion() < 5) {
                    int n2;
                    int n3 = this.data.getuint16(32);
                    if (n >= n3) {
                        return null;
                    }
                    int n4 = this.data.getuint16(34 + n * 2);
                    if (n4 < 258) {
                        return macNames[n4];
                    }
                    int n5 = 34 + n3 * 2;
                    for (n2 = 0; n2 < n4; ++n2) {
                        int n6 = this.data.getuint8(n5);
                        n5 += 1 + n6;
                    }
                    n2 = this.data.getuint8(n5);
                    char[] cArray = new char[n2];
                    for (int i = 0; i < n2; ++i) {
                        cArray[i] = (char)this.data.getuint8(n5);
                    }
                    return new String(cArray);
                }
                int n7 = this.data.getint8(34 + n * 2);
                return macNames[n + n7];
            }
        }
        return null;
    }

    public int glyphName2gid(String string) throws InvalidFontException {
        switch (this.getTableMajorVersion()) {
            case 1: {
                for (int i = 0; i < macNames.length; ++i) {
                    if (!macNames[i].equals(string)) continue;
                    return i;
                }
                return 0;
            }
            case 2: {
                int n = this.data.getuint16(32);
                for (int i = 0; i < n; ++i) {
                    if (!string.equals(this.getGlyphName(i))) continue;
                    return i;
                }
                return 0;
            }
        }
        return 0;
    }
}

