/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler;

import flex2.compiler.CompilationUnit;
import flex2.compiler.CompilerException;
import flex2.compiler.Source;
import flex2.compiler.SourcePath;
import flex2.compiler.io.FileUtil;
import flex2.compiler.io.LocalFile;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.NameFormatter;
import flex2.compiler.util.QName;
import flex2.compiler.util.ThreadLocalToolkit;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class SourceList {
    private Map sources;
    private List directories;
    private String[] mimeTypes;
    static final /* synthetic */ boolean $assertionsDisabled;

    public SourceList(List files, VirtualFile[] classPath, VirtualFile appPath, String[] mimeTypes) throws CompilerException {
        this(files, classPath, appPath, mimeTypes, true);
    }

    public SourceList(List files, VirtualFile[] classPath, VirtualFile appPath, String[] mimeTypes, boolean lastIsRoot) throws CompilerException {
        VirtualFile[] vfiles = new VirtualFile[files.size()];
        files.toArray(vfiles);
        this.init(vfiles, classPath, appPath, mimeTypes, lastIsRoot);
    }

    private void init(VirtualFile[] files, VirtualFile[] classPath, VirtualFile appPath, String[] mimeTypes, boolean lastIsRoot) throws CompilerException {
        this.mimeTypes = mimeTypes;
        this.sources = new LinkedHashMap(files.length);
        this.directories = new ArrayList(classPath == null ? 0 : classPath.length);
        SourcePath.addApplicationParentToSourcePath(appPath, classPath, this.directories);
        SourcePath.addPathElements(classPath, this.directories, true, null);
        int length = files.length;
        for (int i = 0; i < length; ++i) {
            VirtualFile pathRoot;
            String name;
            if (appPath != null && files[i].getName().equals(appPath.getName()) || this.isSupported(files[i])) {
                name = files[i].getName();
                pathRoot = this.calculatePathRoot(files[i]);
                if (pathRoot == null) {
                    FileNotInSourcePath ex = new FileNotInSourcePath(name);
                    ThreadLocalToolkit.log(ex);
                    throw ex;
                }
            } else {
                UnsupportedFileType ex = new UnsupportedFileType(files[i].getName());
                ThreadLocalToolkit.log(ex);
                throw ex;
            }
            String relativePath = this.calculateRelativePath(name);
            String namespaceURI = relativePath.replace('/', '.');
            String localPart = this.calculateLocalPart(name);
            Source s = new Source(files[i], pathRoot, relativePath, localPart, this, false, i == length - 1 && lastIsRoot);
            this.sources.put(this.constructClassName(namespaceURI, localPart), s);
        }
    }

    private VirtualFile calculatePathRoot(VirtualFile f) {
        return SourceList.calculatePathRoot(f, this.directories);
    }

    static VirtualFile calculatePathRoot(VirtualFile f, List directories) {
        int size;
        String name = f.getName();
        int n = size = directories == null ? 0 : directories.size();
        for (int i = 0; i < size; ++i) {
            String dir = ((File)directories.get(i)).getAbsolutePath();
            if (!name.startsWith(dir)) continue;
            return new LocalFile(FileUtil.openFile(dir));
        }
        return null;
    }

    private String calculateRelativePath(String name) {
        int size;
        int n = size = this.directories == null ? 0 : this.directories.size();
        for (int i = 0; i < size; ++i) {
            String dir = ((File)this.directories.get(i)).getAbsolutePath();
            if (!name.startsWith(dir)) continue;
            int index = (name = name.substring(dir.length() + 1)).lastIndexOf(File.separatorChar);
            if (index != -1) {
                return name.substring(0, index).replace(File.separatorChar, '/');
            }
            return "";
        }
        return "";
    }

    private String calculateLocalPart(String name) {
        String leafName = name.substring(name.lastIndexOf(File.separatorChar) + 1);
        String localPart = leafName.substring(0, leafName.lastIndexOf(46));
        return localPart;
    }

    public List retrieveSources() {
        ArrayList<Source> sources = new ArrayList<Source>(this.sources.size());
        Iterator i = this.sources.keySet().iterator();
        while (i.hasNext()) {
            CompilationUnit u;
            String name = (String)i.next();
            Source s = (Source)this.sources.get(name);
            CompilationUnit compilationUnit = u = s != null ? s.getCompilationUnit() : null;
            if (s != null && !s.exists()) {
                s = null;
            } else if (!(u != null && !u.isDone() || s != null && s.isUpdated() || u == null)) {
                s = s.copy();
                if (!$assertionsDisabled && s == null) {
                    throw new AssertionError();
                }
            }
            if (s == null) continue;
            sources.add(s);
        }
        return sources;
    }

    private String constructClassName(String namespaceURI, String localPart) {
        return namespaceURI.length() == 0 ? localPart : new StringBuffer(namespaceURI.length() + localPart.length() + 1).append(namespaceURI).append(":").append(localPart).toString();
    }

    public Source findSource(String namespaceURI, String localPart) {
        CompilationUnit u;
        if (this.sources.size() == 0) {
            return null;
        }
        if (!($assertionsDisabled || localPart.indexOf(46) == -1 && localPart.indexOf(47) == -1 && localPart.indexOf(58) == -1)) {
            throw new AssertionError((Object)("findSource(" + namespaceURI + "," + localPart + ") has bad localPart"));
        }
        String className = this.constructClassName(namespaceURI, localPart);
        Source s = (Source)this.sources.get(className);
        CompilationUnit compilationUnit = u = s != null ? s.getCompilationUnit() : null;
        if (s != null && !s.exists()) {
            s = null;
        }
        if (s != null && u != null && u.topLevelDefinitions.size() == 1 && !u.topLevelDefinitions.contains(namespaceURI, localPart)) {
            String realName = u.topLevelDefinitions.first().toString();
            this.sources.put(realName, s);
            s = null;
            u = null;
        }
        if ((s == null || (u == null || u.isDone()) && !s.isUpdated()) && s != null && u != null) {
            s = s.copy();
            if (!$assertionsDisabled && s == null) {
                throw new AssertionError();
            }
        }
        return s;
    }

    String[] checkClassNameFileName(Source s) {
        QName def;
        String defName = null;
        String pathName = null;
        if (s.getOwner() == this && (defName = (def = s.getCompilationUnit().topLevelDefinitions.last()).getLocalPart()).equals(pathName = s.getShortName())) {
            return null;
        }
        return new String[]{pathName, defName};
    }

    String[] checkPackageNameDirectoryName(Source s) {
        QName def;
        String defPackage = null;
        String pathPackage = null;
        if (s.getOwner() == this && (defPackage = NameFormatter.normalizePackageName((def = s.getCompilationUnit().topLevelDefinitions.last()).getNamespace())).equals(pathPackage = NameFormatter.toDot(s.getRelativePath(), '/'))) {
            return null;
        }
        return new String[]{pathPackage, defPackage};
    }

    private boolean isSupported(VirtualFile file) {
        int length = this.mimeTypes.length;
        for (int i = 0; i < length; ++i) {
            if (!this.mimeTypes[i].equals(file.getMimeType())) continue;
            return true;
        }
        return false;
    }

    List getPaths() {
        return this.directories;
    }

    String[] getMimeTypes() {
        return this.mimeTypes;
    }

    Collection sources() {
        return this.sources.values();
    }

    static {
        $assertionsDisabled = !SourceList.class.desiredAssertionStatus();
    }

    public static class UnsupportedFileType
    extends CompilerMessage.CompilerError {
        public final String name;

        public UnsupportedFileType(String name) {
            this.name = name;
        }
    }

    public static class FileNotInSourcePath
    extends CompilerMessage.CompilerError {
        public final String name;

        public FileNotInSourcePath(String name) {
            this.name = name;
        }
    }
}

