/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.css;

import flash.css.FontFaceRule;
import flash.css.Rule;
import flash.css.RuleList;
import flash.css.StyleRule;
import flash.css.StyleSheet;
import flash.fonts.FontManager;
import flex2.compiler.CompilationUnit;
import flex2.compiler.Context;
import flex2.compiler.Logger;
import flex2.compiler.Source;
import flex2.compiler.SymbolTable;
import flex2.compiler.Transcoder;
import flex2.compiler.as3.EmbedExtension;
import flex2.compiler.common.CompilerConfiguration;
import flex2.compiler.css.ConditionTypeNotSupported;
import flex2.compiler.css.ParseError;
import flex2.compiler.css.SelectorTypeNotSupported;
import flex2.compiler.css.StyleModule;
import flex2.compiler.io.FileUtil;
import flex2.compiler.io.LocalFile;
import flex2.compiler.io.TextFile;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.mxml.LogAdapter;
import flex2.compiler.mxml.SourceCodeBuffer;
import flex2.compiler.mxml.gen.VelocityUtil;
import flex2.compiler.mxml.lang.StandardDefs;
import flex2.compiler.mxml.lang.TextParser;
import flex2.compiler.mxml.rep.AtEmbed;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.DualModeLineNumberMap;
import flex2.compiler.util.LineNumberMap;
import flex2.compiler.util.ThreadLocalToolkit;
import flex2.compiler.util.VelocityException;
import flex2.compiler.util.VelocityManager;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.batik.css.parser.AbstractSelector;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.w3c.css.sac.AttributeCondition;
import org.w3c.css.sac.Condition;
import org.w3c.css.sac.ConditionalSelector;
import org.w3c.css.sac.ElementSelector;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SelectorList;

public class Compiler
implements flex2.compiler.Compiler {
    private static final String TEMPLATE_PATH = "flex2/compiler/css/";
    private static final String STYLE_MODULE_KEY = "styleModule";
    private static final String STYLE_MODULE_TEMPLATE = "flex2/compiler/css/StyleModule.vm";
    private static final String STYLE_LIBRARY_TEMPLATE = "flex2/compiler/css/StyleLibrary.vm";
    private static final String DELEGATE_UNIT = "DelegateUnit";
    private static final String LINE_NUMBER_MAP = "LineNumberMap";
    private String[] mimeTypes;
    private CompilerConfiguration configuration;
    private flex2.compiler.as3.Compiler asc;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Compiler(CompilerConfiguration configuration, Transcoder[] transcoders) {
        this.configuration = configuration;
        this.mimeTypes = new String[]{"text/css"};
        this.asc = new flex2.compiler.as3.Compiler(configuration);
        String gendir = configuration.keepGeneratedActionScript() ? configuration.getGeneratedDirectory() : null;
        this.asc.addCompilerExtension(new EmbedExtension(transcoders, gendir, configuration.showDeprecationWarnings()));
    }

    public boolean isSupported(String mimeType) {
        return this.mimeTypes[0].equals(mimeType);
    }

    private String generateStyleName(Source source) {
        int extension;
        String result = source.getName();
        int lastSeparator = result.lastIndexOf(File.separator);
        if (lastSeparator != -1 && (extension = (result = result.substring(lastSeparator + 1)).indexOf(".css")) != -1) {
            result = result.substring(0, extension);
        }
        return result;
    }

    public String[] getSupportedMimeTypes() {
        return this.mimeTypes;
    }

    public Source preprocess(Source source) {
        String componentName;
        if (!this.configuration.archiveClassesAndAssets()) {
            this.configuration.addExtern(StandardDefs.CLASS_CSSSTYLEDECLARATION);
            this.configuration.addExtern(StandardDefs.CLASS_DOWNLOADPROGRESSBAR);
            this.configuration.addExtern(StandardDefs.CLASS_FLEXEVENT);
            this.configuration.addExtern(StandardDefs.CLASS_FLEXSPRITE);
            this.configuration.addExtern(StandardDefs.CLASS_LOADERCONFIG);
            this.configuration.addExtern(StandardDefs.CLASS_MODULEEVENT);
            this.configuration.addExtern(StandardDefs.CLASS_MODULEMANAGER);
            this.configuration.addExtern(StandardDefs.CLASS_PRELOADER);
            this.configuration.addExtern(StandardDefs.CLASS_STYLEEVENT);
            this.configuration.addExtern(StandardDefs.CLASS_SYSTEMCHILDRENLIST);
            this.configuration.addExtern(StandardDefs.CLASS_SYSTEMMANAGER);
            this.configuration.addExtern(StandardDefs.CLASS_SYSTEMRAWCHILDRENLIST);
            this.configuration.addExtern(StandardDefs.INTERFACE_ICHILDLIST);
            this.configuration.addExtern(StandardDefs.INTERFACE_IFLEXDISPLAYOBJECT);
            this.configuration.addExtern(StandardDefs.INTERFACE_IFOCUSMANAGERCONTAINER);
            this.configuration.addExtern(StandardDefs.INTERFACE_IINVALIDATING);
            this.configuration.addExtern(StandardDefs.INTERFACE_ILAYOUTMANAGERCLIENT);
            this.configuration.addExtern(StandardDefs.INTERFACE_IMODULEINFO);
            this.configuration.addExtern(StandardDefs.INTERFACE_IRAWCHILDRENCONTAINER);
            this.configuration.addExtern(StandardDefs.INTERFACE_ISIMPLESTYLECLIENT);
            this.configuration.addExtern(StandardDefs.INTERFACE_ISTYLECLIENT);
            this.configuration.addExtern(StandardDefs.INTERFACE_ISYSTEMMANAGER);
            this.configuration.addExtern(StandardDefs.INTERFACE_IUICOMPONENT);
        }
        if (!TextParser.isValidIdentifier(componentName = source.getShortName())) {
            InvalidComponentName invalidComponentName = new InvalidComponentName(componentName);
            invalidComponentName.setPath(source.getNameForReporting());
            ThreadLocalToolkit.log(invalidComponentName);
        }
        return source;
    }

    public CompilationUnit parse1(Source source, SymbolTable symbolTable) {
        FontManager fontManager = this.configuration.getFontsConfiguration().getTopLevelManager();
        StyleSheet styleSheet = new StyleSheet();
        styleSheet.checkDeprecation(this.configuration.showDeprecationWarnings());
        try {
            styleSheet.parse(source.getName(), source.getInputStream(), (flash.css.Logger)ThreadLocalToolkit.getLogger(), fontManager);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            ParseError parseError = new ParseError(exception.getLocalizedMessage());
            parseError.setPath(source.getName());
            ThreadLocalToolkit.log(parseError);
            return null;
        }
        if (styleSheet.errorsExist()) {
            ThreadLocalToolkit.getLogger().log(new StyleSheetParseError(source.getName()));
        }
        String styleName = this.generateStyleName(source);
        StyleModule styleModule = new StyleModule(styleName, source, symbolTable.perCompileData);
        this.extractStyles(styleSheet, styleModule);
        Context context = new Context();
        CompilationUnit cssCompilationUnit = source.newCompilationUnit(null, context);
        VirtualFile generatedFile = this.generateSourceCodeFile(cssCompilationUnit, styleModule);
        Source generatedSource = new Source(generatedFile, source);
        Collection atEmbeds = styleModule.getAtEmbeds();
        if (atEmbeds != null && this.configuration.archiveClassesAndAssets()) {
            HashMap<String, LocalFile> archiveFiles = new HashMap<String, LocalFile>();
            Iterator i = atEmbeds.iterator();
            while (i.hasNext()) {
                AtEmbed e = (AtEmbed)i.next();
                String src = (String)e.getAttributes().get("source");
                String original = (String)e.getAttributes().get("original");
                if (src == null) continue;
                archiveFiles.put(original, new LocalFile(new File(src)));
            }
            if (archiveFiles.size() > 0) {
                context.setAttribute("CSSArchiveFiles", archiveFiles);
            }
        }
        Logger original = ThreadLocalToolkit.getLogger();
        DualModeLineNumberMap lineNumberMap = styleModule.getLineNumberMap();
        LogAdapter adapter = new LogAdapter(original, lineNumberMap);
        ThreadLocalToolkit.setLogger(adapter);
        CompilationUnit ascCompilationUnit = this.asc.parse1(generatedSource, symbolTable);
        if (ascCompilationUnit != null) {
            cssCompilationUnit.getSource().addFileIncludes(ascCompilationUnit.getSource());
            context.setAttribute(DELEGATE_UNIT, ascCompilationUnit);
            context.setAttribute(LINE_NUMBER_MAP, lineNumberMap);
            Source.transferMetaData(ascCompilationUnit, cssCompilationUnit);
            Source.transferGeneratedSources(ascCompilationUnit, cssCompilationUnit);
            Source.transferDefinitions(ascCompilationUnit, cssCompilationUnit);
            Source.transferInheritance(ascCompilationUnit, cssCompilationUnit);
        } else {
            cssCompilationUnit = null;
        }
        return cssCompilationUnit;
    }

    public void parse2(CompilationUnit unit, SymbolTable symbolTable) {
        CompilationUnit ascUnit = (CompilationUnit)unit.getContext().getAttribute(DELEGATE_UNIT);
        Source.transferInheritance(unit, ascUnit);
        Logger original = ThreadLocalToolkit.getLogger();
        LineNumberMap map = (LineNumberMap)unit.getContext().getAttribute(LINE_NUMBER_MAP);
        LogAdapter adapter = new LogAdapter(original, map);
        ThreadLocalToolkit.setLogger(adapter);
        this.asc.parse2(ascUnit, symbolTable);
        ThreadLocalToolkit.setLogger(original);
        Source.transferAssets(ascUnit, unit);
        Source.transferGeneratedSources(ascUnit, unit);
    }

    public void analyze1(CompilationUnit unit, SymbolTable symbolTable) {
        CompilationUnit ascUnit = (CompilationUnit)unit.getContext().getAttribute(DELEGATE_UNIT);
        Logger original = ThreadLocalToolkit.getLogger();
        LineNumberMap map = (LineNumberMap)unit.getContext().getAttribute(LINE_NUMBER_MAP);
        LogAdapter adapter = new LogAdapter(original, map);
        ThreadLocalToolkit.setLogger(adapter);
        this.asc.analyze1(ascUnit, symbolTable);
        ThreadLocalToolkit.setLogger(original);
        Source.transferTypeInfo(ascUnit, unit);
        Source.transferNamespaces(ascUnit, unit);
    }

    public void analyze2(CompilationUnit unit, SymbolTable symbolTable) {
        CompilationUnit ascUnit = (CompilationUnit)unit.getContext().getAttribute(DELEGATE_UNIT);
        Source.transferDependencies(unit, ascUnit);
        Logger original = ThreadLocalToolkit.getLogger();
        LineNumberMap map = (LineNumberMap)unit.getContext().getAttribute(LINE_NUMBER_MAP);
        LogAdapter adapter = new LogAdapter(original, map);
        ThreadLocalToolkit.setLogger(adapter);
        this.asc.analyze2(ascUnit, symbolTable);
        ThreadLocalToolkit.setLogger(original);
        Source.transferDependencies(ascUnit, unit);
    }

    public void analyze3(CompilationUnit unit, SymbolTable symbolTable) {
        CompilationUnit ascUnit = (CompilationUnit)unit.getContext().getAttribute(DELEGATE_UNIT);
        Source.transferDependencies(unit, ascUnit);
        Logger original = ThreadLocalToolkit.getLogger();
        LineNumberMap map = (LineNumberMap)unit.getContext().getAttribute(LINE_NUMBER_MAP);
        LogAdapter adapter = new LogAdapter(original, map);
        ThreadLocalToolkit.setLogger(adapter);
        this.asc.analyze3(ascUnit, symbolTable);
        ThreadLocalToolkit.setLogger(original);
    }

    public void analyze4(CompilationUnit unit, SymbolTable symbolTable) {
        CompilationUnit ascUnit = (CompilationUnit)unit.getContext().getAttribute(DELEGATE_UNIT);
        Logger original = ThreadLocalToolkit.getLogger();
        LineNumberMap map = (LineNumberMap)unit.getContext().getAttribute(LINE_NUMBER_MAP);
        LogAdapter adapter = new LogAdapter(original, map);
        ThreadLocalToolkit.setLogger(adapter);
        this.asc.analyze4(ascUnit, symbolTable);
        if (ThreadLocalToolkit.errorCount() > 0) {
            return;
        }
        ThreadLocalToolkit.setLogger(original);
        Source.transferExpressions(ascUnit, unit);
        Source.transferMetaData(ascUnit, unit);
        Source.transferLoaderClassBase(ascUnit, unit);
        Source.transferClassTable(ascUnit, unit);
        Source.transferStyles(ascUnit, unit);
    }

    public void extractStyles(StyleSheet styleSheet, StyleModule styleModule) {
        RuleList sheetRules = styleSheet.getCssRules();
        if (sheetRules != null) {
            Iterator ruleIterator = sheetRules.iterator();
            while (ruleIterator.hasNext()) {
                Rule rule = (Rule)ruleIterator.next();
                if (rule instanceof StyleRule) {
                    SelectorList selectors = ((StyleRule)rule).getSelectorList();
                    int nSelectors = selectors.getLength();
                    for (int i = 0; i < nSelectors; ++i) {
                        Selector selector = selectors.item(i);
                        int lineNumber = rule.getStyle().getLineNumber();
                        if (selector instanceof AbstractSelector) {
                            lineNumber = ((AbstractSelector)selector).getLineNumber();
                        }
                        if (selector.getSelectorType() == 0) {
                            Condition condition = ((ConditionalSelector)selector).getCondition();
                            if (condition.getConditionType() == 9) {
                                String name = ((AttributeCondition)condition).getValue();
                                if (!$assertionsDisabled && name == null) {
                                    throw new AssertionError((Object)"parsed CSS class selector name is null");
                                }
                                styleModule.addSelector(name, false, rule, lineNumber);
                                continue;
                            }
                            ConditionTypeNotSupported conditionTypeNotSupported = new ConditionTypeNotSupported(styleModule.getSource().getName(), lineNumber, condition.toString());
                            ThreadLocalToolkit.log(conditionTypeNotSupported);
                            continue;
                        }
                        if (selector.getSelectorType() == 4) {
                            String name = ((ElementSelector)selector).getLocalName();
                            if (name == null) continue;
                            styleModule.addSelector(name, true, rule, lineNumber);
                            continue;
                        }
                        SelectorTypeNotSupported selectorTypeNotSupported = new SelectorTypeNotSupported(styleModule.getSource().getName(), lineNumber, selector.toString());
                        ThreadLocalToolkit.log(selectorTypeNotSupported);
                    }
                    continue;
                }
                if (!(rule instanceof FontFaceRule)) continue;
                styleModule.addFontFaceRule((FontFaceRule)rule);
            }
        }
    }

    public void generate(CompilationUnit unit, SymbolTable symbolTable) {
        CompilationUnit ascUnit = (CompilationUnit)unit.getContext().getAttribute(DELEGATE_UNIT);
        Logger original = ThreadLocalToolkit.getLogger();
        DualModeLineNumberMap map = (DualModeLineNumberMap)unit.getContext().getAttribute(LINE_NUMBER_MAP);
        map.flushTemp();
        LogAdapter adapter = new LogAdapter(original, map);
        ThreadLocalToolkit.setLogger(adapter);
        this.asc.generate(ascUnit, symbolTable);
        if (ThreadLocalToolkit.errorCount() > 0) {
            return;
        }
        Source.transferGeneratedSources(ascUnit, unit);
        Source.transferBytecodes(ascUnit, unit);
    }

    private VirtualFile generateSourceCodeFile(CompilationUnit compilationUnit, StyleModule styleModule) {
        Template template;
        String templateName = !this.configuration.archiveClassesAndAssets() ? STYLE_MODULE_TEMPLATE : STYLE_LIBRARY_TEMPLATE;
        try {
            template = VelocityManager.getTemplate(templateName);
        }
        catch (Exception exception) {
            ThreadLocalToolkit.log(new VelocityException.TemplateNotFound(templateName));
            return null;
        }
        SourceCodeBuffer sourceCodeBuffer = new SourceCodeBuffer();
        String genFileName = this.configuration.getGeneratedDirectory() + File.separatorChar + styleModule.getName() + "-generated.as";
        Source source = compilationUnit.getSource();
        DualModeLineNumberMap lineNumberMap = new DualModeLineNumberMap(source.getNameForReporting(), genFileName);
        styleModule.setLineNumberMap(lineNumberMap);
        try {
            VelocityUtil velocityUtil = new VelocityUtil(TEMPLATE_PATH, this.configuration.debug(), sourceCodeBuffer, lineNumberMap);
            VelocityContext velocityContext = VelocityManager.getCodeGenContext(velocityUtil);
            velocityContext.put(STYLE_MODULE_KEY, (Object)styleModule);
            template.merge((org.apache.velocity.context.Context)velocityContext, (Writer)sourceCodeBuffer);
        }
        catch (Exception e) {
            ThreadLocalToolkit.log(new VelocityException.GenerateException(styleModule.getName(), e.getLocalizedMessage()));
            return null;
        }
        String sourceCode = sourceCodeBuffer.toString();
        if (this.configuration.keepGeneratedActionScript()) {
            try {
                FileUtil.writeFile(genFileName, sourceCode);
            }
            catch (IOException e) {
                ThreadLocalToolkit.log(new VelocityException.UnableToWriteGeneratedFile(genFileName, e.getLocalizedMessage()));
            }
        }
        return new TextFile(sourceCode, genFileName, null, "text/as", Long.MAX_VALUE);
    }

    public void postprocess(CompilationUnit unit, SymbolTable symbolTable) {
    }

    static {
        $assertionsDisabled = !Compiler.class.desiredAssertionStatus();
    }

    public static class StyleSheetParseError
    extends CompilerMessage.CompilerError {
        public final String stylePath;

        public StyleSheetParseError(String stylePath) {
            this.stylePath = stylePath;
        }
    }

    public static class InvalidComponentName
    extends CompilerMessage.CompilerError {
        public final String name;

        public InvalidComponentName(String name) {
            this.name = name;
        }
    }
}

