/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.css;

import flex2.compiler.Source;
import flex2.compiler.abc.MetaData;
import flex2.compiler.css.StyleConflictException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class Styles {
    private static final String FORMAT = "format";
    private static final String COLOR = "Color";
    private static final String INHERIT = "inherit";
    private static final String YES = "yes";
    private Map declMap;
    private Map locationMap;

    public Styles(int preferredSize) {
        this.declMap = new HashMap(preferredSize);
        this.locationMap = new HashMap(preferredSize);
    }

    public Styles() {
        this(16);
    }

    public int size() {
        return this.declMap.size();
    }

    public void addStyle(String name, MetaData md, Source source) throws StyleConflictException {
        if (Styles.isInherit(md) ? this.isNonInheritingStyle(name) : this.isInheritingStyle(name)) {
            throw new StyleConflictException(name, (Source)this.locationMap.get(name));
        }
        this.declMap.put(name, md);
        this.locationMap.put(name, source);
    }

    public void addStyles(Styles styles) throws StyleConflictException {
        Iterator i = styles.declMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            String name = (String)e.getKey();
            this.addStyle(name, (MetaData)e.getValue(), styles.getLocation(name));
        }
    }

    public Source getLocation(String name) {
        return (Source)this.locationMap.get(name);
    }

    public MetaData getStyle(String name) {
        return (MetaData)this.declMap.get(name);
    }

    public boolean isInheritingStyle(String name) {
        MetaData md = this.getStyle(name);
        return md != null && Styles.isInherit(md);
    }

    public boolean isNonInheritingStyle(String name) {
        MetaData md = this.getStyle(name);
        return md != null && !Styles.isInherit(md);
    }

    private static boolean isInherit(MetaData md) {
        String inherit = md.getValue(INHERIT);
        return inherit != null && YES.equals(inherit);
    }

    public Iterator getStyleNames() {
        return this.declMap.keySet().iterator();
    }

    public Set getInheritingStyles() {
        HashSet<String> result = new HashSet<String>();
        Iterator iterator = this.getStyleNames();
        while (iterator.hasNext()) {
            String styleName = (String)iterator.next();
            if (!this.isInheritingStyle(styleName)) continue;
            result.add(styleName);
        }
        return result;
    }

    public void clear() {
        this.declMap.clear();
    }
}

