/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.mxml.builder;

import flex2.compiler.CompilationUnit;
import flex2.compiler.mxml.Configuration;
import flex2.compiler.mxml.builder.Builder;
import flex2.compiler.mxml.dom.BooleanNode;
import flex2.compiler.mxml.dom.CDATANode;
import flex2.compiler.mxml.dom.ClassNode;
import flex2.compiler.mxml.dom.FunctionNode;
import flex2.compiler.mxml.dom.IntNode;
import flex2.compiler.mxml.dom.NumberNode;
import flex2.compiler.mxml.dom.PrimitiveNode;
import flex2.compiler.mxml.dom.StringNode;
import flex2.compiler.mxml.dom.UIntNode;
import flex2.compiler.mxml.lang.BindingHandler;
import flex2.compiler.mxml.reflect.Type;
import flex2.compiler.mxml.reflect.TypeTable;
import flex2.compiler.mxml.rep.BindingExpression;
import flex2.compiler.mxml.rep.Model;
import flex2.compiler.mxml.rep.MxmlDocument;
import flex2.compiler.mxml.rep.Primitive;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.NameFormatter;

class PrimitiveBuilder
extends Builder {
    protected boolean topLevel;
    protected BindingHandler bindingHandler;
    Primitive value;

    PrimitiveBuilder(CompilationUnit unit, TypeTable typeTable, Configuration configuration, MxmlDocument document, boolean topLevel, BindingHandler bindingHandler) {
        super(unit, typeTable, configuration, document);
        this.topLevel = topLevel;
        this.bindingHandler = bindingHandler;
    }

    public void analyze(StringNode node) {
        this.processPrimitiveEntry(node);
    }

    public void analyze(NumberNode node) {
        this.processPrimitiveEntry(node);
    }

    public void analyze(IntNode node) {
        this.processPrimitiveEntry(node);
    }

    public void analyze(UIntNode node) {
        this.processPrimitiveEntry(node);
    }

    public void analyze(BooleanNode node) {
        this.processPrimitiveEntry(node);
    }

    public void analyze(ClassNode node) {
        this.processPrimitiveEntry(node);
    }

    public void analyze(FunctionNode node) {
        this.processPrimitiveEntry(node);
    }

    private void processPrimitiveEntry(PrimitiveNode node) {
        Type type = this.nodeTypeResolver.resolveType(node);
        Primitive primitive = this.initPrimitiveValue(type, node);
        CDATANode cdata = this.getTextContent(node.getChildren(), false);
        if (cdata != null) {
            this.processTextInitializer(cdata.image, type, cdata.inCDATA, cdata.beginLine);
        } else if (!this.topLevel) {
            if (this.typeTable.stringType.isAssignableTo(type)) {
                this.processTextInitializer("", type, true, node.beginLine);
            } else {
                this.log(node.beginLine, (CompilerMessage)new InitializerRequired());
            }
        }
        String id = (String)node.getAttribute("id");
        if (id != null || this.topLevel) {
            if (primitive.getValue() != null) {
                this.registerModel(node, (Model)primitive, this.topLevel);
            } else {
                boolean autogenerated = false;
                if (id == null) {
                    autogenerated = true;
                    id = primitive.getId();
                }
                this.document.addDeclaration(id, type.getName(), node.beginLine, true, this.topLevel, autogenerated);
            }
        }
    }

    private Primitive initPrimitiveValue(Type type, PrimitiveNode node) {
        Primitive primitive = new Primitive(this.document, type, node.beginLine);
        primitive.setInspectable(true);
        this.value = primitive;
        return primitive;
    }

    public void processTextInitializer(String text, Type type, boolean cdata, int line) {
        int flags = cdata ? 1 : 0;
        Object result = this.textParser.parseValue(text, type, flags, line, NameFormatter.toDot(type.getName()));
        if (result != null) {
            if (result instanceof BindingExpression) {
                if (this.bindingHandler != null) {
                    this.bindingHandler.invoke((BindingExpression)result, this.value);
                } else {
                    this.log(new Builder.BindingNotAllowed());
                }
            }
            this.value.setValue(result);
        }
    }

    public static class InitializerRequired
    extends CompilerMessage.CompilerError {
    }
}

