/*
 * Decompiled with CFR 0.152.
 */
package flex.webtier.server.j2ee.cache;

import com.opensymphony.oscache.base.Cache;
import com.opensymphony.oscache.base.CacheEntry;
import com.opensymphony.oscache.base.EntryRefreshPolicy;
import flex.webtier.server.j2ee.IncrementalCompileFilter;
import flex.webtier.server.j2ee.SWFInfo;
import flex.webtier.server.j2ee.cache.CacheHelper;

public class CacheEntryRefreshPolicy
implements EntryRefreshPolicy {
    static final long serialVersionUID = 1526067755123821662L;
    private boolean incremental;
    private String key;
    private CacheHelper ch;
    private Cache cache;

    public void init(CacheHelper ch, Cache cache, String key, boolean incremental) {
        this.ch = ch;
        this.cache = cache;
        this.key = key;
        this.incremental = incremental;
    }

    public boolean needsRefresh(CacheEntry entry) {
        boolean recompile = false;
        SWFInfo swfInfo = (SWFInfo)entry.getContent();
        if (this.cache.isFlushed(entry)) {
            recompile = true;
        } else if (this.ch.needsRecompile(this.key, swfInfo.getLastModified())) {
            if (this.incremental) {
                IncrementalCompileFilter.targetThreadLocal.set(swfInfo.getTarget());
            }
            recompile = true;
        } else {
            recompile = false;
        }
        return recompile;
    }
}

