/*
 * Decompiled with CFR 0.152.
 */
package flex.webtier.server.j2ee.html;

import flex.webtier.server.j2ee.MxmlContext;
import flex.webtier.server.j2ee.URLEncoder;
import flex.webtier.server.j2ee.cache.CacheKeyUtils;
import flex.webtier.server.j2ee.html.HistoryRenderer;
import flex.webtier.services.ServiceFactory;
import flex.webtier.services.config.FlashPlayerConfiguration;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class BaseSwfRenderer {
    protected FlashPlayerConfiguration configuration = ServiceFactory.getConfigurator().getServerConfiguration().getFlashPlayerConfiguration();

    protected String getSwfWebPath(MxmlContext context) {
        String swfUri = context.getSwfUri();
        String fullUri = swfUri.startsWith("/") ? context.getRequest().getContextPath() + swfUri : swfUri;
        String encodedSwfUri = this.encodeSrcUrl(fullUri);
        return encodedSwfUri;
    }

    protected String getSwfId(MxmlContext context) {
        String swfId = context.getSwfId();
        if (swfId == null) {
            swfId = context.getSwfUri();
            if (swfId.lastIndexOf("/") != -1) {
                swfId = swfId.substring(swfId.lastIndexOf("/") + 1);
            }
            if (swfId.indexOf(".") != -1) {
                swfId = swfId.substring(0, swfId.indexOf("."));
            }
        }
        return swfId;
    }

    protected String getPluginDownloadUrl(boolean isSecure) {
        String plugin = isSecure ? this.configuration.getPluginDownloadHttpsUrl() : this.configuration.getPluginDownloadUrl();
        return plugin;
    }

    protected String getActivexDownloadUrl(boolean isSecure) {
        String activexDownloadUrl = isSecure ? this.configuration.getCodebaseHttps() + this.configuration.getCodebaseVersion() : this.configuration.getCodebase() + this.configuration.getCodebaseVersion();
        return activexDownloadUrl;
    }

    protected String getActivexCodebase(boolean isSecure) {
        String codebase = isSecure ? this.configuration.getCodebaseHttps() : this.configuration.getCodebase();
        return codebase;
    }

    protected String getFlashVars(MxmlContext context, boolean history) {
        Map parameterMap;
        Map additionalFlashVars;
        StringBuffer sb = new StringBuffer();
        if (history) {
            HistoryRenderer historyRenderer = new HistoryRenderer(context);
            sb.append(historyRenderer.renderHistoryFlashVars(context));
        }
        if ((additionalFlashVars = context.getFlashVars()) != null && additionalFlashVars.entrySet() != null) {
            Set entrySet = additionalFlashVars.entrySet();
            Iterator i = entrySet.iterator();
            while (i != null && i.hasNext()) {
                Map.Entry entry = i.next();
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (sb.length() > 0) {
                    sb.append("&");
                }
                sb.append(URLEncoder.encode(key));
                if (value == null || value.equals("")) continue;
                sb.append("=");
                sb.append(URLEncoder.encode(value));
            }
        }
        if ((parameterMap = context.getRequest().getParameterMap()) != null && parameterMap.keySet() != null) {
            Set keySet = parameterMap.keySet();
            Iterator i = keySet.iterator();
            while (i != null && i.hasNext()) {
                String key = (String)i.next();
                String value = context.getRequest().getParameter(key);
                if (CacheKeyUtils.isCompilerDirective(key) || key.equals("objectWrapperJs") || key.equals("versionChecked") || key.equals("h") || key.equals("w")) continue;
                if (sb.length() > 0) {
                    sb.append("&");
                }
                sb.append(URLEncoder.encode(key));
                if (value == null || value.equals("")) continue;
                sb.append("=");
                sb.append(URLEncoder.encode(value));
            }
        }
        return sb.toString();
    }

    protected String encodeSrcUrl(String fullUri) {
        try {
            int length = fullUri.length();
            StringBuffer buf = new StringBuffer(length);
            for (int i = 0; i < length; ++i) {
                char c = fullUri.charAt(i);
                if (c <= '\u007f') {
                    buf.append(c);
                    continue;
                }
                byte[] bytes = fullUri.substring(i, i + 1).getBytes("UTF-8");
                for (int j = 0; j < bytes.length; ++j) {
                    int b = bytes[j] & 0xFF;
                    buf.append('%');
                    if (b < 16) {
                        buf.append('0');
                    }
                    buf.append(Integer.toHexString(b));
                }
            }
            return buf.toString();
        }
        catch (UnsupportedEncodingException e) {
            return fullUri;
        }
    }
}

