/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.agl.converters;

import com.adobe.agl.common.ErrorCode;
import com.adobe.agl.converters.UConverter;
import com.adobe.agl.converters.UErrorCode;
import com.adobe.agl.impl.UConverterUTF16;

public final class NativeConverter {
    public static final int STOP_CALLBACK = 0;
    public static final int SKIP_CALLBACK = 1;
    public static final int SUBSTITUTE_CALLBACK = 3;

    public static final int convertByteToChar(UConverter converterHandle, byte[] input, int inEnd, char[] output, int outEnd, int[] data, boolean flush) {
        int[] errorCode = new int[]{0};
        int[] inputBegin = new int[]{data[0]};
        int[] outputBegin = new int[]{data[1]};
        converterHandle.ucnv_toUnicode(output, outputBegin, outEnd, input, inputBegin, inEnd, flush, errorCode);
        data[0] = inputBegin[0] - data[0];
        data[1] = outputBegin[0] - data[1];
        return errorCode[0];
    }

    public static final int decode(UConverter converterHandle, byte[] input, int inEnd, char[] output, int outEnd, int[] data, boolean flush) {
        int[] ec = new int[]{NativeConverter.convertByteToChar(converterHandle, input, inEnd, output, outEnd, data, flush)};
        if (ec[0] == 12 || ec[0] == 10) {
            int[] errorCode = new int[]{0};
            if (converterHandle != null) {
                int[] myData = data;
                char[] invalidUChars = new char[32];
                int[] len = new int[]{invalidUChars.length};
                converterHandle.ucnv_getInvalidUChars(invalidUChars, len, errorCode);
                myData[2] = len[0];
            } else {
                ec[0] = 1;
            }
        }
        return ec[0];
    }

    public static final int convertCharToByte(UConverter converterHandle, char[] input, int inEnd, byte[] output, int outEnd, int[] data, boolean flush) {
        int[] errorCode = new int[]{0};
        int[] inputBegin = new int[]{data[0]};
        int[] outputBegin = new int[]{data[1]};
        converterHandle.ucnv_fromUnicode(output, outputBegin, outEnd, input, inputBegin, inEnd, flush, errorCode);
        data[0] = inputBegin[0] - data[0];
        data[1] = outputBegin[0] - data[1];
        return errorCode[0];
    }

    public static final int encode(UConverter converterHandle, char[] input, int inEnd, byte[] output, int outEnd, int[] data, boolean flush) {
        int[] ec = new int[]{NativeConverter.convertCharToByte(converterHandle, input, inEnd, output, outEnd, data, flush)};
        if (ec[0] == 12 || ec[0] == 10) {
            int[] myData = data;
            UConverter cnv = converterHandle;
            char[] invalidUChars = new char[32];
            int[] count = new int[]{invalidUChars.length};
            int[] err = new int[]{0};
            cnv.ucnv_getInvalidUChars(invalidUChars, count, err);
            myData[2] = count[0];
        }
        return ec[0];
    }

    public static final int flushCharToByte(UConverter converterHandle, byte[] output, int outEnd, int[] data) {
        int[] errorCode = new int[]{0};
        if (converterHandle != null) {
            char[] source = new char[]{'\u0000'};
            if (data != null) {
                if (output != null) {
                    int[] sourceBegin = new int[]{0};
                    int sourceLimit = 0;
                    int[] outBegin = new int[]{data[1]};
                    converterHandle.ucnv_fromUnicode(output, outBegin, outEnd, source, sourceBegin, sourceLimit, true, errorCode);
                    data[1] = outBegin[0] - data[1];
                } else {
                    errorCode[0] = 1;
                }
            } else {
                errorCode[0] = 1;
            }
            return errorCode[0];
        }
        errorCode[0] = 1;
        return errorCode[0];
    }

    public static final int flushByteToChar(UConverter converterHandle, char[] output, int outEnd, int[] data) {
        int[] errorCode = new int[]{0};
        if (converterHandle != null) {
            byte[] source = new byte[]{0};
            if (data != null) {
                if (output != null) {
                    int[] sourceBegin = new int[]{0};
                    int sourceLimit = 0;
                    int[] outBegin = new int[]{data[1]};
                    converterHandle.ucnv_toUnicode(output, outBegin, outEnd, source, sourceBegin, sourceLimit, true, errorCode);
                    data[1] = outBegin[0] - data[1];
                } else {
                    errorCode[0] = 1;
                }
            } else {
                errorCode[0] = 1;
            }
            return errorCode[0];
        }
        errorCode[0] = 1;
        return errorCode[0];
    }

    public static final int openConverter(UConverter[] converterHandle, String encoding) {
        int[] errorCode = new int[]{0};
        converterHandle[0] = UConverter.ucnv_open(encoding, errorCode);
        return errorCode[0];
    }

    public static final void resetByteToChar(UConverter converterHandle) {
        if (converterHandle != null) {
            converterHandle.ucnv_resetToUnicode();
        }
    }

    public static final void resetCharToByte(UConverter converterHandle) {
        if (converterHandle != null) {
            converterHandle.ucnv_resetFromUnicode();
        }
    }

    public static final void closeConverter(UConverter converterHandle) {
        if (converterHandle != null) {
            converterHandle.ucnv_close();
        }
    }

    private static final int setToUCallbackSubs(UConverter cnv, char[] subChars, int length, boolean stopOnIllegal) {
        return 0;
    }

    public static final int setSubstitutionChars(UConverter converterHandle, char[] subChars, int length) {
        int[] errorCode = new int[]{0};
        if (converterHandle != null) {
            if (subChars != null) {
                errorCode[0] = NativeConverter.setToUCallbackSubs(converterHandle, subChars, length, false);
            } else {
                converterHandle.ucnv_setToUCallBack(new UConverter.UCNV_TO_U_CALLBACK_STOP(), null, null, null, errorCode);
            }
            return errorCode[0];
        }
        errorCode[0] = 1;
        return errorCode[0];
    }

    public static final int setSubstitutionBytes(UConverter converterHandle, byte[] subChars, int length) {
        int[] errorCode = new int[]{0};
        UConverter cnv = converterHandle;
        byte[] u_subChars = subChars;
        if (cnv != null) {
            if (u_subChars != null) {
                byte[] mySubChars = u_subChars;
                cnv.ucnv_setSubstChars(mySubChars, (byte)length, errorCode);
                if (UErrorCode.U_FAILURE(errorCode[0])) {
                    return errorCode[0];
                }
            } else {
                errorCode[0] = 1;
            }
            return errorCode[0];
        }
        errorCode[0] = 1;
        return errorCode[0];
    }

    public static final int setSubstitutionModeCharToByte(UConverter converterHandle, boolean mode) {
        int[] errorCode = new int[]{0};
        UConverter conv = converterHandle;
        if (conv != null) {
            UConverter.UConverterFromUCallback[] fromUOldAction = new UConverter.UConverterFromUCallback[1];
            byte[][] fromUOldContext = new byte[1][];
            byte[] fromUNewContext = null;
            if (mode) {
                conv.ucnv_setFromUCallBack(new UConverter.UCNV_FROM_U_CALLBACK_SUBSTITUTE(), fromUNewContext, fromUOldAction, fromUOldContext, errorCode);
            } else {
                conv.ucnv_setFromUCallBack(new UConverter.UCNV_FROM_U_CALLBACK_STOP(), fromUNewContext, fromUOldAction, fromUOldContext, errorCode);
            }
            return errorCode[0];
        }
        errorCode[0] = 1;
        return errorCode[0];
    }

    public static final int countInvalidBytes(UConverter converterHandle, int[] length) {
        UConverter cnv = converterHandle;
        int[] errorCode = new int[]{0};
        if (cnv != null) {
            byte[] invalidChars = new byte[32];
            int[] len = length;
            if (len != null) {
                cnv.ucnv_getInvalidChars(invalidChars, len, errorCode);
            }
            return errorCode[0];
        }
        errorCode[0] = 1;
        return errorCode[0];
    }

    public static final int countInvalidChars(UConverter converterHandle, int[] length) {
        int[] errorCode = new int[]{0};
        UConverter cnv = converterHandle;
        char[] invalidUChars = new char[32];
        if (cnv != null) {
            int[] len = length;
            if (len != null) {
                cnv.ucnv_getInvalidUChars(invalidUChars, len, errorCode);
            }
            return errorCode[0];
        }
        errorCode[0] = 1;
        return errorCode[0];
    }

    public static final int getMaxBytesPerChar(UConverter converterHandle) {
        return converterHandle.ucnv_getMaxCharSize();
    }

    public static final float getAveBytesPerChar(UConverter converterHandle) {
        if (converterHandle != null) {
            float max = converterHandle.ucnv_getMaxCharSize();
            float min = converterHandle.ucnv_getMinCharSize();
            return (max + min) / 2.0f;
        }
        return -1.0f;
    }

    public static final int getMaxCharsPerByte(UConverter converterHandle) {
        if (converterHandle != null) {
            return converterHandle.ucnv_getMaxCharSize();
        }
        return -1;
    }

    public static final float getAveCharsPerByte(UConverter converterHandle) {
        float v = 0.0f;
        if (converterHandle != null) {
            v = 1.0f / (float)NativeConverter.getMaxCharsPerByte(converterHandle);
        }
        return v;
    }

    public static final byte[] getSubstitutionBytes(UConverter converterHandle) {
        UConverter cnv = converterHandle;
        int[] status = new int[]{0};
        byte[] subBytes = new byte[10];
        byte[] len = new byte[]{10};
        if (cnv != null) {
            cnv.ucnv_getSubstChars(subBytes, len, status);
            if (ErrorCode.isSuccess(status[0])) {
                byte[] arr = new byte[len[0]];
                System.arraycopy(subBytes, 0, arr, 0, len[0]);
                return arr;
            }
        }
        return new byte[0];
    }

    public static final boolean canEncode(UConverter converterHandle, int codeUnit) {
        int[] errorCode = new int[]{0};
        if (converterHandle != null) {
            char[] source = new char[3];
            int[] mySource = new int[]{0};
            int sourceLimit = codeUnit < 65536 ? 1 : 2;
            byte[] target = new byte[5];
            int[] myTarget = new int[]{0};
            int targetLimit = 4;
            int[] i = new int[]{0};
            UConverterUTF16.U16_APPEND(source, i, 2, codeUnit, null);
            converterHandle.ucnv_fromUnicode(target, myTarget, targetLimit, source, mySource, sourceLimit, true, errorCode);
            if (UErrorCode.U_SUCCESS(errorCode[0])) {
                return true;
            }
        }
        return false;
    }

    public static final boolean canDecode(UConverter converterHandle, byte[] bytes) {
        int[] errorCode = new int[]{0};
        UConverter cnv = converterHandle;
        if (cnv != null) {
            int len = bytes.length;
            byte[] cSource = bytes;
            if (cSource != null) {
                int cSourceLimit = len;
                char[] target = new char[2 * len];
                int[] targetBegin = new int[]{0};
                int targetLimit = 2 * len;
                int[] cSourceBegin = new int[]{0};
                converterHandle.ucnv_toUnicode(target, targetBegin, targetLimit, cSource, cSourceBegin, cSourceLimit, true, errorCode);
                if (UErrorCode.U_SUCCESS(errorCode[0])) {
                    return true;
                }
            }
        }
        return false;
    }

    public static final int countAvailable() {
        return UConverter.ucnv_countAvailable();
    }

    public static final String[] getAvailable() {
        int i = UConverter.ucnv_countAvailable();
        int[] error = new int[]{0};
        String[] ret = new String[i];
        while (--i >= 0) {
            String name = UConverter.ucnv_getAvailableName(i);
            if (name.indexOf(44) != -1) {
                name = UConverter.ucnv_getAlias(name, 1, error);
            }
            ret[i] = name;
        }
        return ret;
    }

    public static final int countAliases(String enc) {
        int num = 0;
        int[] error = new int[]{0};
        if (enc != null) {
            num = UConverter.ucnv_countAliases(enc, error);
        }
        return num;
    }

    public static final String[] getAliases(String encName) {
        String[] ret = null;
        int aliasNum = 0;
        int[] error = new int[]{0};
        int i = 0;
        int j = 0;
        String[] aliasArray = new String[50];
        if (encName != null) {
            aliasNum = UConverter.ucnv_countAliases(encName, error);
            if (UErrorCode.U_SUCCESS(error[0])) {
                j = 0;
                for (i = 0; i < aliasNum; ++i) {
                    String name = UConverter.ucnv_getAlias(encName, i, error);
                    if (name.indexOf(43) != -1 || name.indexOf(44) != -1) continue;
                    aliasArray[j++] = name;
                }
                ret = new String[j];
                while (--j >= 0) {
                    ret[j] = aliasArray[j];
                }
            }
        }
        return ret;
    }

    public static final String getCanonicalName(String enc) {
        int[] error = new int[]{0};
        String ret = "";
        if (enc != null) {
            String canonicalName = UConverter.ucnv_getAlias(enc, 0, error);
            if (canonicalName != null) {
                if (canonicalName.indexOf(",") != -1) {
                    canonicalName = UConverter.ucnv_getAlias(canonicalName, 1, error);
                }
                ret = canonicalName;
            } else {
                ret = "";
            }
        }
        return ret;
    }

    /*
     * WARNING - void declaration
     */
    public static final int setCallbackDecode(UConverter converterHandle, int mode, boolean stopOnIllegal) {
        UConverter conv = converterHandle;
        int[] errorCode = new int[]{0};
        if (conv != null) {
            void var8_8;
            UConverter.UConverterToUCallback[] toUOldAction = new UConverter.UConverterToUCallback[1];
            byte[][] toUOldContext = new byte[1][];
            byte[] toUNewContext = null;
            switch (mode) {
                default: {
                    UConverter.UConverterToUCallback newAction = new UConverter.UCNV_TO_U_CALLBACK_STOP();
                    break;
                }
                case 1: {
                    UConverter.UConverterToUCallback newAction = new UConverter.UCNV_TO_U_CALLBACK_SKIP();
                    if (!stopOnIllegal) break;
                    toUNewContext = UConverter.UCNV_SUB_STOP_ON_ILLEGAL;
                    break;
                }
                case 3: {
                    return NativeConverter.setToUCallbackSubs(conv, null, 0, stopOnIllegal);
                }
            }
            conv.ucnv_setToUCallBack((UConverter.UConverterToUCallback)var8_8, toUNewContext, toUOldAction, toUOldContext, errorCode);
            return errorCode[0];
        }
        errorCode[0] = 1;
        return errorCode[0];
    }

    public static final int setCallbackEncode(UConverter converterHandle, int mode, boolean stopOnIllegal) {
        UConverter conv = converterHandle;
        int[] errorCode = new int[]{0};
        if (conv != null) {
            UConverter.UConverterFromUCallback newAction;
            UConverter.UConverterFromUCallback[] fromUOldAction = new UConverter.UConverterFromUCallback[1];
            byte[][] fromUOldContext = new byte[1][];
            byte[] fromUNewContext = null;
            switch (mode) {
                default: {
                    newAction = new UConverter.UCNV_FROM_U_CALLBACK_STOP();
                    break;
                }
                case 1: {
                    newAction = new UConverter.UCNV_FROM_U_CALLBACK_SKIP();
                    if (!stopOnIllegal) break;
                    fromUNewContext = UConverter.UCNV_SUB_STOP_ON_ILLEGAL;
                    break;
                }
                case 3: {
                    newAction = new UConverter.UCNV_FROM_U_CALLBACK_SUBSTITUTE();
                    if (!stopOnIllegal) break;
                    fromUNewContext = UConverter.UCNV_SUB_STOP_ON_ILLEGAL;
                }
            }
            conv.ucnv_setFromUCallBack(newAction, fromUNewContext, fromUOldAction, fromUOldContext, errorCode);
            return errorCode[0];
        }
        errorCode[0] = 1;
        return errorCode[0];
    }

    public static boolean isValidSubstitutionBytes(String enc, byte[] sub) {
        boolean isvalid = false;
        int[] err = new int[]{0};
        UConverter cnv = UConverter.ucnv_open(enc, err);
        if (cnv != null) {
            err[0] = 0;
            cnv.ucnv_isValidSubstChars(sub, err);
            if (UErrorCode.U_SUCCESS(err[0])) {
                isvalid = true;
            }
        }
        return isvalid;
    }

    public static final int safeClone(UConverter converterHandle, UConverter[] handleArr) {
        int[] errorCode = new int[]{0};
        return errorCode[0];
    }
}

