/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.agl.impl;

import com.adobe.agl.impl.ICUDebug;
import com.adobe.agl.impl.ICUListResourceBundle;
import com.adobe.agl.impl.LocaleUtility;
import com.adobe.agl.util.ULocale;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;

public class ICULocaleData {
    private static final String ICU_PACKAGE = "com.adobe.agl.impl.data";
    static final String LOCALE_ELEMENTS = "LocaleElements";
    private static final boolean DEBUG = ICUDebug.enabled("localedata");
    private static SoftReference GET_AVAILABLE_CACHE;
    private static SoftReference BUNDLE_CACHE;

    public static ResourceBundle getLocaleElements(ULocale locale) {
        if (locale == null) {
            locale = ULocale.getDefault();
        }
        return ICULocaleData.getResourceBundle(ICU_PACKAGE, LOCALE_ELEMENTS, locale.getBaseName());
    }

    public static ResourceBundle getLocaleElements(String localeName) {
        return ICULocaleData.getResourceBundle(ICU_PACKAGE, LOCALE_ELEMENTS, localeName);
    }

    public static ResourceBundle getResourceBundle(String bundleName, String localeName) {
        return ICULocaleData.getResourceBundle(ICU_PACKAGE, bundleName, localeName);
    }

    public static ResourceBundle getResourceBundle(String bundleName, ULocale locale) {
        if (locale == null) {
            locale = ULocale.getDefault();
        }
        return ICULocaleData.getResourceBundle(ICU_PACKAGE, bundleName, locale.getBaseName());
    }

    public static ResourceBundle getResourceBundle(String packageName, String bundleName, String localeName) {
        try {
            String path = packageName + "." + bundleName;
            if (DEBUG) {
                System.out.println("calling instantiate: " + path + "_" + localeName);
            }
            return ICULocaleData.instantiate(path, localeName);
        }
        catch (MissingResourceException e) {
            if (DEBUG) {
                System.out.println(bundleName + "_" + localeName + " not found in " + packageName);
            }
            throw e;
        }
    }

    public static ResourceBundle getResourceBundle(String[] packages, String bundleName, String localeName) {
        ResourceBundle r = null;
        for (int i = 0; r == null && i < packages.length; ++i) {
            r = ICULocaleData.getResourceBundle(packages[i], bundleName, localeName);
        }
        return r;
    }

    public static ResourceBundle loadResourceBundle(String bundleName, ULocale locale) {
        if (locale == null) {
            locale = ULocale.getDefault();
        }
        return ICULocaleData.loadResourceBundle(bundleName, locale.getBaseName());
    }

    public static ResourceBundle loadResourceBundle(String bundleName, String localeName) {
        block7: {
            if (localeName != null && localeName.length() > 0) {
                bundleName = bundleName + "_" + localeName;
            }
            String name = "com.adobe.agl.impl.data." + bundleName;
            try {
                if (name.indexOf("_zh_") == -1) {
                    Class<?> rbclass = Class.forName(name);
                    ResourceBundle rb = (ResourceBundle)rbclass.newInstance();
                    return rb;
                }
            }
            catch (ClassNotFoundException e) {
                if (DEBUG) {
                    System.out.println(name + " not found");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (!DEBUG) break block7;
                System.out.println(e.getMessage());
            }
        }
        if (DEBUG) {
            System.out.println(bundleName + " not found.");
        }
        return null;
    }

    private static ResourceBundle loadFromCache(String key) {
        Map m;
        if (BUNDLE_CACHE != null && (m = (Map)BUNDLE_CACHE.get()) != null) {
            return (ResourceBundle)m.get(key);
        }
        return null;
    }

    private static void addToCache(String key, ResourceBundle b) {
        HashMap<String, ResourceBundle> m = null;
        if (BUNDLE_CACHE != null) {
            m = (HashMap<String, ResourceBundle>)BUNDLE_CACHE.get();
        }
        if (m == null) {
            m = new HashMap<String, ResourceBundle>();
            BUNDLE_CACHE = new SoftReference(m);
        }
        m.put(key, b);
    }

    private static ResourceBundle instantiate(String name) {
        ResourceBundle b = ICULocaleData.loadFromCache(name);
        if (b == null) {
            ResourceBundle parent = null;
            int i = name.lastIndexOf(95);
            Locale rootLocale = new Locale("", "", "");
            if (i != -1) {
                parent = ICULocaleData.instantiate(name.substring(0, i));
            }
            try {
                Locale locale = rootLocale;
                i = name.indexOf(95);
                if (i != -1) {
                    locale = LocaleUtility.getLocaleFromName(name.substring(i + 1));
                } else {
                    i = name.length();
                }
                Class<?> cls = ICULocaleData.class.getClassLoader().loadClass(name);
                if (ICUListResourceBundle.class.isAssignableFrom(cls)) {
                    ICUListResourceBundle bx = (ICUListResourceBundle)cls.newInstance();
                    if (parent != null) {
                        bx.setParentX(parent);
                    }
                    bx.icuLocale = locale;
                    b = bx;
                } else {
                    b = ResourceBundle.getBundle(name.substring(0, i), locale);
                }
                ICULocaleData.addToCache(name, b);
            }
            catch (ClassNotFoundException e) {
                int j = name.indexOf(95);
                int k = name.lastIndexOf(95);
                if (k == j && j != -1) {
                    String locName = name.substring(j + 1, name.length());
                    String defaultName = ULocale.getDefault().toString();
                    if (!locName.equals(rootLocale.toString()) && defaultName.indexOf(locName) == -1) {
                        String bundle = name.substring(0, j);
                        parent = ICULocaleData.instantiate(bundle + "_" + defaultName);
                    }
                }
                b = parent;
            }
            catch (Exception e) {
                System.out.println("failure");
                System.out.println(e);
            }
        }
        return b;
    }

    private static synchronized ResourceBundle instantiate(String name, String localeName) {
        if (localeName.length() != 0) {
            name = name + "_" + localeName;
        }
        return ICULocaleData.instantiate(name);
    }

    private static Set createLocaleNameSet(String bundleName) {
        try {
            ResourceBundle index = ICULocaleData.getResourceBundle(bundleName, "index");
            Object[][] localeStrings = (Object[][])index.getObject("InstalledLocales");
            String[] localeNames = new String[localeStrings.length];
            for (int i = 0; i < localeNames.length; ++i) {
                localeNames[i] = LocaleUtility.getLocaleFromName((String)localeStrings[i][0]).toString();
            }
            HashSet<String> set = new HashSet<String>();
            set.addAll(Arrays.asList(localeNames));
            return Collections.unmodifiableSet(set);
        }
        catch (MissingResourceException e) {
            if (DEBUG) {
                System.out.println("couldn't find index for bundleName: " + bundleName);
            }
            Thread.dumpStack();
            return Collections.EMPTY_SET;
        }
    }
}

