﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Text.RegularExpressions;

namespace SpeechCast
{
    class BBSThread
    {
        public string Text = null;
        public string RawText = null;
        public string ResponseCount = null;
        public string ThreadID = null;

        static Regex jbbsRegex = new Regex(@"^(\d+).cgi,(.+)\((\d+)\)");
        static Regex nichanRegex = new Regex(@"^(\d+).dat<>(.+)\((\d+)\)");

        public bool SetRawText(string rawText)
        {
            this.RawText = rawText;
            bool success = false;

            switch (Response.Style)
            {
                case Response.BBSStyle.jbbs:
                    {
                        Match m = jbbsRegex.Match(rawText);

                        if (m.Success)
                        {
                            Text = m.Groups[2].Value;
                            ResponseCount = m.Groups[3].Value;
                            ThreadID = m.Groups[1].Value;
                            success = true;
                        }
                        break;
                    }
                case Response.BBSStyle.yykakiko:
                case Response.BBSStyle.nichan:
                    {
                        Match m = nichanRegex.Match(rawText);

                        if (m.Success)
                        {
                            Text = m.Groups[2].Value;
                            ResponseCount = m.Groups[3].Value;
                            ThreadID = m.Groups[1].Value;
                            success = true;
                        }
                        break;
                    }

            }

            return success;
        }


    }
}
