﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Drawing;
using System.Windows.Forms;
using System.Text.RegularExpressions;

namespace SpeechCast
{
    public class UserConfig
    {
        public UserConfig()
        {
        }

        public UserConfig(string filePath)
        {
            filePath_ = filePath;
        }

        static private string filePath_;

        public Rectangle FormMainRect;
        public Rectangle FormCaptionRect;

        public int SpeakingInvervalMillsec = 3000;
        public int SpeakingRate = 0;
        public int SpeakingVolume = 100;
        public bool SpeaksResNumber = true;
        public int AutoGettingWebInvervalMillsec = 7000;
        public int MaxSpeakingCharacterCount = 100;
        public List<string> NGWords = new List<string>();
        public List<string> Pronounciations = new List<string>();

        public void UpdatePronounciations()
        {
            replacedStrings = null;
        }

        public string URL = "";

        public string VoiceName = "VW Misaki";

        public CaptionFont CaptionFont = new CaptionFont();


        public void Serialize()
        {
            System.Xml.Serialization.XmlSerializer serializer = new System.Xml.Serialization.XmlSerializer(typeof(UserConfig));

            string dirPath = System.IO.Path.GetDirectoryName(filePath_);

            if (!System.IO.Directory.Exists(dirPath))
            {
                System.IO.Directory.CreateDirectory(dirPath);
            }

            using (System.IO.FileStream fs = new System.IO.FileStream(filePath_, System.IO.FileMode.Create))
            {
                serializer.Serialize(fs, this);
            }
        }

        public static void SetRectToForm(Rectangle rect, Form form)
        {
            form.Top = rect.Top;
            form.Height = rect.Height;
            form.Left = rect.Left;
            form.Width = rect.Width;
        }

        public static void SetFormToRect(ref Rectangle rect, Form form)
        {
            rect.Y = form.Top;
            rect.Height = form.Height;
            rect.X = form.Left;
            rect.Width = form.Width;
        }


        public static UserConfig Deserialize(string filePath)
        {
            UserConfig userConfig;

            filePath_ = filePath;

            System.Xml.Serialization.XmlSerializer serializer = new System.Xml.Serialization.XmlSerializer(typeof(UserConfig));
            using (System.IO.FileStream fs = new System.IO.FileStream(filePath_, System.IO.FileMode.Open))
            {
                userConfig = (UserConfig) serializer.Deserialize(fs);
            }

            return userConfig;
        }

        public bool IncludesNGWord(string text)
        {
            foreach (string ngword in NGWords)
            {
                if (text.IndexOf(ngword) >= 0)
                {
                    return true;
                }
            }
            return false;
        }

        private List<int> replacementIndices;
        private Dictionary<Regex, string> replacedStrings = null;

        private void CreateReplacedStrings()
        {
            if (replacedStrings == null)
            {
                replacedStrings = new Dictionary<Regex, string>();

                foreach (string pro in Pronounciations)
                {
                    bool backSlash = false;
                    string regexString = null;
                    string regexOption = "";
                    for (int i = 0; i < pro.Length; i++)
                    {
                        if (backSlash == false && pro[i] == '/')
                        {
                            regexString = pro.Substring(0, i);
                            newText = pro.Substring(i + 1);
                            int idx = newText.IndexOf('/');

                            if (idx >= 0 && idx < newText.Length - 1)
                            {
                                regexOption = newText.Substring(idx + 1, newText.Length - idx - 1);
                                newText = newText.Substring(0, idx);
                            }
                            break;
                        }

                        if (pro[i] == '\\')
                        {
                            backSlash = true;
                        }
                        else
                        {
                            backSlash = false;
                        }
                    }

                    if (newText != null)
                    {
                        try
                        {
                            RegexOptions opt = RegexOptions.None;

                            for (int i = 0; i < regexOption.Length; i++)
                            {
                                char c = char.ToLower(regexOption[i]);

                                switch (c)
                                {
                                    case 'i':
                                        opt |= RegexOptions.IgnoreCase;
                                        break;
                                    case 's':
                                        opt |= RegexOptions.Singleline;
                                        break;
                                    case 'm':
                                        opt |= RegexOptions.Multiline;
                                        break;

                                }
                            }

                            Regex rx = new Regex(regexString, opt);

                            replacedStrings.Add(rx, newText);
                        }
                        catch //(Exception e)
                        {
                        }
                    }
                }
            }
        }
        public string ReplacePronouncationWords(string text, out List<int> indices)
        {
            CreateReplacedStrings();

            speakingText = text;
            replacementIndices = new List<int>();
            for (int i = 0; i < text.Length; i++)
            {
                replacementIndices.Add(i);
            }

            foreach (KeyValuePair<Regex, string> kvp in replacedStrings)
            {
                Regex rx = kvp.Key;
                newText = kvp.Value;

                matches.Clear();
                text = rx.Replace(text, matchDelegate);

                matches.Reverse();
                foreach (Match match in matches)
                {
                    int index = match.Index;

                    int endIndex = match.Index + match.Length;

                    if (endIndex >= replacementIndices.Count)
                    {
                        endIndex = replacementIndices.Count - 1;
                    }

                    int start = replacementIndices[endIndex] - 1;


                    for (int i = 0; i < match.Length; i++)
                    {
                        if (index < replacementIndices.Count)
                        {
                            replacementIndices.RemoveAt(index);
                        }
                        else
                        {
                            break;
                        }
                    }

                    for (int i = 0; i < newText.Length; i++)
                    {
                        if (replacementIndices.Count - 1 > index)
                        {
                            replacementIndices.Insert(index, start);
                        }
                        else
                        {
                            replacementIndices.Add(start);
                        }
                    }
                }                
            }
        

            indices = replacementIndices;
            return text;
        }

        List<Match> matches = new List<Match>();
        private string speakingText;
        private string newText;
        private string matchDelegate(Match match)
        {
            matches.Add(match);
            return newText;
        }
    }
}
