/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package net.korabo.app.vaadin01.ui;

import com.vaadin.annotations.Theme;
import com.vaadin.annotations.Title;
import com.vaadin.annotations.VaadinServletConfiguration;
import com.vaadin.annotations.Widgetset;
import com.vaadin.data.util.BeanItemContainer;
import com.vaadin.server.VaadinRequest;
import com.vaadin.server.VaadinServlet;
import com.vaadin.ui.Button;
import com.vaadin.ui.Grid;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.TextField;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.annotation.WebServlet;
import net.korabo.app.vaadin01.ent.Contact;
import net.korabo.app.vaadin01.srv.ContactBeanQuery;
import net.korabo.app.vaadin01.srv.ContactService;
import org.vaadin.addons.lazyquerycontainer.BeanQueryFactory;
import org.vaadin.addons.lazyquerycontainer.LazyQueryContainer;
import org.vaadin.addons.lazyquerycontainer.LazyQueryDefinition;
import org.vaadin.addons.lazyquerycontainer.QueryDefinition;

/**
 *
 * @author cintake
 */
@Title("Addressbook2")
@Theme("valo")
@Widgetset("net.korabo.app.vaadin01.MyAppWidgetset")
public class AddressbookUI2 extends UI {

  TextField filter = new TextField();
  Grid contactList = new Grid();
  Button newContact = new Button("New contact");

  // ContactForm is an example of a custom component class
  ContactForm contactForm = new ContactForm();

  // ContactService is a in-memory mock DAO that mimics
  // a real-world datasource. Typically implemented for
  // example as EJB or Spring Data based service.
  LazyQueryContainer container;
  ContactService service = ContactService.createDemoService();

  @Override
  protected void init(VaadinRequest request) {
    configureComponents();
    buildLayout();
  }

  private void configureComponents() {

    newContact.addClickListener(e -> contactForm.edit(new Contact()));

    filter.setInputPrompt("Filter contacts...");
    filter.addTextChangeListener(e -> refreshContacts(e.getText()));

    BeanQueryFactory<ContactBeanQuery> queryFactory = new BeanQueryFactory<>(ContactBeanQuery.class);

Map<String,Object> queryConfiguration=new HashMap<>();
queryConfiguration.put("ContactService",ContactService.createDemoService());
queryFactory.setQueryConfiguration(queryConfiguration);

container = new LazyQueryContainer(new LazyQueryDefinition(false, 50, "ContactID"), queryFactory);
contactList.setContainerDataSource(container);
//    contactList.setContainerDataSource(new BeanItemContainer<>(Contact.class));
//    contactList.setColumnOrder("firstName", "lastName", "email");
//    contactList.removeColumn("id");
//    contactList.removeColumn("birthDate");
//    contactList.removeColumn("phone");
//    contactList.setSelectionMode(Grid.SelectionMode.SINGLE);
//    contactList.addSelectionListener(e
//      -> contactForm.edit((Contact) contactList.getSelectedRow()));
    refreshContacts();
  }

  private void buildLayout() {
    HorizontalLayout actions = new HorizontalLayout(filter, newContact);
    actions.setWidth("100%");
    filter.setWidth("100%");
    actions.setExpandRatio(filter, 1);

    VerticalLayout left = new VerticalLayout(actions, contactList);
    left.setSizeFull();
    contactList.setSizeFull();
    left.setExpandRatio(contactList, 1);

    HorizontalLayout mainLayout = new HorizontalLayout(left, contactForm);
    mainLayout.setSizeFull();
    mainLayout.setExpandRatio(left, 1);

    // Split and allow resizing
    setContent(mainLayout);
  }

  void refreshContacts() {
    refreshContacts(filter.getValue());
  }

  private void refreshContacts(String stringFilter) {
    container.refresh();
//    contactList.setContainerDataSource(new BeanItemContainer<>(
//      Contact.class, service.findAll(stringFilter)));
    contactForm.setVisible(false);
  }

  @WebServlet(urlPatterns = "/2/*")
  @VaadinServletConfiguration(ui = AddressbookUI2.class, productionMode = false)
  public static class MyUIServlet extends VaadinServlet {

  }

}
