package com.ozacc.mail.util;

import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;

/**
 * DNS に MX レコードが登録されているかをチェックするクラス。
 * Sun JDK 1.4 以上で使用できます。
 * <p>
 * TODO: 未完成。正しく動作しません。
 * 
 * @since 1.1
 * @version $Id: MXCheck.java,v 1.1 2004/09/14 22:27:57 otsuka Exp $
 * @author Tomohiro Otsuka
 */
public class MXCheck {

	public static boolean isValidEmailAddress(String email, String dns) {
		try {
			new InternetAddress(email, true);
		} catch (AddressException e) {
			return false;
		}

		int pos = email.lastIndexOf("@");
		String hostName = email.substring(pos + 1);
		return hasMXRecord(hostName, dns);
	}

	/**
	 * 指定された host に MX レコードが関連付けられているか
	 * どうか判定します。
	 * 
	 * @param hostName 検査するホスト名
	 * @param dns 検査に使用する DNS サーバ
	 * @return MX レコードが存在すれば true
	 */
	public static boolean hasMXRecord(String hostName, String dns) {
		String name = "dns://" + dns + "/" + hostName;
		try {
			DirContext ictx = new InitialDirContext();
			Attributes attrs = ictx.getAttributes(name, new String[] { "MX" });
			NamingEnumeration namingEnumeration = attrs.getAll();
			if (namingEnumeration.hasMore()) {
				return true;
			}
		} catch (NamingException e) {
			return false;
		}

		return false;
	}

	/**
	 * 指定された host に MX レコードが関連付けられているかどうか判定します。
	 * 検査に使用する DNS サーバは localhost です。
	 * 
	 * @param hostName 検査するホスト名
	 * @return MX レコードが存在すれば true
	 */
	public static boolean hasMXRecord(String hostName) {
		return hasMXRecord(hostName, "localhost");
	}

	/**
	 * 次のコマンドで、ホスト名に MX レコードが存在するかどうか調べます。
	 * <p>
	 * <code>java com.ozacc.mail.util.MXChecker [ホスト名] [使用するDNSサーバ]</code>
	 * 
	 */
	public static void main(String[] args) {
		boolean result = false;
		if (args.length == 1) {
			result = hasMXRecord(args[0]);
		} else {
			result = hasMXRecord(args[0], args[1]);
		}

		if (result)
			System.out.println(args[0] + " の MX レコードは存在します。");
		else
			System.out.println(args[0] + " の MX レコードは登録されていません。");
	}
}