package com.ozacc.mail;

/**
 * SMTPサーバ接続の認証に失敗した際にスローされる例外。
 * 
 * @since 1.0
 * @author Tomohiro Otsuka
 * @version $Id: MailAuthenticationException.java,v 1.2 2004/09/13 07:08:22 otsuka Exp $
 */
public class MailAuthenticationException extends MailException {

	/**
	 * @param message 
	 */
	public MailAuthenticationException(String message) {
		super(message);
	}

	/**
	 * @param message
	 * @param cause 
	 */
	public MailAuthenticationException(String message, Throwable cause) {
		super(message, cause);
	}

	public MailAuthenticationException(Throwable cause) {
		super("Authentication failed: " + cause.getMessage(), cause);
	}

}

