package com.ozacc.mail.impl;

import java.io.IOException;
import java.io.InputStream;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/**
 * ozacc-mail libraryのDTDファイルをクラスパス上から検出するEntityResolver実装。
 * 
 * @since 1.1
 * 
 * @author Tomohiro Otsuka
 * @version $Id: DTDEntityResolver.java,v 1.1.2.2 2004/11/25 08:01:07 otsuka Exp $
 */
public class DTDEntityResolver implements EntityResolver {

	private static Log log = LogFactory.getLog(DTDEntityResolver.class);

	private static final String URL = "http://www.ozacc.com/library/dtd/";

	/**
	 * クラスパス「com/ozacc/mail」上で、指定されたsystemIdのファイル名と同じファイルを検出します。
	 * もしも検出できなければnullを返します。(必ず検出できるはずです。)
	 * 
	 * @see org.xml.sax.EntityResolver#resolveEntity(java.lang.String, java.lang.String)
	 */
	public InputSource resolveEntity(String publicId, String systemId) throws SAXException,
																		IOException {
		if (systemId != null && systemId.startsWith(URL)) {
			log.debug("クラスパス[com/ozacc/mail/]上で'" + systemId + "'の取得を試みます。");

			// Search for DTD
			ClassLoader classLoader = this.getClass().getClassLoader();
			InputStream dtdStream = classLoader.getResourceAsStream("com/ozacc/mail/"
					+ systemId.substring(URL.length()));

			if (dtdStream == null) {
				log.debug("'" + systemId + "'はクラスパス上に見つかりませんでした。");
				return null;
			} else {
				log.debug("'" + systemId + "'をクラスパス上で取得しました。");
				InputSource source = new InputSource(dtdStream);
				source.setPublicId(publicId);
				source.setSystemId(systemId);
				return source;
			}
		} else {
			// use the default behaviour
			return null;
		}
	}

}