
package com.ozacc.mail.fetch.impl;

import javax.mail.Message.RecipientType;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;

import junit.framework.TestCase;

import org.apache.log4j.BasicConfigurator;
import org.jvnet.mock_javamail.Mailbox;

import com.ozacc.mail.Mail;
import com.ozacc.mail.fetch.ReceivedMail;

/**
 * FetchMailImplクラスのテストケース。
 * 
 * @since 1.2.3
 * @author Iwao AVE!
 */
public class FetchMailImplTest extends TestCase
{
	protected void setUp() throws Exception
	{
		super.setUp();
		BasicConfigurator.configure();
	}

	/**
	 * 受信したメールの返信を作成するテスト (#12279)
	 */
	public void testReplyReceivedMail() throws Exception
	{
		String subject = "Test subject";
		String recipient = "info@example.com";
		Session session = Session.getInstance(System.getProperties());
		MimeMessage msg = new MimeMessage(session);
		msg.setRecipients(RecipientType.TO, recipient);
		msg.setSubject(subject);
		msg.setText("Test body");
		msg.setHeader("Message-ID", "MSGID-123");
		Mailbox inbox = Mailbox.get("info@example.com");
		inbox.add(msg);

		FetchMailImpl fetchMail = new FetchMailImpl();
		fetchMail.setHost("example.com");
		fetchMail.setUsername("info");
		ReceivedMail[] mails = fetchMail.getMails();
		assertEquals(1, mails.length);
		ReceivedMail receivedMail = mails[0];
		Mail reply = (Mail)(receivedMail.reply());
		assertEquals(receivedMail.getReplySubjectPrefix() + subject, reply.getSubject());
	}

	protected void tearDown() throws Exception {
		super.tearDown();
		BasicConfigurator.resetConfiguration();
		Mailbox.clearAll();
	}
}
