package my.logic;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * <pre>
 * コーディング問題
 *
 * 2以上の全ての整数は、いくつかの素数を掛け合わせた解になります。
 *
 * 2=2
 * 3=3
 * 4=2*2
 * 5=5
 * 6=2*3
 * 7=7
 * 8=2*2*2
 * 9=3*3
 * 10=2*5
 * ...
 *
 * 任意の整数を与えられた時、掛け合わせるとその整数となる素数の集合を算出する関数を作成してください。例えば、「4」が与え* ら れた時「2,2」を返戻し、「10」が与えられた時「2,5」を返戻します。
 * 関数は、ループ処理を用いた物と再帰処理を用いた物の2種類を作成してください。
 * 実装にはオブジェクト指向言語をご使用ください。又、問題の意図を無視した実装は避けて頂くようお願いします。
 * 又、動作に何らかの前提が必要な場合は、コメントを記載してください。
 *
 */
public class PrimeNumber {

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		for (int n = 2; n < 1000; n++) {
			PrimeNumber pn = new PrimeNumber();
	
			List<Integer> ns = new ArrayList<Integer>();
			pn.loop(n, ns);
			pn.print(n, ns);
			
			ns = new ArrayList<Integer>();
			pn.recurse(n, ns);
			pn.print(n, ns);
		}
	}

	private boolean test(Integer n) {
		if (n > 3) {
			int h = n / 2;
			for (int i = 2; i <= h; i++) {
				if (n % i == 0) {
					return false;
				}
			}
		}
		return true;
	}
	
	public void print(Integer n, List<Integer> ns) {
		Integer[] na = ns.toArray(new Integer[ns.size()]);
		Arrays.sort(na);

		Integer s = 1;
		System.out.print(n + ":");
		for (Integer i : na) {
			System.out.print(" " + i);
			if (!test(i)) {
				System.out.println(" - ERROR");
				System.exit(1);
			}
			s *= i;
		}
		System.out.println();
		
		if (!s.equals(n)) {
			System.out.println("ERROR: " + s);
			System.exit(1);
		}
	}
	
	/**
	 * ループ処理で指定した整数の素因数を求める
	 * @param n　整数
	 * @param ns　素因数を格納するリスト
	 */
	public void loop(int n, List<Integer> ns) {
		while (n > 3) {
			int h = n / 2;
			int j = n;
			for (int i = 2; i <= h; i++) {
				if (n % i == 0) {
					ns.add(i);
					n = n / i;
					break;
				}
			}
			if (j == n) {
				break;
			}
		}
		ns.add(n);
	}
	
	/**
	 * 再帰処理で指定した整数の素因数を求める
	 * @param n　整数
	 * @param ns　素因数を格納するリスト
	 */
	public void recurse(int n, List<Integer> ns) {
		if (n > 3) {
			int h = n / 2;
			for (int i = 2; i <= h; i++) {
				if (n % i == 0) {
					int j = n / i;
					recurse(i, ns);
					recurse(j, ns);
					return;
				}
			}
		}
		ns.add(n);
	}

}
