package my.tools;

import java.io.File;

public class Ghumbs {

	static File src = new File("C:/Pictures/Girls");
	static File des = new File("C:/Pictures/Girls/.thumbs");

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		try {
			File[] subs = src.listFiles();
			for (File f : subs) {
				if (f.isDirectory() && !f.getName().startsWith(".")) {
					gthumbs(f);
				}
			}
		}
		catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	private static void gthumbs(File f) throws Exception {
		System.out.println(f.getPath() + " ...");

		File t = new File(f, ".thumbs");
		if (t.exists()) {
			String p = f.getPath();
			String r = p.substring(src.getPath().length());
			
			File td = new File(des.getPath() + r);
			td.getParentFile().mkdirs();
			t.renameTo(td);
			System.out.println(t.getPath() + " --> " + td.getPath());
		}

		File[] subs = f.listFiles();
		for (File sf : subs) {
			if (sf.isDirectory()) {
				gthumbs(sf);
			}
		}
	}
}
