package my.tools;

import java.io.File;
import java.io.StringWriter;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.w3c.dom.Document;

/**
 * DOM(Document Object Model)を使用したサンプルプログラムです。<br/>
 * <br/>
 * <b>内容</b>
 * <ol type="1">
 * <li>XMLドキュメントのエンコーディングを指定します。</li>
 * </ol>
 * 
 * @author Takafumi Kondo (TK Factory)
 */
public class XmlTransform {
	/**
	 * SampleSetEncodingオブジェクトを構築すると、 UnsupportedOperationExceptionがスローされます。<br/>
	 */
	protected XmlTransform() {
		throw new UnsupportedOperationException();
	}

	/**
	 * mainメソッドです。<br/>
	 * 
	 * @param args 引数
	 */
	public static void main(String[] args) {
		try {
			DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
			DocumentBuilder docbuilder = dbfactory.newDocumentBuilder();
			Document document = docbuilder.newDocument();

			TransformerFactory tfactory = TransformerFactory.newInstance();
			Transformer transformer = tfactory.newTransformer();

			transformer.setOutputProperty(OutputKeys.ENCODING, "Shift_JIS");

			StringWriter sw = new StringWriter();
			transformer.transform(new DOMSource(document), new StreamResult(sw));

			System.out.print(sw.toString());
		}
		catch (Exception ex) {
			ex.printStackTrace();
		}
	}
}
