/*
 * This file is part of Nuts Framework.
 * Copyright (C) 2009 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package my.tools.auction;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.TreeMap;
import java.util.Vector;

import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

import nuts.core.collections.CollectionUtils;
import nuts.core.io.CsvReader;
import nuts.core.io.IOUtils;
import nuts.core.lang.NumberUtils;
import nuts.core.lang.StringUtils;
import nuts.core.net.HttpClientAgent;

import org.apache.commons.validator.GenericValidator;


/**
 * 
 */
public class A99Off {
	/**
	 * Base main class for code generator. Parse basic command line options.
	 */
	public static class Main {
		/**
		 * @param args arguments
		 */
		public static void main(String[] args) {
//			Thread print = new Thread("print") {
//				public void run() {
//					while (true) {
//						String s = logs.poll();
//						if (s != null) {
//							System.out.print(s);
//						}
//						else {
//							tsleep(10);
//						}
//					}
//				}
//			};
//			print.start();
			
			A99Off c = new A99Off();

			prompt();
			
			Scanner stdin = new Scanner(System.in);

			String line;
			while ((line = stdin.nextLine()) != null) {
				line = StringUtils.strip(line);
				String[] cs = StringUtils.split(line);
				if (cs.length > 0) {
					if ("exit".equalsIgnoreCase(cs[0])) {
						System.exit(0);
					}
					else if ("auctions".equalsIgnoreCase(cs[0])) {
						if (isAuctioning()) {
							printError("Main Auction is running.");
						}
						else if (cs.length > 1) {
							auction(cs[1], null, cs.length > 2 ? cs[2] : null);
						}
					}
					else if ("auction".equalsIgnoreCase(cs[0])) {
						if (isAuctioning()) {
							printError("Main Auction is running.");
						}
						else if (cs.length > 2) {
							auction(cs[1], cs[2], (cs.length > 3 ? cs[3] : null));
						}
					}
					else if ("login".equalsIgnoreCase(cs[0])) {
						String email = null;
						String password = null;
						if (cs.length > 2) {
							email = cs[1];
							password = cs[2];
							c.login(email, password);
						}
						else if (cs.length == 2) {
							if (GenericValidator.isInt(cs[1])) {
								c.login(NumberUtils.toInt(cs[1]));
							}
							else {
								email = cs[1];
								password = getPasswordFromEmail(email);
								c.login(email, password);
							}
						}
					}
					else if ("logout".equalsIgnoreCase(cs[0])) {
						c.logout();
					}
					else if ("ping".equalsIgnoreCase(cs[0])) {
						if (cs.length > 1) {
							c.ping(cs[1]);
						}
						else {
							c.ping();
						}
					}
					else if ("detail".equalsIgnoreCase(cs[0])) {
						c.detail();
					}
					else if ("rank".equalsIgnoreCase(cs[0])) {
						if (cs.length > 1) {
							c.rank(cs[1]);
						}
						else if (c.goods != null) {
							c.rank(String.valueOf(c.goods.id));
						}
					}
					else if ("pbet".equalsIgnoreCase(cs[0])) {
						if (cs.length > 1) {
							c.pbet(cs[1]);
						}
					}
					else if ("bet".equalsIgnoreCase(cs[0])) {
						c.bet();
					}
					else if ("bets".equalsIgnoreCase(cs[0])) {
						c.bets();
					}
					else if ("uload".equalsIgnoreCase(cs[0])) {
						if (cs.length > 1) {
							c.uload(cs[1]);
						}
					}
					else if ("uinfo".equalsIgnoreCase(cs[0])) {
						if (c.user != null) {
							c.ulist(c.user.email);
						}
					}
					else if ("ulist".equalsIgnoreCase(cs[0])) {
						c.ulist(null);
					}
					else if ("ulogin".equalsIgnoreCase(cs[0])) {
						if (cs.length > 1) {
							c.ulogin(cs[1]);
						}
					}
					else if ("uclear".equalsIgnoreCase(cs[0])) {
						c.uclear();
					}
					else if ("cookie".equalsIgnoreCase(cs[0])) {
						c.cookie();
					}
					else {
						printError("Unknown command!");
					}
				}
				prompt();
			}
		}

		private static Thread mauction;

		protected static boolean isAuctioning() {
			return mauction != null && mauction.isAlive();
		}

		protected static synchronized void auction(final String gid, final String uid, final String pstart) {
			if (StringUtils.isNotEmpty(uid)) {
				final User u = new User();
				if (GenericValidator.isInt(uid)) {
					User u2 = A99Off.getUser(NumberUtils.toInt(uid));
					if (u2 == null) {
						printError("No user!");
						return;
					}
					u.email = u2.email;
					u.password = u2.password;
				}
				else {
					String[] ss = StringUtils.split(uid, '/');
					if (ss.length > 1) {
						u.email = ss[0];
						u.password = ss[1];
					}
					else {
						printError("Incorrect user!");
						return;
					}
				}

				mauction = new Thread("m" + gid) {
					public void run() {
						A99Off a = new A99Off();
						a.setStartPrice(pstart);
						a.auction(gid, u.email, u.password);
						while (a.isInAuction()) {
							tsleep(1000);
						}
						mauction = null;
					}
				};
			}
			else {
				if (CollectionUtils.isEmpty(A99Off.users)) {
					printError("No user!");
					return;
				}
				
				mauction = new Thread("m" + gid) {
					public void run() {
						A99Off a = new A99Off();
						a.setStartPrice(pstart);
						for (User u : A99Off.users.values()) {
							a.auction(gid, u.email, u.password);
							while (a.isInAuction()) {
								tsleep(1000);
							}
							if (a.goods == null) {
								break;
							}
							else if (a.user != null 
									&& a.user.coin > 0 
									&& a.goods.over
									&& !a.user.nick.equals(a.goods.unick)) {
								break;
							}
						}
						mauction = null;
					}
				};
			}
			mauction.start();
		}
		
	}

	protected static class User implements Cloneable {
		protected String email;
		protected String password;
		protected String nick;
		protected int coin = 0;
		protected int bets = 0;
		protected long btime = 0;
		
		public String toString() {
			StringBuilder sb = new StringBuilder();
			sb.append("{ ");
			sb.append("email: ").append(email);
			sb.append(", nick: ").append(nick);
			sb.append(", coin: ").append(coin);
			sb.append(", bets: ").append(bets);
			sb.append(", btime: ").append(dateFormat.format(new Date(btime)));
			sb.append(" }");
			return sb.toString();
		}
		
		public User clone() {
			User u = new User();
			u.email = this.email;
			u.password = this.password;
			u.nick = this.nick;
			u.coin = this.coin;
			u.bets = this.bets;
			u.btime = this.btime;
			return u;
		}
	}
	
	protected static class Goods {
		protected int id;
		protected int price;
		protected long times;
		protected int uid;
		protected String unick;
		protected boolean over;
		protected long ptime;

		public String toString() {
			StringBuilder sb = new StringBuilder();
			sb.append("{ ");
			sb.append("id: ").append(id);
			sb.append(", price: ").append(price);
			sb.append(", times: ").append(times);
			sb.append(", over: ").append(over);
			sb.append(", unick: ").append(unick);
			sb.append(", ptime: ").append(dateFormat.format(new Date(ptime)));
			sb.append(" }");
			return sb.toString();
		}
	}

	//---------------------------------------------------------------------------------------
	// properties
	//---------------------------------------------------------------------------------------
//	private static Queue<String> logs = new ConcurrentLinkedQueue<String>();

	private static List<User> bets = new ArrayList<User>();
	
	private HttpClientAgent agent = new HttpClientAgent();

	private static Map<String, User> users = CollectionUtils.caseInsensitiveMap(new TreeMap<String, User>());

	private int gpmin = 0;
	
	private User user;
	private Goods goods;

	private Thread auction;
	private List<Thread> pings = new Vector<Thread>();;
	private long ptime = 0;
	
	/**
	 * Constructor
	 */
	public A99Off() {
	}

	protected void setStartPrice(String price) {
		if (NumberUtils.isInt(price)) {
			gpmin = NumberUtils.toInt(price);
		}
	}

	protected void cookie() {
		printInfo(agent.getCookieStore().getCookies().toString());
	}
	
	protected void uclear() {
		users.clear();
	}

	protected void ulogin(String uno) {
		Integer i = 0;
		for (User u : users.values()) {
			i++;
			if ("0".equals(uno) || i.toString().equals(uno)) {
				if (user != null) {
					logout();
				}
				if (login(u.email, u.password)) {
					tsleep(1000);
				}
			}
		}
	}

	protected void bets() {
		print("==" 
				+ StringUtils.rightPad(" No. ", 7, '=')
				+ StringUtils.rightPad(" Email ", 30, '=')
				+ StringUtils.rightPad(" BTime ", 20, '=')
				+ StringUtils.rightPad(" Coin ", 8, '=')
				+ StringUtils.rightPad(" Bets ", 8, '=')
				+ '\n');
		
		int i = 0;
		for (User u : bets) {
			i++;
			print("   " 
				+ StringUtils.rightPad(String.valueOf(i), 7)
				+ StringUtils.rightPad(String.valueOf(u.email), 30)
				+ StringUtils.rightPad(dateFormat.format(new Date(u.btime)), 19)
				+ StringUtils.leftPad(String.valueOf(u.coin), 5)
				+ StringUtils.leftPad(String.valueOf(u.bets), 8)
				+ '\n');
		}
	}

	protected void ulist(String email) {
		print("==" 
				+ StringUtils.rightPad(" No. ", 7, '=')
				+ StringUtils.rightPad(" Email ", 30, '=')
				+ StringUtils.rightPad(" Nick ", 20, '=')
				+ StringUtils.rightPad(" Coin ", 8, '=')
				+ StringUtils.rightPad(" Bets ", 8, '=')
				+ '\n');
		
		int i = 0;
		for (User u : users.values()) {
			i++;
			if (StringUtils.isEmpty(email) || email.equalsIgnoreCase(u.email)) {
				print("   " 
					+ StringUtils.rightPad(String.valueOf(i), 7)
					+ StringUtils.rightPad(String.valueOf(u.email), 30)
					+ StringUtils.rightPad(String.valueOf(u.nick), 19)
					+ StringUtils.leftPad(String.valueOf(u.coin), 5)
					+ StringUtils.leftPad(String.valueOf(u.bets), 8)
					+ '\n');
			}
		}
	}

	protected void uload(String file) {
		if (StringUtils.isNotEmpty(file)) {
			CsvReader cr = null;
			try {
				cr = new CsvReader(new FileReader(file));
				List<String> line;
				
				while ((line = cr.readNext()) != null) {
					User u = new User();
					if (line.size() > 1) {
						u.email = line.get(0).trim();
						u.password = line.get(1).trim();
					}
					else if (line.size() == 1) {
						u.email = line.get(0).trim();
						u.password = getPasswordFromEmail(u.email);
					}
					if (StringUtils.isNotEmpty(u.email)
							&& StringUtils.isNotEmpty(u.password)) {
						users.put(u.email, u);
						printInfo("Add user: " + u.email);
					}
				}
			}
			catch (IOException e) {
				printError(e);
			}
			finally {
				IOUtils.closeQuietly(cr);
			}
		}
	}
	
//	httpGet("http://99off.jp/Login.aspx"); 
	
	protected boolean isInAuction() {
		return auction != null && auction.isAlive();
	}
	
	private static String remainTime(long remain) {
		if (remain > 10000) {
			return " ( " + remain + " )";
		}
		else if (remain > 1000) {
			return " (( " + remain + " ))";
		}
		else {
			return " ((( " + remain + " )))";
		}
	}
	
	protected synchronized void auction(String gid, String uid, String upw) {
		if (isInAuction()) {
			printError("Auction(" + gid + ") is running.");
			return;
		}
		
		goods = null;
		ping(gid);
		if (goods == null) {
			printError("Goods(" + gid + ") is missing.");
			logout();
			return;
		}

		user = null;
		if (StringUtils.isNotEmpty(upw)) {
			if (!login(uid, upw)) {
				return;
			}
		}
		else {
			User u;
			if (NumberUtils.isInt(uid)) {
				u = getUser(NumberUtils.toInt(uid));
			}
			else {
				u = users.get(uid);
			}

			if (u == null) {
				printError("User(" + uid + ") is missing.");
				return;
			}
			if (!login(u.email, u.password)) {
				return;
			}
		}
		
		if (StringUtils.isEmpty(user.nick)) {
			printError("User(" + user.email + ") nickname is missing.");
			logout();
			return;
		}
		
		if (user.coin < 1) {
			printError("User(" + user.email + ") has no coin.");
			logout();
			return;
		}
		
		ping(gid);

		auction = new Thread("a" + gid) {
			public void run() {
				while (true) {
					if (goods.over) {
						break;
					}
					if (user.coin < 1 && !user.nick.equals(goods.unick)) {
						break;
					}

					long ctime = System.currentTimeMillis();
					long remain = goods.times - (ctime - goods.ptime);
					print("\r[" + Thread.currentThread().getName() + "] " 
							+ dateFormat.format(new Date(ctime))
							+ remainTime(remain)
							+ " [ " + pings.size() + " ]"
							+ " { n: " + user.nick 
							+ ", c: " + user.coin
							+ ", b: " + user.bets
							+ ", t: " + dateFormat.format(new Date(user.btime))
							+ " }        ");

					if (remain < 300 
							&& goods.price >= gpmin
							&& user.btime < goods.ptime
//							&& ctime - user.btime > 10000 
							&& !user.nick.equals(goods.unick)) {
						if (bet()) {
							while (user.btime > goods.ptime) {
								tping(350);
								tsleep(50);
							}

							Thread r = new Thread("rank-" + user.bets) {
								public void run() {
									rank(String.valueOf(goods.id));
								}
							};
							r.start();
						}
						else {
							if (user.coin < 1) {
								break;
							}
							
							rank(String.valueOf(goods.id));

							while (pings.size() > 0) {
								tjoin(pings.get(0), 0);
								tsleep(10);
							}
							
							while (!ping());

							if (goods.over) {
								break;
							}
						}
					}
					else if (remain < 1500) {
						tping(10);
					}
					else if (remain < 5000) {
						tping(500);
						tsleep(100);
					}
					else if (remain < 10000) {
						tping(500);
						tsleep(500);
					}
					else {
						if (ctime - goods.ptime > 30000) {
							if (pings.size() < 1) {
								tping(30000);
							}
						}
						tsleep(500);
					}
				}
				
				rank(String.valueOf(goods.id));
				if (user.nick.equals(goods.unick)) {
					println("!!!! BINGO !!!!");
				}
				else {
					println("!!!! FAILED !!!!"
							+ "\n (g:" + goods.toString() + ")"
							+ "\n (u:" + user.toString() + ")");
				}
				logout();
			}
		};
		auction.start();
	}

	private static void tsleep(long ms) {
		try {
			Thread.sleep(ms);
		}
		catch (InterruptedException e) {
		}
	}

	private static void tjoin(Thread t, long ms) {
		try {
			t.join(ms);
		}
		catch (InterruptedException e) {
		}
	}

	protected boolean tping(long wait) {
		long ctime = System.currentTimeMillis();
		if (pings.size() > 10 || ctime - ptime < 60) {
			return false;
		}
		
		Thread t = new Thread("ping-" + (pings.size() + 1)) {
			public void run() {
				ptime = System.currentTimeMillis();
				pings.add(this);
				try {
					print("\n");
					ping();
				}
				finally {
					pings.remove(this);
				}
			}
		};
		
		t.start();
		tjoin(t, wait);

		return true;
	}
	
	protected static User getUser(int uno) {
		int i = 0;
		for (User u : users.values()) {
			i++;
			if (i == uno) {
				return u;
			}
		}
		return null;
	}
	
	protected boolean login(int uno) {
		User u = getUser(uno);
		if (u != null) {
			return login(u.email, u.password);
		}
		return false;
	}
	
	protected String getResponseText() {
		try {
			return agent.getResponseText();
		}
		catch (Exception e) {
			return "";
		}
	}
	
	protected boolean login(String email, String password) {
		if (StringUtils.isNotEmpty(email) 
				&& StringUtils.isNotEmpty(password)) {
			Map<String, Object> forms = new HashMap<String, Object>();
			forms.put("c", "User.Login");
			forms.put("e", email);
			forms.put("p", password);
			forms.put("r", "0");
			forms.put("rnd", rnd());

			httpPost("http://99off.jp/cmd/default.ashx", forms);
			
			if ("1".equals(getResponseText())) {
				user = users.get(email);
				if (user == null) {
					user = new User();
					users.put(email, user);
				}
				user.email = email;
				user.password = password;

				printInfo("LOGIN OK! (" + user.email + ")");
				
				userinfo();
				return true;
			}
			else {
				printError("LOGIN FAILED! (" + email + "/" + password + ")");
			}
		}
		return false;
	}

	protected void logout() {
		if (user != null) {
			Map<String, Object> forms = new HashMap<String, Object>();
			forms.put("c", "User.Logout");
			forms.put("rnd", rnd());

			httpPost("http://99off.jp/cmd/default.ashx", forms);
		}
	}

	protected boolean pbet(String gid) {
		if (user == null) {
			printError("Please Login!");
			return false;
		}

		Map<String, Object> forms = new LinkedHashMap<String, Object>();
		forms.put("c", "Good.Bet");
		forms.put("gid", gid);
		forms.put("rnd", rnd());

		agent.getRequestHeader().put("referer", "http://99off.jp/Detail.aspx?id=" + gid);
		httpGet("http://99off.jp/cmd/default.ashx", forms);

		if ("1".equals(getResponseText())) {
			int retry = 3;
			while (retry > 0) {
				if (userinfo()) {
					break;
				}
				retry--;
			}

			user.bets++;
			user.btime = System.currentTimeMillis();
			printInfo("BET OK! (coin: " + user.coin 
					+ ", bets: " + user.bets 
					+ ", time: " + dateFormat.format(new Date(user.btime)) 
					+ ")");
			return true;
		}
		else {
			printError("BET FAILED! - " + getResponseText());
			return false;
		}
	}

	protected boolean tbet() {
		user.bets++;
		user.btime = System.currentTimeMillis();
		printInfo("BET TEST! (coin: " + user.coin 
				+ ", bets: " + user.bets 
				+ ", time: " + dateFormat.format(new Date(user.btime)) 
				+ ")");
		return true;
	}

	protected boolean bet() {
		if (user == null) {
			printError("Please Login!");
			return false;
		}
		
		if (goods == null) {
			printError("Please select goods!");
			return false;
		}
		
		if (goods.over) {
			printError("Goods(" + goods.id + ") auction is over.");
			return false;
		}
		
		if (user.coin < 1) {
			printError("No coin!");
			return false;
		}

		print("\n[" + Thread.currentThread().getName() + "] " 
				+ dateFormat.format(new Date(System.currentTimeMillis()))
				+ " Bet ... ");

		int btry = 3;
		while (btry > 0) {
			Map<String, Object> forms = new LinkedHashMap<String, Object>();
			forms.put("c", "Good.Bet");
			forms.put("gid", String.valueOf(goods.id));
			forms.put("rnd", rnd());
	
			agent.getRequestHeader().put("referer", "http://99off.jp/Detail.aspx?id=" + goods.id);
			httpGet("http://99off.jp/cmd/default.ashx", forms);
			if ("1".equals(getResponseText())) {
				int coin = --user.coin;
				int retry = 3;
				while (retry > 0) {
					if (userinfo()) {
						break;
					}
					retry--;
				}

				if (coin < user.coin) {
					btry--;
					continue;
				}

				user.bets++;
				user.btime = System.currentTimeMillis();
				
				bets.add(user.clone());

				printInfo("BET OK! (coin: " + user.coin 
						+ ", bets: " + user.bets 
						+ ", time: " + dateFormat.format(new Date(user.btime)) 
						+ ")");
				return true;
			}
			else {
				if ("nb".equals(getResponseText())
						|| "nc".equals(getResponseText())) {
					user.coin = 0;
				}
				printError("BET FAILED! - " + getResponseText());
				return false;
			}
		}
		return false;
	}
	
	protected boolean userinfo() {
		if (user == null) {
			printError("Please Login!");
			return false;
		}

		httpGet("http://99off.jp/user/detail.aspx");
		String content = getResponseText();
		if (StringUtils.isNotEmpty(content)) {
			final String coin = "<span id=\"header_coinnum\">";
			final String nick = "id=\"nick\"";
			final String vale = "value=\"";
			BufferedReader br = new BufferedReader(new StringReader(content));
			String line;
			try {
				String usernick = null;
				int usercoin = 0;
				while ((line = br.readLine()) != null) {
					int i = 0;
					
					i = line.indexOf(coin);
					if (i > 0) {
						i += coin.length();
						int j = line.indexOf("</span>", i);
						if (j > 0) {
							String cn = line.substring(i, j);
							usercoin = Integer.parseInt(cn);
						}
					}
					
					i = line.indexOf(nick);
					if (i > 0) {
						i = line.indexOf(vale);
						if (i > 0) {
							i += vale.length();
							int j = line.indexOf("\"", i);
							if (j > 0) {
								usernick = line.substring(i, j);
							}
						}
					}
				}
				
				printInfo("nick: " + usernick + " | coin: " + usercoin);
				if (StringUtils.isNotEmpty(usernick)) {
					user.nick = usernick;
					user.coin = usercoin;
					return true;
				}
			}
			catch (Exception e) {
				printError(e);
			}
		}
		return false;
	}

	protected boolean ping() {
		if (goods != null) {
			return ping(String.valueOf(goods.id));
		}
		else {
			return ping(null);
		}
	}
	
	protected boolean ping(final String gid) {
		long st = System.currentTimeMillis();
		
		HttpClientAgent agent = new HttpClientAgent();

		JSONArray p = null;
		int retry = 10;
		while (retry > 0) {
			httpRequest(agent, "http://99off.jp/caches/data/p.txt?rnd=" + rnd(), HttpClientAgent.GET, null);
			
			JSONObject json = (JSONObject)parseJson(getResponseText());
			if (json != null) {
				p = json.getJSONArray("p");
				if (p != null && p.size() > 0) {
					break;
				}
			}
			tsleep(250);
			retry--;
		}

		if (p == null || p.size() < 1) {
			return false;
		}
		
		long et = System.currentTimeMillis();
		for (int i = 0; i < p.size(); i++) {
			JSONObject o = p.getJSONObject(i);
			if (StringUtils.isEmpty(gid)) {
				println(o.toString());
			}
			else {
				if (gid.equals(String.valueOf(o.getInt("i")))) {
					Goods g = new Goods();
					g.id = o.getInt("i");
					g.price = o.getInt("p");
					g.times = o.getInt("rs") * 1000;
					g.uid = o.getInt("ui");
					g.unick = o.getString("un");
					g.over = (o.getInt("o") != 0);
					g.ptime = et;

					if (goods == null 
							|| goods.price < g.price
							|| (goods.price == g.price && goods.times > g.times)) {
						printInfo((et - st) + "ms " + o.toString());
						goods = g;
					}
					return true;
				}
			}
		}

		if (goods != null && StringUtils.isNotEmpty(gid)) {
			printError("Goods(" + gid + ") is missing.");
			goods.over = true;
		}

		return true;
	}

	protected void detail() {
		if (goods != null) {
			httpGet("http://99off.jp/Detail.aspx?id=" + goods.id);
		}
	}
	
	protected void rank(final String gid) {
		if (StringUtils.isNotEmpty(gid)) {
			httpGet("http://99off.jp/caches/data/detail/" + gid + "/h.txt?rnd=" + rnd());
			JSONArray ja = (JSONArray)parseJson(getResponseText());
			if (ja != null && ja.size() > 0) {
				printInfo("======= RANK ==========");
				for (int i = 0; i < ja.size(); i++) {
					JSONObject jo = ja.getJSONObject(i);
					print(jo.toString() + "\n");
				}
			}
		}
	}

	private static void httpRequest(HttpClientAgent agent, String url, int method, Map<String, Object> forms) {
		int retry = 300;
		while (retry > 0) {
			try {
//				println(" >>> " + url + " ... ");
//				long st = System.currentTimeMillis();
				agent.doRequest(url, method, forms);
//				long et = System.currentTimeMillis();
//				println(" <<< " + url 
//						+ " " + agent.getResponseStatus()
//						+ " " + agent.getResponseContentLength() + "B"
//						+ " " + (et - st) + "ms");
				if (agent.getResonseStatusCode() == 200) {
					break;
				}
				tsleep(250);
				retry--;
			}
			catch (Exception e) {
				printError(e);
			}
		}
	}

	private void httpRequest(String url, int method, Map<String, Object> forms) {
		httpRequest(agent, url, method, forms);
	}

	private void httpGet(String url) {
		httpRequest(url, HttpClientAgent.GET, null);
	}

	private void httpGet(String url, Map<String, Object> forms) {
		httpRequest(url, HttpClientAgent.GET, forms);
	}
	
	private void httpPost(String url, Map<String, Object> forms) {
		httpRequest(url, HttpClientAgent.POST, forms);
	}

	private Object parseJson(String res) {
		try {
			if (res != null) {
				for (int i = 0; i < res.length(); i++) {
					char ch = res.charAt(i);
					if (ch == '[') {
						res = res.substring(i);
						return JSONArray.fromObject(res);
					}
					else if (ch == '{') {
						res = res.substring(i);
						return JSONObject.fromObject(res);
					}
				}
			}
		}
		catch (Exception e) {
		}
		return null;
	}

	private static SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss.SSS");

	private static void prompt() {
		print("$ ");
	}

	private static void print(String msg) {
		System.out.print(msg);
	}
	
	private static void println(String msg) {
		print("[" + Thread.currentThread().getName() + "] " 
				+ dateFormat.format(new Date(System.currentTimeMillis()))
				+ ' ' + msg + "\n");
	}
	
	private static void printInfo(String msg) {
		println("==>> " + msg);
	}
	
	private static void printError(String msg) {
		println("**>> " + msg);
	}

	private static void printError(Exception e) {
		printError("ERROR: " + e.getMessage());
	}

	private static String getPasswordFromEmail(String email) {
		int i = email.indexOf('@');
		if (i > 0) {
			return email.substring(0, i);
		}
		return null;
	}
	
	static final String WordsArr = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
	
	private static int rndnum(int minnum, int maxnum) {
		return (int)Math.ceil(Math.random() * (maxnum - minnum) + minnum);
	}

	private static String rndword() {
		int i = rndnum(0, 51);
		return WordsArr.substring(i, i + 1);
	}

	private static String rnd() {
		int len = 10;
		StringBuilder rtn = new StringBuilder();
		
		for (int i = 0; i < len; i++) {
			rtn.append(rndword());
		}
		return rtn.toString();
	}
}
