package my.tools.pdf;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.w3c.dom.Document;
import org.xhtmlrenderer.pdf.ITextRenderer;

public class Alice {

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		try {
			File aliceHtml = new File("data/alice.html");
			
			System.out.print(aliceHtml.getAbsolutePath() + "  -->  ");
			
			ITextRenderer renderer = new ITextRenderer();
	
			DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
		    Document doc = builder.parse(new FileInputStream(aliceHtml));
	
			renderer.setDocument(doc, null);
	
			File alicePdf = new File("alice.pdf");
			
			OutputStream os = new FileOutputStream(alicePdf);
			
			renderer.layout();
			renderer.createPDF(os);
			renderer.finishPDF();
			
			os.close();
			
			System.out.println(alicePdf.getAbsolutePath());
		}
		catch (Exception e) {
			e.printStackTrace();
		}
	}

}
