package my.tools.test;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import nuts.core.lang.ArrayUtils;

import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Document;
import org.xhtmlrenderer.pdf.ITextRenderer;
import org.xhtmlrenderer.pdf.TrueTypeUtil;
import org.xml.sax.InputSource;

import com.lowagie.text.pdf.BaseFont;

public class FlyingSaucerFontTest {

	public static void main(String[] args) {
		try {
			String dir = "C:\\Windows\\Fonts";
			if (args.length > 0) {
				dir = args[0];
			}

			ITextRenderer renderer = new ITextRenderer();

			File fontDir = new File(dir);

			// Build valid XHTML source for parsing
			StringBuilder buf = new StringBuilder();
			
			buf.append("<html>");
			buf.append("<head>");
			buf.append("</head>");
			buf.append("<body>");

			buf.append("This is formatted paragraph");

			// Gets TTF or OTF font file from
			// the font directory
			if (fontDir.isDirectory()) {

				// Only add fonts with specific extensions
				File[] files = fontDir.listFiles(new FilenameFilter() {
					public boolean accept(File dir, String name) {
						String lower = name.toLowerCase();
						// Load TTF or OTF files
						return lower.endsWith(".otf") || lower.endsWith(".ttf");
					}
				});

				for (File file : files) {
					// You should always embed TrueType fonts.
					renderer.getFontResolver().addFont(
							file.getAbsolutePath(), BaseFont.IDENTITY_H,
							BaseFont.EMBEDDED);

					// Get font family name from the BaseFont object.
					// All this work just to get font family name
					BaseFont font = BaseFont.createFont(
							file.getAbsolutePath(), BaseFont.IDENTITY_H,
							BaseFont.NOT_EMBEDDED);
					String[] fontFamilyNames = TrueTypeUtil.getFamilyNames(font);

					System.out.println(file.getName() + " : " + StringUtils.join(fontFamilyNames, ", "));
					
					if (ArrayUtils.isNotEmpty(fontFamilyNames)) {
						for (String fontFamilyName : fontFamilyNames) {
							buf.append("<div style=\"font-family: ");
							buf.append(fontFamilyName);
							buf.append(";\">");
							buf.append(file.getName() + " - " + fontFamilyName + " - あいうえお");
							buf.append("</div>");
						}
					}
				}
			}

			buf.append("<p>This paragraph is unformatted</p>");
			buf.append("</body>");
			buf.append("</html>");

			ByteArrayInputStream bais = new ByteArrayInputStream(buf.toString().getBytes("UTF-8"));
			DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
			InputSource is = new InputSource(bais);
			Document doc = builder.parse(is);

			renderer.setDocument(doc, null);
			renderer.layout();

			String filename = "fonts.pdf";
			BufferedOutputStream bufferedOutput = new BufferedOutputStream(
					new FileOutputStream(filename));

			renderer.createPDF(bufferedOutput);
			bufferedOutput.flush();
			bufferedOutput.close();
		}
		catch (Exception e) {
			e.printStackTrace();
		}
	}
}
