set APPID=%1
set WSID=%2
set RCAT=%3

if "%APPID%" == "" (
	echo "APPID is required."
	goto error
)
if "%WSID%" == "" (
	echo "WSID is required."
	goto error
)
if "%RCAT%" == "" (
	echo "RCAT is required."
	goto error
)

rmdir /s /q dist\%APPID%
xcopy /e /i /q dist\war dist\%APPID%

cd ..\squirrels-affiliate
move /y main\classes\log4j.properties main\classes\log4j.bak.properties
echo log4j.rootLogger=warn, stdout >> main\classes\log4j.properties
echo log4j.logger.nuts=info >> main\classes\log4j.properties
echo log4j.logger.squirrels=debug >> main\classes\log4j.properties
echo log4j.appender.stdout=org.apache.log4j.ConsoleAppender >> main\classes\log4j.properties
echo log4j.appender.stdout.layout=org.apache.log4j.PatternLayout >> main\classes\log4j.properties
rem echo log4j.appender.stdout.layout.ConversionPattern=%m %n >> main\classes\log4j.properties
echo log4j.appender.stdout.Target=System.out >> main\classes\log4j.properties

call ant.bat -Dwsid=%WSID% -Drcat=%RCAT% -Dsitemap="../squirrels-affiliate-gae/dist/%APPID%/WEB-INF/sitemap.csv" sitemap
if errorlevel 1 goto error

move /y main\classes\log4j.bak.properties main\classes\log4j.properties

cd ..\squirrels-affiliate-gae
if exist ..\squirrels-affiliate-gae-deploy\%APPID%\%APPID%.css (
	copy /b /y dist\%APPID%\styles\site.css + ..\squirrels-affiliate-gae-deploy\%APPID%\%APPID%.css dist\%APPID%\styles\site.css
)
if exist ..\squirrels-affiliate-gae-deploy\%APPID%\%APPID%.ico (
	copy /y ..\squirrels-affiliate-gae-deploy\%APPID%\%APPID%.ico dist\%APPID%\favicon.ico
)
if exist ..\squirrels-affiliate-gae-deploy\%APPID%\%APPID%-logo.png (
	copy /y ..\squirrels-affiliate-gae-deploy\%APPID%\%APPID%-logo.png dist\%APPID%\images\site-logo.png
)
if exist ..\squirrels-affiliate-gae-deploy\%APPID%\%APPID%-top.jpg (
	copy /y ..\squirrels-affiliate-gae-deploy\%APPID%\%APPID%-top.jpg dist\%APPID%\images\site-top.jpg
)

call ant.bat -Dappid=%APPID% pred 
if errorlevel 1 goto error

appcfg update dist\%APPID%
if errorlevel 1 goto error


:success
exit /b 0

:error
echo !!!! error !!!!
pause
exit /b 1
