/*
 * This file is part of Nuts.
 * Copyright (C) 2009 Nuts Develop Team.
 *
 * Nuts is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts. If not, see <http://www.gnu.org/licenses/>.
 */
package squirrels.affiliate.action.admin;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;

import nuts.aems.model.bean.User;
import nuts.core.orm.dao.DataAccessSession;
import nuts.exts.struts2.actions.CommonWorkAction;

import squirrels.affiliate.Application;
import squirrels.affiliate.model.CategoryModel;
import squirrels.affiliate.model.bean.Category;
import squirrels.affiliate.model.dao.CategoryDAO;
import squirrels.affiliate.util.ActionUtils;



/**
 */
@SuppressWarnings("serial")
public class CategoryRetrieveAction extends CommonWorkAction {

	private static String time;
	private static boolean stop = false;
	private static boolean progress = false;
	private static int count;
	private static String line;
	
	private int start;
	private int limit;
	private int words;
	
	public CategoryRetrieveAction() {
	}

	/**
	 * @return the time
	 */
	public String getTime() {
		return time;
	}

	/**
	 * @return the stop
	 */
	public boolean isStop() {
		return stop;
	}

	/**
	 * @return the count
	 */
	public int getCount() {
		return count;
	}

	/**
	 * @return the line
	 */
	public String getLine() {
		return line;
	}

	/**
	 * @return the progress
	 */
	public boolean isProgress() {
		return progress;
	}

	/**
	 * @return the start
	 */
	public int getStart() {
		return start;
	}

	/**
	 * @param start the start to set
	 */
	public void setStart(int start) {
		this.start = start;
	}

	/**
	 * @return the limit
	 */
	public int getLimit() {
		return limit;
	}

	/**
	 * @param limit the limit to set
	 */
	public void setLimit(int limit) {
		this.limit = limit;
	}

	/**
	 * @return the words
	 */
	public int getWords() {
		return words;
	}

	/**
	 * @param words the words to set
	 */
	public void setWords(int words) {
		this.words = words;
	}

	/**
	 * @return the utils
	 */
	public ActionUtils utils() {
		return (ActionUtils)super.getUtils();
	}

	public String stop() {
		stop = true;
		time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(Calendar.getInstance().getTime());
		return "xml";
	}
	
	public String peek() {
		time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(Calendar.getInstance().getTime());
		return "xml";
	}
	
	protected void init() throws Exception {
		super.init();
		stop = false;
	}
	
	public String retrieve() {
		try {
			init();
			if (progress) {
				doProgress();
			}
			else {
				doRetrieve();
			}
		}
		catch (Throwable e) {
			log.warn("retrieve", e);
			try {
				printError(e.getMessage());
			}
			catch (Exception ex) {
			}
		}
		return NONE;
	}
	
	private void doProgress() throws Exception {
		int cnt = 0;
		while (progress) {
			while (progress && cnt == count) {
				Thread.sleep(500);
			}
			cnt = count;
			printProcess(count, line);
		}
		printSuccess(String.valueOf(count));
	}

	private void insertCategory(CategoryDAO cdao, Category c0, User u) throws Exception {
		if (isStop()) {
			return;
		}
		
		Category c = c0.clone();
		
		c.setWs(Application.WSID);
		c.setId(c.getWs() + c.getId());
		if (c.getParentId() != null) {
			c.setParentId(c.getWs() + c.getParentId());
		}
		c.setInvalid(false);
		c.setUusid(u.getId());
		c.setUtime(Calendar.getInstance().getTime());
		
		cdao.save(c);

		count++;
		printProcess(count, c.getId() + "/" + c.getLevel() + ": " + c.getName());
		if (count % 1000 == 0) {
			printProcess(count, "==== COMMIT ====");
		}
		
		int wait = 0;
		while (true) {
			if (isStop()) {
				return;
			}

			List<Category> children = c0.getChildren();
			if (children == null) {
				wait += 60;
				printProcess(count, c.getId() + "/" + c.getLevel() + ": " + c.getName()
					+ " -- Wait " + wait + " seconds to retrieve children.");
				Thread.sleep(wait * 1000);
				continue;
			}

			for (Category c2 : children) {
				Thread.sleep(200);
				insertCategory(cdao, c2, u);
			}
			break;
		}
	}
	
	private void doRetrieve() throws Exception {
		DataAccessSession das = getDataAccessSession();

		try {
			User u = utils().getLoginUser();
			
			progress = true;
			count = 0;

			CategoryDAO cdao = new CategoryDAO(das);

			Category c = CategoryModel.getInstance().getRootCategory();

			insertCategory(cdao, c, u);

			das.commit();
			
			printSuccess(String.valueOf(count));
		}
		catch (Exception e) {
			das.rollback();
			throw e;
		}
		finally {
			progress = false;
		}
	}
}
