/*
 * This file is part of Squirrels.
 * Copyright (C) 2009 Squirrels Develop Team.
 *
 * Squirrels is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Squirrels is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Squirrels. If not, see <http://www.gnu.org/licenses/>.
 */
package squirrels.affiliate.action.images;

import java.io.File;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import nuts.core.servlet.HttpServletUtils;
import nuts.exts.struts2.util.StrutsContextUtils;

import squirrels.affiliate.action.AbstractAction;



/**
 */
@SuppressWarnings("serial")
public class DispatchAction extends AbstractAction {
	/**
	 * execute
	 * @return result name
	 * @throws Exception if an error occurs
	 */
	public String execute() throws Exception {
		ServletContext context = StrutsContextUtils.getServletContext();
		HttpServletRequest request = StrutsContextUtils.getServletRequest();
		HttpServletResponse response = StrutsContextUtils.getServletResponse();
		
		String uri = HttpServletUtils.getRequestURI(request);

		String path = context.getRealPath(uri);
		File file = new File(path);
		if (file.exists()) {
			context.getRequestDispatcher(uri).forward(request, response);
		}
		else {
			HttpServletUtils.sendRedirect(response, context.getContextPath() +"/images/s.gif");
		}
		return NONE;
	}
}
